// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/shopping/merchant/accounts/v1beta/businessidentity.proto

package accountspb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// All possible settings regarding promotions related to the business
// identity.
type BusinessIdentity_PromotionsConsent int32

const (
	// Default value indicating that no selection was made.
	BusinessIdentity_PROMOTIONS_CONSENT_UNSPECIFIED BusinessIdentity_PromotionsConsent = 0
	// Indicates that the account consented to having their business identity
	// used for promotions.
	BusinessIdentity_PROMOTIONS_CONSENT_GIVEN BusinessIdentity_PromotionsConsent = 1
	// Indicates that the account did not consent to having their business
	// identity used for promotions.
	BusinessIdentity_PROMOTIONS_CONSENT_DENIED BusinessIdentity_PromotionsConsent = 2
)

// Enum value maps for BusinessIdentity_PromotionsConsent.
var (
	BusinessIdentity_PromotionsConsent_name = map[int32]string{
		0: "PROMOTIONS_CONSENT_UNSPECIFIED",
		1: "PROMOTIONS_CONSENT_GIVEN",
		2: "PROMOTIONS_CONSENT_DENIED",
	}
	BusinessIdentity_PromotionsConsent_value = map[string]int32{
		"PROMOTIONS_CONSENT_UNSPECIFIED": 0,
		"PROMOTIONS_CONSENT_GIVEN":       1,
		"PROMOTIONS_CONSENT_DENIED":      2,
	}
)

func (x BusinessIdentity_PromotionsConsent) Enum() *BusinessIdentity_PromotionsConsent {
	p := new(BusinessIdentity_PromotionsConsent)
	*p = x
	return p
}

func (x BusinessIdentity_PromotionsConsent) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BusinessIdentity_PromotionsConsent) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_enumTypes[0].Descriptor()
}

func (BusinessIdentity_PromotionsConsent) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_enumTypes[0]
}

func (x BusinessIdentity_PromotionsConsent) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BusinessIdentity_PromotionsConsent.Descriptor instead.
func (BusinessIdentity_PromotionsConsent) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_rawDescGZIP(), []int{0, 0}
}

// All possible settings regarding the declaration of an identity.
type BusinessIdentity_IdentityAttribute_IdentityDeclaration int32

const (
	// Default value indicating that no selection was made.
	BusinessIdentity_IdentityAttribute_IDENTITY_DECLARATION_UNSPECIFIED BusinessIdentity_IdentityAttribute_IdentityDeclaration = 0
	// Indicates that the account identifies with the attribute.
	BusinessIdentity_IdentityAttribute_SELF_IDENTIFIES_AS BusinessIdentity_IdentityAttribute_IdentityDeclaration = 1
	// Indicates that the account does not identify with the attribute.
	BusinessIdentity_IdentityAttribute_DOES_NOT_SELF_IDENTIFY_AS BusinessIdentity_IdentityAttribute_IdentityDeclaration = 2
)

// Enum value maps for BusinessIdentity_IdentityAttribute_IdentityDeclaration.
var (
	BusinessIdentity_IdentityAttribute_IdentityDeclaration_name = map[int32]string{
		0: "IDENTITY_DECLARATION_UNSPECIFIED",
		1: "SELF_IDENTIFIES_AS",
		2: "DOES_NOT_SELF_IDENTIFY_AS",
	}
	BusinessIdentity_IdentityAttribute_IdentityDeclaration_value = map[string]int32{
		"IDENTITY_DECLARATION_UNSPECIFIED": 0,
		"SELF_IDENTIFIES_AS":               1,
		"DOES_NOT_SELF_IDENTIFY_AS":        2,
	}
)

func (x BusinessIdentity_IdentityAttribute_IdentityDeclaration) Enum() *BusinessIdentity_IdentityAttribute_IdentityDeclaration {
	p := new(BusinessIdentity_IdentityAttribute_IdentityDeclaration)
	*p = x
	return p
}

func (x BusinessIdentity_IdentityAttribute_IdentityDeclaration) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BusinessIdentity_IdentityAttribute_IdentityDeclaration) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_enumTypes[1].Descriptor()
}

func (BusinessIdentity_IdentityAttribute_IdentityDeclaration) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_enumTypes[1]
}

func (x BusinessIdentity_IdentityAttribute_IdentityDeclaration) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BusinessIdentity_IdentityAttribute_IdentityDeclaration.Descriptor instead.
func (BusinessIdentity_IdentityAttribute_IdentityDeclaration) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_rawDescGZIP(), []int{0, 0, 0}
}

// Collection of information related to the [identity of a
// business](https://support.google.com/merchants/answer/12564247).
type BusinessIdentity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The resource name of the business identity.
	// Format: `accounts/{account}/businessIdentity`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Whether the identity attributes may be used for promotions.
	PromotionsConsent BusinessIdentity_PromotionsConsent `protobuf:"varint,2,opt,name=promotions_consent,json=promotionsConsent,proto3,enum=google.shopping.merchant.accounts.v1beta.BusinessIdentity_PromotionsConsent" json:"promotions_consent,omitempty"`
	// Optional. Specifies whether the business identifies itself as being
	// black-owned. This optional field will only be available for merchants with
	// a business country set to `US`. It is also not applicable for marketplaces
	// or marketplace sellers.
	BlackOwned *BusinessIdentity_IdentityAttribute `protobuf:"bytes,3,opt,name=black_owned,json=blackOwned,proto3" json:"black_owned,omitempty"`
	// Optional. Specifies whether the business identifies itself as being
	// women-owned. This optional field will only be available for merchants with
	// a business country set to `US`. It is also not applicable for marketplaces
	// or marketplace sellers.
	WomenOwned *BusinessIdentity_IdentityAttribute `protobuf:"bytes,4,opt,name=women_owned,json=womenOwned,proto3" json:"women_owned,omitempty"`
	// Optional. Specifies whether the business identifies itself as being
	// veteran-owned. This optional field will only be available for merchants
	// with a business country set to `US`. It is also not applicable for
	// marketplaces or marketplace sellers.
	VeteranOwned *BusinessIdentity_IdentityAttribute `protobuf:"bytes,5,opt,name=veteran_owned,json=veteranOwned,proto3" json:"veteran_owned,omitempty"`
	// Optional. Specifies whether the business identifies itself as being
	// latino-owned. This optional field will only be available for merchants with
	// a business country set to `US`. It is also not applicable for marketplaces
	// or marketplace sellers.
	LatinoOwned *BusinessIdentity_IdentityAttribute `protobuf:"bytes,6,opt,name=latino_owned,json=latinoOwned,proto3" json:"latino_owned,omitempty"`
	// Optional. Specifies whether the business identifies itself as a small
	// business. This optional field will only be available for merchants with a
	// business country set to `US`. It is also not applicable for marketplaces.
	SmallBusiness *BusinessIdentity_IdentityAttribute `protobuf:"bytes,7,opt,name=small_business,json=smallBusiness,proto3" json:"small_business,omitempty"`
}

func (x *BusinessIdentity) Reset() {
	*x = BusinessIdentity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BusinessIdentity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BusinessIdentity) ProtoMessage() {}

func (x *BusinessIdentity) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BusinessIdentity.ProtoReflect.Descriptor instead.
func (*BusinessIdentity) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_rawDescGZIP(), []int{0}
}

func (x *BusinessIdentity) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *BusinessIdentity) GetPromotionsConsent() BusinessIdentity_PromotionsConsent {
	if x != nil {
		return x.PromotionsConsent
	}
	return BusinessIdentity_PROMOTIONS_CONSENT_UNSPECIFIED
}

func (x *BusinessIdentity) GetBlackOwned() *BusinessIdentity_IdentityAttribute {
	if x != nil {
		return x.BlackOwned
	}
	return nil
}

func (x *BusinessIdentity) GetWomenOwned() *BusinessIdentity_IdentityAttribute {
	if x != nil {
		return x.WomenOwned
	}
	return nil
}

func (x *BusinessIdentity) GetVeteranOwned() *BusinessIdentity_IdentityAttribute {
	if x != nil {
		return x.VeteranOwned
	}
	return nil
}

func (x *BusinessIdentity) GetLatinoOwned() *BusinessIdentity_IdentityAttribute {
	if x != nil {
		return x.LatinoOwned
	}
	return nil
}

func (x *BusinessIdentity) GetSmallBusiness() *BusinessIdentity_IdentityAttribute {
	if x != nil {
		return x.SmallBusiness
	}
	return nil
}

// Request message for the `GetBusinessIdentity` method.
type GetBusinessIdentityRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the business identity.
	// Format: `accounts/{account}/businessIdentity`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetBusinessIdentityRequest) Reset() {
	*x = GetBusinessIdentityRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetBusinessIdentityRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBusinessIdentityRequest) ProtoMessage() {}

func (x *GetBusinessIdentityRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBusinessIdentityRequest.ProtoReflect.Descriptor instead.
func (*GetBusinessIdentityRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_rawDescGZIP(), []int{1}
}

func (x *GetBusinessIdentityRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the `UpdateBusinessIdentity` method.
type UpdateBusinessIdentityRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The new version of the business identity.
	BusinessIdentity *BusinessIdentity `protobuf:"bytes,1,opt,name=business_identity,json=businessIdentity,proto3" json:"business_identity,omitempty"`
	// Required. List of fields being updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateBusinessIdentityRequest) Reset() {
	*x = UpdateBusinessIdentityRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateBusinessIdentityRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateBusinessIdentityRequest) ProtoMessage() {}

func (x *UpdateBusinessIdentityRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateBusinessIdentityRequest.ProtoReflect.Descriptor instead.
func (*UpdateBusinessIdentityRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_rawDescGZIP(), []int{2}
}

func (x *UpdateBusinessIdentityRequest) GetBusinessIdentity() *BusinessIdentity {
	if x != nil {
		return x.BusinessIdentity
	}
	return nil
}

func (x *UpdateBusinessIdentityRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// All information related to an identity attribute.
type BusinessIdentity_IdentityAttribute struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The declaration of identity for this attribute.
	IdentityDeclaration BusinessIdentity_IdentityAttribute_IdentityDeclaration `protobuf:"varint,1,opt,name=identity_declaration,json=identityDeclaration,proto3,enum=google.shopping.merchant.accounts.v1beta.BusinessIdentity_IdentityAttribute_IdentityDeclaration" json:"identity_declaration,omitempty"`
}

func (x *BusinessIdentity_IdentityAttribute) Reset() {
	*x = BusinessIdentity_IdentityAttribute{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BusinessIdentity_IdentityAttribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BusinessIdentity_IdentityAttribute) ProtoMessage() {}

func (x *BusinessIdentity_IdentityAttribute) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BusinessIdentity_IdentityAttribute.ProtoReflect.Descriptor instead.
func (*BusinessIdentity_IdentityAttribute) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_rawDescGZIP(), []int{0, 0}
}

func (x *BusinessIdentity_IdentityAttribute) GetIdentityDeclaration() BusinessIdentity_IdentityAttribute_IdentityDeclaration {
	if x != nil {
		return x.IdentityDeclaration
	}
	return BusinessIdentity_IdentityAttribute_IDENTITY_DECLARATION_UNSPECIFIED
}

var File_google_shopping_merchant_accounts_v1beta_businessidentity_proto protoreflect.FileDescriptor

var file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_rawDesc = []byte{
	0x0a, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x62, 0x75, 0x73, 0x69, 0x6e,
	0x65, 0x73, 0x73, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0x96, 0x0a, 0x0a, 0x10, 0x42, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x80,
	0x01, 0x0a, 0x12, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x63, 0x6f,
	0x6e, 0x73, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65,
	0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x50, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x43, 0x6f, 0x6e, 0x73, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11,
	0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x43, 0x6f, 0x6e, 0x73, 0x65, 0x6e,
	0x74, 0x12, 0x72, 0x0a, 0x0b, 0x62, 0x6c, 0x61, 0x63, 0x6b, 0x5f, 0x6f, 0x77, 0x6e, 0x65, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x42, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x62, 0x6c, 0x61, 0x63, 0x6b,
	0x4f, 0x77, 0x6e, 0x65, 0x64, 0x12, 0x72, 0x0a, 0x0b, 0x77, 0x6f, 0x6d, 0x65, 0x6e, 0x5f, 0x6f,
	0x77, 0x6e, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x77,
	0x6f, 0x6d, 0x65, 0x6e, 0x4f, 0x77, 0x6e, 0x65, 0x64, 0x12, 0x76, 0x0a, 0x0d, 0x76, 0x65, 0x74,
	0x65, 0x72, 0x61, 0x6e, 0x5f, 0x6f, 0x77, 0x6e, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x75, 0x73, 0x69,
	0x6e, 0x65, 0x73, 0x73, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x65, 0x74, 0x65, 0x72, 0x61, 0x6e, 0x4f, 0x77, 0x6e, 0x65,
	0x64, 0x12, 0x74, 0x0a, 0x0c, 0x6c, 0x61, 0x74, 0x69, 0x6e, 0x6f, 0x5f, 0x6f, 0x77, 0x6e, 0x65,
	0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61,
	0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x42, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x6c, 0x61, 0x74, 0x69,
	0x6e, 0x6f, 0x4f, 0x77, 0x6e, 0x65, 0x64, 0x12, 0x78, 0x0a, 0x0e, 0x73, 0x6d, 0x61, 0x6c, 0x6c,
	0x5f, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x75, 0x73, 0x69, 0x6e,
	0x65, 0x73, 0x73, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0d, 0x73, 0x6d, 0x61, 0x6c, 0x6c, 0x42, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73,
	0x73, 0x1a, 0xa2, 0x02, 0x0a, 0x11, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x98, 0x01, 0x0a, 0x14, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x5f, 0x64, 0x65, 0x63, 0x6c, 0x61, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x60, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x42, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x44, 0x65, 0x63,
	0x6c, 0x61, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x44, 0x65, 0x63, 0x6c, 0x61, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x72, 0x0a, 0x13, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x44, 0x65,
	0x63, 0x6c, 0x61, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x20, 0x49, 0x44, 0x45,
	0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x44, 0x45, 0x43, 0x4c, 0x41, 0x52, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x16, 0x0a, 0x12, 0x53, 0x45, 0x4c, 0x46, 0x5f, 0x49, 0x44, 0x45, 0x4e, 0x54, 0x49, 0x46, 0x49,
	0x45, 0x53, 0x5f, 0x41, 0x53, 0x10, 0x01, 0x12, 0x1d, 0x0a, 0x19, 0x44, 0x4f, 0x45, 0x53, 0x5f,
	0x4e, 0x4f, 0x54, 0x5f, 0x53, 0x45, 0x4c, 0x46, 0x5f, 0x49, 0x44, 0x45, 0x4e, 0x54, 0x49, 0x46,
	0x59, 0x5f, 0x41, 0x53, 0x10, 0x02, 0x22, 0x74, 0x0a, 0x11, 0x50, 0x72, 0x6f, 0x6d, 0x6f, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x43, 0x6f, 0x6e, 0x73, 0x65, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x1e, 0x50,
	0x52, 0x4f, 0x4d, 0x4f, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x5f, 0x43, 0x4f, 0x4e, 0x53, 0x45, 0x4e,
	0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x1c, 0x0a, 0x18, 0x50, 0x52, 0x4f, 0x4d, 0x4f, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x5f, 0x43, 0x4f,
	0x4e, 0x53, 0x45, 0x4e, 0x54, 0x5f, 0x47, 0x49, 0x56, 0x45, 0x4e, 0x10, 0x01, 0x12, 0x1d, 0x0a,
	0x19, 0x50, 0x52, 0x4f, 0x4d, 0x4f, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x5f, 0x43, 0x4f, 0x4e, 0x53,
	0x45, 0x4e, 0x54, 0x5f, 0x44, 0x45, 0x4e, 0x49, 0x45, 0x44, 0x10, 0x02, 0x3a, 0x7b, 0xea, 0x41,
	0x78, 0x0a, 0x2b, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x75,
	0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x23,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x7d, 0x2f, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x2a, 0x12, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x32, 0x10, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73,
	0x73, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x22, 0x65, 0x0a, 0x1a, 0x47, 0x65, 0x74,
	0x42, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x75, 0x73, 0x69, 0x6e, 0x65,
	0x73, 0x73, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0xcf, 0x01, 0x0a, 0x1d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x75, 0x73, 0x69, 0x6e,
	0x65, 0x73, 0x73, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x6c, 0x0a, 0x11, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e,
	0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73,
	0x73, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10,
	0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x73, 0x6b, 0x32, 0xe3, 0x04, 0x0a, 0x17, 0x42, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xdb,
	0x01, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x42, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x47, 0x65, 0x74, 0x42, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x22, 0x42, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x12, 0x33, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x75, 0x73, 0x69, 0x6e,
	0x65, 0x73, 0x73, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x7d, 0x12, 0xa0, 0x02, 0x0a,
	0x16, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61,
	0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73,
	0x73, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x75, 0x73, 0x69,
	0x6e, 0x65, 0x73, 0x73, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x22, 0x80, 0x01, 0xda,
	0x41, 0x1d, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x5a, 0x3a, 0x11, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x5f,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x32, 0x45, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x62, 0x75, 0x73, 0x69,
	0x6e, 0x65, 0x73, 0x73, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x75,
	0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x7d, 0x1a,
	0x47, 0xca, 0x41, 0x1a, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41,
	0x27, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x97, 0x01, 0x0a, 0x2c, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x15, 0x42, 0x75, 0x73, 0x69, 0x6e,
	0x65, 0x73, 0x73, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x4e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x70, 0x62, 0x3b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_rawDescOnce sync.Once
	file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_rawDescData = file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_rawDesc
)

func file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_rawDescGZIP() []byte {
	file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_rawDescOnce.Do(func() {
		file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_rawDescData)
	})
	return file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_rawDescData
}

var file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_goTypes = []interface{}{
	(BusinessIdentity_PromotionsConsent)(0),                     // 0: google.shopping.merchant.accounts.v1beta.BusinessIdentity.PromotionsConsent
	(BusinessIdentity_IdentityAttribute_IdentityDeclaration)(0), // 1: google.shopping.merchant.accounts.v1beta.BusinessIdentity.IdentityAttribute.IdentityDeclaration
	(*BusinessIdentity)(nil),                                    // 2: google.shopping.merchant.accounts.v1beta.BusinessIdentity
	(*GetBusinessIdentityRequest)(nil),                          // 3: google.shopping.merchant.accounts.v1beta.GetBusinessIdentityRequest
	(*UpdateBusinessIdentityRequest)(nil),                       // 4: google.shopping.merchant.accounts.v1beta.UpdateBusinessIdentityRequest
	(*BusinessIdentity_IdentityAttribute)(nil),                  // 5: google.shopping.merchant.accounts.v1beta.BusinessIdentity.IdentityAttribute
	(*fieldmaskpb.FieldMask)(nil),                               // 6: google.protobuf.FieldMask
}
var file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_depIdxs = []int32{
	0,  // 0: google.shopping.merchant.accounts.v1beta.BusinessIdentity.promotions_consent:type_name -> google.shopping.merchant.accounts.v1beta.BusinessIdentity.PromotionsConsent
	5,  // 1: google.shopping.merchant.accounts.v1beta.BusinessIdentity.black_owned:type_name -> google.shopping.merchant.accounts.v1beta.BusinessIdentity.IdentityAttribute
	5,  // 2: google.shopping.merchant.accounts.v1beta.BusinessIdentity.women_owned:type_name -> google.shopping.merchant.accounts.v1beta.BusinessIdentity.IdentityAttribute
	5,  // 3: google.shopping.merchant.accounts.v1beta.BusinessIdentity.veteran_owned:type_name -> google.shopping.merchant.accounts.v1beta.BusinessIdentity.IdentityAttribute
	5,  // 4: google.shopping.merchant.accounts.v1beta.BusinessIdentity.latino_owned:type_name -> google.shopping.merchant.accounts.v1beta.BusinessIdentity.IdentityAttribute
	5,  // 5: google.shopping.merchant.accounts.v1beta.BusinessIdentity.small_business:type_name -> google.shopping.merchant.accounts.v1beta.BusinessIdentity.IdentityAttribute
	2,  // 6: google.shopping.merchant.accounts.v1beta.UpdateBusinessIdentityRequest.business_identity:type_name -> google.shopping.merchant.accounts.v1beta.BusinessIdentity
	6,  // 7: google.shopping.merchant.accounts.v1beta.UpdateBusinessIdentityRequest.update_mask:type_name -> google.protobuf.FieldMask
	1,  // 8: google.shopping.merchant.accounts.v1beta.BusinessIdentity.IdentityAttribute.identity_declaration:type_name -> google.shopping.merchant.accounts.v1beta.BusinessIdentity.IdentityAttribute.IdentityDeclaration
	3,  // 9: google.shopping.merchant.accounts.v1beta.BusinessIdentityService.GetBusinessIdentity:input_type -> google.shopping.merchant.accounts.v1beta.GetBusinessIdentityRequest
	4,  // 10: google.shopping.merchant.accounts.v1beta.BusinessIdentityService.UpdateBusinessIdentity:input_type -> google.shopping.merchant.accounts.v1beta.UpdateBusinessIdentityRequest
	2,  // 11: google.shopping.merchant.accounts.v1beta.BusinessIdentityService.GetBusinessIdentity:output_type -> google.shopping.merchant.accounts.v1beta.BusinessIdentity
	2,  // 12: google.shopping.merchant.accounts.v1beta.BusinessIdentityService.UpdateBusinessIdentity:output_type -> google.shopping.merchant.accounts.v1beta.BusinessIdentity
	11, // [11:13] is the sub-list for method output_type
	9,  // [9:11] is the sub-list for method input_type
	9,  // [9:9] is the sub-list for extension type_name
	9,  // [9:9] is the sub-list for extension extendee
	0,  // [0:9] is the sub-list for field type_name
}

func init() { file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_init() }
func file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_init() {
	if File_google_shopping_merchant_accounts_v1beta_businessidentity_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BusinessIdentity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetBusinessIdentityRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateBusinessIdentityRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BusinessIdentity_IdentityAttribute); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_goTypes,
		DependencyIndexes: file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_depIdxs,
		EnumInfos:         file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_enumTypes,
		MessageInfos:      file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_msgTypes,
	}.Build()
	File_google_shopping_merchant_accounts_v1beta_businessidentity_proto = out.File
	file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_rawDesc = nil
	file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_goTypes = nil
	file_google_shopping_merchant_accounts_v1beta_businessidentity_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// BusinessIdentityServiceClient is the client API for BusinessIdentityService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BusinessIdentityServiceClient interface {
	// Retrieves the business identity of an account.
	GetBusinessIdentity(ctx context.Context, in *GetBusinessIdentityRequest, opts ...grpc.CallOption) (*BusinessIdentity, error)
	// Updates the business identity of an account. Executing this method requires
	// admin access.
	UpdateBusinessIdentity(ctx context.Context, in *UpdateBusinessIdentityRequest, opts ...grpc.CallOption) (*BusinessIdentity, error)
}

type businessIdentityServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewBusinessIdentityServiceClient(cc grpc.ClientConnInterface) BusinessIdentityServiceClient {
	return &businessIdentityServiceClient{cc}
}

func (c *businessIdentityServiceClient) GetBusinessIdentity(ctx context.Context, in *GetBusinessIdentityRequest, opts ...grpc.CallOption) (*BusinessIdentity, error) {
	out := new(BusinessIdentity)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.accounts.v1beta.BusinessIdentityService/GetBusinessIdentity", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *businessIdentityServiceClient) UpdateBusinessIdentity(ctx context.Context, in *UpdateBusinessIdentityRequest, opts ...grpc.CallOption) (*BusinessIdentity, error) {
	out := new(BusinessIdentity)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.accounts.v1beta.BusinessIdentityService/UpdateBusinessIdentity", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BusinessIdentityServiceServer is the server API for BusinessIdentityService service.
type BusinessIdentityServiceServer interface {
	// Retrieves the business identity of an account.
	GetBusinessIdentity(context.Context, *GetBusinessIdentityRequest) (*BusinessIdentity, error)
	// Updates the business identity of an account. Executing this method requires
	// admin access.
	UpdateBusinessIdentity(context.Context, *UpdateBusinessIdentityRequest) (*BusinessIdentity, error)
}

// UnimplementedBusinessIdentityServiceServer can be embedded to have forward compatible implementations.
type UnimplementedBusinessIdentityServiceServer struct {
}

func (*UnimplementedBusinessIdentityServiceServer) GetBusinessIdentity(context.Context, *GetBusinessIdentityRequest) (*BusinessIdentity, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBusinessIdentity not implemented")
}
func (*UnimplementedBusinessIdentityServiceServer) UpdateBusinessIdentity(context.Context, *UpdateBusinessIdentityRequest) (*BusinessIdentity, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateBusinessIdentity not implemented")
}

func RegisterBusinessIdentityServiceServer(s *grpc.Server, srv BusinessIdentityServiceServer) {
	s.RegisterService(&_BusinessIdentityService_serviceDesc, srv)
}

func _BusinessIdentityService_GetBusinessIdentity_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBusinessIdentityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BusinessIdentityServiceServer).GetBusinessIdentity(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.accounts.v1beta.BusinessIdentityService/GetBusinessIdentity",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BusinessIdentityServiceServer).GetBusinessIdentity(ctx, req.(*GetBusinessIdentityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BusinessIdentityService_UpdateBusinessIdentity_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBusinessIdentityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BusinessIdentityServiceServer).UpdateBusinessIdentity(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.accounts.v1beta.BusinessIdentityService/UpdateBusinessIdentity",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BusinessIdentityServiceServer).UpdateBusinessIdentity(ctx, req.(*UpdateBusinessIdentityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _BusinessIdentityService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.shopping.merchant.accounts.v1beta.BusinessIdentityService",
	HandlerType: (*BusinessIdentityServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetBusinessIdentity",
			Handler:    _BusinessIdentityService_GetBusinessIdentity_Handler,
		},
		{
			MethodName: "UpdateBusinessIdentity",
			Handler:    _BusinessIdentityService_UpdateBusinessIdentity_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/shopping/merchant/accounts/v1beta/businessidentity.proto",
}
