#pragma once
/*
 *  $Id: meta-browser.h 28682 2025-10-21 09:14:21Z yeti-dn $
 *  Copyright (C) 2013-2025 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYAPP_META_BROWSER_H__
#define __GWYAPP_META_BROWSER_H__

#include <gtk/gtk.h>
#include <libgwyapp/file.h>

G_BEGIN_DECLS

#define GWY_TYPE_META_BROWSER            (gwy_meta_browser_get_type())
#define GWY_META_BROWSER(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_META_BROWSER, GwyMetaBrowser))
#define GWY_META_BROWSER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_META_BROWSER, GwyMetaBrowserClass))
#define GWY_IS_META_BROWSER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_META_BROWSER))
#define GWY_IS_META_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_META_BROWSER))
#define GWY_META_BROWSER_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_META_BROWSER, GwyMetaBrowserClass))

typedef struct _GwyMetaBrowser        GwyMetaBrowser;
typedef struct _GwyMetaBrowserClass   GwyMetaBrowserClass;
typedef struct _GwyMetaBrowserPrivate GwyMetaBrowserPrivate;

struct _GwyMetaBrowser {
    GtkWindow parent;
    GwyMetaBrowserPrivate *priv;
};

struct _GwyMetaBrowserClass {
    GtkWindowClass parent;

    gpointer reserved1;
    gpointer reserved2;
};

GType      gwy_meta_browser_get_type(void)                  G_GNUC_CONST;
GtkWidget* gwy_meta_browser_new     (GwyFile *file,
                                     GwyDataKind data_kind,
                                     gint id);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
