/*
 * Copyright University of Reims Champagne-Ardenne
 * Authors and Contributors: Akilan RAJAMANI, Corentin LEFEBVRE, Johanna KLEIN,
 *                           Emmanuel PLUOT, Gaetan RUBEZ, Hassan KHARTABIL,
 *                           Jean-Charles BOISSON and Eric HENON
 * (24/07/2017)
 * jean-charles.boisson@univ-reims.fr, eric.henon@univ-reims.fr
 *
 * This software is a computer program whose purpose is to
 * detect and quantify interactions from electron density
 * obtained either internally from promolecular density or
 * calculated from an input wave function input file. It also
 * prepares for the visualization of isosurfaces representing
 * several descriptors (dg) coming from the IGM methodology.
 *
 * This software is governed by the CeCILL-C license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL-C
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided only
 * with a limited warranty  and the software's author,  the holder of the
 * economic rights,  and the successive licensors  have only  limited
 * liability.
 *
 * In this respect, the user's attention is drawn to the risks associated
 * with loading,  using,  modifying and/or developing or reproducing the
 * software by the user in light of its specific status of free software,
 * that may mean  that it is complicated to manipulate,  and  that  also
 * therefore means  that it is reserved for developers  and  experienced
 * professionals having in-depth computer knowledge. Users are therefore
 * encouraged to load and test the software's suitability as regards their
 * requirements in conditions enabling the security of their systems and/or
 * data to be ensured and,  more generally, to use and operate it in the
 * same conditions as regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL-C license and that you accept its terms.
 *
 * */

/**
 * @file vmdFileGenerator.cpp
 * @brief Implementation of methods declared in vmdFileGenerator.h */

#ifndef _VMDFILEGENERATOR_CPP_
#define _VMDFILEGENERATOR_CPP_

// LOCAL
#include <vmdFileGenerator.h>

void generateVMDAtContribInterFile(const std::string *rep, const bool QMmode) // PROMOLECULAR MODE and QM MODE
{
  FILE* file=fopen("AtContribInter.vmd","w");
  fprintf(file, "%*s\n", 0,"#");
  fprintf(file, "%*s\n", 0,"#Copyright University of Reims Champagne-Ardenne");
  fprintf(file, "%*s\n", 0,"#Authors and Contributors: Akilan RAJAMANI, Corentin LEFEBVRE, Johanna KLEIN, Emmanuel PLUOT, Gaetan RUBEZ, Hassan Khartabil, Jean-Charles-BOISSON and Eric HENON");
  fprintf(file, "%*s\n", 0,"#(24/07/2017)");
  fprintf(file, "%*s\n", 0,"#");
  fprintf(file, "%*s\n", 0,"#jean-charles.boisson@univ-reims.fr, eric.henon@univ-reims.fr");
  fprintf(file, "%*s\n", 0,"#");
  fprintf(file, "%*s\n", 0,"#This software is a computer program whose purpose is to ");
  fprintf(file, "%*s\n", 0,"#detect and prepare the plot of molecular interactions");
  fprintf(file, "%*s\n", 0,"#from electron density and IGM reference using promolecular");
  fprintf(file, "%*s\n", 0,"#electron density.");
  fprintf(file, "%*s\n", 0,"#");
  fprintf(file, "%*s\n", 0,"#This software is governed by the CeCILL-C license under French law and");
  fprintf(file, "%*s\n", 0,"#abiding by the rules of distribution of free software.  You can  use, ");
  fprintf(file, "%*s\n", 0,"#modify and/ or redistribute the software under the terms of the CeCILL-C");
  fprintf(file, "%*s\n", 0,"#license as circulated by CEA, CNRS and INRIA at the following URL");
  fprintf(file, "%*s\n", 0,"#\"http://www.cecill.info\". ");
  fprintf(file, "%*s\n", 0,"#");
  fprintf(file, "%*s\n", 0,"#As a counterpart to the access to the source code and  rights to copy,");
  fprintf(file, "%*s\n", 0,"#modify and redistribute granted by the license, users are provided only");
  fprintf(file, "%*s\n", 0,"#with a limited warranty  and the software\'s author,  the holder of the");
  fprintf(file, "%*s\n", 0,"#economic rights,  and the successive licensors  have only  limited");
  fprintf(file, "%*s\n", 0,"#liability. ");
  fprintf(file, "%*s\n", 0,"#");
  fprintf(file, "%*s\n", 0,"#In this respect, the user\'s attention is drawn to the risks associated");
  fprintf(file, "%*s\n", 0,"#with loading,  using,  modifying and/or developing or reproducing the");
  fprintf(file, "%*s\n", 0,"#software by the user in light of its specific status of free software,");
  fprintf(file, "%*s\n", 0,"#that may mean  that it is complicated to manipulate,  and  that  also");
  fprintf(file, "%*s\n", 0,"#therefore means  that it is reserved for developers  and  experienced");
  fprintf(file, "%*s\n", 0,"#professionals having in-depth computer knowledge. Users are therefore");
  fprintf(file, "%*s\n", 0,"#encouraged to load and test the software\'s suitability as regards their");
  fprintf(file, "%*s\n", 0,"#requirements in conditions enabling the security of their systems and/or ");
  fprintf(file, "%*s\n", 0,"#data to be ensured and,  more generally, to use and operate it in the ");
  fprintf(file, "%*s\n", 0,"#same conditions as regards security. ");
  fprintf(file, "%*s\n", 0,"#");
  fprintf(file, "%*s\n", 0,"#The fact that you are presently reading this means that you have had");
  fprintf(file, "%*s\n", 0,"#knowledge of the CeCILL-C license and that you accept its terms.");
  fprintf(file, "%*s\n", 0,"#");
  fprintf(file, "%*s\n", 0,"");
  fprintf(file, "%*s\n", 0,"");
  fprintf(file, "%*s\n", 0,"#!/usr/local/bin/vmd");
  fprintf(file, "%*s\n", 0,"# VMD script written by save_state $Revision: 1.46 $");
  fprintf(file, "%*s\n", 0,"# VMD version: 1.9.2beta1optixtest4");
  //fprintf(file, "%*s\n", 0,"set viewplist {}");
  //fprintf(file, "%*s\n", 0,"set fixedlist {}");
  fprintf(file, "%*s\n", 0,"proc vmdrestoremymaterials {} {");
  fprintf(file, "%*s\n", 2,"  set mlist { Opaque Transparent BrushedMetal Diffuse Ghost Glass1 Glass2 Glass3 Glossy HardPlastic MetallicPastel Steel Translucent Edgy EdgyShiny EdgyGlass Goodsell AOShiny AOChalky AOEdgy BlownGlass GlassBubble }");
  fprintf(file, "%*s\n", 2,"  set mymlist [material list]");
  fprintf(file, "%*s\n", 2,"  foreach mat $mlist {");
  fprintf(file, "%*s\n", 4,"    if { [lsearch $mymlist $mat] == -1 } { ");
  fprintf(file, "%*s\n", 6,"      material add $mat");
  fprintf(file, "%*s\n", 4,"    }");
  fprintf(file, "%*s\n", 2,"  }");
  fprintf(file, "%*s\n", 2,"  material change ambient Opaque 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Opaque 0.650000");
  fprintf(file, "%*s\n", 2,"  material change specular Opaque 0.500000");
  fprintf(file, "%*s\n", 2,"  material change shininess Opaque 0.534020");
  fprintf(file, "%*s\n", 2,"  material change opacity Opaque 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline Opaque 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Opaque 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Opaque 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Transparent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Transparent 0.650000");
  fprintf(file, "%*s\n", 2,"  material change specular Transparent 0.500000");
  fprintf(file, "%*s\n", 2,"  material change shininess Transparent 0.534020");
  fprintf(file, "%*s\n", 2,"  material change opacity Transparent 0.300000");
  fprintf(file, "%*s\n", 2,"  material change outline Transparent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Transparent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Transparent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient BrushedMetal 0.080000");
  fprintf(file, "%*s\n", 2,"  material change diffuse BrushedMetal 0.390000");
  fprintf(file, "%*s\n", 2,"  material change specular BrushedMetal 0.340000");
  fprintf(file, "%*s\n", 2,"  material change shininess BrushedMetal 0.150000");
  fprintf(file, "%*s\n", 2,"  material change opacity BrushedMetal 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline BrushedMetal 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth BrushedMetal 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode BrushedMetal 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Diffuse 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Diffuse 0.620000");
  fprintf(file, "%*s\n", 2,"  material change specular Diffuse 0.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess Diffuse 0.530000");
  fprintf(file, "%*s\n", 2,"  material change opacity Diffuse 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline Diffuse 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Diffuse 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Diffuse 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Ghost 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Ghost 0.000000");
  fprintf(file, "%*s\n", 2,"  material change specular Ghost 1.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess Ghost 0.230000");
  fprintf(file, "%*s\n", 2,"  material change opacity Ghost 0.100000");
  fprintf(file, "%*s\n", 2,"  material change outline Ghost 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Ghost 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Ghost 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Glass1 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Glass1 0.500000");
  fprintf(file, "%*s\n", 2,"  material change specular Glass1 0.650000");
  fprintf(file, "%*s\n", 2,"  material change shininess Glass1 0.530000");
  fprintf(file, "%*s\n", 2,"  material change opacity Glass1 0.150000");
  fprintf(file, "%*s\n", 2,"  material change outline Glass1 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Glass1 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Glass1 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Glass2 0.520000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Glass2 0.760000");
  fprintf(file, "%*s\n", 2,"  material change specular Glass2 0.220000");
  fprintf(file, "%*s\n", 2,"  material change shininess Glass2 0.590000");
  fprintf(file, "%*s\n", 2,"  material change opacity Glass2 0.680000");
  fprintf(file, "%*s\n", 2,"  material change outline Glass2 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Glass2 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Glass2 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Glass3 0.150000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Glass3 0.250000");
  fprintf(file, "%*s\n", 2,"  material change specular Glass3 0.750000");
  fprintf(file, "%*s\n", 2,"  material change shininess Glass3 0.800000");
  fprintf(file, "%*s\n", 2,"  material change opacity Glass3 0.500000");
  fprintf(file, "%*s\n", 2,"  material change outline Glass3 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Glass3 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Glass3 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Glossy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Glossy 0.650000");
  fprintf(file, "%*s\n", 2,"  material change specular Glossy 1.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess Glossy 0.880000");
  fprintf(file, "%*s\n", 2,"  material change opacity Glossy 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline Glossy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Glossy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Glossy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient HardPlastic 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse HardPlastic 0.560000");
  fprintf(file, "%*s\n", 2,"  material change specular HardPlastic 0.280000");
  fprintf(file, "%*s\n", 2,"  material change shininess HardPlastic 0.690000");
  fprintf(file, "%*s\n", 2,"  material change opacity HardPlastic 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline HardPlastic 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth HardPlastic 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode HardPlastic 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient MetallicPastel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse MetallicPastel 0.260000");
  fprintf(file, "%*s\n", 2,"  material change specular MetallicPastel 0.550000");
  fprintf(file, "%*s\n", 2,"  material change shininess MetallicPastel 0.190000");
  fprintf(file, "%*s\n", 2,"  material change opacity MetallicPastel 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline MetallicPastel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth MetallicPastel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode MetallicPastel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Steel 0.250000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Steel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change specular Steel 0.380000");
  fprintf(file, "%*s\n", 2,"  material change shininess Steel 0.320000");
  fprintf(file, "%*s\n", 2,"  material change opacity Steel 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline Steel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Steel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Steel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Translucent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Translucent 0.700000");
  fprintf(file, "%*s\n", 2,"  material change specular Translucent 0.600000");
  fprintf(file, "%*s\n", 2,"  material change shininess Translucent 0.300000");
  fprintf(file, "%*s\n", 2,"  material change opacity Translucent 0.800000");
  fprintf(file, "%*s\n", 2,"  material change outline Translucent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Translucent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Translucent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Edgy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Edgy 0.660000");
  fprintf(file, "%*s\n", 2,"  material change specular Edgy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess Edgy 0.750000");
  fprintf(file, "%*s\n", 2,"  material change opacity Edgy 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline Edgy 0.620000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Edgy 0.940000");
  fprintf(file, "%*s\n", 2,"  material change transmode Edgy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient EdgyShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse EdgyShiny 0.660000");
  fprintf(file, "%*s\n", 2,"  material change specular EdgyShiny 0.960000");
  fprintf(file, "%*s\n", 2,"  material change shininess EdgyShiny 0.750000");
  fprintf(file, "%*s\n", 2,"  material change opacity EdgyShiny 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline EdgyShiny 0.760000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth EdgyShiny 0.940000");
  fprintf(file, "%*s\n", 2,"  material change transmode EdgyShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient EdgyGlass 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse EdgyGlass 0.660000");
  fprintf(file, "%*s\n", 2,"  material change specular EdgyGlass 0.500000");
  fprintf(file, "%*s\n", 2,"  material change shininess EdgyGlass 0.750000");
  fprintf(file, "%*s\n", 2,"  material change opacity EdgyGlass 0.620000");
  fprintf(file, "%*s\n", 2,"  material change outline EdgyGlass 0.620000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth EdgyGlass 0.940000");
  fprintf(file, "%*s\n", 2,"  material change transmode EdgyGlass 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Goodsell 0.520000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Goodsell 1.000000");
  fprintf(file, "%*s\n", 2,"  material change specular Goodsell 0.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess Goodsell 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Goodsell 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline Goodsell 4.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Goodsell 0.900000");
  fprintf(file, "%*s\n", 2,"  material change transmode Goodsell 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient AOShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse AOShiny 0.850000");
  fprintf(file, "%*s\n", 2,"  material change specular AOShiny 0.200000");
  fprintf(file, "%*s\n", 2,"  material change shininess AOShiny 0.530000");
  fprintf(file, "%*s\n", 2,"  material change opacity AOShiny 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline AOShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth AOShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode AOShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient AOChalky 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse AOChalky 0.850000");
  fprintf(file, "%*s\n", 2,"  material change specular AOChalky 0.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess AOChalky 0.530000");
  fprintf(file, "%*s\n", 2,"  material change opacity AOChalky 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline AOChalky 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth AOChalky 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode AOChalky 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient AOEdgy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse AOEdgy 0.900000");
  fprintf(file, "%*s\n", 2,"  material change specular AOEdgy 0.200000");
  fprintf(file, "%*s\n", 2,"  material change shininess AOEdgy 0.530000");
  fprintf(file, "%*s\n", 2,"  material change opacity AOEdgy 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline AOEdgy 0.620000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth AOEdgy 0.930000");
  fprintf(file, "%*s\n", 2,"  material change transmode AOEdgy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient BlownGlass 0.040000");
  fprintf(file, "%*s\n", 2,"  material change diffuse BlownGlass 0.340000");
  fprintf(file, "%*s\n", 2,"  material change specular BlownGlass 1.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess BlownGlass 1.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity BlownGlass 0.100000");
  fprintf(file, "%*s\n", 2,"  material change outline BlownGlass 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth BlownGlass 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode BlownGlass 1.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient GlassBubble 0.250000");
  fprintf(file, "%*s\n", 2,"  material change diffuse GlassBubble 0.340000");
  fprintf(file, "%*s\n", 2,"  material change specular GlassBubble 1.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess GlassBubble 1.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity GlassBubble 0.040000");
  fprintf(file, "%*s\n", 2,"  material change outline GlassBubble 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth GlassBubble 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode GlassBubble 1.000000");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"vmdrestoremymaterials");
  fprintf(file, "%*s\n", 0,"# Atom selection macros");
  fprintf(file, "%*s\n", 0,"atomselect macro at {resname ADE A THY T");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro acidic {resname ASP GLU");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro cyclic {resname HIS PHE PRO TRP TYR");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro acyclic {protein and not cyclic");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro aliphatic {resname ALA GLY ILE LEU VAL");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro alpha {protein and name CA");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro amino {protein");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro aromatic {resname HIS PHE TRP TYR");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro basic {resname ARG HIS LYS HSP");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro bonded {numbonds > 0");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro buried {resname ALA LEU VAL ILE PHE CYS MET TRP");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro cg {resname CYT C GUA G");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro charged {basic or acidic");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro hetero {not (protein or nucleic)");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro hydrophobic {resname ALA LEU VAL ILE PRO PHE MET TRP");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro small {resname ALA GLY SER");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro medium {resname VAL THR ASP ASN PRO CYS ASX PCA HYP");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro large {protein and not (small or medium)");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro neutral {resname VAL PHE GLN TYR HIS CYS MET TRP ASX GLX PCA HYP");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro polar {protein and not hydrophobic");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro purine {resname ADE A GUA G");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro pyrimidine {resname CYT C THY T URA U");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro surface {protein and not buried");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro lipid {resname DLPE DMPC DPPC GPC LPPC PALM PC PGCL POPC POPE");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro lipids {lipid");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro ion {resname AL BA CA CAL CD CES CLA CL CO CS CU CU1 CUA HG IN IOD K MG MN3 MO3 MO4 MO5 MO6 NA NAW OC7 PB POT PT RB SOD TB TL WO4 YB ZN ZN1 ZN2");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro ions {ion");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro sugar {resname AGLC");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro solvent {not (protein or sugar or nucleic or lipid)");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro carbon {name \"C.*\" and not ion");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro hydrogen {name \"[0-9]?H.*\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro nitrogen {name \"N.*\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro oxygen {name \"O.*\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro sulfur {name \"S.*\" and not ion");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro noh {not hydrogen");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro heme {resname HEM HEME");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationall {altloc \"\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationA {altloc \"\" or altloc \"A\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationB {altloc \"\" or altloc \"B\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationC {altloc \"\" or altloc \"C\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationD {altloc \"\" or altloc \"D\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationE {altloc \"\" or altloc \"E\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationF {altloc \"\" or altloc \"F\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro drude {type DRUD or type LP");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro unparametrized beta<1");
  fprintf(file, "%*s\n", 0,"atomselect macro addedmolefacture {occupancy 0.8}");
  fprintf(file, "%*s\n", 0,"# Display settings");
  fprintf(file, "%*s\n", 0,"display eyesep       0.065000");
  fprintf(file, "%*s\n", 0,"display focallength  2.000000");
  fprintf(file, "%*s\n", 0,"display height       6.000000");
  fprintf(file, "%*s\n", 0,"display distance     -2.000000");
  fprintf(file, "%*s\n", 0,"display projection   Perspective");
  fprintf(file, "%*s\n", 0,"display nearclip set 0.500000");
  fprintf(file, "%*s\n", 0,"display farclip  set 10.000000");
  fprintf(file, "%*s\n", 0,"display depthcue   off");
  fprintf(file, "%*s\n", 0,"display cuestart   0.500000");
  fprintf(file, "%*s\n", 0,"display cueend     10.000000");
  fprintf(file, "%*s\n", 0,"display cuestart   0.500000");
  fprintf(file, "%*s\n", 0,"display cueend     10.000000");
  fprintf(file, "%*s\n", 0,"display cuedensity 0.320000");
  fprintf(file, "%*s\n", 0,"display cuemode    Exp2");
  fprintf(file, "%*s\n", 0,"display shadows off");
  fprintf(file, "%*s\n", 0,"display ambientocclusion off");
  fprintf(file, "%*s\n", 0,"display aoambient 0.800000");
  fprintf(file, "%*s\n", 0,"display aodirect 0.300000");
  fprintf(file, "%*s\n", 0,"display dof off");
  fprintf(file, "%*s\n", 0,"display dof_fnumber 64.000000");
  fprintf(file, "%*s\n", 0,"display dof_focaldist 0.700000");
  fprintf(file, "%*s%s%s\n", 0, "mol new ", rep[COMPLEX].c_str(), " type xyz first 0 last -1 step 1 filebonds 1 autobonds 1 waitfor all");
  fprintf(file, "%*s\n", 0,"mol delrep 0 top");
  if (not QMmode) // promol mode, a surface representation is more appropriate for protein (=frag2)
   {
     fprintf(file, "%*s\n", 0,"mol representation Surf 1.400000 0.000000");
   }
   else
   {
     fprintf(file, "%*s\n", 0,"mol representation CPK 1.000000 0.300000 12.000000 12.000000"); // QM mode
   }
  fprintf(file, "%*s\n", 0,"mol color Charge");
  //fprintf(file, "%*s%s%s\n", 0, "mol selection {index ", rep[FIRST_PROT_INDEX].c_str(), " to ", rep[LAST_COMPLEX_INDEX].c_str(), "}");
  fprintf(file, "%*s%s%s\n", 0, "mol selection {", rep[FRAG2Def].c_str(), "}");
  fprintf(file, "%*s\n", 0,"mol material Opaque");
  fprintf(file, "%*s\n", 0,"mol addrep top");
  fprintf(file, "%*s\n", 0,"mol selupdate 0 top 0");
  fprintf(file, "%*s\n", 0,"mol colupdate 0 top 0");
  fprintf(file, "%*s%s%s\n", 0, "mol scaleminmax top 0 0 ", rep[MAX_PERCENT].c_str(), ""); 
  fprintf(file, "%*s\n", 0,"mol smoothrep top 0 0");
  fprintf(file, "%*s\n", 0,"mol drawframes top 0 {now}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 0 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  0 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 0 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 0 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 1 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  1 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 1 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 1 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 2 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  2 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 2 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 2 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 3 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  3 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 3 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 3 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 4 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  4 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 4 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 4 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 5 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  5 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 5 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 5 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol representation CPK 1.000000 0.300000 12.000000 12.000000");
  fprintf(file, "%*s\n", 0,"mol color Charge");
//  fprintf(file, "%*s%s%s\n", 0, "mol selection {index 0 to ", rep[LAST_LIG_INDEX].c_str(), "}");
  fprintf(file, "%*s%s%s\n", 0, "mol selection {", rep[FRAG1Def].c_str(), "}");
  fprintf(file, "%*s\n", 0,"mol material Opaque");
  fprintf(file, "%*s\n", 0,"mol addrep top");
  fprintf(file, "%*s\n", 0,"mol selupdate 1 top 0");
  fprintf(file, "%*s\n", 0,"mol colupdate 1 top 0");
  fprintf(file, "%*s%s%s\n", 0, "mol scaleminmax top 1 0 ", rep[MAX_PERCENT].c_str(), "");

  fprintf(file, "%*s\n", 0,"mol smoothrep top 1 0");
  fprintf(file, "%*s\n", 0,"mol drawframes top 1 {now}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 0 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  0 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 0 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 0 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 1 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  1 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 1 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 1 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 2 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  2 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 2 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 2 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 3 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  3 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 3 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 3 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 4 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  4 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 4 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 4 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 5 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  5 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 5 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 5 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol representation CPK 1.000000 0.300000 12.000000 12.000000");
  fprintf(file, "%*s\n", 0,"mol color Name");
//  fprintf(file, "%*s%s%s\n", 0, "mol selection {index 0 to ", rep[LAST_LIG_INDEX].c_str(), "}");
  fprintf(file, "%*s%s%s\n", 0, "mol selection {", rep[FRAG1Def].c_str(), "}");
  fprintf(file, "%*s\n", 0,"mol material Opaque");
  fprintf(file, "%*s\n", 0,"mol addrep top");
  fprintf(file, "%*s\n", 0,"mol selupdate 2 top 0");
  fprintf(file, "%*s\n", 0,"mol colupdate 2 top 0");
  fprintf(file, "%*s\n", 0,"mol scaleminmax top 2 0.000000 0.000000");
  fprintf(file, "%*s\n", 0,"mol smoothrep top 2 0");
  fprintf(file, "%*s\n", 0,"mol drawframes top 2 {now}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 0 2 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  0 2 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 0 2 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 0 2 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 1 2 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  1 2 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 1 2 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 1 2 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 2 2 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  2 2 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 2 2 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 2 2 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 3 2 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  3 2 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 3 2 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 3 2 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 4 2 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  4 2 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 4 2 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 4 2 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 5 2 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  5 2 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 5 2 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 5 2 top {0}");
  fprintf(file, "%*s\n", 0,"mol showrep top 2 0");
  fprintf(file, "%*s\n", 0,"mol rename top coord.xyz");
  fprintf(file, "%*s\n", 0,"set topmol [molinfo top]");
  fprintf(file, "%*s\n", 0,"# done with molecule 0");
  //fprintf(file, "%*s\n", 0,"foreach v $viewplist {");
  //fprintf(file, "%*s\n", 2,"  molinfo $v set {center_matrix rotate_matrix scale_matrix global_matrix} $viewpoints($v)");
  //fprintf(file, "%*s\n", 0,"}");
  //fprintf(file, "%*s\n", 0,"foreach v $fixedlist {");
  //fprintf(file, "%*s\n", 2,"  molinfo $v set fixed 1");
  //fprintf(file, "%*s\n", 0,"}");
  //fprintf(file, "%*s\n", 0,"unset viewplist");
  //fprintf(file, "%*s\n", 0,"unset fixedlist");
  fprintf(file, "%*s\n", 0,"mol top $topmol");
  fprintf(file, "%*s\n", 0,"unset topmol");
  fprintf(file, "%*s\n", 0,"proc vmdrestoremycolors {} {");
  fprintf(file, "%*s\n", 0,"color scale colors RWB {1.0 0.0 0.0} {1.0 1.0 1.0} {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"color scale colors BWR {0.0 0.0 1.0} {1.0 1.0 1.0} {1.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"color scale colors RGryB {1.0 0.0 0.0} {0.5 0.5 0.5} {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"color scale colors BGryR {0.0 0.0 1.0} {0.5 0.5 0.5} {1.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"color scale colors RGB {1.0 0.0 0.0} {0.0 1.0 0.0} {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"color scale colors BGR {0.0 0.0 1.0} {0.0 1.0 0.0} {1.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"color scale colors RWG {1.0 0.0 0.0} {1.0 1.0 1.0} {0.0 1.0 0.0}");
  fprintf(file, "%*s\n", 0,"color scale colors GWR {0.0 1.0 0.0} {1.0 1.0 1.0} {1.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"color scale colors GWB {0.0 1.0 0.0} {1.0 1.0 1.0} {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"color scale colors BWG {0.0 0.0 1.0} {1.0 1.0 1.0} {0.0 1.0 0.0}");
  fprintf(file, "%*s\n", 0,"color scale colors BlkW {0.0 0.0 0.0} {0.5 0.5 0.5} {1.0 1.0 1.0}");
  fprintf(file, "%*s\n", 0,"color scale colors WBlk {1.0 1.0 1.0} {0.5 0.5 0.5} {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 2,"  color scale method BGryR");
  fprintf(file, "%*s\n", 2,"  set colorcmds {");
  fprintf(file, "%*s\n", 4,"    {color Display {BackgroundTop} black}");
  fprintf(file, "%*s\n", 4,"    {color Display {BackgroundBot} blue2}");
  fprintf(file, "%*s\n", 4,"    {color Display {FPS} white}");
  fprintf(file, "%*s\n", 4,"    {color Name {LPA} green}");
  fprintf(file, "%*s\n", 4,"    {color Name {LPB} green}");
  fprintf(file, "%*s\n", 4,"    {color Name {F} pink}");
  fprintf(file, "%*s\n", 4,"    {color Name {M} cyan}");
  fprintf(file, "%*s\n", 4,"    {color Type {LP} green}");
  fprintf(file, "%*s\n", 4,"    {color Type {DRUD} pink}");
  fprintf(file, "%*s\n", 4,"    {color Type {F} pink}");
  fprintf(file, "%*s\n", 4,"    {color Type {M} cyan}");
  fprintf(file, "%*s\n", 4,"    {color Element {X} cyan}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ac} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ag} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Al} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Am} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ar} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {As} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {At} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Au} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {B} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ba} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Be} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Bh} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Bi} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Bk} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Br} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ca} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cd} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ce} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cf} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cl} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cm} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Co} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cs} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cu} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Db} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ds} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Dy} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Er} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Es} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Eu} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {F} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Fe} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Fm} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Fr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ga} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Gd} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ge} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {He} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Hf} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Hg} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ho} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Hs} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {I} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {In} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ir} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {K} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Kr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {La} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Li} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Lr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Lu} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Md} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Mg} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Mn} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Mo} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Mt} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Na} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Nb} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Nd} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ne} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ni} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {No} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Np} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Os} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pa} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pb} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pd} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pm} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Po} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pt} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pu} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ra} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Rb} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Re} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Rf} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Rg} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Rh} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Rn} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ru} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Sb} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Sc} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Se} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Sg} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Si} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Sm} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Sn} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Sr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ta} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Tb} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Tc} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Te} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Th} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ti} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Tl} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Tm} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {U} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {V} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {W} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Xe} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Y} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Yb} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Zr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Resname {} silver}");
  fprintf(file, "%*s\n", 4,"    {color Chain {X} blue}");
  fprintf(file, "%*s\n", 4,"    {color Segname {} blue}");
  fprintf(file, "%*s\n", 4,"    {color Conformation {all} blue}");
  fprintf(file, "%*s\n", 4,"    {color Molecule {0} blue}");
  fprintf(file, "%*s\n", 4,"    {color Molecule {1} red}");
  fprintf(file, "%*s\n", 4,"    {color Structure {3_10_Helix} blue}");
  fprintf(file, "%*s\n", 4,"    {color Surface {Grasp} gray}");
  fprintf(file, "%*s\n", 4,"    {color Labels {Springs} orange}");
  fprintf(file, "%*s\n", 4,"    {color Stage {Even} gray}");
  fprintf(file, "%*s\n", 4,"    {color Stage {Odd} silver}");
  fprintf(file, "%*s\n", 2,"  }");
  fprintf(file, "%*s\n", 2,"  foreach colcmd $colorcmds {");
  fprintf(file, "%*s\n", 4,"    set val [catch {eval $colcmd}]");
  fprintf(file, "%*s\n", 2,"  }");
  fprintf(file, "%*s\n", 2,"  color change rgb 0 0.0 0.0 1.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 2 0.3499999940395355 0.3499999940395355 0.3499999940395355");
  fprintf(file, "%*s\n", 2,"  color change rgb 3 1.0 0.5 0.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 4 1.0 1.0 0.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 5 0.5 0.5 0.20000000298023224");
  fprintf(file, "%*s\n", 2,"  color change rgb 6 0.6000000238418579 0.6000000238418579 0.6000000238418579");
  fprintf(file, "%*s\n", 2,"  color change rgb 7 0.0 1.0 0.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 9 1.0 0.6000000238418579 0.6000000238418579");
  fprintf(file, "%*s\n", 2,"  color change rgb 11 0.6499999761581421 0.0 0.6499999761581421");
  fprintf(file, "%*s\n", 2,"  color change rgb 12 0.5 0.8999999761581421 0.4000000059604645");
  fprintf(file, "%*s\n", 2,"  color change rgb 13 0.8999999761581421 0.4000000059604645 0.699999988079071");
  fprintf(file, "%*s\n", 2,"  color change rgb 14 0.5 0.30000001192092896 0.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 15 0.5 0.5 0.75");
  fprintf(file, "%*s\n", 2,"  color change rgb 17 0.8799999952316284 0.9700000286102295 0.019999999552965164");
  fprintf(file, "%*s\n", 2,"  color change rgb 18 0.550000011920929 0.8999999761581421 0.019999999552965164");
  fprintf(file, "%*s\n", 2,"  color change rgb 19 0.0 0.8999999761581421 0.03999999910593033");
  fprintf(file, "%*s\n", 2,"  color change rgb 20 0.0 0.8999999761581421 0.5");
  fprintf(file, "%*s\n", 2,"  color change rgb 21 0.0 0.8799999952316284 1.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 22 0.0 0.7599999904632568 1.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 23 0.019999999552965164 0.3799999952316284 0.6700000166893005");
  fprintf(file, "%*s\n", 2,"  color change rgb 24 0.009999999776482582 0.03999999910593033 0.9300000071525574");
  fprintf(file, "%*s\n", 2,"  color change rgb 25 0.27000001072883606 0.0 0.9800000190734863");
  fprintf(file, "%*s\n", 2,"  color change rgb 26 0.44999998807907104 0.0 0.8999999761581421");
  fprintf(file, "%*s\n", 2,"  color change rgb 27 0.8999999761581421 0.0 0.8999999761581421");
  fprintf(file, "%*s\n", 2,"  color change rgb 28 1.0 0.0 0.6600000262260437");
  fprintf(file, "%*s\n", 2,"  color change rgb 29 0.9800000190734863 0.0 0.23000000417232513");
  fprintf(file, "%*s\n", 2,"  color change rgb 30 0.8100000023841858 0.0 0.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 31 0.8899999856948853 0.3499999940395355 0.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 32 0.9599999785423279 0.7200000286102295 0.0");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"vmdrestoremycolors");
  fprintf(file, "%*s\n", 0,"label textsize 1.0");
  fprintf(file, "%*s\n", 0,"");
  fprintf(file, "%*s\n", 0,"# set colormap according to atom contributions to the inter deltag value");
  fprintf(file, "%*s%s%s\n", 0, "set charge_file [open ", rep[PERCENT].c_str(), "]");
  fprintf(file, "%*s\n", 0,"set num_of_atoms [molinfo 0 get numatoms]");
  fprintf(file, "%*s\n", 0,"# skip header-line");
  fprintf(file, "%*s\n", 0,"gets $charge_file line");
  fprintf(file, "%*s\n", 0,"# read one line per atom");
  fprintf(file, "%*s\n", 0,"for {set i 0} { $i < $num_of_atoms } { incr i } {");
  fprintf(file, "%*s\n", 2,"  # read currentline");
  fprintf(file, "%*s\n", 2,"  gets $charge_file line");
  fprintf(file, "%*s\n", 2,"  # suppress extra whitespace and extract column 4");
  fprintf(file, "%*s\n", 2,"  set atomContrib [lindex [join $line \" \"] 3]");
  fprintf(file, "%*s\n", 2,"  # create atom selection with current atom");
  fprintf(file, "%*s\n", 2,"  set sel [atomselect 0 \"index == $i\"]");
  fprintf(file, "%*s\n", 2,"  # set the color of the current atom according to its contrib to intermolecular interactions");
  fprintf(file, "%*s\n", 2,"  $sel set charge $atomContrib");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"");
  fprintf(file, "%*s\n", 0,"axes location Off");
  fprintf(file, "%*s\n", 0,"display rendermode GLSL");
  fclose(file);
} // end of generateVMDAtContribInterFile


void generateVMDelfFile(const std::string *rep)
{
  FILE* file=fopen("elf.vmd","w");
  fprintf(file, "%*s\n", 0,"#");
  fprintf(file, "%*s\n", 0,"##Copyright University of Reims Champagne-Ardenne");
  fprintf(file, "%*s\n", 0,"#Authors and Contributors: Akilan RAJAMANI, Corentin LEFEBVRE, Johanna KLEIN, Emmanuel PLUOT, Gaetan RUBEZ, Hassan Khartabil, Jean-Charles-BOISSON and Eric HENON");
  fprintf(file, "%*s\n", 0,"#Contributors: Hassan Khartabil, Miguel Ponce-Vargas, Julia Contreras-Garcia");
  fprintf(file, "%*s\n", 0,"##(24/07/2017)");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"##jean-charles.boisson@univ-reims.fr, eric.henon@univ-reims.fr");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"##This software is a computer program whose purpose is to ");
  fprintf(file, "%*s\n", 0,"##detect and prepare the plot of molecular interactions");
  fprintf(file, "%*s\n", 0,"##from electron density and IGM reference using promolecular");
  fprintf(file, "%*s\n", 0,"##electron density.");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"##This software is governed by the CeCILL-C license under French law and");
  fprintf(file, "%*s\n", 0,"##abiding by the rules of distribution of free software.  You can  use, ");
  fprintf(file, "%*s\n", 0,"##modify and/ or redistribute the software under the terms of the CeCILL-C");
  fprintf(file, "%*s\n", 0,"##license as circulated by CEA, CNRS and INRIA at the following URL");
  fprintf(file, "%*s\n", 0,"##\"http://www.cecill.info\". ");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"##As a counterpart to the access to the source code and  rights to copy,");
  fprintf(file, "%*s\n", 0,"##modify and redistribute granted by the license, users are provided only");
  fprintf(file, "%*s\n", 0,"##with a limited warranty  and the software\'s author,  the holder of the");
  fprintf(file, "%*s\n", 0,"##economic rights,  and the successive licensors  have only  limited");
  fprintf(file, "%*s\n", 0,"##liability. ");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"##In this respect, the user\'s attention is drawn to the risks associated");
  fprintf(file, "%*s\n", 0,"##with loading,  using,  modifying and/or developing or reproducing the");
  fprintf(file, "%*s\n", 0,"##software by the user in light of its specific status of free software,");
  fprintf(file, "%*s\n", 0,"##that may mean  that it is complicated to manipulate,  and  that  also");
  fprintf(file, "%*s\n", 0,"##therefore means  that it is reserved for developers  and  experienced");
  fprintf(file, "%*s\n", 0,"##professionals having in-depth computer knowledge. Users are therefore");
  fprintf(file, "%*s\n", 0,"##encouraged to load and test the software\'s suitability as regards their");
  fprintf(file, "%*s\n", 0,"##requirements in conditions enabling the security of their systems and/or ");
  fprintf(file, "%*s\n", 0,"##data to be ensured and,  more generally, to use and operate it in the ");
  fprintf(file, "%*s\n", 0,"##same conditions as regards security. ");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"##The fact that you are presently reading this means that you have had");
  fprintf(file, "%*s\n", 0,"##knowledge of the CeCILL-C license and that you accept its terms.");
  fprintf(file, "%*s\n", 0,"##");

  fprintf(file, "%*s\n", 0,"##!/usr/local/bin/vmd");
  fprintf(file, "%*s\n", 0,"# VMD script written by save_state $Revision: 1.46 $");
  fprintf(file, "%*s\n", 0,"# VMD version: 1.9.2beta1optixtest4");
  fprintf(file, "%*s\n", 0,"proc vmdrestoremymaterials {} {");
  fprintf(file, "%*s\n", 2,"  set mlist { Opaque Transparent BrushedMetal Diffuse Ghost Glass1 Glass2 Glass3 Glossy HardPlastic MetallicPastel Steel Translucent Edgy EdgyShiny EdgyGlass Goodsell AOShiny AOChalky AOEdgy BlownGlass GlassBubble }");
  fprintf(file, "%*s\n", 2,"  set mymlist [material list]");
  fprintf(file, "%*s\n", 2,"  foreach mat $mlist {");
  fprintf(file, "%*s\n", 4,"    if { [lsearch $mymlist $mat] == -1 } { ");
  fprintf(file, "%*s\n", 6,"      material add $mat");
  fprintf(file, "%*s\n", 4,"    }");
  fprintf(file, "%*s\n", 2,"  }");


fprintf(file, "%*s\n",  2,"  material change ambient Opaque 0.000000");
fprintf(file, "%*s\n",  2,"  material change diffuse Opaque 0.650000");
fprintf(file, "%*s\n",  2,"  material change specular Opaque 0.500000");
fprintf(file, "%*s\n",  2,"  material change shininess Opaque 0.534020");
fprintf(file, "%*s\n",  2,"  material change mirror Opaque 0.000000");
fprintf(file, "%*s\n",  2,"  material change opacity Opaque 1.000000");
fprintf(file, "%*s\n",  2,"  material change outline Opaque 0.000000");
fprintf(file, "%*s\n",  2,"  material change outlinewidth Opaque 0.000000");
fprintf(file, "%*s\n",  2,"  material change transmode Opaque 0.000000");
fprintf(file, "%*s\n",  2,"  material change ambient Transparent 0.000000");
fprintf(file, "%*s\n",  2,"  material change diffuse Transparent 0.650000");
fprintf(file, "%*s\n",  2,"  material change specular Transparent 0.500000");
fprintf(file, "%*s\n",  2,"  material change shininess Transparent 0.534020");
fprintf(file, "%*s\n",  2,"  material change mirror Transparent 0.000000");
fprintf(file, "%*s\n",  2,"  material change opacity Transparent 0.300000");
fprintf(file, "%*s\n",  2,"  material change outline Transparent 0.000000");
fprintf(file, "%*s\n",  2,"  material change outlinewidth Transparent 0.000000");
fprintf(file, "%*s\n",  2,"  material change transmode Transparent 0.000000");
fprintf(file, "%*s\n",  2,"  material change ambient BrushedMetal 0.080000");
fprintf(file, "%*s\n",  2,"  material change diffuse BrushedMetal 0.390000");
fprintf(file, "%*s\n",  2,"  material change specular BrushedMetal 0.340000");
fprintf(file, "%*s\n",  2,"  material change shininess BrushedMetal 0.150000");
fprintf(file, "%*s\n",  2,"  material change mirror BrushedMetal 0.000000");
fprintf(file, "%*s\n",  2,"  material change opacity BrushedMetal 1.000000");
fprintf(file, "%*s\n",  2,"  material change outline BrushedMetal 0.000000");
fprintf(file, "%*s\n",  2,"  material change outlinewidth BrushedMetal 0.000000");
fprintf(file, "%*s\n",  2,"  material change transmode BrushedMetal 0.000000");
fprintf(file, "%*s\n",  2,"  material change ambient Diffuse 0.000000");
fprintf(file, "%*s\n",  2,"  material change diffuse Diffuse 0.620000");
fprintf(file, "%*s\n",  2,"  material change specular Diffuse 0.000000");
fprintf(file, "%*s\n",  2,"  material change shininess Diffuse 0.530000");
fprintf(file, "%*s\n",  2,"  material change mirror Diffuse 0.000000");
fprintf(file, "%*s\n",  2,"  material change opacity Diffuse 1.000000");
fprintf(file, "%*s\n",  2,"  material change outline Diffuse 0.000000");
fprintf(file, "%*s\n",  2,"  material change outlinewidth Diffuse 0.000000");
fprintf(file, "%*s\n",  2,"  material change transmode Diffuse 0.000000");
fprintf(file, "%*s\n",  2,"  material change ambient Ghost 0.000000");
fprintf(file, "%*s\n",  2,"  material change diffuse Ghost 0.000000");
fprintf(file, "%*s\n",  2,"  material change specular Ghost 1.000000");
fprintf(file, "%*s\n",  2,"  material change shininess Ghost 0.230000");
fprintf(file, "%*s\n",  2,"  material change mirror Ghost 0.000000");
fprintf(file, "%*s\n",  2,"  material change opacity Ghost 0.100000");
fprintf(file, "%*s\n",  2,"  material change outline Ghost 0.000000");
fprintf(file, "%*s\n",  2,"  material change outlinewidth Ghost 0.000000");
fprintf(file, "%*s\n",  2,"  material change transmode Ghost 0.000000");
fprintf(file, "%*s\n",  2,"  material change ambient Glass1 0.000000");
fprintf(file, "%*s\n",  2,"  material change diffuse Glass1 0.500000");
fprintf(file, "%*s\n",  2,"  material change specular Glass1 0.650000");
fprintf(file, "%*s\n",  2,"  material change shininess Glass1 0.530000");
fprintf(file, "%*s\n",  2,"  material change mirror Glass1 0.000000");
fprintf(file, "%*s\n",  2,"  material change opacity Glass1 0.150000");
fprintf(file, "%*s\n",  2,"  material change outline Glass1 0.000000");
fprintf(file, "%*s\n",  2,"  material change outlinewidth Glass1 0.000000");
fprintf(file, "%*s\n",  2,"  material change transmode Glass1 0.000000");
fprintf(file, "%*s\n",  2,"  material change ambient Glass2 0.520000");
fprintf(file, "%*s\n",  2,"  material change diffuse Glass2 0.760000");
fprintf(file, "%*s\n",  2,"  material change specular Glass2 0.220000");
fprintf(file, "%*s\n",  2,"  material change shininess Glass2 0.590000");
fprintf(file, "%*s\n",  2,"  material change mirror Glass2 0.000000");
fprintf(file, "%*s\n",  2,"  material change opacity Glass2 0.680000");
fprintf(file, "%*s\n",  2,"  material change outline Glass2 0.000000");
fprintf(file, "%*s\n",  2,"  material change outlinewidth Glass2 0.000000");
fprintf(file, "%*s\n",  2,"  material change transmode Glass2 0.000000");
fprintf(file, "%*s\n",  2,"  material change ambient Glass3 0.150000");
fprintf(file, "%*s\n",  2,"  material change diffuse Glass3 0.250000");
fprintf(file, "%*s\n",  2,"  material change specular Glass3 0.750000");
fprintf(file, "%*s\n",  2,"  material change shininess Glass3 0.800000");
fprintf(file, "%*s\n",  2,"  material change mirror Glass3 0.000000");
fprintf(file, "%*s\n",  2,"  material change opacity Glass3 0.500000");
fprintf(file, "%*s\n",  2,"  material change outline Glass3 0.000000");
fprintf(file, "%*s\n",  2,"  material change outlinewidth Glass3 0.000000");
fprintf(file, "%*s\n",  2,"  material change transmode Glass3 0.000000");
fprintf(file, "%*s\n",  2,"  material change ambient Glossy 0.000000");
fprintf(file, "%*s\n",  2,"  material change diffuse Glossy 0.650000");
fprintf(file, "%*s\n",  2,"  material change specular Glossy 1.000000");
fprintf(file, "%*s\n",  2,"  material change shininess Glossy 0.880000");
fprintf(file, "%*s\n",  2,"  material change mirror Glossy 0.000000");
fprintf(file, "%*s\n",  2,"  material change opacity Glossy 1.000000");
fprintf(file, "%*s\n",  2,"  material change outline Glossy 0.000000");
fprintf(file, "%*s\n",  2,"  material change outlinewidth Glossy 0.000000");
fprintf(file, "%*s\n",  2,"  material change transmode Glossy 0.000000");
fprintf(file, "%*s\n",  2,"  material change ambient HardPlastic 0.000000");
fprintf(file, "%*s\n",  2,"  material change diffuse HardPlastic 0.560000");
fprintf(file, "%*s\n",  2,"  material change specular HardPlastic 0.280000");
fprintf(file, "%*s\n",  2,"  material change shininess HardPlastic 0.690000");
fprintf(file, "%*s\n",  2,"  material change mirror HardPlastic 0.000000");
fprintf(file, "%*s\n",  2,"  material change opacity HardPlastic 1.000000");
fprintf(file, "%*s\n",  2,"  material change outline HardPlastic 0.000000");
fprintf(file, "%*s\n",  2,"  material change outlinewidth HardPlastic 0.000000");
fprintf(file, "%*s\n",  2,"  material change transmode HardPlastic 0.000000");
fprintf(file, "%*s\n",  2,"  material change ambient MetallicPastel 0.000000");
fprintf(file, "%*s\n",  2,"  material change diffuse MetallicPastel 0.260000");
fprintf(file, "%*s\n",  2,"  material change specular MetallicPastel 0.550000");
fprintf(file, "%*s\n",  2,"  material change shininess MetallicPastel 0.190000");
fprintf(file, "%*s\n",  2,"  material change mirror MetallicPastel 0.000000");
fprintf(file, "%*s\n",  2,"  material change opacity MetallicPastel 1.000000");
fprintf(file, "%*s\n",  2,"  material change outline MetallicPastel 0.000000");
fprintf(file, "%*s\n",  2,"  material change outlinewidth MetallicPastel 0.000000");
fprintf(file, "%*s\n",  2,"  material change transmode MetallicPastel 0.000000");
fprintf(file, "%*s\n",  2,"  material change ambient Steel 0.250000");
fprintf(file, "%*s\n",  2,"  material change diffuse Steel 0.000000");
fprintf(file, "%*s\n",  2,"  material change specular Steel 0.380000");
fprintf(file, "%*s\n",  2,"  material change shininess Steel 0.320000");
fprintf(file, "%*s\n",  2,"  material change mirror Steel 0.000000");
fprintf(file, "%*s\n",  2,"  material change opacity Steel 1.000000");
fprintf(file, "%*s\n",  2,"  material change outline Steel 0.000000");
fprintf(file, "%*s\n",  2,"  material change outlinewidth Steel 0.000000");
fprintf(file, "%*s\n",  2,"  material change transmode Steel 0.000000");
fprintf(file, "%*s\n",  2,"  material change ambient Translucent 0.000000");
fprintf(file, "%*s\n",  2,"  material change diffuse Translucent 0.700000");
fprintf(file, "%*s\n",  2,"  material change specular Translucent 0.600000");
fprintf(file, "%*s\n",  2,"  material change shininess Translucent 0.300000");
fprintf(file, "%*s\n",  2,"  material change mirror Translucent 0.000000");
fprintf(file, "%*s\n",  2,"  material change opacity Translucent 0.800000");
fprintf(file, "%*s\n",  2,"  material change outline Translucent 0.000000");
fprintf(file, "%*s\n",  2,"  material change outlinewidth Translucent 0.000000");
fprintf(file, "%*s\n",  2,"  material change transmode Translucent 0.000000");
fprintf(file, "%*s\n",  2,"  material change ambient Edgy 0.000000");
fprintf(file, "%*s\n",  2,"  material change diffuse Edgy 0.660000");
fprintf(file, "%*s\n",  2,"  material change specular Edgy 0.000000");
fprintf(file, "%*s\n",  2,"  material change shininess Edgy 0.750000");
fprintf(file, "%*s\n",  2,"  material change mirror Edgy 0.000000");
fprintf(file, "%*s\n",  2,"  material change opacity Edgy 1.000000");
fprintf(file, "%*s\n",  2,"  material change outline Edgy 0.620000");
fprintf(file, "%*s\n",  2,"  material change outlinewidth Edgy 0.940000");
fprintf(file, "%*s\n",  2,"  material change transmode Edgy 0.000000");
fprintf(file, "%*s\n",  2,"  material change ambient EdgyShiny 0.000000");
fprintf(file, "%*s\n",  2,"  material change diffuse EdgyShiny 0.660000");
fprintf(file, "%*s\n",  2,"  material change specular EdgyShiny 0.960000");
fprintf(file, "%*s\n",  2,"  material change shininess EdgyShiny 0.750000");
fprintf(file, "%*s\n",  2,"  material change mirror EdgyShiny 0.000000");
fprintf(file, "%*s\n",  2,"  material change opacity EdgyShiny 1.000000");
fprintf(file, "%*s\n",  2,"  material change outline EdgyShiny 0.760000");
fprintf(file, "%*s\n",  2,"  material change outlinewidth EdgyShiny 0.940000");
fprintf(file, "%*s\n",  2,"  material change transmode EdgyShiny 0.000000");
fprintf(file, "%*s\n",  2,"  material change ambient EdgyGlass 0.000000");
fprintf(file, "%*s\n",  2,"  material change diffuse EdgyGlass 0.660000");
fprintf(file, "%*s\n",  2,"  material change specular EdgyGlass 0.500000");
fprintf(file, "%*s\n",  2,"  material change shininess EdgyGlass 0.750000");
fprintf(file, "%*s\n",  2,"  material change mirror EdgyGlass 0.000000");
fprintf(file, "%*s\n",  2,"  material change opacity EdgyGlass 0.620000");
fprintf(file, "%*s\n",  2,"  material change outline EdgyGlass 0.620000");
fprintf(file, "%*s\n",  2,"  material change outlinewidth EdgyGlass 0.940000");
fprintf(file, "%*s\n",  2,"  material change transmode EdgyGlass 0.000000");
fprintf(file, "%*s\n",  2,"  material change ambient Goodsell 0.520000");
fprintf(file, "%*s\n",  2,"  material change diffuse Goodsell 1.000000");
fprintf(file, "%*s\n",  2,"  material change specular Goodsell 0.000000");
fprintf(file, "%*s\n",  2,"  material change shininess Goodsell 0.000000");
fprintf(file, "%*s\n",  2,"  material change mirror Goodsell 0.000000");
fprintf(file, "%*s\n",  2,"  material change opacity Goodsell 1.000000");
fprintf(file, "%*s\n",  2,"  material change outline Goodsell 4.000000");
fprintf(file, "%*s\n",  2,"  material change outlinewidth Goodsell 0.900000");
fprintf(file, "%*s\n",  2,"  material change transmode Goodsell 0.000000");
fprintf(file, "%*s\n",  2,"  material change ambient AOShiny 0.000000");
fprintf(file, "%*s\n",  2,"  material change diffuse AOShiny 0.850000");
fprintf(file, "%*s\n",  2,"  material change specular AOShiny 0.200000");
fprintf(file, "%*s\n",  2,"  material change shininess AOShiny 0.530000");
fprintf(file, "%*s\n",  2,"  material change mirror AOShiny 0.000000");
fprintf(file, "%*s\n",  2,"  material change opacity AOShiny 1.000000");
fprintf(file, "%*s\n",  2,"  material change outline AOShiny 0.000000");
fprintf(file, "%*s\n",  2,"  material change outlinewidth AOShiny 0.000000");
fprintf(file, "%*s\n",  2,"  material change transmode AOShiny 0.000000");
fprintf(file, "%*s\n",  2,"  material change ambient AOChalky 0.000000");
fprintf(file, "%*s\n",  2,"  material change diffuse AOChalky 0.850000");
fprintf(file, "%*s\n",  2,"  material change specular AOChalky 0.000000");
fprintf(file, "%*s\n",  2,"  material change shininess AOChalky 0.530000");
fprintf(file, "%*s\n",  2,"  material change mirror AOChalky 0.000000");
fprintf(file, "%*s\n",  2,"  material change opacity AOChalky 1.000000");
fprintf(file, "%*s\n",  2,"  material change outline AOChalky 0.000000");
fprintf(file, "%*s\n",  2,"  material change outlinewidth AOChalky 0.000000");
fprintf(file, "%*s\n",  2,"  material change transmode AOChalky 0.000000");
fprintf(file, "%*s\n",  2,"  material change ambient AOEdgy 0.000000");
fprintf(file, "%*s\n",  2,"  material change diffuse AOEdgy 0.900000");
fprintf(file, "%*s\n",  2,"  material change specular AOEdgy 0.200000");
fprintf(file, "%*s\n",  2,"  material change shininess AOEdgy 0.530000");
fprintf(file, "%*s\n",  2,"  material change mirror AOEdgy 0.000000");
fprintf(file, "%*s\n",  2,"  material change opacity AOEdgy 1.000000");
fprintf(file, "%*s\n",  2,"  material change outline AOEdgy 0.620000");
fprintf(file, "%*s\n",  2,"  material change outlinewidth AOEdgy 0.930000");
fprintf(file, "%*s\n",  2,"  material change transmode AOEdgy 0.000000");
fprintf(file, "%*s\n",  2,"  material change ambient BlownGlass 0.040000");
fprintf(file, "%*s\n",  2,"  material change diffuse BlownGlass 0.340000");
fprintf(file, "%*s\n",  2,"  material change specular BlownGlass 1.000000");
fprintf(file, "%*s\n",  2,"  material change shininess BlownGlass 1.000000");
fprintf(file, "%*s\n",  2,"  material change mirror BlownGlass 0.000000");
fprintf(file, "%*s\n",  2,"  material change opacity BlownGlass 0.100000");
fprintf(file, "%*s\n",  2,"  material change outline BlownGlass 0.000000");
fprintf(file, "%*s\n",  2,"  material change outlinewidth BlownGlass 0.000000");
fprintf(file, "%*s\n",  2,"  material change transmode BlownGlass 1.000000");
fprintf(file, "%*s\n",  2,"  material change ambient GlassBubble 0.250000");
fprintf(file, "%*s\n",  2,"  material change diffuse GlassBubble 0.340000");
fprintf(file, "%*s\n",  2,"  material change specular GlassBubble 1.000000");
fprintf(file, "%*s\n",  2,"  material change shininess GlassBubble 1.000000");
fprintf(file, "%*s\n",  2,"  material change mirror GlassBubble 0.000000");
fprintf(file, "%*s\n",  2,"  material change opacity GlassBubble 0.040000");
fprintf(file, "%*s\n",  2,"  material change outline GlassBubble 0.000000");
fprintf(file, "%*s\n",  2,"  material change outlinewidth GlassBubble 0.000000");
fprintf(file, "%*s\n",  2,"  material change transmode GlassBubble 1.000000");
fprintf(file, "%*s\n",  2,"  material change ambient RTChrome 0.000000");
fprintf(file, "%*s\n",  2,"  material change diffuse RTChrome 0.650000");
fprintf(file, "%*s\n",  2,"  material change specular RTChrome 0.500000");
fprintf(file, "%*s\n",  2,"  material change shininess RTChrome 0.530000");
fprintf(file, "%*s\n",  2,"  material change mirror RTChrome 0.700000");
fprintf(file, "%*s\n",  2,"  material change opacity RTChrome 1.000000");
fprintf(file, "%*s\n",  2,"  material change outline RTChrome 0.000000");
fprintf(file, "%*s\n",  2,"  material change outlinewidth RTChrome 0.000000");
fprintf(file, "%*s\n",  2,"  material change transmode RTChrome 0.000000");
fprintf(file, "%*s\n",  2,"}");
fprintf(file, "%*s\n",  0,"vmdrestoremymaterials");
fprintf(file, "%*s\n",  0,"# Atom selection macros");
fprintf(file, "%*s\n",  0,"atomselect macro at {resname ADE A THY T");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro acidic {resname ASP GLU");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro cyclic {resname HIS PHE PRO TRP TYR");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro acyclic {protein and not cyclic");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro aliphatic {resname ALA GLY ILE LEU VAL");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro alpha {protein and name CA");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro amino {protein");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro aromatic {resname HIS PHE TRP TYR");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro basic {resname ARG HIS LYS HSP");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro bonded {numbonds > 0");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro buried {resname ALA LEU VAL ILE PHE CYS MET TRP");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro cg {resname CYT C GUA G");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro charged {basic or acidic");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro hetero {not (protein or nucleic)");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro hydrophobic {resname ALA LEU VAL ILE PRO PHE MET TRP");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro small {resname ALA GLY SER");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro medium {resname VAL THR ASP ASN PRO CYS ASX PCA HYP");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro large {protein and not (small or medium)");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro neutral {resname VAL PHE GLN TYR HIS CYS MET TRP ASX GLX PCA HYP");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro polar {protein and not hydrophobic");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro purine {resname ADE A GUA G");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro pyrimidine {resname CYT C THY T URA U");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro surface {protein and not buried");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro lipid {resname DLPE DMPC DPPC GPC LPPC PALM PC PGCL POPC POPE");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro lipids {lipid");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro ion {resname AL BA CA CAL CD CES CLA CL CO CS CU CU1 CUA HG IN IOD K MG MN3 MO3 MO4 MO5 MO6 NA NAW OC7 PB POT PT RB SOD TB TL WO4 YB ZN ZN1 ZN2");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro ions {ion");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro sugar {resname AGLC");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro solvent {not (protein or sugar or nucleic or lipid)");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro glycan {resname NAG BGLN FUC AFUC MAN AMAN BMA BMAN}");
fprintf(file, "%*s\n",  0,"atomselect macro carbon {name \"C.*\" and not ion");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro hydrogen {name \"[0-9]?H.*\"");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro nitrogen {name \"N.*\"");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro oxygen {name \"O.*\"");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro sulfur {name \"S.*\" and not ion");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro noh {not hydrogen");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro heme {resname HEM HEME");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro conformationall {altloc \"\"");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro conformationA {altloc \"\" or altloc \"A\"");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro conformationB {altloc \"\" or altloc \"B\"");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro conformationC {altloc \"\" or altloc \"C\"");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro conformationD {altloc \"\" or altloc \"D\"");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro conformationE {altloc \"\" or altloc \"E\"");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro conformationF {altloc \"\" or altloc \"F\"");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro drude {type DRUD or type LP");
fprintf(file, "%*s\n",  0,"}");
fprintf(file, "%*s\n",  0,"atomselect macro unparametrized beta<1");
fprintf(file, "%*s\n",  0,"atomselect macro addedmolefacture {occupancy 0.8}");
fprintf(file, "%*s\n",  0,"atomselect macro qwikmd_protein {(not name QWIKMDDELETE and protein)}");
fprintf(file, "%*s\n",  0,"atomselect macro qwikmd_nucleic {(not name QWIKMDDELETE and nucleic)}");
fprintf(file, "%*s\n",  0,"atomselect macro qwikmd_glycan {(not name QWIKMDDELETE and glycan)}");
fprintf(file, "%*s\n",  0,"atomselect macro qwikmd_lipid {(not name QWIKMDDELETE and lipid)}");
fprintf(file, "%*s\n",  0,"atomselect macro qwikmd_hetero {(not name QWIKMDDELETE and hetero and not qwikmd_protein and not qwikmd_lipid and not qwikmd_nucleic and not qwikmd_glycan and not water)}");
fprintf(file, "%*s\n",  0,"# Display settings");
fprintf(file, "%*s\n",  0,"display eyesep       0.065000");
fprintf(file, "%*s\n",  0,"display focallength  2.000000");
fprintf(file, "%*s\n",  0,"display height       6.000000");
fprintf(file, "%*s\n",  0,"display distance     -2.000000");
fprintf(file, "%*s\n",  0,"display projection   Perspective");
fprintf(file, "%*s\n",  0,"display nearclip set 0.500000");
fprintf(file, "%*s\n",  0,"display farclip  set 10.000000");
fprintf(file, "%*s\n",  0,"display depthcue   off");
fprintf(file, "%*s\n",  0,"display cuestart   0.500000");
fprintf(file, "%*s\n",  0,"display cueend     10.000000");
fprintf(file, "%*s\n",  0,"display cuestart   0.500000");
fprintf(file, "%*s\n",  0,"display cueend     10.000000");
fprintf(file, "%*s\n",  0,"display cuedensity 0.320000");
fprintf(file, "%*s\n",  0,"display cuemode    Exp2");
fprintf(file, "%*s\n",  0,"display shadows off");
fprintf(file, "%*s\n",  0,"display ambientocclusion off");
fprintf(file, "%*s\n",  0,"display aoambient 0.800000");
fprintf(file, "%*s\n",  0,"display aodirect 0.300000");
fprintf(file, "%*s\n",  0,"display dof off");
fprintf(file, "%*s\n",  0,"display dof_fnumber 64.000000");
fprintf(file, "%*s\n",  0,"display dof_focaldist 0.700000");
fprintf(file, "%*s%s%s\n",  0,"mol new ", rep[ELFcube].c_str()," type cube first 0 last -1 step 1 filebonds 1 autobonds 1 waitfor all");
fprintf(file, "%*s%s%s\n",  0,"mol addfile ", rep[ELF_IGMcolor].c_str()," type cube first 0 last -1 step 1 filebonds 1 autobonds 1 waitfor all");
fprintf(file, "%*s\n",  0,"mol delrep 0 top");
fprintf(file, "%*s\n",  0,"mol representation Lines 1.000000");
fprintf(file, "%*s\n",  0,"mol color Name");
fprintf(file, "%*s\n",  0,"mol selection {all}");
fprintf(file, "%*s\n",  0,"mol material Opaque");
fprintf(file, "%*s\n",  0,"mol addrep top");
fprintf(file, "%*s\n",  0,"mol selupdate 0 top 0");
fprintf(file, "%*s\n",  0,"mol colupdate 0 top 0");
fprintf(file, "%*s\n",  0,"mol scaleminmax top 0 0.000000 0.000000");
fprintf(file, "%*s\n",  0,"mol smoothrep top 0 0");
fprintf(file, "%*s\n",  0,"mol drawframes top 0 {now}");
fprintf(file, "%*s\n",  0,"mol clipplane center 0 0 top {0.0 0.0 0.0}");
fprintf(file, "%*s\n",  0,"mol clipplane color  0 0 top {0.5 0.5 0.5 }");
fprintf(file, "%*s\n",  0,"mol clipplane normal 0 0 top {0.0 0.0 1.0}");
fprintf(file, "%*s\n",  0,"mol clipplane status 0 0 top {0}");
fprintf(file, "%*s\n",  0,"mol clipplane center 1 0 top {0.0 0.0 0.0}");
fprintf(file, "%*s\n",  0,"mol clipplane color  1 0 top {0.5 0.5 0.5 }");
fprintf(file, "%*s\n",  0,"mol clipplane normal 1 0 top {0.0 0.0 1.0}");
fprintf(file, "%*s\n",  0,"mol clipplane status 1 0 top {0}");
fprintf(file, "%*s\n",  0,"mol clipplane center 2 0 top {0.0 0.0 0.0}");
fprintf(file, "%*s\n",  0,"mol clipplane color  2 0 top {0.5 0.5 0.5 }");
fprintf(file, "%*s\n",  0,"mol clipplane normal 2 0 top {0.0 0.0 1.0}");
fprintf(file, "%*s\n",  0,"mol clipplane status 2 0 top {0}");
fprintf(file, "%*s\n",  0,"mol clipplane center 3 0 top {0.0 0.0 0.0}");
fprintf(file, "%*s\n",  0,"mol clipplane color  3 0 top {0.5 0.5 0.5 }");
fprintf(file, "%*s\n",  0,"mol clipplane normal 3 0 top {0.0 0.0 1.0}");
fprintf(file, "%*s\n",  0,"mol clipplane status 3 0 top {0}");
fprintf(file, "%*s\n",  0,"mol clipplane center 4 0 top {0.0 0.0 0.0}");
fprintf(file, "%*s\n",  0,"mol clipplane color  4 0 top {0.5 0.5 0.5 }");
fprintf(file, "%*s\n",  0,"mol clipplane normal 4 0 top {0.0 0.0 1.0}");
fprintf(file, "%*s\n",  0,"mol clipplane status 4 0 top {0}");
fprintf(file, "%*s\n",  0,"mol clipplane center 5 0 top {0.0 0.0 0.0}");
fprintf(file, "%*s\n",  0,"mol clipplane color  5 0 top {0.5 0.5 0.5 }");
fprintf(file, "%*s\n",  0,"mol clipplane normal 5 0 top {0.0 0.0 1.0}");
fprintf(file, "%*s\n",  0,"mol clipplane status 5 0 top {0}");
fprintf(file, "%*s%s%s\n",  0,"mol representation Isosurface ", rep[ELF_isovalue].c_str(), " 0 0 0 1 1");
fprintf(file, "%*s\n",  0,"mol color Volume 1");
fprintf(file, "%*s\n",  0,"mol selection {all}");
fprintf(file, "%*s\n",  0,"mol material Glossy");
fprintf(file, "%*s\n",  0,"mol addrep top");
fprintf(file, "%*s\n",  0,"mol selupdate 1 top 0");
fprintf(file, "%*s\n",  0,"mol colupdate 1 top 0");
fprintf(file, "%*s\n",  0,"mol scaleminmax top 1 0.200000 0.800000");
fprintf(file, "%*s\n",  0,"mol smoothrep top 1 0");
fprintf(file, "%*s\n",  0,"mol drawframes top 1 {now}");
fprintf(file, "%*s\n",  0,"mol clipplane center 0 1 top {0.0 0.0 0.0}");
fprintf(file, "%*s\n",  0,"mol clipplane color  0 1 top {0.5 0.5 0.5 }");
fprintf(file, "%*s\n",  0,"mol clipplane normal 0 1 top {0.0 0.0 1.0}");
fprintf(file, "%*s\n",  0,"mol clipplane status 0 1 top {0}");
fprintf(file, "%*s\n",  0,"mol clipplane center 1 1 top {0.0 0.0 0.0}");
fprintf(file, "%*s\n",  0,"mol clipplane color  1 1 top {0.5 0.5 0.5 }");
fprintf(file, "%*s\n",  0,"mol clipplane normal 1 1 top {0.0 0.0 1.0}");
fprintf(file, "%*s\n",  0,"mol clipplane status 1 1 top {0}");
fprintf(file, "%*s\n",  0,"mol clipplane center 2 1 top {0.0 0.0 0.0}");
fprintf(file, "%*s\n",  0,"mol clipplane color  2 1 top {0.5 0.5 0.5 }");
fprintf(file, "%*s\n",  0,"mol clipplane normal 2 1 top {0.0 0.0 1.0}");
fprintf(file, "%*s\n",  0,"mol clipplane status 2 1 top {0}");
fprintf(file, "%*s\n",  0,"mol clipplane center 3 1 top {0.0 0.0 0.0}");
fprintf(file, "%*s\n",  0,"mol clipplane color  3 1 top {0.5 0.5 0.5 }");
fprintf(file, "%*s\n",  0,"mol clipplane normal 3 1 top {0.0 0.0 1.0}");
fprintf(file, "%*s\n",  0,"mol clipplane status 3 1 top {0}");
fprintf(file, "%*s\n",  0,"mol clipplane center 4 1 top {0.0 0.0 0.0}");
fprintf(file, "%*s\n",  0,"mol clipplane color  4 1 top {0.5 0.5 0.5 }");
fprintf(file, "%*s\n",  0,"mol clipplane normal 4 1 top {0.0 0.0 1.0}");
fprintf(file, "%*s\n",  0,"mol clipplane status 4 1 top {0}");
fprintf(file, "%*s\n",  0,"mol clipplane center 5 1 top {0.0 0.0 0.0}");
fprintf(file, "%*s\n",  0,"mol clipplane color  5 1 top {0.5 0.5 0.5 }");
fprintf(file, "%*s\n",  0,"mol clipplane normal 5 1 top {0.0 0.0 1.0}");
fprintf(file, "%*s\n",  0,"mol clipplane status 5 1 top {0}");
fprintf(file, "%*s\n",  0,"mol rename top ELF.cube");
fprintf(file, "%*s\n",  0,"set viewpoints([molinfo top]) {{{1 0 0 -0.355104} {0 1 0 0} {0 0 1 -0.990198} {0 0 0 1}} {{0.133336 -0.163998 0.97723 0} {-0.819026 -0.57332 0.0155475 0} {0.557756 -0.80252 -0.210794 0} {0 0 0 1}} {{0.317064 0 0 0} {0 0.317064 0 0} {0 0 0.317064 0} {0 0 0 1}} {{1 0 0 -0.06} {0 1 0 0.1} {0 0 1 0} {0 0 0 1}}}");
fprintf(file, "%*s\n",  0,"lappend viewplist [molinfo top]");
fprintf(file, "%*s\n",  0,"# done with molecule 0");

//fprintf(file, "%*s\n",  0,"foreach v $viewplist {");
//fprintf(file, "%*s\n",  2,"  molinfo $v set {center_matrix rotate_matrix scale_matrix global_matrix} $viewpoints($v)");
//fprintf(file, "%*s\n",  2,"}");
//fprintf(file, "%*s\n",  0,"foreach v $fixedlist {");
//fprintf(file, "%*s\n",  2,"  molinfo $v set fixed 1");
//fprintf(file, "%*s\n",  2,"}");
//fprintf(file, "%*s\n",  0,"unset viewplist");
//fprintf(file, "%*s\n",  0,"unset fixedlist");
//fprintf(file, "%*s\n",  0,"mol top $topmol");
//fprintf(file, "%*s\n",  0,"unset topmol");
fprintf(file, "%*s\n",  0,"proc vmdrestoremycolors {} {");
fprintf(file, "%*s\n",  0,"color scale colors RWB {1.0 0.0 0.0} {1.0 1.0 1.0} {0.0 0.0 1.0}");
fprintf(file, "%*s\n",  0,"color scale colors BWR {0.0 0.0 1.0} {1.0 1.0 1.0} {1.0 0.0 0.0}");
fprintf(file, "%*s\n",  0,"color scale colors RGryB {1.0 0.0 0.0} {0.5 0.5 0.5} {0.0 0.0 1.0}");
fprintf(file, "%*s\n",  0,"color scale colors BGryR {0.0 0.0 1.0} {0.5 0.5 0.5} {1.0 0.0 0.0}");
fprintf(file, "%*s\n",  0,"color scale colors RGB {1.0 0.0 0.0} {0.0 1.0 0.0} {0.0 0.0 1.0}");
fprintf(file, "%*s\n",  0,"color scale colors BGR {0.0 0.0 1.0} {0.0 1.0 0.0} {1.0 0.0 0.0}");
fprintf(file, "%*s\n",  0,"color scale colors RWG {1.0 0.0 0.0} {1.0 1.0 1.0} {0.0 1.0 0.0}");
fprintf(file, "%*s\n",  0,"color scale colors GWR {0.0 1.0 0.0} {1.0 1.0 1.0} {1.0 0.0 0.0}");
fprintf(file, "%*s\n",  0,"color scale colors GWB {0.0 1.0 0.0} {1.0 1.0 1.0} {0.0 0.0 1.0}");
fprintf(file, "%*s\n",  0,"color scale colors BWG {0.0 0.0 1.0} {1.0 1.0 1.0} {0.0 1.0 0.0}");
fprintf(file, "%*s\n",  0,"color scale colors BlkW {0.0 0.0 0.0} {0.5 0.5 0.5} {1.0 1.0 1.0}");
fprintf(file, "%*s\n",  0,"color scale colors WBlk {1.0 1.0 1.0} {0.5 0.5 0.5} {0.0 0.0 0.0}");
fprintf(file, "%*s\n",  2,"  color scale method BGR");
fprintf(file, "%*s\n",  2,"  set colorcmds {");
fprintf(file, "%*s\n",  4,"    {color Display {BackgroundTop} black}");
fprintf(file, "%*s\n",  4,"    {color Display {BackgroundBot} blue2}");
fprintf(file, "%*s\n",  4,"    {color Display {FPS} white}");
fprintf(file, "%*s\n",  4,"    {color Name {LPA} green}");
fprintf(file, "%*s\n",  4,"    {color Name {LPB} green}");
fprintf(file, "%*s\n",  4,"    {color Type {LP} green}");
fprintf(file, "%*s\n",  4,"    {color Type {DRUD} pink}");
fprintf(file, "%*s\n",  4,"    {color Element {X} cyan}");
fprintf(file, "%*s\n",  4,"    {color Element {Ac} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Ag} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Al} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Am} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Ar} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {As} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {At} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Au} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {B} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Ba} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Be} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Bh} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Bi} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Bk} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Br} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Ca} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Cd} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Ce} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Cf} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Cl} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Cm} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Co} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Cr} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Cs} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Cu} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Db} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Ds} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Dy} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Er} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Es} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Eu} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {F} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Fe} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Fm} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Fr} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Ga} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Gd} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Ge} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {He} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Hf} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Hg} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Ho} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Hs} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {I} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {In} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Ir} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {K} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Kr} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {La} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Li} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Lr} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Lu} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Md} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Mg} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Mn} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Mo} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Mt} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Na} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Nb} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Nd} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Ne} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Ni} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {No} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Np} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Os} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Pa} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Pb} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Pd} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Pm} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Po} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Pr} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Pt} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Pu} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Ra} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Rb} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Re} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Rf} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Rg} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Rh} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Rn} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Ru} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Sb} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Sc} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Se} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Sg} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Si} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Sm} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Sn} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Sr} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Ta} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Tb} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Tc} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Te} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Th} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Ti} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Tl} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Tm} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {U} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {V} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {W} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Xe} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Y} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Yb} ochre}");
fprintf(file, "%*s\n",  4,"    {color Element {Zr} ochre}");
fprintf(file, "%*s\n",  4,"    {color Resname {} silver}");
fprintf(file, "%*s\n",  4,"    {color Chain {X} blue}");
fprintf(file, "%*s\n",  4,"    {color Segname {} blue}");
fprintf(file, "%*s\n",  4,"    {color Conformation {all} blue}");
fprintf(file, "%*s\n",  4,"    {color Molecule {0} blue}");
fprintf(file, "%*s\n",  4,"    {color Molecule {mol-dgInter.cube} blue}");
fprintf(file, "%*s\n",  4,"    {color Molecule {1} red}");
fprintf(file, "%*s\n",  4,"    {color Molecule {mol-dgIntra.cube} red}");
fprintf(file, "%*s\n",  4,"    {color Structure {3_10_Helix} blue}");
fprintf(file, "%*s\n",  4,"    {color Surface {Grasp} gray}");
fprintf(file, "%*s\n",  4,"    {color Labels {Springs} orange}");
fprintf(file, "%*s\n",  4,"    {color Stage {Even} gray}");
fprintf(file, "%*s\n",  4,"    {color Stage {Odd} silver}");
fprintf(file, "%*s\n",  4,"  }");
fprintf(file, "%*s\n",  2,"  foreach colcmd $colorcmds {");
fprintf(file, "%*s\n",  4,"    set val [catch {eval $colcmd}]");
fprintf(file, "%*s\n",  4,"  }");
fprintf(file, "%*s\n",  2,"  color change rgb 0 0.0 0.0 1.0");
fprintf(file, "%*s\n",  2,"  color change rgb 2 0.3499999940395355 0.3499999940395355 0.3499999940395355");
fprintf(file, "%*s\n",  2,"  color change rgb 3 1.0 0.5 0.0");
fprintf(file, "%*s\n",  2,"  color change rgb 4 1.0 1.0 0.0");
fprintf(file, "%*s\n",  2,"  color change rgb 5 0.5 0.5 0.20000000298023224");
fprintf(file, "%*s\n",  2,"  color change rgb 6 0.6000000238418579 0.6000000238418579 0.6000000238418579");
fprintf(file, "%*s\n",  2,"  color change rgb 7 0.0 1.0 0.0");
fprintf(file, "%*s\n",  2,"  color change rgb 9 1.0 0.6000000238418579 0.6000000238418579");
fprintf(file, "%*s\n",  2,"  color change rgb 11 0.6499999761581421 0.0 0.6499999761581421");
fprintf(file, "%*s\n",  2,"  color change rgb 12 0.5 0.8999999761581421 0.4000000059604645");
fprintf(file, "%*s\n",  2,"  color change rgb 13 0.8999999761581421 0.4000000059604645 0.699999988079071");
fprintf(file, "%*s\n",  2,"  color change rgb 14 0.5 0.30000001192092896 0.0");
fprintf(file, "%*s\n",  2,"  color change rgb 15 0.5 0.5 0.75");
fprintf(file, "%*s\n",  2,"  color change rgb 17 0.8799999952316284 0.9700000286102295 0.019999999552965164");
fprintf(file, "%*s\n",  2,"  color change rgb 18 0.550000011920929 0.8999999761581421 0.019999999552965164");
fprintf(file, "%*s\n",  2,"  color change rgb 19 0.0 0.8999999761581421 0.03999999910593033");
fprintf(file, "%*s\n",  2,"  color change rgb 20 0.0 0.8999999761581421 0.5");
fprintf(file, "%*s\n",  2,"  color change rgb 21 0.0 0.8799999952316284 1.0");
fprintf(file, "%*s\n",  2,"  color change rgb 22 0.0 0.7599999904632568 1.0");
fprintf(file, "%*s\n",  2,"  color change rgb 23 0.019999999552965164 0.3799999952316284 0.6700000166893005");
fprintf(file, "%*s\n",  2,"  color change rgb 24 0.009999999776482582 0.03999999910593033 0.9300000071525574");
fprintf(file, "%*s\n",  2,"  color change rgb 25 0.27000001072883606 0.0 0.9800000190734863");
fprintf(file, "%*s\n",  2,"  color change rgb 26 0.44999998807907104 0.0 0.8999999761581421");
fprintf(file, "%*s\n",  2,"  color change rgb 27 0.8999999761581421 0.0 0.8999999761581421");
fprintf(file, "%*s\n",  2,"  color change rgb 28 1.0 0.0 0.6600000262260437");
fprintf(file, "%*s\n",  2,"  color change rgb 29 0.9800000190734863 0.0 0.23000000417232513");
fprintf(file, "%*s\n",  2,"  color change rgb 30 0.8100000023841858 0.0 0.0");
fprintf(file, "%*s\n",  2,"  color change rgb 31 0.8899999856948853 0.3499999940395355 0.0");
fprintf(file, "%*s\n",  2,"  color change rgb 32 0.9599999785423279 0.7200000286102295 0.0");
fprintf(file, "%*s\n",  2,"}");
fprintf(file, "%*s\n",  0,"vmdrestoremycolors");
fprintf(file, "%*s\n",  0,"label textsize 1.0");
fprintf(file, "%*s\n", 0,"axes location Off");
fprintf(file, "%*s\n", 0,"display rendermode GLSL");
fprintf(file, "%*s\n", 0,"display depthcue off");
fprintf(file, "%*s\n", 0,"");
fclose(file);


} // end of generateVMDelfFile

void generateVMDigmFile(const std::string *rep)
{

  FILE* file=fopen("igm.vmd","w");
  fprintf(file, "%*s\n", 0,"#");
  fprintf(file, "%*s\n", 0,"##Copyright University of Reims Champagne-Ardenne");
  fprintf(file, "%*s\n", 0,"#Authors and Contributors: Akilan RAJAMANI, Corentin LEFEBVRE, Johanna KLEIN, Emmanuel PLUOT, Gaetan RUBEZ, Hassan Khartabil, Jean-Charles-BOISSON and Eric HENON");
  fprintf(file, "%*s\n", 0,"#Contributors: Hassan Khartabil, Miguel Ponce-Vargas, Julia Contreras-Garcia");
  fprintf(file, "%*s\n", 0,"##(24/07/2017)");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"##jean-charles.boisson@univ-reims.fr, eric.henon@univ-reims.fr");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"##This software is a computer program whose purpose is to ");
  fprintf(file, "%*s\n", 0,"##detect and prepare the plot of molecular interactions");
  fprintf(file, "%*s\n", 0,"##from electron density and IGM reference using promolecular");
  fprintf(file, "%*s\n", 0,"##electron density.");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"##This software is governed by the CeCILL-C license under French law and");
  fprintf(file, "%*s\n", 0,"##abiding by the rules of distribution of free software.  You can  use, ");
  fprintf(file, "%*s\n", 0,"##modify and/ or redistribute the software under the terms of the CeCILL-C");
  fprintf(file, "%*s\n", 0,"##license as circulated by CEA, CNRS and INRIA at the following URL");
  fprintf(file, "%*s\n", 0,"##\"http://www.cecill.info\". ");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"##As a counterpart to the access to the source code and  rights to copy,");
  fprintf(file, "%*s\n", 0,"##modify and redistribute granted by the license, users are provided only");
  fprintf(file, "%*s\n", 0,"##with a limited warranty  and the software\'s author,  the holder of the");
  fprintf(file, "%*s\n", 0,"##economic rights,  and the successive licensors  have only  limited");
  fprintf(file, "%*s\n", 0,"##liability. ");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"##In this respect, the user\'s attention is drawn to the risks associated");
  fprintf(file, "%*s\n", 0,"##with loading,  using,  modifying and/or developing or reproducing the");
  fprintf(file, "%*s\n", 0,"##software by the user in light of its specific status of free software,");
  fprintf(file, "%*s\n", 0,"##that may mean  that it is complicated to manipulate,  and  that  also");
  fprintf(file, "%*s\n", 0,"##therefore means  that it is reserved for developers  and  experienced");
  fprintf(file, "%*s\n", 0,"##professionals having in-depth computer knowledge. Users are therefore");
  fprintf(file, "%*s\n", 0,"##encouraged to load and test the software\'s suitability as regards their");
  fprintf(file, "%*s\n", 0,"##requirements in conditions enabling the security of their systems and/or ");
  fprintf(file, "%*s\n", 0,"##data to be ensured and,  more generally, to use and operate it in the ");
  fprintf(file, "%*s\n", 0,"##same conditions as regards security. ");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"##The fact that you are presently reading this means that you have had");
  fprintf(file, "%*s\n", 0,"##knowledge of the CeCILL-C license and that you accept its terms.");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"#");
  fprintf(file, "%*s\n", 0,"#");
  fprintf(file, "%*s\n", 0,"##!/usr/local/bin/vmd");
  fprintf(file, "%*s\n", 0,"# VMD script written by save_state $Revision: 1.46 $");
  fprintf(file, "%*s\n", 0,"# VMD version: 1.9.2beta1optixtest4");
  fprintf(file, "%*s\n", 0,"proc vmdrestoremymaterials {} {");
  fprintf(file, "%*s\n", 2,"  set mlist { Opaque Transparent BrushedMetal Diffuse Ghost Glass1 Glass2 Glass3 Glossy HardPlastic MetallicPastel Steel Translucent Edgy EdgyShiny EdgyGlass Goodsell AOShiny AOChalky AOEdgy BlownGlass GlassBubble }");
  fprintf(file, "%*s\n", 2,"  set mymlist [material list]");
  fprintf(file, "%*s\n", 2,"  foreach mat $mlist {");
  fprintf(file, "%*s\n", 4,"    if { [lsearch $mymlist $mat] == -1 } { ");
  fprintf(file, "%*s\n", 6,"      material add $mat");
  fprintf(file, "%*s\n", 4,"    }");
  fprintf(file, "%*s\n", 2,"  }");
  fprintf(file, "%*s\n", 2,"  material change ambient Opaque 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Opaque 0.650000");
  fprintf(file, "%*s\n", 2,"  material change specular Opaque 0.500000");
  fprintf(file, "%*s\n", 2,"  material change shininess Opaque 0.534020");
  fprintf(file, "%*s\n", 2,"  material change opacity Opaque 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline Opaque 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Opaque 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Opaque 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Transparent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Transparent 0.650000");
  fprintf(file, "%*s\n", 2,"  material change specular Transparent 0.500000");
  fprintf(file, "%*s\n", 2,"  material change shininess Transparent 0.534020");
  fprintf(file, "%*s\n", 2,"  material change opacity Transparent 0.300000");
  fprintf(file, "%*s\n", 2,"  material change outline Transparent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Transparent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Transparent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient BrushedMetal 0.080000");
  fprintf(file, "%*s\n", 2,"  material change diffuse BrushedMetal 0.390000");
  fprintf(file, "%*s\n", 2,"  material change specular BrushedMetal 0.340000");
  fprintf(file, "%*s\n", 2,"  material change shininess BrushedMetal 0.150000");
  fprintf(file, "%*s\n", 2,"  material change opacity BrushedMetal 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline BrushedMetal 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth BrushedMetal 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode BrushedMetal 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Diffuse 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Diffuse 0.620000");
  fprintf(file, "%*s\n", 2,"  material change specular Diffuse 0.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess Diffuse 0.530000");
  fprintf(file, "%*s\n", 2,"  material change opacity Diffuse 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline Diffuse 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Diffuse 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Diffuse 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Ghost 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Ghost 0.000000");
  fprintf(file, "%*s\n", 2,"  material change specular Ghost 1.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess Ghost 0.230000");
  fprintf(file, "%*s\n", 2,"  material change opacity Ghost 0.100000");
  fprintf(file, "%*s\n", 2,"  material change outline Ghost 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Ghost 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Ghost 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Glass1 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Glass1 0.500000");
  fprintf(file, "%*s\n", 2,"  material change specular Glass1 0.650000");
  fprintf(file, "%*s\n", 2,"  material change shininess Glass1 0.530000");
  fprintf(file, "%*s\n", 2,"  material change opacity Glass1 0.150000");
  fprintf(file, "%*s\n", 2,"  material change outline Glass1 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Glass1 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Glass1 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Glass2 0.520000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Glass2 0.760000");
  fprintf(file, "%*s\n", 2,"  material change specular Glass2 0.220000");
  fprintf(file, "%*s\n", 2,"  material change shininess Glass2 0.590000");
  fprintf(file, "%*s\n", 2,"  material change opacity Glass2 0.680000");
  fprintf(file, "%*s\n", 2,"  material change outline Glass2 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Glass2 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Glass2 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Glass3 0.150000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Glass3 0.250000");
  fprintf(file, "%*s\n", 2,"  material change specular Glass3 0.750000");
  fprintf(file, "%*s\n", 2,"  material change shininess Glass3 0.800000");
  fprintf(file, "%*s\n", 2,"  material change opacity Glass3 0.500000");
  fprintf(file, "%*s\n", 2,"  material change outline Glass3 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Glass3 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Glass3 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Glossy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Glossy 0.650000");
  fprintf(file, "%*s\n", 2,"  material change specular Glossy 1.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess Glossy 0.880000");
  fprintf(file, "%*s\n", 2,"  material change opacity Glossy 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline Glossy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Glossy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Glossy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient HardPlastic 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse HardPlastic 0.560000");
  fprintf(file, "%*s\n", 2,"  material change specular HardPlastic 0.280000");
  fprintf(file, "%*s\n", 2,"  material change shininess HardPlastic 0.690000");
  fprintf(file, "%*s\n", 2,"  material change opacity HardPlastic 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline HardPlastic 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth HardPlastic 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode HardPlastic 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient MetallicPastel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse MetallicPastel 0.260000");
  fprintf(file, "%*s\n", 2,"  material change specular MetallicPastel 0.550000");
  fprintf(file, "%*s\n", 2,"  material change shininess MetallicPastel 0.190000");
  fprintf(file, "%*s\n", 2,"  material change opacity MetallicPastel 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline MetallicPastel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth MetallicPastel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode MetallicPastel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Steel 0.250000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Steel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change specular Steel 0.380000");
  fprintf(file, "%*s\n", 2,"  material change shininess Steel 0.320000");
  fprintf(file, "%*s\n", 2,"  material change opacity Steel 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline Steel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Steel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Steel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Translucent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Translucent 0.700000");
  fprintf(file, "%*s\n", 2,"  material change specular Translucent 0.600000");
  fprintf(file, "%*s\n", 2,"  material change shininess Translucent 0.300000");
  fprintf(file, "%*s\n", 2,"  material change opacity Translucent 0.800000");
  fprintf(file, "%*s\n", 2,"  material change outline Translucent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Translucent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Translucent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Edgy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Edgy 0.660000");
  fprintf(file, "%*s\n", 2,"  material change specular Edgy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess Edgy 0.750000");
  fprintf(file, "%*s\n", 2,"  material change opacity Edgy 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline Edgy 0.620000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Edgy 0.940000");
  fprintf(file, "%*s\n", 2,"  material change transmode Edgy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient EdgyShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse EdgyShiny 0.660000");
  fprintf(file, "%*s\n", 2,"  material change specular EdgyShiny 0.960000");
  fprintf(file, "%*s\n", 2,"  material change shininess EdgyShiny 0.750000");
  fprintf(file, "%*s\n", 2,"  material change opacity EdgyShiny 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline EdgyShiny 0.760000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth EdgyShiny 0.940000");
  fprintf(file, "%*s\n", 2,"  material change transmode EdgyShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient EdgyGlass 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse EdgyGlass 0.660000");
  fprintf(file, "%*s\n", 2,"  material change specular EdgyGlass 0.500000");
  fprintf(file, "%*s\n", 2,"  material change shininess EdgyGlass 0.750000");
  fprintf(file, "%*s\n", 2,"  material change opacity EdgyGlass 0.620000");
  fprintf(file, "%*s\n", 2,"  material change outline EdgyGlass 0.620000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth EdgyGlass 0.940000");
  fprintf(file, "%*s\n", 2,"  material change transmode EdgyGlass 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Goodsell 0.520000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Goodsell 1.000000");
  fprintf(file, "%*s\n", 2,"  material change specular Goodsell 0.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess Goodsell 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Goodsell 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline Goodsell 4.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Goodsell 0.900000");
  fprintf(file, "%*s\n", 2,"  material change transmode Goodsell 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient AOShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse AOShiny 0.850000");
  fprintf(file, "%*s\n", 2,"  material change specular AOShiny 0.200000");
  fprintf(file, "%*s\n", 2,"  material change shininess AOShiny 0.530000");
  fprintf(file, "%*s\n", 2,"  material change opacity AOShiny 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline AOShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth AOShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode AOShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient AOChalky 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse AOChalky 0.850000");
  fprintf(file, "%*s\n", 2,"  material change specular AOChalky 0.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess AOChalky 0.530000");
  fprintf(file, "%*s\n", 2,"  material change opacity AOChalky 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline AOChalky 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth AOChalky 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode AOChalky 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient AOEdgy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse AOEdgy 0.900000");
  fprintf(file, "%*s\n", 2,"  material change specular AOEdgy 0.200000");
  fprintf(file, "%*s\n", 2,"  material change shininess AOEdgy 0.530000");
  fprintf(file, "%*s\n", 2,"  material change opacity AOEdgy 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline AOEdgy 0.620000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth AOEdgy 0.930000");
  fprintf(file, "%*s\n", 2,"  material change transmode AOEdgy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient BlownGlass 0.040000");
  fprintf(file, "%*s\n", 2,"  material change diffuse BlownGlass 0.340000");
  fprintf(file, "%*s\n", 2,"  material change specular BlownGlass 1.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess BlownGlass 1.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity BlownGlass 0.100000");
  fprintf(file, "%*s\n", 2,"  material change outline BlownGlass 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth BlownGlass 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode BlownGlass 1.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient GlassBubble 0.250000");
  fprintf(file, "%*s\n", 2,"  material change diffuse GlassBubble 0.340000");
  fprintf(file, "%*s\n", 2,"  material change specular GlassBubble 1.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess GlassBubble 1.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity GlassBubble 0.040000");
  fprintf(file, "%*s\n", 2,"  material change outline GlassBubble 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth GlassBubble 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode GlassBubble 1.000000");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"vmdrestoremymaterials");
  fprintf(file, "%*s\n", 0,"# Atom selection macros");
  fprintf(file, "%*s\n", 0,"atomselect macro at {resname ADE A THY T");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro acidic {resname ASP GLU");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro cyclic {resname HIS PHE PRO TRP TYR");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro acyclic {protein and not cyclic");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro aliphatic {resname ALA GLY ILE LEU VAL");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro alpha {protein and name CA");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro amino {protein");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro aromatic {resname HIS PHE TRP TYR");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro basic {resname ARG HIS LYS HSP");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro bonded {numbonds > 0");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro buried {resname ALA LEU VAL ILE PHE CYS MET TRP");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro cg {resname CYT C GUA G");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro charged {basic or acidic");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro hetero {not (protein or nucleic)");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro hydrophobic {resname ALA LEU VAL ILE PRO PHE MET TRP");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro small {resname ALA GLY SER");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro medium {resname VAL THR ASP ASN PRO CYS ASX PCA HYP");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro large {protein and not (small or medium)");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro neutral {resname VAL PHE GLN TYR HIS CYS MET TRP ASX GLX PCA HYP");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro polar {protein and not hydrophobic");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro purine {resname ADE A GUA G");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro pyrimidine {resname CYT C THY T URA U");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro surface {protein and not buried");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro lipid {resname DLPE DMPC DPPC GPC LPPC PALM PC PGCL POPC POPE");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro lipids {lipid");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro ion {resname AL BA CA CAL CD CES CLA CL CO CS CU CU1 CUA HG IN IOD K MG MN3 MO3 MO4 MO5 MO6 NA NAW OC7 PB POT PT RB SOD TB TL WO4 YB ZN ZN1 ZN2");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro ions {ion");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro sugar {resname AGLC");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro solvent {not (protein or sugar or nucleic or lipid)");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro carbon {name \"C.*\" and not ion");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro hydrogen {name \"[0-9]?H.*\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro nitrogen {name \"N.*\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro oxygen {name \"O.*\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro sulfur {name \"S.*\" and not ion");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro noh {not hydrogen");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro heme {resname HEM HEME");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationall {altloc \"\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationA {altloc \"\" or altloc \"A\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationB {altloc \"\" or altloc \"B\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationC {altloc \"\" or altloc \"C\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationD {altloc \"\" or altloc \"D\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationE {altloc \"\" or altloc \"E\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationF {altloc \"\" or altloc \"F\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro drude {type DRUD or type LP");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro unparametrized beta<1");
  fprintf(file, "%*s\n", 0,"atomselect macro addedmolefacture {occupancy 0.8}");
  fprintf(file, "%*s\n", 0,"# Display settings");
  fprintf(file, "%*s\n", 0,"display eyesep       0.065000");
  fprintf(file, "%*s\n", 0,"display focallength  2.000000");
  fprintf(file, "%*s\n", 0,"display height       6.000000");
  fprintf(file, "%*s\n", 0,"display distance     -2.000000");
  fprintf(file, "%*s\n", 0,"display projection   Perspective");
  fprintf(file, "%*s\n", 0,"display nearclip set 0.500000");
  fprintf(file, "%*s\n", 0,"display farclip  set 10.000000");
  fprintf(file, "%*s\n", 0,"display depthcue   off");
  fprintf(file, "%*s\n", 0,"display cuestart   0.500000");
  fprintf(file, "%*s\n", 0,"display cueend     10.000000");
  fprintf(file, "%*s\n", 0,"display cuestart   0.500000");
  fprintf(file, "%*s\n", 0,"display cueend     10.000000");
  fprintf(file, "%*s\n", 0,"display cuedensity 0.320000");
  fprintf(file, "%*s\n", 0,"display cuemode    Exp2");
  fprintf(file, "%*s\n", 0,"display shadows off");
  fprintf(file, "%*s\n", 0,"display ambientocclusion off");
  fprintf(file, "%*s\n", 0,"display aoambient 0.800000");
  fprintf(file, "%*s\n", 0,"display aodirect 0.300000");
  fprintf(file, "%*s\n", 0,"display dof off");
  fprintf(file, "%*s\n", 0,"display dof_fnumber 64.000000");
  fprintf(file, "%*s\n", 0,"display dof_focaldist 0.700000");
  fprintf(file, "%*s%s%s\n", 0, "mol new ", rep[DGINTER].c_str(), " type cube first 0 last -1 step 1 filebonds 1 autobonds 1 waitfor all");
  fprintf(file, "%*s%s%s\n", 0, "mol addfile ", rep[DENS].c_str(), " type cube first 0 last -1 step 1 filebonds 1 autobonds 1 waitfor all");
  fprintf(file, "%*s\n", 0,"mol delrep 0 top");
  fprintf(file, "%*s\n", 0,"mol representation CPK 0.600000 0.100000 12.000000 12.000000");
  fprintf(file, "%*s\n", 0,"mol color Name");
  fprintf(file, "%*s\n", 0,"mol selection {all}");
  fprintf(file, "%*s\n", 0,"mol material Opaque");
  fprintf(file, "%*s\n", 0,"mol addrep top");
  fprintf(file, "%*s\n", 0,"mol selupdate 0 top 0");
  fprintf(file, "%*s\n", 0,"mol colupdate 0 top 0");
  fprintf(file, "%*s\n", 0,"mol scaleminmax top 0 0.000000 0.000000");
  fprintf(file, "%*s\n", 0,"mol smoothrep top 0 0");
  fprintf(file, "%*s\n", 0,"mol drawframes top 0 {now}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 0 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  0 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 0 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 0 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 1 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  1 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 1 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 1 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 2 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  2 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 2 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 2 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 3 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  3 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 3 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 3 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 4 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  4 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 4 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 4 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 5 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  5 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 5 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 5 0 top {0}");
  fprintf(file, "%*s%s%s\n", 0,"mol representation Isosurface ",rep[CUTPLOTIGM4].c_str()," 0 0 0 1 1");
  fprintf(file, "%*s\n", 0,"mol color Volume 1");
  fprintf(file, "%*s\n", 0,"mol selection {all}");
  fprintf(file, "%*s\n", 0,"mol material Opaque");
  fprintf(file, "%*s\n", 0,"mol addrep top");
  fprintf(file, "%*s\n", 0,"mol selupdate 1 top 0");
  fprintf(file, "%*s\n", 0,"mol colupdate 1 top 0");
  fprintf(file, "%*s%s%s%s%s\n", 0, "mol scaleminmax top 1 -", rep[VMDCOLRANGIGM2].c_str(), " ", rep[VMDCOLRANGIGM2].c_str(), "");
  fprintf(file, "%*s\n", 0,"mol smoothrep top 1 0");
  fprintf(file, "%*s\n", 0,"mol drawframes top 1 {now}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 0 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  0 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 0 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 0 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 1 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  1 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 1 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 1 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 2 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  2 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 2 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 2 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 3 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  3 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 3 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 3 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 4 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  4 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 4 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 4 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 5 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  5 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 5 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 5 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol rename top mol-dgInter.cube");
  fprintf(file, "%*s\n", 0,"# done with molecule 0");
  fprintf(file, "%*s%s%s\n", 0, "mol new ", rep[DGINTRA].c_str(), " type cube first 0 last -1 step 1 filebonds 1 autobonds 1 waitfor all");
  fprintf(file, "%*s%s%s\n", 0, "mol addfile ", rep[DENS].c_str(), " type cube first 0 last -1 step 1 filebonds 1 autobonds 1 waitfor all");
  fprintf(file, "%*s\n", 0,"mol delrep 0 top");
  fprintf(file, "%*s\n", 0,"mol representation CPK 0.600000 0.100000 12.000000 12.000000");
  fprintf(file, "%*s\n", 0,"mol color Name");
  fprintf(file, "%*s\n", 0,"mol selection {all}");
  fprintf(file, "%*s\n", 0,"mol material Opaque");
  fprintf(file, "%*s\n", 0,"mol addrep top");
  fprintf(file, "%*s\n", 0,"mol selupdate 0 top 0");
  fprintf(file, "%*s\n", 0,"mol colupdate 0 top 0");
  fprintf(file, "%*s\n", 0,"mol scaleminmax top 0 0.000000 0.000000");
  fprintf(file, "%*s\n", 0,"mol smoothrep top 0 0");
  fprintf(file, "%*s\n", 0,"mol drawframes top 0 {now}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 0 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  0 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 0 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 0 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 1 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  1 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 1 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 1 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 2 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  2 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 2 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 2 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 3 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  3 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 3 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 3 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 4 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  4 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 4 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 4 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 5 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  5 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 5 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 5 0 top {0}");
  fprintf(file, "%*s%s%s\n", 0,"mol representation Isosurface ", rep[CUTPLOTIGM3].c_str()," 0 0 0 1 1");
  fprintf(file, "%*s\n", 0,"mol color Volume 1");
  fprintf(file, "%*s\n", 0,"mol selection {all}");
  fprintf(file, "%*s\n", 0,"mol material Opaque");
  fprintf(file, "%*s\n", 0,"mol addrep top");
  fprintf(file, "%*s\n", 0,"mol selupdate 1 top 0");
  fprintf(file, "%*s\n", 0,"mol colupdate 1 top 0");
  fprintf(file, "%*s%s%s%s%s\n", 0, "mol scaleminmax top 1 -", rep[VMDCOLRANGIGM1].c_str(), " ", rep[VMDCOLRANGIGM1].c_str(), "");
  fprintf(file, "%*s\n", 0,"mol smoothrep top 1 0");
  fprintf(file, "%*s\n", 0,"mol drawframes top 1 {now}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 0 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  0 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 0 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 0 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 1 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  1 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 1 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 1 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 2 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  2 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 2 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 2 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 3 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  3 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 3 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 3 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 4 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  4 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 4 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 4 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 5 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  5 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 5 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 5 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol rename top mol-dgIntra.cube");
  fprintf(file, "%*s\n", 0,"molinfo top set drawn 0");
  fprintf(file, "%*s\n", 0,"set topmol [molinfo top]");
  fprintf(file, "%*s\n", 0,"# done with molecule 1");
  fprintf(file, "%*s\n", 0,"mol top $topmol");
  fprintf(file, "%*s\n", 0,"unset topmol");
  fprintf(file, "%*s\n", 0,"proc vmdrestoremycolors {} {");
  fprintf(file, "%*s\n", 0,"color scale colors RWB {1.0 0.0 0.0} {1.0 1.0 1.0} {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"color scale colors BWR {0.0 0.0 1.0} {1.0 1.0 1.0} {1.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"color scale colors RGryB {1.0 0.0 0.0} {0.5 0.5 0.5} {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"color scale colors BGryR {0.0 0.0 1.0} {0.5 0.5 0.5} {1.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"color scale colors RGB {1.0 0.0 0.0} {0.0 1.0 0.0} {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"color scale colors BGR {0.0 0.0 1.0} {0.0 1.0 0.0} {1.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"color scale colors RWG {1.0 0.0 0.0} {1.0 1.0 1.0} {0.0 1.0 0.0}");
  fprintf(file, "%*s\n", 0,"color scale colors GWR {0.0 1.0 0.0} {1.0 1.0 1.0} {1.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"color scale colors GWB {0.0 1.0 0.0} {1.0 1.0 1.0} {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"color scale colors BWG {0.0 0.0 1.0} {1.0 1.0 1.0} {0.0 1.0 0.0}");
  fprintf(file, "%*s\n", 0,"color scale colors BlkW {0.0 0.0 0.0} {0.5 0.5 0.5} {1.0 1.0 1.0}");
  fprintf(file, "%*s\n", 0,"color scale colors WBlk {1.0 1.0 1.0} {0.5 0.5 0.5} {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 2,"  color scale method BGR");
  fprintf(file, "%*s\n", 2,"  set colorcmds {");
  fprintf(file, "%*s\n", 4,"    {color Display {BackgroundTop} black}");
  fprintf(file, "%*s\n", 4,"    {color Display {BackgroundBot} blue2}");
  fprintf(file, "%*s\n", 4,"    {color Display {FPS} white}");
  fprintf(file, "%*s\n", 4,"    {color Name {LPA} green}");
  fprintf(file, "%*s\n", 4,"    {color Name {LPB} green}");
  fprintf(file, "%*s\n", 4,"    {color Type {LP} green}");
  fprintf(file, "%*s\n", 4,"    {color Type {DRUD} pink}");
  fprintf(file, "%*s\n", 4,"    {color Element {X} cyan}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ac} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ag} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Al} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Am} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ar} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {As} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {At} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Au} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {B} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ba} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Be} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Bh} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Bi} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Bk} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Br} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ca} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cd} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ce} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cf} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cl} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cm} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Co} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cs} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cu} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Db} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ds} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Dy} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Er} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Es} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Eu} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {F} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Fe} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Fm} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Fr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ga} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Gd} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ge} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {He} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Hf} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Hg} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ho} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Hs} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {I} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {In} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ir} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {K} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Kr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {La} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Li} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Lr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Lu} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Md} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Mg} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Mn} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Mo} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Mt} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Na} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Nb} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Nd} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ne} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ni} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {No} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Np} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Os} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pa} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pb} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pd} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pm} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Po} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pt} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pu} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ra} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Rb} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Re} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Rf} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Rg} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Rh} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Rn} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ru} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Sb} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Sc} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Se} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Sg} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Si} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Sm} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Sn} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Sr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ta} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Tb} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Tc} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Te} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Th} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ti} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Tl} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Tm} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {U} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {V} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {W} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Xe} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Y} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Yb} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Zr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Resname {} silver}");
  fprintf(file, "%*s\n", 4,"    {color Chain {X} blue}");
  fprintf(file, "%*s\n", 4,"    {color Segname {} blue}");
  fprintf(file, "%*s\n", 4,"    {color Conformation {all} blue}");
  fprintf(file, "%*s\n", 4,"    {color Molecule {0} blue}");
  fprintf(file, "%*s\n", 4,"    {color Molecule {1} red}");
  fprintf(file, "%*s\n", 4,"    {color Structure {3_10_Helix} blue}");
  fprintf(file, "%*s\n", 4,"    {color Surface {Grasp} gray}");
  fprintf(file, "%*s\n", 4,"    {color Labels {Springs} orange}");
  fprintf(file, "%*s\n", 4,"    {color Stage {Even} gray}");
  fprintf(file, "%*s\n", 4,"    {color Stage {Odd} silver}");
  fprintf(file, "%*s\n", 2,"  }");
  fprintf(file, "%*s\n", 2,"  foreach colcmd $colorcmds {");
  fprintf(file, "%*s\n", 4,"    set val [catch {eval $colcmd}]");
  fprintf(file, "%*s\n", 2,"  }");
  fprintf(file, "%*s\n", 2,"  color change rgb 0 0.0 0.0 1.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 2 0.3499999940395355 0.3499999940395355 0.3499999940395355");
  fprintf(file, "%*s\n", 2,"  color change rgb 3 1.0 0.5 0.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 4 1.0 1.0 0.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 5 0.5 0.5 0.20000000298023224");
  fprintf(file, "%*s\n", 2,"  color change rgb 6 0.6000000238418579 0.6000000238418579 0.6000000238418579");
  fprintf(file, "%*s\n", 2,"  color change rgb 7 0.0 1.0 0.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 9 1.0 0.6000000238418579 0.6000000238418579");
  fprintf(file, "%*s\n", 2,"  color change rgb 11 0.6499999761581421 0.0 0.6499999761581421");
  fprintf(file, "%*s\n", 2,"  color change rgb 12 0.5 0.8999999761581421 0.4000000059604645");
  fprintf(file, "%*s\n", 2,"  color change rgb 13 0.8999999761581421 0.4000000059604645 0.699999988079071");
  fprintf(file, "%*s\n", 2,"  color change rgb 14 0.5 0.30000001192092896 0.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 15 0.5 0.5 0.75");
  fprintf(file, "%*s\n", 2,"  color change rgb 17 0.8799999952316284 0.9700000286102295 0.019999999552965164");
  fprintf(file, "%*s\n", 2,"  color change rgb 18 0.550000011920929 0.8999999761581421 0.019999999552965164");
  fprintf(file, "%*s\n", 2,"  color change rgb 19 0.0 0.8999999761581421 0.03999999910593033");
  fprintf(file, "%*s\n", 2,"  color change rgb 20 0.0 0.8999999761581421 0.5");
  fprintf(file, "%*s\n", 2,"  color change rgb 21 0.0 0.8799999952316284 1.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 22 0.0 0.7599999904632568 1.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 23 0.019999999552965164 0.3799999952316284 0.6700000166893005");
  fprintf(file, "%*s\n", 2,"  color change rgb 24 0.009999999776482582 0.03999999910593033 0.9300000071525574");
  fprintf(file, "%*s\n", 2,"  color change rgb 25 0.27000001072883606 0.0 0.9800000190734863");
  fprintf(file, "%*s\n", 2,"  color change rgb 26 0.44999998807907104 0.0 0.8999999761581421");
  fprintf(file, "%*s\n", 2,"  color change rgb 27 0.8999999761581421 0.0 0.8999999761581421");
  fprintf(file, "%*s\n", 2,"  color change rgb 28 1.0 0.0 0.6600000262260437");
  fprintf(file, "%*s\n", 2,"  color change rgb 29 0.9800000190734863 0.0 0.23000000417232513");
  fprintf(file, "%*s\n", 2,"  color change rgb 30 0.8100000023841858 0.0 0.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 31 0.8899999856948853 0.3499999940395355 0.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 32 0.9599999785423279 0.7200000286102295 0.0");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"vmdrestoremycolors");
  fprintf(file, "%*s\n", 0,"label textsize 1.0");
  fprintf(file, "%*s\n", 0,"");
  fprintf(file, "%*s\n", 0,"axes location Off");
  fprintf(file, "%*s\n", 0,"display rendermode GLSL");
  fprintf(file, "%*s\n", 0,"display depthcue off");
  fprintf(file, "%*s\n", 0,"");
  fclose(file);
} // end of  generateVMDigmFile(const std::string *rep)

void generateVMDPAULIFile(const std::string *rep)
{
  FILE* file=fopen("self.vmd","w");
  fprintf(file, "%*s\n", 0,"#");
  fprintf(file, "%*s\n", 0,"##Copyright University of Reims Champagne-Ardenne");
  fprintf(file, "%*s\n", 0,"#Authors and Contributors: Akilan RAJAMANI, Corentin LEFEBVRE, Johanna KLEIN, Emmanuel PLUOT, Gaetan RUBEZ, Hassan Khartabil, Jean-Charles-BOISSON and Eric HENON");
  fprintf(file, "%*s\n", 0,"#Contributors: Hassan Khartabil, Miguel Ponce-Vargas, Julia Contreras-Garcia");
  fprintf(file, "%*s\n", 0,"##(24/07/2017)");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"##jean-charles.boisson@univ-reims.fr, eric.henon@univ-reims.fr");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"##This software is a computer program whose purpose is to ");
  fprintf(file, "%*s\n", 0,"##detect and prepare the plot of molecular interactions");
  fprintf(file, "%*s\n", 0,"##from electron density and IGM reference using promolecular");
  fprintf(file, "%*s\n", 0,"##electron density.");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"##This software is governed by the CeCILL-C license under French law and");
  fprintf(file, "%*s\n", 0,"##abiding by the rules of distribution of free software.  You can  use, ");
  fprintf(file, "%*s\n", 0,"##modify and/ or redistribute the software under the terms of the CeCILL-C");
  fprintf(file, "%*s\n", 0,"##license as circulated by CEA, CNRS and INRIA at the following URL");
  fprintf(file, "%*s\n", 0,"##\"http://www.cecill.info\". ");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"##As a counterpart to the access to the source code and  rights to copy,");
  fprintf(file, "%*s\n", 0,"##modify and redistribute granted by the license, users are provided only");
  fprintf(file, "%*s\n", 0,"##with a limited warranty  and the software\'s author,  the holder of the");
  fprintf(file, "%*s\n", 0,"##economic rights,  and the successive licensors  have only  limited");
  fprintf(file, "%*s\n", 0,"##liability. ");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"##In this respect, the user\'s attention is drawn to the risks associated");
  fprintf(file, "%*s\n", 0,"##with loading,  using,  modifying and/or developing or reproducing the");
  fprintf(file, "%*s\n", 0,"##software by the user in light of its specific status of free software,");
  fprintf(file, "%*s\n", 0,"##that may mean  that it is complicated to manipulate,  and  that  also");
  fprintf(file, "%*s\n", 0,"##therefore means  that it is reserved for developers  and  experienced");
  fprintf(file, "%*s\n", 0,"##professionals having in-depth computer knowledge. Users are therefore");
  fprintf(file, "%*s\n", 0,"##encouraged to load and test the software\'s suitability as regards their");
  fprintf(file, "%*s\n", 0,"##requirements in conditions enabling the security of their systems and/or ");
  fprintf(file, "%*s\n", 0,"##data to be ensured and,  more generally, to use and operate it in the ");
  fprintf(file, "%*s\n", 0,"##same conditions as regards security. ");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"##The fact that you are presently reading this means that you have had");
  fprintf(file, "%*s\n", 0,"##knowledge of the CeCILL-C license and that you accept its terms.");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"#");
  fprintf(file, "%*s\n", 0,"#");
  fprintf(file, "%*s\n", 0,"#!/usr/local/bin/vmd");
  fprintf(file, "%*s\n", 0,"# VMD script written by save_state $Revision: 1.47 $");
  fprintf(file, "%*s\n", 0,"# VMD version: 1.9.3");
  fprintf(file, "%*s\n", 0,"set viewplist {}");
  fprintf(file, "%*s\n", 0,"set fixedlist {}");
  fprintf(file, "%*s\n", 0,"proc vmdrestoremymaterials {} {");
  fprintf(file, "%*s\n", 0,"  set mlist { Opaque Transparent BrushedMetal Diffuse Ghost Glass1 Glass2 Glass3 Glossy HardPlastic MetallicPastel Steel Translucent Edgy EdgyShiny EdgyGlass Goodsell AOShiny AOChalky AOEdgy BlownGlass GlassBubble RTChrome }");
  fprintf(file, "%*s\n", 2,"  set mymlist [material list]");
  fprintf(file, "%*s\n", 2,"  foreach mat $mlist {");
  fprintf(file, "%*s\n", 4,"    if { [lsearch $mymlist $mat] == -1 } { ");
  fprintf(file, "%*s\n", 6,"      material add $mat");
  fprintf(file, "%*s\n", 4,"    }");
  fprintf(file, "%*s\n", 2,"  }");
  fprintf(file, "%*s\n", 2,"  material change ambient Opaque 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Opaque 0.650000");
  fprintf(file, "%*s\n", 2,"  material change specular Opaque 0.500000");
  fprintf(file, "%*s\n", 2,"  material change shininess Opaque 0.534020");
  fprintf(file, "%*s\n", 2,"  material change mirror Opaque 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Opaque 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline Opaque 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Opaque 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Opaque 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Transparent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Transparent 0.650000");
  fprintf(file, "%*s\n", 2,"  material change specular Transparent 0.500000");
  fprintf(file, "%*s\n", 2,"  material change shininess Transparent 0.534020");
  fprintf(file, "%*s\n", 2,"  material change mirror Transparent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Transparent 0.300000");
  fprintf(file, "%*s\n", 2,"  material change outline Transparent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Transparent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Transparent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient BrushedMetal 0.080000");
  fprintf(file, "%*s\n", 2,"  material change diffuse BrushedMetal 0.390000");
  fprintf(file, "%*s\n", 2,"  material change specular BrushedMetal 0.340000");
  fprintf(file, "%*s\n", 2,"  material change shininess BrushedMetal 0.150000");
  fprintf(file, "%*s\n", 2,"  material change mirror BrushedMetal 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity BrushedMetal 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline BrushedMetal 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth BrushedMetal 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode BrushedMetal 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Diffuse 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Diffuse 0.620000");
  fprintf(file, "%*s\n", 2,"  material change specular Diffuse 0.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess Diffuse 0.530000");
  fprintf(file, "%*s\n", 2,"  material change mirror Diffuse 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Diffuse 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline Diffuse 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Diffuse 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Diffuse 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Ghost 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Ghost 0.000000");
  fprintf(file, "%*s\n", 2,"  material change specular Ghost 1.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess Ghost 0.230000");
  fprintf(file, "%*s\n", 2,"  material change mirror Ghost 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Ghost 0.100000");
  fprintf(file, "%*s\n", 2,"  material change outline Ghost 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Ghost 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Ghost 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Glass1 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Glass1 0.500000");
  fprintf(file, "%*s\n", 2,"  material change specular Glass1 0.650000");
  fprintf(file, "%*s\n", 2,"  material change shininess Glass1 0.530000");
  fprintf(file, "%*s\n", 2,"  material change mirror Glass1 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Glass1 0.150000");
  fprintf(file, "%*s\n", 2,"  material change outline Glass1 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Glass1 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Glass1 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Glass2 0.520000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Glass2 0.760000");
  fprintf(file, "%*s\n", 2,"  material change specular Glass2 0.220000");
  fprintf(file, "%*s\n", 2,"  material change shininess Glass2 0.590000");
  fprintf(file, "%*s\n", 2,"  material change mirror Glass2 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Glass2 0.680000");
  fprintf(file, "%*s\n", 2,"  material change outline Glass2 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Glass2 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Glass2 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Glass3 0.150000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Glass3 0.250000");
  fprintf(file, "%*s\n", 2,"  material change specular Glass3 0.750000");
  fprintf(file, "%*s\n", 2,"  material change shininess Glass3 0.800000");
  fprintf(file, "%*s\n", 2,"  material change mirror Glass3 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Glass3 0.500000");
  fprintf(file, "%*s\n", 2,"  material change outline Glass3 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Glass3 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Glass3 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Glossy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Glossy 0.650000");
  fprintf(file, "%*s\n", 2,"  material change specular Glossy 1.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess Glossy 0.880000");
  fprintf(file, "%*s\n", 2,"  material change mirror Glossy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Glossy 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline Glossy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Glossy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Glossy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient HardPlastic 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse HardPlastic 0.560000");
  fprintf(file, "%*s\n", 2,"  material change specular HardPlastic 0.280000");
  fprintf(file, "%*s\n", 2,"  material change shininess HardPlastic 0.690000");
  fprintf(file, "%*s\n", 2,"  material change mirror HardPlastic 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity HardPlastic 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline HardPlastic 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth HardPlastic 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode HardPlastic 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient MetallicPastel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse MetallicPastel 0.260000");
  fprintf(file, "%*s\n", 2,"  material change specular MetallicPastel 0.550000");
  fprintf(file, "%*s\n", 2,"  material change shininess MetallicPastel 0.190000");
  fprintf(file, "%*s\n", 2,"  material change mirror MetallicPastel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity MetallicPastel 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline MetallicPastel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth MetallicPastel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode MetallicPastel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Steel 0.250000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Steel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change specular Steel 0.380000");
  fprintf(file, "%*s\n", 2,"  material change shininess Steel 0.320000");
  fprintf(file, "%*s\n", 2,"  material change mirror Steel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Steel 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline Steel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Steel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Steel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Translucent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Translucent 0.700000");
  fprintf(file, "%*s\n", 2,"  material change specular Translucent 0.600000");
  fprintf(file, "%*s\n", 2,"  material change shininess Translucent 0.300000");
  fprintf(file, "%*s\n", 2,"  material change mirror Translucent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Translucent 0.800000");
  fprintf(file, "%*s\n", 2,"  material change outline Translucent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Translucent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Translucent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Edgy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Edgy 0.660000");
  fprintf(file, "%*s\n", 2,"  material change specular Edgy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess Edgy 0.750000");
  fprintf(file, "%*s\n", 2,"  material change mirror Edgy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Edgy 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline Edgy 0.620000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Edgy 0.940000");
  fprintf(file, "%*s\n", 2,"  material change transmode Edgy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient EdgyShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse EdgyShiny 0.660000");
  fprintf(file, "%*s\n", 2,"  material change specular EdgyShiny 0.960000");
  fprintf(file, "%*s\n", 2,"  material change shininess EdgyShiny 0.750000");
  fprintf(file, "%*s\n", 2,"  material change mirror EdgyShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity EdgyShiny 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline EdgyShiny 0.760000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth EdgyShiny 0.940000");
  fprintf(file, "%*s\n", 2,"  material change transmode EdgyShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient EdgyGlass 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse EdgyGlass 0.660000");
  fprintf(file, "%*s\n", 2,"  material change specular EdgyGlass 0.500000");
  fprintf(file, "%*s\n", 2,"  material change shininess EdgyGlass 0.750000");
  fprintf(file, "%*s\n", 2,"  material change mirror EdgyGlass 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity EdgyGlass 0.620000");
  fprintf(file, "%*s\n", 2,"  material change outline EdgyGlass 0.620000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth EdgyGlass 0.940000");
  fprintf(file, "%*s\n", 2,"  material change transmode EdgyGlass 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Goodsell 0.520000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Goodsell 1.000000");
  fprintf(file, "%*s\n", 2,"  material change specular Goodsell 0.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess Goodsell 0.000000");
  fprintf(file, "%*s\n", 2,"  material change mirror Goodsell 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Goodsell 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline Goodsell 4.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Goodsell 0.900000");
  fprintf(file, "%*s\n", 2,"  material change transmode Goodsell 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient AOShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse AOShiny 0.850000");
  fprintf(file, "%*s\n", 2,"  material change specular AOShiny 0.200000");
  fprintf(file, "%*s\n", 2,"  material change shininess AOShiny 0.530000");
  fprintf(file, "%*s\n", 2,"  material change mirror AOShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity AOShiny 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline AOShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth AOShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode AOShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient AOChalky 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse AOChalky 0.850000");
  fprintf(file, "%*s\n", 2,"  material change specular AOChalky 0.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess AOChalky 0.530000");
  fprintf(file, "%*s\n", 2,"  material change mirror AOChalky 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity AOChalky 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline AOChalky 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth AOChalky 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode AOChalky 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient AOEdgy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse AOEdgy 0.900000");
  fprintf(file, "%*s\n", 2,"  material change specular AOEdgy 0.200000");
  fprintf(file, "%*s\n", 2,"  material change shininess AOEdgy 0.530000");
  fprintf(file, "%*s\n", 2,"  material change mirror AOEdgy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity AOEdgy 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline AOEdgy 0.620000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth AOEdgy 0.930000");
  fprintf(file, "%*s\n", 2,"  material change transmode AOEdgy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient BlownGlass 0.040000");
  fprintf(file, "%*s\n", 2,"  material change diffuse BlownGlass 0.340000");
  fprintf(file, "%*s\n", 2,"  material change specular BlownGlass 1.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess BlownGlass 1.000000");
  fprintf(file, "%*s\n", 2,"  material change mirror BlownGlass 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity BlownGlass 0.100000");
  fprintf(file, "%*s\n", 2,"  material change outline BlownGlass 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth BlownGlass 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode BlownGlass 1.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient GlassBubble 0.250000");
  fprintf(file, "%*s\n", 2,"  material change diffuse GlassBubble 0.340000");
  fprintf(file, "%*s\n", 2,"  material change specular GlassBubble 1.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess GlassBubble 1.000000");
  fprintf(file, "%*s\n", 2,"  material change mirror GlassBubble 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity GlassBubble 0.040000");
  fprintf(file, "%*s\n", 2,"  material change outline GlassBubble 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth GlassBubble 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode GlassBubble 1.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient RTChrome 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse RTChrome 0.650000");
  fprintf(file, "%*s\n", 2,"  material change specular RTChrome 0.500000");
  fprintf(file, "%*s\n", 2,"  material change shininess RTChrome 0.530000");
  fprintf(file, "%*s\n", 2,"  material change mirror RTChrome 0.700000");
  fprintf(file, "%*s\n", 2,"  material change opacity RTChrome 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline RTChrome 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth RTChrome 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode RTChrome 0.000000");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"vmdrestoremymaterials");
  fprintf(file, "%*s\n", 0,"# Atom selection macros");
  fprintf(file, "%*s\n", 0,"atomselect macro at {resname ADE A THY T");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro acidic {resname ASP GLU");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro cyclic {resname HIS PHE PRO TRP TYR");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro acyclic {protein and not cyclic");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro aliphatic {resname ALA GLY ILE LEU VAL");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro alpha {protein and name CA");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro amino {protein");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro aromatic {resname HIS PHE TRP TYR");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro basic {resname ARG HIS LYS HSP");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro bonded {numbonds > 0");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro buried {resname ALA LEU VAL ILE PHE CYS MET TRP");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro cg {resname CYT C GUA G");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro charged {basic or acidic");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro hetero {not (protein or nucleic)");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro hydrophobic {resname ALA LEU VAL ILE PRO PHE MET TRP");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro small {resname ALA GLY SER");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro medium {resname VAL THR ASP ASN PRO CYS ASX PCA HYP");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro large {protein and not (small or medium)");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro neutral {resname VAL PHE GLN TYR HIS CYS MET TRP ASX GLX PCA HYP");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro polar {protein and not hydrophobic");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro purine {resname ADE A GUA G");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro pyrimidine {resname CYT C THY T URA U");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro surface {protein and not buried");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro lipid {resname DLPE DMPC DPPC GPC LPPC PALM PC PGCL POPC POPE");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro lipids {lipid");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro ion {resname AL BA CA CAL CD CES CLA CL CO CS CU CU1 CUA HG IN IOD K MG MN3 MO3 MO4 MO5 MO6 NA NAW OC7 PB POT PT RB SOD TB TL WO4 YB ZN ZN1 ZN2");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro ions {ion");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro sugar {resname AGLC");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro solvent {not (protein or sugar or nucleic or lipid)");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro glycan {resname NAG BGLN FUC AFUC MAN AMAN BMA BMAN");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro carbon {name \"C.*\" and not ion");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro hydrogen {name \"[0-9]?H.*\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro nitrogen {name \"N.*\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro oxygen {name \"O.*\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro sulfur {name \"S.*\" and not ion");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro noh {not hydrogen");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro heme {resname HEM HEME");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationall {altloc \"\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationA {altloc \"\" or altloc \"A\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationB {altloc \"\" or altloc \"B\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationC {altloc \"\" or altloc \"C\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationD {altloc \"\" or altloc \"D\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationE {altloc \"\" or altloc \"E\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationF {altloc \"\" or altloc \"F\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro drude {type DRUD or type LP");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro unparametrized beta<1");
  fprintf(file, "%*s\n", 0,"atomselect macro addedmolefacture {occupancy 0.8}");
  fprintf(file, "%*s\n", 0,"atomselect macro qwikmd_protein {(not name QWIKMDDELETE and protein)}");
  fprintf(file, "%*s\n", 0,"atomselect macro qwikmd_nucleic {(not name QWIKMDDELETE and nucleic)}");
  fprintf(file, "%*s\n", 0,"atomselect macro qwikmd_glycan {(not name QWIKMDDELETE and glycan)}");
  fprintf(file, "%*s\n", 0,"atomselect macro qwikmd_lipid {(not name QWIKMDDELETE and lipid)}");
  fprintf(file, "%*s\n", 0,"atomselect macro qwikmd_hetero {(not name QWIKMDDELETE and hetero and not qwikmd_protein and not qwikmd_lipid and not qwikmd_nucleic and not qwikmd_glycan and not water)}");
  fprintf(file, "%*s\n", 0,"# Display settings");
  fprintf(file, "%*s\n", 0,"display eyesep       0.065000");
  fprintf(file, "%*s\n", 0,"display focallength  2.000000");
  fprintf(file, "%*s\n", 0,"display height       6.000000");
  fprintf(file, "%*s\n", 0,"display distance     -2.000000");
  fprintf(file, "%*s\n", 0,"display projection   Perspective");
  fprintf(file, "%*s\n", 0,"display nearclip set 0.500000");
  fprintf(file, "%*s\n", 0,"display farclip  set 10.000000");
  fprintf(file, "%*s\n", 0,"display depthcue   off");
  fprintf(file, "%*s\n", 0,"display cuestart   0.500000");
  fprintf(file, "%*s\n", 0,"display cueend     10.000000");
  fprintf(file, "%*s\n", 0,"display cuestart   0.500000");
  fprintf(file, "%*s\n", 0,"display cueend     10.000000");
  fprintf(file, "%*s\n", 0,"display cuedensity 0.320000");
  fprintf(file, "%*s\n", 0,"display cuemode    Exp2");
  fprintf(file, "%*s\n", 0,"display shadows off");
  fprintf(file, "%*s\n", 0,"display ambientocclusion off");
  fprintf(file, "%*s\n", 0,"display aoambient 0.800000");
  fprintf(file, "%*s\n", 0,"display aodirect 0.300000");
  fprintf(file, "%*s\n", 0,"display dof off");
  fprintf(file, "%*s\n", 0,"display dof_fnumber 64.000000");
  fprintf(file, "%*s\n", 0,"display dof_focaldist 0.700000");

//MOL 0
  fprintf(file, "%*s%s%s\n", 0,"mol new ", rep[DGINTER].c_str(), " type cube first 0 last -1 step 1 filebonds 1 autobonds 1 waitfor all");
  fprintf(file, "%*s%s%s\n", 0,"mol addfile ", rep[SELFcube].c_str(), " type cube first 0 last -1 step 1 filebonds 1 autobonds 1 waitfor all");
  fprintf(file, "%*s\n", 0,"mol delrep 0 top");
  fprintf(file, "%*s\n", 0,"mol representation CPK 0.600000 0.100000 47.000000 47.000000");
  fprintf(file, "%*s\n", 0,"mol color Name");
  fprintf(file, "%*s\n", 0,"mol selection {all}");
  fprintf(file, "%*s\n", 0,"mol material Glossy");
  fprintf(file, "%*s\n", 0,"mol addrep top");
  fprintf(file, "%*s\n", 0,"mol selupdate 0 top 0");
  fprintf(file, "%*s\n", 0,"mol colupdate 0 top 0");
  fprintf(file, "%*s\n", 0,"mol scaleminmax top 0 0.000000 0.000000");
  fprintf(file, "%*s\n", 0,"mol smoothrep top 0 0");
  fprintf(file, "%*s\n", 0,"mol drawframes top 0 {now}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 0 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  0 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 0 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 0 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 1 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  1 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 1 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 1 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 2 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  2 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 2 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 2 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 3 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  3 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 3 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 3 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 4 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  4 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 4 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 4 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 5 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  5 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 5 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 5 0 top {0}");

// Dg/rho iso-surface:
  fprintf(file, "%*s%s%s\n", 0,"mol representation Isosurface ", rep[DGSCALEDMAX].c_str(), " 0 0 0 1 1");
  fprintf(file, "%*s\n", 0,"mol color Volume 1");
  fprintf(file, "%*s\n", 0,"mol selection {all}");
  fprintf(file, "%*s\n", 0,"mol material Glossy");
  fprintf(file, "%*s\n", 0,"mol addrep top");
  fprintf(file, "%*s\n", 0,"mol selupdate 1 top 0");
  fprintf(file, "%*s\n", 0,"mol colupdate 1 top 0");

//                                               colored according to SELF in the range :
  fprintf(file, "%*s%s%s\n", 0,"mol scaleminmax top 1 0.000000 ",  rep[SELFMAXCOLOR].c_str(), "");
  fprintf(file, "%*s\n", 0,"mol smoothrep top 1 0");
  fprintf(file, "%*s\n", 0,"mol drawframes top 1 {now}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 0 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  0 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 0 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 0 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 1 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  1 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 1 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 1 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 2 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  2 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 2 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 2 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 3 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  3 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 3 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 3 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 4 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  4 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 4 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 4 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 5 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  5 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 5 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 5 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol rename top {dg/rho col. with SELF}");
  fprintf(file, "%*s\n", 0,"molinfo top set drawn 0");
  fprintf(file, "%*s\n", 0,"set viewpoints([molinfo top]) {{{1 0 0 0.712383} {0 1 0 0.00673728} {0 0 1 -0.0233231} {0 0 0 1}} {{0.887115 -0.0836314 -0.453911 0} {0.10699 0.993922 0.0259737 0} {0.448981 -0.071605 0.890672 0} {0 0 0 1}} {{0.158823 0 0 0} {0 0.158823 0 0} {0 0 0.158823 0} {0 0 0 1}} {{1 0 0 0} {0 1 0 0} {0 0 1 0} {0 0 0 1}}}");
  fprintf(file, "%*s\n", 0,"lappend viewplist [molinfo top]");
  fprintf(file, "%*s\n", 0,"# done with molecule 0");

if (rep[isSELFAtomic] == "TRUE") {
// MOL 1
// ATOMIC CONTRIBUTIONS
  fprintf(file, "%*s%s%s\n", 0,"mol new ", rep[SELFcube].c_str(), " type cube first 0 last -1 step 1 filebonds 1 autobonds 1 waitfor all");
  fprintf(file, "%*s%s%s\n", 0,"mol addfile ", rep[DGINTER].c_str(), " type cube first 0 last -1 step 1 filebonds 1 autobonds 1 waitfor all");
  fprintf(file, "%*s\n", 0,"mol delrep 0 top");
  fprintf(file, "%*s\n", 0,"mol representation Licorice 0.100000 47.000000 47.000000");
  fprintf(file, "%*s\n", 0,"mol color Charge");
  fprintf(file, "%*s\n", 0,"mol selection {all}");
  fprintf(file, "%*s\n", 0,"mol material Transparent");
  fprintf(file, "%*s\n", 0,"mol addrep top");
  fprintf(file, "%*s\n", 0,"mol selupdate 0 top 0");
  fprintf(file, "%*s\n", 0,"mol colupdate 0 top 0");
//                                                         CPK colored according to data read in selfatomdat in the range :
  fprintf(file, "%*s%s%s%s%s\n", 0,"mol scaleminmax 1   0 ", rep[SELFMIN].c_str(), " ", rep[SELFMAX].c_str(),"");
  fprintf(file, "%*s\n", 0,"mol smoothrep top 0 0");
  fprintf(file, "%*s\n", 0,"mol drawframes top 0 {now}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 0 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  0 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 0 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 0 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 1 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  1 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 1 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 1 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 2 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  2 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 2 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 2 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 3 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  3 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 3 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 3 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 4 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  4 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 4 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 4 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 5 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  5 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 5 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 5 0 top {0}");
// dg/rho iso-surface:                           ==> with isovalue:
  fprintf(file, "%*s%s%s\n", 0,"mol representation Isosurface ", rep[DGSCALEDMAX].c_str(), " 1 0 0 1 1");
  fprintf(file, "%*s\n", 0,"mol color Volume 0");
  fprintf(file, "%*s\n", 0,"mol selection {all}");
  fprintf(file, "%*s\n", 0,"mol material Glossy");
  fprintf(file, "%*s\n", 0,"mol addrep top");
  fprintf(file, "%*s\n", 0,"mol selupdate 1 top 0");
  fprintf(file, "%*s\n", 0,"mol colupdate 1 top 0");

//                                               colored according to SELF in the range :
  fprintf(file, "%*s%s%s\n", 0,"mol scaleminmax 1 1 -0.000000 ",  rep[SELFMAXCOLOR].c_str(), "");
  fprintf(file, "%*s\n", 0,"mol smoothrep top 1 0");
  fprintf(file, "%*s\n", 0,"mol drawframes top 1 {now}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 0 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  0 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 0 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 0 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 1 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  1 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 1 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 1 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 2 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  2 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 2 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 2 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 3 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  3 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 3 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 3 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 4 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  4 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 4 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 4 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 5 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  5 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 5 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 5 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol rename top AtomicContrib");
  fprintf(file, "%*s\n", 0,"set viewpoints([molinfo top]) {{{1 0 0 0.712383} {0 1 0 0.00673728} {0 0 1 -0.0233231} {0 0 0 1}} {{0.887115 -0.0836314 -0.453911 0} {0.10699 0.993922 0.0259737 0} {0.448981 -0.071605 0.890672 0} {0 0 0 1}} {{0.158823 0 0 0} {0 0.158823 0 0} {0 0 0.158823 0} {0 0 0 1}} {{1 0 0 0} {0 1 0 0} {0 0 1 0} {0 0 0 1}}}");
  fprintf(file, "%*s\n", 0,"lappend viewplist [molinfo top]");
  fprintf(file, "%*s\n", 0,"set topmol [molinfo top]");
  fprintf(file, "%*s\n", 0,"# done with molecule 1");

// END MOL1
  } // end of if (rep[isSELFAtomic] == "TRUE")

// MOL 1
  else {
  fprintf(file, "%*s%s%s\n", 0,"mol new ", rep[SELFcube].c_str(), " type cube first 0 last -1 step 1 filebonds 1 autobonds 1 waitfor all");
  fprintf(file, "%*s\n", 0,"mol delrep 0 top");
  fprintf(file, "%*s%s%s\n", 0,"mol representation Isosurface ", rep[SELFMAXCOLOR].c_str(), " 0 0 0 1 1");
  fprintf(file, "%*s\n", 0,"mol color ColorID 16");
  fprintf(file, "%*s\n", 0,"mol selection {all}");
  fprintf(file, "%*s\n", 0,"mol material Translucent");
  fprintf(file, "%*s\n", 0,"mol addrep top");
  fprintf(file, "%*s\n", 0,"mol selupdate 0 top 0");
  fprintf(file, "%*s\n", 0,"mol colupdate 0 top 0");
  fprintf(file, "%*s\n", 0,"mol scaleminmax top 0 0.000000 0.000000");
  fprintf(file, "%*s\n", 0,"mol smoothrep top 0 0");
  fprintf(file, "%*s\n", 0,"mol drawframes top 0 {now}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 0 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  0 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 0 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 0 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 1 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  1 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 1 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 1 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 2 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  2 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 2 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 2 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 3 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  3 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 3 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 3 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 4 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  4 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 4 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 4 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 5 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  5 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 5 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 5 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol rename top {SELF}");
  fprintf(file, "%*s\n", 0,"set viewpoints([molinfo top]) {{{1 0 0 2.48353e-08} {0 1 0 -4.96705e-08} {0 0 1 -4.96705e-08} {0 0 0 1}} {{0.847453 0.112594 0.518939 0} {-0.0181391 0.982895 -0.183604 0} {-0.530684 0.146186 0.83496 0} {0 0 0 1}} {{0.36009 0 0 0} {0 0.36009 0 0} {0 0 0.36009 0} {0 0 0 1}} {{1 0 0 0} {0 1 0 0} {0 0 1 0} {0 0 0 1}}}");
  fprintf(file, "%*s\n", 0,"lappend viewplist [molinfo top]");
  fprintf(file, "%*s\n", 0,"set topmol [molinfo top]");
  fprintf(file, "%*s\n", 0,"# done with molecule 1");
// END MOL1

  } // end of else of if (rep[isSELFAtomic] == "TRUE") 

  fprintf(file, "%*s\n", 0,"proc vmdrestoremycolors {} {");
  fprintf(file, "%*s\n", 0,"color scale colors RWB {1.0 0.0 0.0} {1.0 1.0 1.0} {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"color scale colors BWR {0.0 0.0 1.0} {1.0 1.0 1.0} {1.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"color scale colors RGryB {1.0 0.0 0.0} {0.5 0.5 0.5} {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"color scale colors BGryR {0.0 0.0 1.0} {0.5 0.5 0.5} {1.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"color scale colors RGB {1.0 0.0 0.0} {0.0 1.0 0.0} {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"color scale colors BGR {0.0 0.0 1.0} {0.0 1.0 0.0} {1.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"color scale colors RWG {1.0 0.0 0.0} {1.0 1.0 1.0} {0.0 1.0 0.0}");
  fprintf(file, "%*s\n", 0,"color scale colors GWR {0.0 1.0 0.0} {1.0 1.0 1.0} {1.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"color scale colors GWB {0.0 1.0 0.0} {1.0 1.0 1.0} {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"color scale colors BWG {0.0 0.0 1.0} {1.0 1.0 1.0} {0.0 1.0 0.0}");
  fprintf(file, "%*s\n", 0,"color scale colors BlkW {0.0 0.0 0.0} {0.5 0.5 0.5} {1.0 1.0 1.0}");
  fprintf(file, "%*s\n", 0,"color scale colors WBlk {1.0 1.0 1.0} {0.5 0.5 0.5} {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 2,"  color scale method BGR");
  fprintf(file, "%*s\n", 2,"  set colorcmds {");
  fprintf(file, "%*s\n", 4,"    {color Display {Background} white}");
  fprintf(file, "%*s\n", 4,"    {color Display {BackgroundTop} black}");
  fprintf(file, "%*s\n", 4,"    {color Display {BackgroundBot} blue2}");
  fprintf(file, "%*s\n", 4,"    {color Display {FPS} white}");
  fprintf(file, "%*s\n", 4,"    {color Name {LPA} green}");
  fprintf(file, "%*s\n", 4,"    {color Name {LPB} green}");
  fprintf(file, "%*s\n", 4,"    {color Name {F} pink}");
  fprintf(file, "%*s\n", 4,"    {color Type {LP} green}");
  fprintf(file, "%*s\n", 4,"    {color Type {DRUD} pink}");
  fprintf(file, "%*s\n", 4,"    {color Type {F} pink}");
  fprintf(file, "%*s\n", 4,"    {color Element {X} cyan}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ac} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ag} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Al} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Am} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ar} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {As} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {At} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Au} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {B} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ba} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Be} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Bh} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Bi} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Bk} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Br} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ca} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cd} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ce} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cf} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cl} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cm} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Co} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cs} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cu} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Db} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ds} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Dy} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Er} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Es} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Eu} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {F} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Fe} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Fm} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Fr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ga} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Gd} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ge} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {He} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Hf} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Hg} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ho} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Hs} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {I} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {In} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ir} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {K} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Kr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {La} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Li} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Lr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Lu} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Md} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Mg} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Mn} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Mo} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Mt} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Na} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Nb} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Nd} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ne} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ni} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {No} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Np} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Os} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pa} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pb} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pd} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pm} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Po} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pt} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pu} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ra} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Rb} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Re} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Rf} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Rg} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Rh} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Rn} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ru} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Sb} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Sc} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Se} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Sg} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Si} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Sm} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Sn} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Sr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ta} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Tb} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Tc} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Te} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Th} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ti} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Tl} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Tm} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {U} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {V} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {W} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Xe} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Y} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Yb} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Zr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Resname {} silver}");
  fprintf(file, "%*s\n", 4,"    {color Chain {X} blue}");
  fprintf(file, "%*s\n", 4,"    {color Segname {} blue}");
  fprintf(file, "%*s\n", 4,"    {color Conformation {all} blue}");
  fprintf(file, "%*s\n", 4,"    {color Molecule {0} blue}");
  fprintf(file, "%*s\n", 4,"    {color Molecule {dg/rho col. with SELF} blue}");
  fprintf(file, "%*s\n", 4,"    {color Molecule {1} gray}");
  fprintf(file, "%*s\n", 4,"    {color Molecule {Atomiccontrib} red}");
  fprintf(file, "%*s\n", 4,"    {color Molecule {AtomicContrib} red}");
  fprintf(file, "%*s\n", 4,"    {color Structure {3_10_Helix} blue}");
  fprintf(file, "%*s\n", 4,"    {color Surface {Grasp} gray}");
  fprintf(file, "%*s\n", 4,"    {color Labels {Springs} orange}");
  fprintf(file, "%*s\n", 4,"    {color Stage {Even} gray}");
  fprintf(file, "%*s\n", 4,"    {color Stage {Odd} silver}");
  fprintf(file, "%*s\n", 2,"  }");
  fprintf(file, "%*s\n", 2,"  foreach colcmd $colorcmds {");
  fprintf(file, "%*s\n", 4,"    set val [catch {eval $colcmd}]");
  fprintf(file, "%*s\n", 2,"  }");
  fprintf(file, "%*s\n", 2,"  color change rgb 0 0.0 0.0 1.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 2 0.3499999940395355 0.3499999940395355 0.3499999940395355");
  fprintf(file, "%*s\n", 2,"  color change rgb 3 1.0 0.5 0.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 4 1.0 1.0 0.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 5 0.5 0.5 0.20000000298023224");
  fprintf(file, "%*s\n", 2,"  color change rgb 6 0.6000000238418579 0.6000000238418579 0.6000000238418579");
  fprintf(file, "%*s\n", 2,"  color change rgb 7 0.0 1.0 0.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 9 1.0 0.6000000238418579 0.6000000238418579");
  fprintf(file, "%*s\n", 2,"  color change rgb 11 0.6499999761581421 0.0 0.6499999761581421");
  fprintf(file, "%*s\n", 2,"  color change rgb 12 0.5 0.8999999761581421 0.4000000059604645");
  fprintf(file, "%*s\n", 2,"  color change rgb 13 0.8999999761581421 0.4000000059604645 0.699999988079071");
  fprintf(file, "%*s\n", 2,"  color change rgb 14 0.5 0.30000001192092896 0.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 15 0.5 0.5 0.75");
  fprintf(file, "%*s\n", 2,"  color change rgb 17 0.8799999952316284 0.9700000286102295 0.019999999552965164");
  fprintf(file, "%*s\n", 2,"  color change rgb 18 0.550000011920929 0.8999999761581421 0.019999999552965164");
  fprintf(file, "%*s\n", 2,"  color change rgb 19 0.0 0.8999999761581421 0.03999999910593033");
  fprintf(file, "%*s\n", 2,"  color change rgb 20 0.0 0.8999999761581421 0.5");
  fprintf(file, "%*s\n", 2,"  color change rgb 21 0.0 0.8799999952316284 1.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 22 0.0 0.7599999904632568 1.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 23 0.019999999552965164 0.3799999952316284 0.6700000166893005");
  fprintf(file, "%*s\n", 2,"  color change rgb 24 0.009999999776482582 0.03999999910593033 0.9300000071525574");
  fprintf(file, "%*s\n", 2,"  color change rgb 25 0.27000001072883606 0.0 0.9800000190734863");
  fprintf(file, "%*s\n", 2,"  color change rgb 26 0.44999998807907104 0.0 0.8999999761581421");
  fprintf(file, "%*s\n", 2,"  color change rgb 27 0.8999999761581421 0.0 0.8999999761581421");
  fprintf(file, "%*s\n", 2,"  color change rgb 28 1.0 0.0 0.6600000262260437");
  fprintf(file, "%*s\n", 2,"  color change rgb 29 0.9800000190734863 0.0 0.23000000417232513");
  fprintf(file, "%*s\n", 2,"  color change rgb 30 0.8100000023841858 0.0 0.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 31 0.8899999856948853 0.3499999940395355 0.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 32 0.9599999785423279 0.7200000286102295 0.0");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"vmdrestoremycolors");
  fprintf(file, "%*s\n", 0,"label textsize 1.0");
  fprintf(file, "%*s\n", 0,"");

if (rep[isSELFAtomic] == "TRUE") {
// read CHARGES to color atoms according to their PAULI contribution
  fprintf(file, "%*s\n", 0,"# set atomic colormap according to atom contributions to the inter deltag value");
  fprintf(file, "%*s%s%s\n", 0,"set charge_file [open ",  rep[SELFATOMDAT].c_str(), "]");
  fprintf(file, "%*s\n", 0,"set num_of_atoms [molinfo 1 get numatoms]");
  fprintf(file, "%*s\n", 0,"# skip header-line");
  fprintf(file, "%*s\n", 0,"gets $charge_file line");
  fprintf(file, "%*s\n", 0,"# read one line per atom");
  fprintf(file, "%*s\n", 0,"for {set i 0} { $i < $num_of_atoms } { incr i } {");
  fprintf(file, "%*s\n", 2,"  # read currentline");
  fprintf(file, "%*s\n", 2,"  gets $charge_file line");
  fprintf(file, "%*s\n", 2,"  # suppress extra whitespace and extract column 3");
  fprintf(file, "%*s\n", 2,"  set atomContrib [lindex [join $line " "] 2]");
  fprintf(file, "%*s\n", 2,"  # create atom selection with current atom");
  fprintf(file, "%*s\n", 2,"  set sel [atomselect 1 \"index == $i\"]");
  fprintf(file, "%*s\n", 2,"  # set the color of the current atom according to its contrib to intermolecular interactions");
  fprintf(file, "%*s\n", 2,"  $sel set charge $atomContrib");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"");

// label every atom
  fprintf(file, "%*s\n", 0,"# label every atom");
  fprintf(file, "%*s\n", 0,"label textsize 1.0");
  fprintf(file, "%*s\n", 1," set selection \"not name X\"");
  fprintf(file, "%*s\n", 1," set sel [atomselect 1  $selection]");
  fprintf(file, "%*s\n", 1," foreach q [$sel get name] pos [$sel get {x y z}] {");
  fprintf(file, "%*s\n", 1," set qstr [format %s $q]");
  fprintf(file, "%*s\n", 1," set xpos [lindex $pos 0]");
  fprintf(file, "%*s\n", 1," set ypos [lindex $pos 1]");
  fprintf(file, "%*s\n", 1," set zpos [lindex $pos 2]");
  fprintf(file, "%*s\n", 1," set newx [expr $xpos -0.13]");
  fprintf(file, "%*s\n", 1," set newy [expr $ypos +0.05]");
  fprintf(file, "%*s\n", 1," set newz [expr $zpos +0.0]");
  fprintf(file, "%*s\n", 1," set newpos {}");
  fprintf(file, "%*s\n", 1," lappend newpos $newx $newy $newz");
  fprintf(file, "%*s\n", 1," graphics 1 color 16");
  fprintf(file, "%*s\n", 1," graphics 1 text $newpos $qstr size 1 thickness 2.0");
  fprintf(file, "%*s\n", 0,"}");
} // end of if (rep[isSELFAtomic]
else {
    fprintf(file, "%*s\n", 1," mol on 0"); // to activate the only existing molecule 0 in that case
    fprintf(file, "%*s\n", 1," mol off 1 "); // default is to disable PAULI iso-surface
     }
  fprintf(file, "%*s\n", 0,"");
  fprintf(file, "%*s\n", 0,"# Customization");
  fprintf(file, "%*s\n", 0,"axes location Off");
  fprintf(file, "%*s\n", 0,"display rendermode GLSL");
  fprintf(file, "%*s\n", 0,"display depthcue off");
  fclose(file);
} // end of  generateVMDPAULIFile(const std::string *rep)


// ================   generateVMDAtomDOIFile          
void generateVMDAtomDOIFile(const std::string *rep) //QM Mode
{
  FILE* file=fopen("weakAtomContrib.vmd","w");
  fprintf(file, "%*s\n", 0,"#");
  fprintf(file, "%*s\n", 0,"##Copyright University of Reims Champagne-Ardenne");
  fprintf(file, "%*s\n", 0,"#Authors and Contributors: Akilan RAJAMANI, Corentin LEFEBVRE, Johanna KLEIN, Emmanuel PLUOT, Gaetan RUBEZ, Hassan Khartabil, Jean-Charles-BOISSON and Eric HENON");
  fprintf(file, "%*s\n", 0,"#Contributors: Hassan Khartabil, Miguel Ponce-Vargas, Julia Contreras-Garcia");
  fprintf(file, "%*s\n", 0,"##(24/07/2017)");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"##jean-charles.boisson@univ-reims.fr, eric.henon@univ-reims.fr");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"##This software is a computer program whose purpose is to ");
  fprintf(file, "%*s\n", 0,"##detect and prepare the plot of molecular interactions");
  fprintf(file, "%*s\n", 0,"##from electron density and IGM reference using promolecular");
  fprintf(file, "%*s\n", 0,"##electron density.");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"##This software is governed by the CeCILL-C license under French law and");
  fprintf(file, "%*s\n", 0,"##abiding by the rules of distribution of free software.  You can  use, ");
  fprintf(file, "%*s\n", 0,"##modify and/ or redistribute the software under the terms of the CeCILL-C");
  fprintf(file, "%*s\n", 0,"##license as circulated by CEA, CNRS and INRIA at the following URL");
  fprintf(file, "%*s\n", 0,"##\"http://www.cecill.info\". ");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"##As a counterpart to the access to the source code and  rights to copy,");
  fprintf(file, "%*s\n", 0,"##modify and redistribute granted by the license, users are provided only");
  fprintf(file, "%*s\n", 0,"##with a limited warranty  and the software\'s author,  the holder of the");
  fprintf(file, "%*s\n", 0,"##economic rights,  and the successive licensors  have only  limited");
  fprintf(file, "%*s\n", 0,"##liability. ");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"##In this respect, the user\'s attention is drawn to the risks associated");
  fprintf(file, "%*s\n", 0,"##with loading,  using,  modifying and/or developing or reproducing the");
  fprintf(file, "%*s\n", 0,"##software by the user in light of its specific status of free software,");
  fprintf(file, "%*s\n", 0,"##that may mean  that it is complicated to manipulate,  and  that  also");
  fprintf(file, "%*s\n", 0,"##therefore means  that it is reserved for developers  and  experienced");
  fprintf(file, "%*s\n", 0,"##professionals having in-depth computer knowledge. Users are therefore");
  fprintf(file, "%*s\n", 0,"##encouraged to load and test the software\'s suitability as regards their");
  fprintf(file, "%*s\n", 0,"##requirements in conditions enabling the security of their systems and/or ");
  fprintf(file, "%*s\n", 0,"##data to be ensured and,  more generally, to use and operate it in the ");
  fprintf(file, "%*s\n", 0,"##same conditions as regards security. ");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"##The fact that you are presently reading this means that you have had");
  fprintf(file, "%*s\n", 0,"##knowledge of the CeCILL-C license and that you accept its terms.");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"#");
  fprintf(file, "%*s\n", 0,"#");

  fprintf(file, "%*s\n", 0,"#!/usr/local/bin/vmd");
  fprintf(file, "%*s\n", 0,"# VMD script written by save_state $Revision: 1.47 $");
  fprintf(file, "%*s\n", 0,"# VMD version: 1.9.3");
  fprintf(file, "%*s\n", 0,"set viewplist {}");
  fprintf(file, "%*s\n", 0,"set fixedlist {}");
  fprintf(file, "%*s\n", 0,"proc vmdrestoremymaterials {} {");
  fprintf(file, "%*s\n", 2,"  set mlist { Opaque Transparent BrushedMetal Diffuse Ghost Glass1 Glass2 Glass3 Glossy HardPlastic MetallicPastel Steel Translucent Edgy EdgyShiny EdgyGlass Goodsell AOShiny AOChalky AOEdgy BlownGlass GlassBubble RTChrome }");
  fprintf(file, "%*s\n", 2,"  set mymlist [material list]");
  fprintf(file, "%*s\n", 2,"  foreach mat $mlist {");
  fprintf(file, "%*s\n", 4,"    if { [lsearch $mymlist $mat] == -1 } { ");
  fprintf(file, "%*s\n", 6,"      material add $mat");
  fprintf(file, "%*s\n", 4,"    }");
  fprintf(file, "%*s\n", 2,"  }");
  fprintf(file, "%*s\n", 2,"  material change ambient Opaque 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Opaque 0.650000");
  fprintf(file, "%*s\n", 2,"  material change specular Opaque 0.500000");
  fprintf(file, "%*s\n", 2,"  material change shininess Opaque 0.534020");
  fprintf(file, "%*s\n", 2,"  material change mirror Opaque 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Opaque 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline Opaque 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Opaque 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Opaque 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Transparent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Transparent 0.650000");
  fprintf(file, "%*s\n", 2,"  material change specular Transparent 0.500000");
  fprintf(file, "%*s\n", 2,"  material change shininess Transparent 0.534020");
  fprintf(file, "%*s\n", 2,"  material change mirror Transparent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Transparent 0.300000");
  fprintf(file, "%*s\n", 2,"  material change outline Transparent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Transparent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Transparent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient BrushedMetal 0.080000");
  fprintf(file, "%*s\n", 2,"  material change diffuse BrushedMetal 0.390000");
  fprintf(file, "%*s\n", 2,"  material change specular BrushedMetal 0.340000");
  fprintf(file, "%*s\n", 2,"  material change shininess BrushedMetal 0.150000");
  fprintf(file, "%*s\n", 2,"  material change mirror BrushedMetal 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity BrushedMetal 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline BrushedMetal 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth BrushedMetal 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode BrushedMetal 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Diffuse 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Diffuse 0.620000");
  fprintf(file, "%*s\n", 2,"  material change specular Diffuse 0.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess Diffuse 0.530000");
  fprintf(file, "%*s\n", 2,"  material change mirror Diffuse 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Diffuse 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline Diffuse 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Diffuse 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Diffuse 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Ghost 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Ghost 0.000000");
  fprintf(file, "%*s\n", 2,"  material change specular Ghost 1.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess Ghost 0.230000");
  fprintf(file, "%*s\n", 2,"  material change mirror Ghost 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Ghost 0.100000");
  fprintf(file, "%*s\n", 2,"  material change outline Ghost 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Ghost 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Ghost 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Glass1 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Glass1 0.500000");
  fprintf(file, "%*s\n", 2,"  material change specular Glass1 0.650000");
  fprintf(file, "%*s\n", 2,"  material change shininess Glass1 0.530000");
  fprintf(file, "%*s\n", 2,"  material change mirror Glass1 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Glass1 0.150000");
  fprintf(file, "%*s\n", 2,"  material change outline Glass1 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Glass1 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Glass1 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Glass2 0.520000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Glass2 0.760000");
  fprintf(file, "%*s\n", 2,"  material change specular Glass2 0.220000");
  fprintf(file, "%*s\n", 2,"  material change shininess Glass2 0.590000");
  fprintf(file, "%*s\n", 2,"  material change mirror Glass2 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Glass2 0.680000");
  fprintf(file, "%*s\n", 2,"  material change outline Glass2 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Glass2 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Glass2 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Glass3 0.150000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Glass3 0.250000");
  fprintf(file, "%*s\n", 2,"  material change specular Glass3 0.750000");
  fprintf(file, "%*s\n", 2,"  material change shininess Glass3 0.800000");
  fprintf(file, "%*s\n", 2,"  material change mirror Glass3 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Glass3 0.500000");
  fprintf(file, "%*s\n", 2,"  material change outline Glass3 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Glass3 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Glass3 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Glossy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Glossy 0.650000");
  fprintf(file, "%*s\n", 2,"  material change specular Glossy 1.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess Glossy 0.880000");
  fprintf(file, "%*s\n", 2,"  material change mirror Glossy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Glossy 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline Glossy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Glossy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Glossy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient HardPlastic 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse HardPlastic 0.560000");
  fprintf(file, "%*s\n", 2,"  material change specular HardPlastic 0.280000");
  fprintf(file, "%*s\n", 2,"  material change shininess HardPlastic 0.690000");
  fprintf(file, "%*s\n", 2,"  material change mirror HardPlastic 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity HardPlastic 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline HardPlastic 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth HardPlastic 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode HardPlastic 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient MetallicPastel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse MetallicPastel 0.260000");
  fprintf(file, "%*s\n", 2,"  material change specular MetallicPastel 0.550000");
  fprintf(file, "%*s\n", 2,"  material change shininess MetallicPastel 0.190000");
  fprintf(file, "%*s\n", 2,"  material change mirror MetallicPastel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity MetallicPastel 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline MetallicPastel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth MetallicPastel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode MetallicPastel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Steel 0.250000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Steel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change specular Steel 0.380000");
  fprintf(file, "%*s\n", 2,"  material change shininess Steel 0.320000");
  fprintf(file, "%*s\n", 2,"  material change mirror Steel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Steel 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline Steel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Steel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Steel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Translucent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Translucent 0.700000");
  fprintf(file, "%*s\n", 2,"  material change specular Translucent 0.600000");
  fprintf(file, "%*s\n", 2,"  material change shininess Translucent 0.300000");
  fprintf(file, "%*s\n", 2,"  material change mirror Translucent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Translucent 0.800000");
  fprintf(file, "%*s\n", 2,"  material change outline Translucent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Translucent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Translucent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Edgy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Edgy 0.660000");
  fprintf(file, "%*s\n", 2,"  material change specular Edgy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess Edgy 0.750000");
  fprintf(file, "%*s\n", 2,"  material change mirror Edgy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Edgy 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline Edgy 0.620000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Edgy 0.940000");
  fprintf(file, "%*s\n", 2,"  material change transmode Edgy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient EdgyShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse EdgyShiny 0.660000");
  fprintf(file, "%*s\n", 2,"  material change specular EdgyShiny 0.960000");
  fprintf(file, "%*s\n", 2,"  material change shininess EdgyShiny 0.750000");
  fprintf(file, "%*s\n", 2,"  material change mirror EdgyShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity EdgyShiny 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline EdgyShiny 0.760000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth EdgyShiny 0.940000");
  fprintf(file, "%*s\n", 2,"  material change transmode EdgyShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient EdgyGlass 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse EdgyGlass 0.660000");
  fprintf(file, "%*s\n", 2,"  material change specular EdgyGlass 0.500000");
  fprintf(file, "%*s\n", 2,"  material change shininess EdgyGlass 0.750000");
  fprintf(file, "%*s\n", 2,"  material change mirror EdgyGlass 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity EdgyGlass 0.620000");
  fprintf(file, "%*s\n", 2,"  material change outline EdgyGlass 0.620000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth EdgyGlass 0.940000");
  fprintf(file, "%*s\n", 2,"  material change transmode EdgyGlass 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Goodsell 0.520000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Goodsell 1.000000");
  fprintf(file, "%*s\n", 2,"  material change specular Goodsell 0.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess Goodsell 0.000000");
  fprintf(file, "%*s\n", 2,"  material change mirror Goodsell 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Goodsell 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline Goodsell 4.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Goodsell 0.900000");
  fprintf(file, "%*s\n", 2,"  material change transmode Goodsell 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient AOShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse AOShiny 0.850000");
  fprintf(file, "%*s\n", 2,"  material change specular AOShiny 0.200000");
  fprintf(file, "%*s\n", 2,"  material change shininess AOShiny 0.530000");
  fprintf(file, "%*s\n", 2,"  material change mirror AOShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity AOShiny 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline AOShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth AOShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode AOShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient AOChalky 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse AOChalky 0.850000");
  fprintf(file, "%*s\n", 2,"  material change specular AOChalky 0.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess AOChalky 0.530000");
  fprintf(file, "%*s\n", 2,"  material change mirror AOChalky 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity AOChalky 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline AOChalky 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth AOChalky 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode AOChalky 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient AOEdgy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse AOEdgy 0.900000");
  fprintf(file, "%*s\n", 2,"  material change specular AOEdgy 0.200000");
  fprintf(file, "%*s\n", 2,"  material change shininess AOEdgy 0.530000");
  fprintf(file, "%*s\n", 2,"  material change mirror AOEdgy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity AOEdgy 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline AOEdgy 0.620000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth AOEdgy 0.930000");
  fprintf(file, "%*s\n", 2,"  material change transmode AOEdgy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient BlownGlass 0.040000");
  fprintf(file, "%*s\n", 2,"  material change diffuse BlownGlass 0.340000");
  fprintf(file, "%*s\n", 2,"  material change specular BlownGlass 1.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess BlownGlass 1.000000");
  fprintf(file, "%*s\n", 2,"  material change mirror BlownGlass 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity BlownGlass 0.100000");
  fprintf(file, "%*s\n", 2,"  material change outline BlownGlass 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth BlownGlass 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode BlownGlass 1.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient GlassBubble 0.250000");
  fprintf(file, "%*s\n", 2,"  material change diffuse GlassBubble 0.340000");
  fprintf(file, "%*s\n", 2,"  material change specular GlassBubble 1.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess GlassBubble 1.000000");
  fprintf(file, "%*s\n", 2,"  material change mirror GlassBubble 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity GlassBubble 0.040000");
  fprintf(file, "%*s\n", 2,"  material change outline GlassBubble 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth GlassBubble 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode GlassBubble 1.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient RTChrome 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse RTChrome 0.650000");
  fprintf(file, "%*s\n", 2,"  material change specular RTChrome 0.500000");
  fprintf(file, "%*s\n", 2,"  material change shininess RTChrome 0.530000");
  fprintf(file, "%*s\n", 2,"  material change mirror RTChrome 0.700000");
  fprintf(file, "%*s\n", 2,"  material change opacity RTChrome 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline RTChrome 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth RTChrome 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode RTChrome 0.000000");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"vmdrestoremymaterials");
  fprintf(file, "%*s\n", 0,"# Atom selection macros");
  fprintf(file, "%*s\n", 0,"atomselect macro at {resname ADE A THY T");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro acidic {resname ASP GLU");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro cyclic {resname HIS PHE PRO TRP TYR");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro acyclic {protein and not cyclic");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro aliphatic {resname ALA GLY ILE LEU VAL");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro alpha {protein and name CA");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro amino {protein");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro aromatic {resname HIS PHE TRP TYR");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro basic {resname ARG HIS LYS HSP");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro bonded {numbonds > 0");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro buried {resname ALA LEU VAL ILE PHE CYS MET TRP");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro cg {resname CYT C GUA G");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro charged {basic or acidic");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro hetero {not (protein or nucleic)");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro hydrophobic {resname ALA LEU VAL ILE PRO PHE MET TRP");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro small {resname ALA GLY SER");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro medium {resname VAL THR ASP ASN PRO CYS ASX PCA HYP");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro large {protein and not (small or medium)");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro neutral {resname VAL PHE GLN TYR HIS CYS MET TRP ASX GLX PCA HYP");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro polar {protein and not hydrophobic");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro purine {resname ADE A GUA G");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro pyrimidine {resname CYT C THY T URA U");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro surface {protein and not buried");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro lipid {resname DLPE DMPC DPPC GPC LPPC PALM PC PGCL POPC POPE");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro lipids {lipid");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro ion {resname AL BA CA CAL CD CES CLA CL CO CS CU CU1 CUA HG IN IOD K LIT MG MN3 MO3 MO4 MO5 MO6 NA NAW OC7 PB POT PT RB SOD TB TL WO4 YB ZN ZN1 ZN2");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro ions {ion");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro sugar {resname AGLC");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro solvent {not (protein or sugar or nucleic or lipid)");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro glycan {resname NAG BGLN FUC AFUC MAN AMAN BMA BMAN");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro carbon {name \"C.*\" and not ion");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro hydrogen {name \"[0-9]?H.*\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro nitrogen {name \"N.*\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro oxygen {name \"O.*\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro sulfur {name \"S.*\" and not ion");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro noh {not hydrogen");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro heme {resname HEM HEME");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationall {altloc \"\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationA {altloc \"\" or altloc \"A\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationB {altloc \"\" or altloc \"B\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationC {altloc \"\" or altloc \"C\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationD {altloc \"\" or altloc \"D\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationE {altloc \"\" or altloc \"E\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationF {altloc \"\" or altloc \"F\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro drude {type DRUD or type LP");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro unparametrized beta<1");
  fprintf(file, "%*s\n", 0,"atomselect macro addedmolefacture {occupancy 0.8}");
  fprintf(file, "%*s\n", 0,"atomselect macro qwikmd_protein {(not name QWIKMDDELETE and protein)}");
  fprintf(file, "%*s\n", 0,"atomselect macro qwikmd_nucleic {(not name QWIKMDDELETE and nucleic)}");
  fprintf(file, "%*s\n", 0,"atomselect macro qwikmd_glycan {(not name QWIKMDDELETE and glycan)}");
  fprintf(file, "%*s\n", 0,"atomselect macro qwikmd_lipid {(not name QWIKMDDELETE and lipid)}");
  fprintf(file, "%*s\n", 0,"atomselect macro qwikmd_hetero {(not name QWIKMDDELETE and hetero and not qwikmd_protein and not qwikmd_lipid and not qwikmd_nucleic and not qwikmd_glycan and not water)}");
  fprintf(file, "%*s\n", 0,"# Display settings");
  fprintf(file, "%*s\n", 0,"display eyesep       0.065000");
  fprintf(file, "%*s\n", 0,"display focallength  2.000000");
  fprintf(file, "%*s\n", 0,"display height       6.000000");
  fprintf(file, "%*s\n", 0,"display distance     -2.000000");
  fprintf(file, "%*s\n", 0,"display projection   Perspective");
  fprintf(file, "%*s\n", 0,"display nearclip set 0.500000");
  fprintf(file, "%*s\n", 0,"display farclip  set 10.000000");
  fprintf(file, "%*s\n", 0,"display depthcue   off");
  fprintf(file, "%*s\n", 0,"display cuestart   0.500000");
  fprintf(file, "%*s\n", 0,"display cueend     10.000000");
  fprintf(file, "%*s\n", 0,"display cuestart   0.500000");
  fprintf(file, "%*s\n", 0,"display cueend     10.000000");
  fprintf(file, "%*s\n", 0,"display cuedensity 0.320000");
  fprintf(file, "%*s\n", 0,"display cuemode    Exp2");
  fprintf(file, "%*s\n", 0,"display shadows off");
  fprintf(file, "%*s\n", 0,"display ambientocclusion off");
  fprintf(file, "%*s\n", 0,"display aoambient 0.800000");
  fprintf(file, "%*s\n", 0,"display aodirect 0.300000");
  fprintf(file, "%*s\n", 0,"display dof off");
  fprintf(file, "%*s\n", 0,"display dof_fnumber 64.000000");
  fprintf(file, "%*s\n", 0,"display dof_focaldist 0.700000");
  fprintf(file, "%*s%s%s\n", 1, "mol new ", rep[XYZ].c_str(), " type xyz first 0 last -1 step 1 filebonds 1 autobonds 1 waitfor all");
  fprintf(file, "%*s\n", 0,"mol delrep 0 top");
  fprintf(file, "%*s\n", 0,"mol representation CPK 1.000000 0.300000 12.000000 12.000000");
  fprintf(file, "%*s\n", 0,"mol color Charge");
  fprintf(file, "%*s\n", 0,"mol selection {all}");
  fprintf(file, "%*s\n", 0,"mol material Opaque");
  fprintf(file, "%*s\n", 0,"mol addrep top");
  fprintf(file, "%*s\n", 0,"mol selupdate 0 top 0");
  fprintf(file, "%*s\n", 0,"mol colupdate 0 top 0");
  fprintf(file, "%*s%s\n", 0,"mol scaleminmax top 0 0.000000 ", rep[DGATWEAKMAX].c_str());
  fprintf(file, "%*s\n", 0,"mol smoothrep top 0 0");
  fprintf(file, "%*s\n", 0,"mol drawframes top 0 {now}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 0 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  0 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 0 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 0 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 1 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  1 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 1 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 1 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 2 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  2 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 2 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 2 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 3 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  3 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 3 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 3 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 4 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  4 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 4 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 4 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 5 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  5 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 5 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 5 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol representation CPK 1.000000 0.300000 12.000000 12.000000");
  fprintf(file, "%*s\n", 0,"mol color Name");
  fprintf(file, "%*s\n", 0,"mol selection {all}");
  fprintf(file, "%*s\n", 0,"mol material Opaque");
  fprintf(file, "%*s\n", 0,"mol addrep top");
  fprintf(file, "%*s\n", 0,"mol selupdate 1 top 0");
  fprintf(file, "%*s\n", 0,"mol colupdate 1 top 0");
  fprintf(file, "%*s\n", 0,"mol scaleminmax top 1 0.000000 0.000000");
  fprintf(file, "%*s\n", 0,"mol smoothrep top 1 0");
  fprintf(file, "%*s\n", 0,"mol drawframes top 1 {now}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 0 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  0 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 0 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 0 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 1 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  1 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 1 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 1 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 2 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  2 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 2 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 2 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 3 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  3 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 3 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 3 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 4 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  4 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 4 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 4 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 5 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  5 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 5 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 5 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol showrep top 1 0");
  fprintf(file, "%*s\n", 0,"mol rename top coord.xyz");
  fprintf(file, "%*s\n", 0,"set viewpoints([molinfo top]) {{{1 0 0 0.0524956} {0 1 0 0.169785} {0 0 1 -0.00447658} {0 0 0 1}} {{0.533237 0.589075 -0.607192 0} {-0.619337 0.760771 0.194167 0} {0.576314 0.272514 0.770501 0} {0 0 0 1}} {{0.216958 0 0 0} {0 0.216958 0 0} {0 0 0.216958 0} {0 0 0 1}} {{1 0 0 0} {0 1 0 0} {0 0 1 0} {0 0 0 1}}}");
  fprintf(file, "%*s\n", 0,"lappend viewplist [molinfo top]");
  fprintf(file, "%*s\n", 0,"set topmol [molinfo top]");
  fprintf(file, "%*s\n", 0,"# done with molecule 0");
  fprintf(file, "%*s\n", 0,"foreach v $viewplist {");
  fprintf(file, "%*s\n", 2,"  molinfo $v set {center_matrix rotate_matrix scale_matrix global_matrix} $viewpoints($v)");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"foreach v $fixedlist {");
  fprintf(file, "%*s\n", 2,"  molinfo $v set fixed 1");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"unset viewplist");
  fprintf(file, "%*s\n", 0,"unset fixedlist");
  fprintf(file, "%*s\n", 0,"mol top $topmol");
  fprintf(file, "%*s\n", 0,"unset topmol");
  fprintf(file, "%*s\n", 0,"proc vmdrestoremycolors {} {");
  fprintf(file, "%*s\n", 0,"color scale colors RWB {1.0 0.0 0.0} {1.0 1.0 1.0} {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"color scale colors BWR {0.0 0.0 1.0} {1.0 1.0 1.0} {1.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"color scale colors RGryB {1.0 0.0 0.0} {0.5 0.5 0.5} {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"color scale colors BGryR {0.0 0.0 1.0} {0.5 0.5 0.5} {1.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"color scale colors RGB {1.0 0.0 0.0} {0.0 1.0 0.0} {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"color scale colors BGR {0.0 0.0 1.0} {0.0 1.0 0.0} {1.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"color scale colors RWG {1.0 0.0 0.0} {1.0 1.0 1.0} {0.0 1.0 0.0}");
  fprintf(file, "%*s\n", 0,"color scale colors GWR {0.0 1.0 0.0} {1.0 1.0 1.0} {1.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"color scale colors GWB {0.0 1.0 0.0} {1.0 1.0 1.0} {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"color scale colors BWG {0.0 0.0 1.0} {1.0 1.0 1.0} {0.0 1.0 0.0}");
  fprintf(file, "%*s\n", 0,"color scale colors BlkW {0.0 0.0 0.0} {0.5 0.5 0.5} {1.0 1.0 1.0}");
  fprintf(file, "%*s\n", 0,"color scale colors WBlk {1.0 1.0 1.0} {0.5 0.5 0.5} {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 2,"  color scale method BGR");
  fprintf(file, "%*s\n", 2,"  set colorcmds {");
  fprintf(file, "%*s\n", 4,"    {color Display {Background} silver}");
  fprintf(file, "%*s\n", 4,"    {color Display {BackgroundTop} black}");
  fprintf(file, "%*s\n", 4,"    {color Display {BackgroundBot} blue2}");
  fprintf(file, "%*s\n", 4,"    {color Display {FPS} white}");
  fprintf(file, "%*s\n", 4,"    {color Name {LPA} green}");
  fprintf(file, "%*s\n", 4,"    {color Name {LPB} green}");
  fprintf(file, "%*s\n", 4,"    {color Type {LP} green}");
  fprintf(file, "%*s\n", 4,"    {color Type {DRUD} pink}");
  fprintf(file, "%*s\n", 4,"    {color Element {X} cyan}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ac} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ag} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Al} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Am} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ar} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {As} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {At} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Au} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {B} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ba} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Be} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Bh} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Bi} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Bk} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Br} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ca} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cd} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ce} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cf} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cl} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cm} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Co} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cs} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cu} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Db} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ds} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Dy} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Er} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Es} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Eu} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {F} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Fe} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Fm} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Fr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ga} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Gd} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ge} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {He} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Hf} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Hg} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ho} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Hs} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {I} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {In} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ir} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {K} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Kr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {La} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Li} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Lr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Lu} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Md} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Mg} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Mn} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Mo} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Mt} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Na} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Nb} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Nd} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ne} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ni} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {No} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Np} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Os} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pa} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pb} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pd} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pm} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Po} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pt} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pu} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ra} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Rb} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Re} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Rf} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Rg} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Rh} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Rn} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ru} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Sb} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Sc} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Se} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Sg} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Si} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Sm} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Sn} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Sr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ta} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Tb} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Tc} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Te} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Th} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ti} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Tl} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Tm} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {U} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {V} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {W} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Xe} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Y} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Yb} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Zr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Resname {} silver}");
  fprintf(file, "%*s\n", 4,"    {color Chain {X} blue}");
  fprintf(file, "%*s\n", 4,"    {color Segname {} blue}");
  fprintf(file, "%*s\n", 4,"    {color Conformation {all} blue}");
  fprintf(file, "%*s\n", 4,"    {color Molecule {0} blue}");
  fprintf(file, "%*s\n", 4,"    {color Molecule {coord.xyz} blue}");
  fprintf(file, "%*s\n", 4,"    {color Structure {3_10_Helix} blue}");
  fprintf(file, "%*s\n", 4,"    {color Surface {Grasp} gray}");
  fprintf(file, "%*s\n", 4,"    {color Labels {Springs} orange}");
  fprintf(file, "%*s\n", 4,"    {color Stage {Even} gray}");
  fprintf(file, "%*s\n", 4,"    {color Stage {Odd} silver}");
  fprintf(file, "%*s\n", 2,"  }");
  fprintf(file, "%*s\n", 2,"  foreach colcmd $colorcmds {");
  fprintf(file, "%*s\n", 4,"    set val [catch {eval $colcmd}]");
  fprintf(file, "%*s\n", 2,"  }");
  fprintf(file, "%*s\n", 2,"  color change rgb 0 0.0 0.0 1.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 2 0.3499999940395355 0.3499999940395355 0.3499999940395355");
  fprintf(file, "%*s\n", 2,"  color change rgb 3 1.0 0.5 0.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 4 1.0 1.0 0.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 5 0.5 0.5 0.20000000298023224");
  fprintf(file, "%*s\n", 2,"  color change rgb 6 0.6000000238418579 0.6000000238418579 0.6000000238418579");
  fprintf(file, "%*s\n", 2,"  color change rgb 7 0.0 1.0 0.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 9 1.0 0.6000000238418579 0.6000000238418579");
  fprintf(file, "%*s\n", 2,"  color change rgb 11 0.6499999761581421 0.0 0.6499999761581421");
  fprintf(file, "%*s\n", 2,"  color change rgb 12 0.5 0.8999999761581421 0.4000000059604645");
  fprintf(file, "%*s\n", 2,"  color change rgb 13 0.8999999761581421 0.4000000059604645 0.699999988079071");
  fprintf(file, "%*s\n", 2,"  color change rgb 14 0.5 0.30000001192092896 0.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 15 0.5 0.5 0.75");
  fprintf(file, "%*s\n", 2,"  color change rgb 17 0.8799999952316284 0.9700000286102295 0.019999999552965164");
  fprintf(file, "%*s\n", 2,"  color change rgb 18 0.550000011920929 0.8999999761581421 0.019999999552965164");
  fprintf(file, "%*s\n", 2,"  color change rgb 19 0.0 0.8999999761581421 0.03999999910593033");
  fprintf(file, "%*s\n", 2,"  color change rgb 20 0.0 0.8999999761581421 0.5");
  fprintf(file, "%*s\n", 2,"  color change rgb 21 0.0 0.8799999952316284 1.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 22 0.0 0.7599999904632568 1.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 23 0.019999999552965164 0.3799999952316284 0.6700000166893005");
  fprintf(file, "%*s\n", 2,"  color change rgb 24 0.009999999776482582 0.03999999910593033 0.9300000071525574");
  fprintf(file, "%*s\n", 2,"  color change rgb 25 0.27000001072883606 0.0 0.9800000190734863");
  fprintf(file, "%*s\n", 2,"  color change rgb 26 0.44999998807907104 0.0 0.8999999761581421");
  fprintf(file, "%*s\n", 2,"  color change rgb 27 0.8999999761581421 0.0 0.8999999761581421");
  fprintf(file, "%*s\n", 2,"  color change rgb 28 1.0 0.0 0.6600000262260437");
  fprintf(file, "%*s\n", 2,"  color change rgb 29 0.9800000190734863 0.0 0.23000000417232513");
  fprintf(file, "%*s\n", 2,"  color change rgb 30 0.8100000023841858 0.0 0.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 31 0.8899999856948853 0.3499999940395355 0.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 32 0.9599999785423279 0.7200000286102295 0.0");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"vmdrestoremycolors");
  fprintf(file, "%*s\n", 0,"label textsize 1.0");
  fprintf(file, "%*s\n", 0,"# set colormap according to atom contributions to non-covalent contacts");
  fprintf(file, "%*s%s%s\n", 0, "set charge_file [open ", rep[ATOMDOIDAT].c_str(), "]");
  fprintf(file, "%*s\n", 0,"set num_of_atoms [molinfo 0 get numatoms]");
  fprintf(file, "%*s\n", 0,"# skip header-line");
  fprintf(file, "%*s\n", 0,"gets $charge_file line");
  fprintf(file, "%*s\n", 0,"# read one line per atom");
  fprintf(file, "%*s\n", 0,"for {set i 0} { $i < $num_of_atoms } { incr i } {");
  fprintf(file, "%*s\n", 2,"  # read currentline");
  fprintf(file, "%*s\n", 2,"  gets $charge_file line");
  fprintf(file, "%*s\n", 2,"  # suppress extra whitespace and extract column 3");
  fprintf(file, "%*s\n", 2,"  set atomContrib [lindex [join $line \" \"] 2]");
  fprintf(file, "%*s\n", 2,"  # create atom selection with current atom");
  fprintf(file, "%*s\n", 2,"  set sel [atomselect 0 \"index == $i\"]");
  fprintf(file, "%*s\n", 2,"  # set the color of the current atom according to its contrib to weak inter");
  fprintf(file, "%*s\n", 2,"  $sel set charge $atomContrib");
  fprintf(file, "%*s\n", 2,"  # create a new representation for the current atom");
  fprintf(file, "%*s\n", 0,"# mol representation CPK 1.400000 0.300000 12.000000 12.000000");
  fprintf(file, "%*s\n", 0,"# mol selection index 0");
  fprintf(file, "%*s\n", 0,"# mol material Opaque");
  fprintf(file, "%*s\n", 0,"# mol addrep 0");
  fprintf(file, "%*s\n", 2,"  # select current atom in representation i-newly created and in current mol selection 0");
  fprintf(file, "%*s\n", 0,"# set currentRepres [expr $i+2]");
  fprintf(file, "%*s\n", 0,"# mol modselect $currentRepres 0 index $i");
  fprintf(file, "%*s\n", 2,"  # set the radius according to its contrib to weak inter");
  fprintf(file, "%*s\n", 0,"# set atomContrib [expr $atomContrib*15]");
  fprintf(file, "%*s\n", 0,"# mol modstyle $currentRepres 0  CPK $atomContrib 0.300000 12.000000 12.000000");
  fprintf(file, "%*s\n", 0,"} ");
  fprintf(file, "%*s\n", 0,"axes location Off");
  fprintf(file, "%*s\n", 0,"display rendermode GLSL");
  fclose(file);
} // end of generateVMDAtomDOIFile


void generateVMDCriticPointsFile(const std::string *rep, std::vector<criticalpoint>  cpList)
{
  FILE* file=fopen("cp.vmd","w");
  fprintf(file, "%*s\n", 0,"#");
  fprintf(file, "%*s\n", 0,"##Copyright University of Reims Champagne-Ardenne");
  fprintf(file, "%*s\n", 0,"#Authors and Contributors: Akilan RAJAMANI, Corentin LEFEBVRE, Johanna KLEIN, Emmanuel PLUOT, Gaetan RUBEZ, Hassan Khartabil, Jean-Charles-BOISSON and Eric HENON");
  fprintf(file, "%*s\n", 0,"#Contributors: Hassan Khartabil, Miguel Ponce-Vargas, Julia Contreras-Garcia");
  fprintf(file, "%*s\n", 0,"##(24/07/2017)");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"##jean-charles.boisson@univ-reims.fr, eric.henon@univ-reims.fr");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"##This software is a computer program whose purpose is to ");
  fprintf(file, "%*s\n", 0,"##detect and prepare the plot of molecular interactions");
  fprintf(file, "%*s\n", 0,"##from electron density and IGM reference using promolecular");
  fprintf(file, "%*s\n", 0,"##electron density.");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"##This software is governed by the CeCILL-C license under French law and");
  fprintf(file, "%*s\n", 0,"##abiding by the rules of distribution of free software.  You can  use, ");
  fprintf(file, "%*s\n", 0,"##modify and/ or redistribute the software under the terms of the CeCILL-C");
  fprintf(file, "%*s\n", 0,"##license as circulated by CEA, CNRS and INRIA at the following URL");
  fprintf(file, "%*s\n", 0,"##\"http://www.cecill.info\". ");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"##As a counterpart to the access to the source code and  rights to copy,");
  fprintf(file, "%*s\n", 0,"##modify and redistribute granted by the license, users are provided only");
  fprintf(file, "%*s\n", 0,"##with a limited warranty  and the software\'s author,  the holder of the");
  fprintf(file, "%*s\n", 0,"##economic rights,  and the successive licensors  have only  limited");
  fprintf(file, "%*s\n", 0,"##liability. ");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"##In this respect, the user\'s attention is drawn to the risks associated");
  fprintf(file, "%*s\n", 0,"##with loading,  using,  modifying and/or developing or reproducing the");
  fprintf(file, "%*s\n", 0,"##software by the user in light of its specific status of free software,");
  fprintf(file, "%*s\n", 0,"##that may mean  that it is complicated to manipulate,  and  that  also");
  fprintf(file, "%*s\n", 0,"##therefore means  that it is reserved for developers  and  experienced");
  fprintf(file, "%*s\n", 0,"##professionals having in-depth computer knowledge. Users are therefore");
  fprintf(file, "%*s\n", 0,"##encouraged to load and test the software\'s suitability as regards their");
  fprintf(file, "%*s\n", 0,"##requirements in conditions enabling the security of their systems and/or ");
  fprintf(file, "%*s\n", 0,"##data to be ensured and,  more generally, to use and operate it in the ");
  fprintf(file, "%*s\n", 0,"##same conditions as regards security. ");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"##The fact that you are presently reading this means that you have had");
  fprintf(file, "%*s\n", 0,"##knowledge of the CeCILL-C license and that you accept its terms.");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"#");
  fprintf(file, "%*s\n", 0,"#");

  fprintf(file, "%*s\n", 0,"#!/usr/local/bin/vmd");
  fprintf(file, "%*s\n", 0,"# VMD script written by save_state $Revision: 1.47 $");
  fprintf(file, "%*s\n", 0,"# VMD version: 1.9.3");
  fprintf(file, "%*s\n", 0,"set viewplist {}");
  fprintf(file, "%*s\n", 0,"set fixedlist {}");
  fprintf(file, "%*s\n", 0,"proc vmdrestoremymaterials {} {");
  fprintf(file, "%*s\n", 2,"  set mlist { Opaque Transparent BrushedMetal Diffuse Ghost Glass1 Glass2 Glass3 Glossy HardPlastic MetallicPastel Steel Translucent Edgy EdgyShiny EdgyGlass Goodsell AOShiny AOChalky AOEdgy BlownGlass GlassBubble RTChrome }");
  fprintf(file, "%*s\n", 2,"  set mymlist [material list]");
  fprintf(file, "%*s\n", 2,"  foreach mat $mlist {");
  fprintf(file, "%*s\n", 4,"    if { [lsearch $mymlist $mat] == -1 } { ");
  fprintf(file, "%*s\n", 6,"      material add $mat");
  fprintf(file, "%*s\n", 4,"    }");
  fprintf(file, "%*s\n", 2,"  }");
  fprintf(file, "%*s\n", 2,"  material change ambient Opaque 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Opaque 0.650000");
  fprintf(file, "%*s\n", 2,"  material change specular Opaque 0.500000");
  fprintf(file, "%*s\n", 2,"  material change shininess Opaque 0.534020");
  fprintf(file, "%*s\n", 2,"  material change mirror Opaque 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Opaque 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline Opaque 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Opaque 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Opaque 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Transparent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Transparent 0.650000");
  fprintf(file, "%*s\n", 2,"  material change specular Transparent 0.500000");
  fprintf(file, "%*s\n", 2,"  material change shininess Transparent 0.534020");
  fprintf(file, "%*s\n", 2,"  material change mirror Transparent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Transparent 0.300000");
  fprintf(file, "%*s\n", 2,"  material change outline Transparent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Transparent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Transparent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient BrushedMetal 0.080000");
  fprintf(file, "%*s\n", 2,"  material change diffuse BrushedMetal 0.390000");
  fprintf(file, "%*s\n", 2,"  material change specular BrushedMetal 0.340000");
  fprintf(file, "%*s\n", 2,"  material change shininess BrushedMetal 0.150000");
  fprintf(file, "%*s\n", 2,"  material change mirror BrushedMetal 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity BrushedMetal 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline BrushedMetal 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth BrushedMetal 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode BrushedMetal 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Diffuse 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Diffuse 0.620000");
  fprintf(file, "%*s\n", 2,"  material change specular Diffuse 0.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess Diffuse 0.530000");
  fprintf(file, "%*s\n", 2,"  material change mirror Diffuse 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Diffuse 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline Diffuse 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Diffuse 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Diffuse 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Ghost 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Ghost 0.000000");
  fprintf(file, "%*s\n", 2,"  material change specular Ghost 1.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess Ghost 0.230000");
  fprintf(file, "%*s\n", 2,"  material change mirror Ghost 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Ghost 0.100000");
  fprintf(file, "%*s\n", 2,"  material change outline Ghost 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Ghost 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Ghost 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Glass1 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Glass1 0.500000");
  fprintf(file, "%*s\n", 2,"  material change specular Glass1 0.650000");
  fprintf(file, "%*s\n", 2,"  material change shininess Glass1 0.530000");
  fprintf(file, "%*s\n", 2,"  material change mirror Glass1 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Glass1 0.150000");
  fprintf(file, "%*s\n", 2,"  material change outline Glass1 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Glass1 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Glass1 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Glass2 0.520000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Glass2 0.760000");
  fprintf(file, "%*s\n", 2,"  material change specular Glass2 0.220000");
  fprintf(file, "%*s\n", 2,"  material change shininess Glass2 0.590000");
  fprintf(file, "%*s\n", 2,"  material change mirror Glass2 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Glass2 0.680000");
  fprintf(file, "%*s\n", 2,"  material change outline Glass2 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Glass2 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Glass2 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Glass3 0.150000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Glass3 0.250000");
  fprintf(file, "%*s\n", 2,"  material change specular Glass3 0.750000");
  fprintf(file, "%*s\n", 2,"  material change shininess Glass3 0.800000");
  fprintf(file, "%*s\n", 2,"  material change mirror Glass3 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Glass3 0.500000");
  fprintf(file, "%*s\n", 2,"  material change outline Glass3 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Glass3 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Glass3 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Glossy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Glossy 0.650000");
  fprintf(file, "%*s\n", 2,"  material change specular Glossy 1.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess Glossy 0.880000");
  fprintf(file, "%*s\n", 2,"  material change mirror Glossy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Glossy 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline Glossy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Glossy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Glossy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient HardPlastic 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse HardPlastic 0.560000");
  fprintf(file, "%*s\n", 2,"  material change specular HardPlastic 0.280000");
  fprintf(file, "%*s\n", 2,"  material change shininess HardPlastic 0.690000");
  fprintf(file, "%*s\n", 2,"  material change mirror HardPlastic 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity HardPlastic 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline HardPlastic 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth HardPlastic 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode HardPlastic 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient MetallicPastel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse MetallicPastel 0.260000");
  fprintf(file, "%*s\n", 2,"  material change specular MetallicPastel 0.550000");
  fprintf(file, "%*s\n", 2,"  material change shininess MetallicPastel 0.190000");
  fprintf(file, "%*s\n", 2,"  material change mirror MetallicPastel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity MetallicPastel 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline MetallicPastel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth MetallicPastel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode MetallicPastel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Steel 0.250000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Steel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change specular Steel 0.380000");
  fprintf(file, "%*s\n", 2,"  material change shininess Steel 0.320000");
  fprintf(file, "%*s\n", 2,"  material change mirror Steel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Steel 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline Steel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Steel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Steel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Translucent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Translucent 0.700000");
  fprintf(file, "%*s\n", 2,"  material change specular Translucent 0.600000");
  fprintf(file, "%*s\n", 2,"  material change shininess Translucent 0.300000");
  fprintf(file, "%*s\n", 2,"  material change mirror Translucent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Translucent 0.800000");
  fprintf(file, "%*s\n", 2,"  material change outline Translucent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Translucent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Translucent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Edgy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Edgy 0.660000");
  fprintf(file, "%*s\n", 2,"  material change specular Edgy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess Edgy 0.750000");
  fprintf(file, "%*s\n", 2,"  material change mirror Edgy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Edgy 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline Edgy 0.620000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Edgy 0.940000");
  fprintf(file, "%*s\n", 2,"  material change transmode Edgy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient EdgyShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse EdgyShiny 0.660000");
  fprintf(file, "%*s\n", 2,"  material change specular EdgyShiny 0.960000");
  fprintf(file, "%*s\n", 2,"  material change shininess EdgyShiny 0.750000");
  fprintf(file, "%*s\n", 2,"  material change mirror EdgyShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity EdgyShiny 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline EdgyShiny 0.760000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth EdgyShiny 0.940000");
  fprintf(file, "%*s\n", 2,"  material change transmode EdgyShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient EdgyGlass 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse EdgyGlass 0.660000");
  fprintf(file, "%*s\n", 2,"  material change specular EdgyGlass 0.500000");
  fprintf(file, "%*s\n", 2,"  material change shininess EdgyGlass 0.750000");
  fprintf(file, "%*s\n", 2,"  material change mirror EdgyGlass 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity EdgyGlass 0.620000");
  fprintf(file, "%*s\n", 2,"  material change outline EdgyGlass 0.620000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth EdgyGlass 0.940000");
  fprintf(file, "%*s\n", 2,"  material change transmode EdgyGlass 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Goodsell 0.520000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Goodsell 1.000000");
  fprintf(file, "%*s\n", 2,"  material change specular Goodsell 0.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess Goodsell 0.000000");
  fprintf(file, "%*s\n", 2,"  material change mirror Goodsell 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Goodsell 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline Goodsell 4.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Goodsell 0.900000");
  fprintf(file, "%*s\n", 2,"  material change transmode Goodsell 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient AOShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse AOShiny 0.850000");
  fprintf(file, "%*s\n", 2,"  material change specular AOShiny 0.200000");
  fprintf(file, "%*s\n", 2,"  material change shininess AOShiny 0.530000");
  fprintf(file, "%*s\n", 2,"  material change mirror AOShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity AOShiny 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline AOShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth AOShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode AOShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient AOChalky 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse AOChalky 0.850000");
  fprintf(file, "%*s\n", 2,"  material change specular AOChalky 0.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess AOChalky 0.530000");
  fprintf(file, "%*s\n", 2,"  material change mirror AOChalky 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity AOChalky 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline AOChalky 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth AOChalky 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode AOChalky 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient AOEdgy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse AOEdgy 0.900000");
  fprintf(file, "%*s\n", 2,"  material change specular AOEdgy 0.200000");
  fprintf(file, "%*s\n", 2,"  material change shininess AOEdgy 0.530000");
  fprintf(file, "%*s\n", 2,"  material change mirror AOEdgy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity AOEdgy 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline AOEdgy 0.620000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth AOEdgy 0.930000");
  fprintf(file, "%*s\n", 2,"  material change transmode AOEdgy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient BlownGlass 0.040000");
  fprintf(file, "%*s\n", 2,"  material change diffuse BlownGlass 0.340000");
  fprintf(file, "%*s\n", 2,"  material change specular BlownGlass 1.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess BlownGlass 1.000000");
  fprintf(file, "%*s\n", 2,"  material change mirror BlownGlass 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity BlownGlass 0.100000");
  fprintf(file, "%*s\n", 2,"  material change outline BlownGlass 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth BlownGlass 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode BlownGlass 1.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient GlassBubble 0.250000");
  fprintf(file, "%*s\n", 2,"  material change diffuse GlassBubble 0.340000");
  fprintf(file, "%*s\n", 2,"  material change specular GlassBubble 1.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess GlassBubble 1.000000");
  fprintf(file, "%*s\n", 2,"  material change mirror GlassBubble 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity GlassBubble 0.040000");
  fprintf(file, "%*s\n", 2,"  material change outline GlassBubble 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth GlassBubble 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode GlassBubble 1.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient RTChrome 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse RTChrome 0.650000");
  fprintf(file, "%*s\n", 2,"  material change specular RTChrome 0.500000");
  fprintf(file, "%*s\n", 2,"  material change shininess RTChrome 0.530000");
  fprintf(file, "%*s\n", 2,"  material change mirror RTChrome 0.700000");
  fprintf(file, "%*s\n", 2,"  material change opacity RTChrome 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline RTChrome 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth RTChrome 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode RTChrome 0.000000");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"vmdrestoremymaterials");
  fprintf(file, "%*s\n", 0,"# Atom selection macros");
  fprintf(file, "%*s\n", 0,"atomselect macro at {resname ADE A THY T");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro acidic {resname ASP GLU");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro cyclic {resname HIS PHE PRO TRP TYR");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro acyclic {protein and not cyclic");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro aliphatic {resname ALA GLY ILE LEU VAL");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro alpha {protein and name CA");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro amino {protein");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro aromatic {resname HIS PHE TRP TYR");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro basic {resname ARG HIS LYS HSP");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro bonded {numbonds > 0");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro buried {resname ALA LEU VAL ILE PHE CYS MET TRP");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro cg {resname CYT C GUA G");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro charged {basic or acidic");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro hetero {not (protein or nucleic)");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro hydrophobic {resname ALA LEU VAL ILE PRO PHE MET TRP");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro small {resname ALA GLY SER");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro medium {resname VAL THR ASP ASN PRO CYS ASX PCA HYP");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro large {protein and not (small or medium)");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro neutral {resname VAL PHE GLN TYR HIS CYS MET TRP ASX GLX PCA HYP");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro polar {protein and not hydrophobic");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro purine {resname ADE A GUA G");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro pyrimidine {resname CYT C THY T URA U");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro surface {protein and not buried");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro lipid {resname DLPE DMPC DPPC GPC LPPC PALM PC PGCL POPC POPE");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro lipids {lipid");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro ion {resname AL BA CA CAL CD CES CLA CL CO CS CU CU1 CUA HG IN IOD K LIT MG MN3 MO3 MO4 MO5 MO6 NA NAW OC7 PB POT PT RB SOD TB TL WO4 YB ZN ZN1 ZN2");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro ions {ion");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro sugar {resname AGLC");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro solvent {not (protein or sugar or nucleic or lipid)");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro glycan {resname NAG BGLN FUC AFUC MAN AMAN BMA BMAN");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro carbon {name \"C.*\" and not ion");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro hydrogen {name \"[0-9]?H.*\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro nitrogen {name \"N.*\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro oxygen {name \"O.*\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro sulfur {name \"S.*\" and not ion");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro noh {not hydrogen");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro heme {resname HEM HEME");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationall {altloc \"\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationA {altloc \"\" or altloc \"A\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationB {altloc \"\" or altloc \"B\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationC {altloc \"\" or altloc \"C\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationD {altloc \"\" or altloc \"D\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationE {altloc \"\" or altloc \"E\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationF {altloc \"\" or altloc \"F\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro drude {type DRUD or type LP");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro unparametrized beta<1");
  fprintf(file, "%*s\n", 0,"atomselect macro addedmolefacture {occupancy 0.8}");
  fprintf(file, "%*s\n", 0,"atomselect macro qwikmd_protein {(not name QWIKMDDELETE and protein)}");
  fprintf(file, "%*s\n", 0,"atomselect macro qwikmd_nucleic {(not name QWIKMDDELETE and nucleic)}");
  fprintf(file, "%*s\n", 0,"atomselect macro qwikmd_glycan {(not name QWIKMDDELETE and glycan)}");
  fprintf(file, "%*s\n", 0,"atomselect macro qwikmd_lipid {(not name QWIKMDDELETE and lipid)}");
  fprintf(file, "%*s\n", 0,"atomselect macro qwikmd_hetero {(not name QWIKMDDELETE and hetero and not qwikmd_protein and not qwikmd_lipid and not qwikmd_nucleic and not qwikmd_glycan and not water)}");
  fprintf(file, "%*s\n", 0,"# Display settings");
  fprintf(file, "%*s\n", 0,"display eyesep       0.065000");
  fprintf(file, "%*s\n", 0,"display focallength  2.000000");
  fprintf(file, "%*s\n", 0,"display height       6.000000");
  fprintf(file, "%*s\n", 0,"display distance     -2.000000");
  fprintf(file, "%*s\n", 0,"display projection   Perspective");
  fprintf(file, "%*s\n", 0,"display nearclip set 0.500000");
  fprintf(file, "%*s\n", 0,"display farclip  set 10.000000");
  fprintf(file, "%*s\n", 0,"display depthcue   off");
  fprintf(file, "%*s\n", 0,"display cuestart   0.500000");
  fprintf(file, "%*s\n", 0,"display cueend     10.000000");
  fprintf(file, "%*s\n", 0,"display cuestart   0.500000");
  fprintf(file, "%*s\n", 0,"display cueend     10.000000");
  fprintf(file, "%*s\n", 0,"display cuedensity 0.320000");
  fprintf(file, "%*s\n", 0,"display cuemode    Exp2");
  fprintf(file, "%*s\n", 0,"display shadows off");
  fprintf(file, "%*s\n", 0,"display ambientocclusion off");
  fprintf(file, "%*s\n", 0,"display aoambient 0.800000");
  fprintf(file, "%*s\n", 0,"display aodirect 0.300000");
  fprintf(file, "%*s\n", 0,"display dof off");
  fprintf(file, "%*s\n", 0,"display dof_fnumber 64.000000");
  fprintf(file, "%*s\n", 0,"display dof_focaldist 0.700000");

  // load the XYZ molecule file
  fprintf(file, "%*s%s%s\n", 1, "mol new ", rep[XYZ].c_str(), " type xyz first 0 last -1 step 1 filebonds 1 autobonds 1 waitfor all");
  fprintf(file, "%*s\n", 0,"mol delrep 0 top");
  fprintf(file, "%*s\n", 0,"mol representation CPK 0.5000000 0.050000 32.000000 32.000000");
  fprintf(file, "%*s\n", 0,"mol color Name");
  fprintf(file, "%*s\n", 0,"mol selection {all}");
  fprintf(file, "%*s\n", 0,"mol material Opaque");
  fprintf(file, "%*s\n", 0,"mol addrep top");
  fprintf(file, "%*s\n", 0,"mol selupdate 0 top 0");
  fprintf(file, "%*s\n", 0,"mol colupdate 0 top 0");
  fprintf(file, "%*s\n", 0,"mol scaleminmax top 0 0.000000 0.000000");
  fprintf(file, "%*s\n", 0,"mol smoothrep top 0 0");
  fprintf(file, "%*s\n", 0,"mol drawframes top 0 {now}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 0 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  0 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 0 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 0 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 1 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  1 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 1 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 1 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 2 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  2 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 2 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 2 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 3 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  3 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 3 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 3 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 4 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  4 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 4 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 4 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 5 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  5 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 5 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 5 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol rename top coord.xyz");
  fprintf(file, "%*s\n", 0,"set viewpoints([molinfo top]) {{{1 0 0 0.0524956} {0 1 0 0.169785} {0 0 1 -0.00447658} {0 0 0 1}} {{0.533237 0.589075 -0.607192 0} {-0.619337 0.760771 0.194167 0} {0.576314 0.272514 0.770501 0} {0 0 0 1}} {{0.216958 0 0 0} {0 0.216958 0 0} {0 0 0.216958 0} {0 0 0 1}} {{1 0 0 0} {0 1 0 0} {0 0 1 0} {0 0 0 1}}}");
  fprintf(file, "%*s\n", 0,"lappend viewplist [molinfo top]");
  fprintf(file, "%*s\n", 0,"set topmol [molinfo top]");
  fprintf(file, "%*s\n", 0,"# done with molecule 0");

  // =================================================== //
  // create a new representation for Bond Critic Points
  // =================================================== // 
  fprintf(file, "%*s\n", 0,"# Bond Critical Points");
  fprintf(file, "%*s\n", 0,"mol new");
  fprintf(file, "%*s\n", 0,"mol rename top bcp");
  // generate a sphere for each bcp in yellow
  fprintf(file, "%*s\n", 0,"draw color yellow"); 
  for(unsigned int icp = 0; icp < cpList.size(); icp++)
    {
       if (cpList[icp].type==-1) 
        {
          double x = cpList[icp].pos[0]*BOHRTOA;
          double y = cpList[icp].pos[1]*BOHRTOA;
          double z = cpList[icp].pos[2]*BOHRTOA;
       
          fprintf(file, "%*s%10.4f%s%10.4f%s%10.4f%s\n", 0,"draw sphere {", x, " ",y, " ",z, " } radius 0.05");
        }// end of if (cpList[icp].type==-1)
    } // end over bcp
  fprintf(file, "%*s\n", 0,"set viewpoints([molinfo top]) {{{1 0 0 0.0524956} {0 1 0 0.169785} {0 0 1 -0.00447658} {0 0 0 1}} {{0.533237 0.589075 -0.607192 0} {-0.619337 0.760771 0.194167 0} {0.576314 0.272514 0.770501 0} {0 0 0 1}} {{0.216958 0 0 0} {0 0.216958 0 0} {0 0 0.216958 0} {0 0 0 1}} {{1 0 0 0} {0 1 0 0} {0 0 1 0} {0 0 0 1}}}");
  fprintf(file, "%*s\n", 0,"lappend viewplist [molinfo top]");
  fprintf(file, "%*s\n", 0,"set topmol [molinfo top]");
  fprintf(file, "%*s\n", 0,"# done with bcp");

  // =================================================== //
  // create a new representation for Ring Critical Points
  // =================================================== // 
  fprintf(file, "%*s\n", 0,"# Ring Critical Points");
  fprintf(file, "%*s\n", 0,"mol new");
  fprintf(file, "%*s\n", 0,"mol rename top rcp");
  // generate a sphere for each bcp in orange2 
  fprintf(file, "%*s\n", 0,"draw color orange2");
  for(unsigned int icp = 0; icp < cpList.size(); icp++)
    {
       if (cpList[icp].type== 1)
        {
          double x = cpList[icp].pos[0]*BOHRTOA;
          double y = cpList[icp].pos[1]*BOHRTOA;
          double z = cpList[icp].pos[2]*BOHRTOA;

          fprintf(file, "%*s%10.4f%s%10.4f%s%10.4f%s\n", 0,"draw sphere {", x, " ",y, " ",z, " } radius 0.05");
        }// end of if (cpList[icp].type== 1)
    } // end over bcp
  fprintf(file, "%*s\n", 0,"set viewpoints([molinfo top]) {{{1 0 0 0.0524956} {0 1 0 0.169785} {0 0 1 -0.00447658} {0 0 0 1}} {{0.533237 0.589075 -0.607192 0} {-0.619337 0.760771 0.194167 0} {0.576314 0.272514 0.770501 0} {0 0 0 1}} {{0.216958 0 0 0} {0 0.216958 0 0} {0 0 0.216958 0} {0 0 0 1}} {{1 0 0 0} {0 1 0 0} {0 0 1 0} {0 0 0 1}}}");
  fprintf(file, "%*s\n", 0,"lappend viewplist [molinfo top]");
  fprintf(file, "%*s\n", 0,"set topmol [molinfo top]");
  fprintf(file, "%*s\n", 0,"# done with rcp");


  // =================================================== //
  // create a new representation for Cage Critical Points
  // =================================================== // 
  fprintf(file, "%*s\n", 0,"# Cage Critical Points");
  fprintf(file, "%*s\n", 0,"mol new");
  fprintf(file, "%*s\n", 0,"mol rename top ccp");
  // generate a sphere for each bcp in violet2 
  fprintf(file, "%*s\n", 0,"draw color violet2");
  for(unsigned int icp = 0; icp < cpList.size(); icp++)
    {
       if (cpList[icp].type==3)
        {
          double x = cpList[icp].pos[0]*BOHRTOA;
          double y = cpList[icp].pos[1]*BOHRTOA;
          double z = cpList[icp].pos[2]*BOHRTOA;

          fprintf(file, "%*s%10.4f%s%10.4f%s%10.4f%s\n", 0,"draw sphere {", x, " ",y, " ",z, " } radius 0.05");
        }// end of if (cpList[icp].type==3)
    } // end over bcp
  fprintf(file, "%*s\n", 0,"set viewpoints([molinfo top]) {{{1 0 0 0.0524956} {0 1 0 0.169785} {0 0 1 -0.00447658} {0 0 0 1}} {{0.533237 0.589075 -0.607192 0} {-0.619337 0.760771 0.194167 0} {0.576314 0.272514 0.770501 0} {0 0 0 1}} {{0.216958 0 0 0} {0 0.216958 0 0} {0 0 0.216958 0} {0 0 0 1}} {{1 0 0 0} {0 1 0 0} {0 0 1 0} {0 0 0 1}}}");
  fprintf(file, "%*s\n", 0,"lappend viewplist [molinfo top]");
  fprintf(file, "%*s\n", 0,"set topmol [molinfo top]");
  fprintf(file, "%*s\n", 0,"# done with ccp");

  // ========================================================= //
  // create a new representation for Critical Points Numbering
  // ========================================================= // 
  fprintf(file, "%*s\n", 0,"# Critical Points Numbering");
  fprintf(file, "%*s\n", 0,"mol new");
  fprintf(file, "%*s\n", 0,"mol rename top \"cp numbering\"");
  // generate a text for each cp in white
  fprintf(file, "%*s\n", 0,"draw color gray");
  for(unsigned int icp = 0; icp < cpList.size(); icp++)
    {
          double x = cpList[icp].pos[0]*BOHRTOA;
          double y = cpList[icp].pos[1]*BOHRTOA;
          double z = cpList[icp].pos[2]*BOHRTOA;

          fprintf(file, "%*s%10.4f%s%10.4f%s%10.4f%s%d%s\n", 0,"draw text   {", x, " ",y, " ",z, " } \"",icp+1,"\" size 1.3 thickness 3");
    } // end over bcp
  fprintf(file, "%*s\n", 0,"set viewpoints([molinfo top]) {{{1 0 0 0.0524956} {0 1 0 0.169785} {0 0 1 -0.00447658} {0 0 0 1}} {{0.533237 0.589075 -0.607192 0} {-0.619337 0.760771 0.194167 0} {0.576314 0.272514 0.770501 0} {0 0 0 1}} {{0.216958 0 0 0} {0 0.216958 0 0} {0 0 0.216958 0} {0 0 0 1}} {{1 0 0 0} {0 1 0 0} {0 0 1 0} {0 0 0 1}}}");
  fprintf(file, "%*s\n", 0,"lappend viewplist [molinfo top]");
  fprintf(file, "%*s\n", 0,"set topmol [molinfo top]");
  fprintf(file, "%*s\n", 0,"# done with cp numbering");



  fprintf(file, "%*s\n", 0,"foreach v $viewplist {");
  fprintf(file, "%*s\n", 2,"  molinfo $v set {center_matrix rotate_matrix scale_matrix global_matrix} $viewpoints($v)");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"foreach v $fixedlist {");
  fprintf(file, "%*s\n", 2,"  molinfo $v set fixed 1");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"unset viewplist");
  fprintf(file, "%*s\n", 0,"unset fixedlist");
  fprintf(file, "%*s\n", 0,"mol top $topmol");
  fprintf(file, "%*s\n", 0,"unset topmol");
  fprintf(file, "%*s\n", 0,"proc vmdrestoremycolors {} {");
  fprintf(file, "%*s\n", 0,"color scale colors RWB {1.0 0.0 0.0} {1.0 1.0 1.0} {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"color scale colors BWR {0.0 0.0 1.0} {1.0 1.0 1.0} {1.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"color scale colors RGryB {1.0 0.0 0.0} {0.5 0.5 0.5} {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"color scale colors BGryR {0.0 0.0 1.0} {0.5 0.5 0.5} {1.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"color scale colors RGB {1.0 0.0 0.0} {0.0 1.0 0.0} {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"color scale colors BGR {0.0 0.0 1.0} {0.0 1.0 0.0} {1.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"color scale colors RWG {1.0 0.0 0.0} {1.0 1.0 1.0} {0.0 1.0 0.0}");
  fprintf(file, "%*s\n", 0,"color scale colors GWR {0.0 1.0 0.0} {1.0 1.0 1.0} {1.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"color scale colors GWB {0.0 1.0 0.0} {1.0 1.0 1.0} {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"color scale colors BWG {0.0 0.0 1.0} {1.0 1.0 1.0} {0.0 1.0 0.0}");
  fprintf(file, "%*s\n", 0,"color scale colors BlkW {0.0 0.0 0.0} {0.5 0.5 0.5} {1.0 1.0 1.0}");
  fprintf(file, "%*s\n", 0,"color scale colors WBlk {1.0 1.0 1.0} {0.5 0.5 0.5} {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 2,"  color scale method BGR");
  fprintf(file, "%*s\n", 2,"  set colorcmds {");
  fprintf(file, "%*s\n", 4,"    {color Display {Background} black}");
  fprintf(file, "%*s\n", 4,"    {color Display {BackgroundTop} black}");
  fprintf(file, "%*s\n", 4,"    {color Display {BackgroundBot} blue2}");
  fprintf(file, "%*s\n", 4,"    {color Display {FPS} white}");
  fprintf(file, "%*s\n", 4,"    {color Name {LPA} green}");
  fprintf(file, "%*s\n", 4,"    {color Name {LPB} green}");
  fprintf(file, "%*s\n", 4,"    {color Type {LP} green}");
  fprintf(file, "%*s\n", 4,"    {color Type {DRUD} pink}");
  fprintf(file, "%*s\n", 4,"    {color Element {X} cyan}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ac} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ag} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Al} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Am} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ar} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {As} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {At} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Au} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {B} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ba} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Be} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Bh} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Bi} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Bk} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Br} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ca} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cd} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ce} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cf} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cl} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cm} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Co} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cs} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cu} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Db} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ds} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Dy} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Er} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Es} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Eu} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {F} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Fe} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Fm} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Fr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ga} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Gd} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ge} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {He} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Hf} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Hg} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ho} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Hs} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {I} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {In} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ir} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {K} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Kr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {La} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Li} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Lr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Lu} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Md} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Mg} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Mn} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Mo} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Mt} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Na} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Nb} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Nd} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ne} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ni} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {No} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Np} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Os} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pa} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pb} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pd} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pm} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Po} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pt} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pu} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ra} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Rb} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Re} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Rf} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Rg} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Rh} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Rn} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ru} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Sb} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Sc} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Se} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Sg} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Si} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Sm} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Sn} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Sr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ta} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Tb} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Tc} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Te} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Th} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ti} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Tl} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Tm} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {U} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {V} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {W} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Xe} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Y} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Yb} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Zr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Resname {} silver}");
  fprintf(file, "%*s\n", 4,"    {color Chain {X} blue}");
  fprintf(file, "%*s\n", 4,"    {color Segname {} blue}");
  fprintf(file, "%*s\n", 4,"    {color Conformation {all} blue}");
  fprintf(file, "%*s\n", 4,"    {color Molecule {0} blue}");
  fprintf(file, "%*s\n", 4,"    {color Molecule {coord.xyz} blue}");
  fprintf(file, "%*s\n", 4,"    {color Structure {3_10_Helix} blue}");
  fprintf(file, "%*s\n", 4,"    {color Surface {Grasp} gray}");
  fprintf(file, "%*s\n", 4,"    {color Labels {Springs} orange}");
  fprintf(file, "%*s\n", 4,"    {color Stage {Even} gray}");
  fprintf(file, "%*s\n", 4,"    {color Stage {Odd} silver}");
  fprintf(file, "%*s\n", 2,"  }");
  fprintf(file, "%*s\n", 2,"  foreach colcmd $colorcmds {");
  fprintf(file, "%*s\n", 4,"    set val [catch {eval $colcmd}]");
  fprintf(file, "%*s\n", 2,"  }");
  fprintf(file, "%*s\n", 2,"  color change rgb 0 0.0 0.0 1.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 2 0.3499999940395355 0.3499999940395355 0.3499999940395355");
  fprintf(file, "%*s\n", 2,"  color change rgb 3 1.0 0.5 0.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 4 1.0 1.0 0.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 5 0.5 0.5 0.20000000298023224");
  fprintf(file, "%*s\n", 2,"  color change rgb 6 0.6000000238418579 0.6000000238418579 0.6000000238418579");
  fprintf(file, "%*s\n", 2,"  color change rgb 7 0.0 1.0 0.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 9 1.0 0.6000000238418579 0.6000000238418579");
  fprintf(file, "%*s\n", 2,"  color change rgb 11 0.6499999761581421 0.0 0.6499999761581421");
  fprintf(file, "%*s\n", 2,"  color change rgb 12 0.5 0.8999999761581421 0.4000000059604645");
  fprintf(file, "%*s\n", 2,"  color change rgb 13 0.8999999761581421 0.4000000059604645 0.699999988079071");
  fprintf(file, "%*s\n", 2,"  color change rgb 14 0.5 0.30000001192092896 0.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 15 0.5 0.5 0.75");
  fprintf(file, "%*s\n", 2,"  color change rgb 17 0.8799999952316284 0.9700000286102295 0.019999999552965164");
  fprintf(file, "%*s\n", 2,"  color change rgb 18 0.550000011920929 0.8999999761581421 0.019999999552965164");
  fprintf(file, "%*s\n", 2,"  color change rgb 19 0.0 0.8999999761581421 0.03999999910593033");
  fprintf(file, "%*s\n", 2,"  color change rgb 20 0.0 0.8999999761581421 0.5");
  fprintf(file, "%*s\n", 2,"  color change rgb 21 0.0 0.8799999952316284 1.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 22 0.0 0.7599999904632568 1.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 23 0.019999999552965164 0.3799999952316284 0.6700000166893005");
  fprintf(file, "%*s\n", 2,"  color change rgb 24 0.009999999776482582 0.03999999910593033 0.9300000071525574");
  fprintf(file, "%*s\n", 2,"  color change rgb 25 0.27000001072883606 0.0 0.9800000190734863");
  fprintf(file, "%*s\n", 2,"  color change rgb 26 0.44999998807907104 0.0 0.8999999761581421");
  fprintf(file, "%*s\n", 2,"  color change rgb 27 0.8999999761581421 0.0 0.8999999761581421");
  fprintf(file, "%*s\n", 2,"  color change rgb 28 1.0 0.0 0.6600000262260437");
  fprintf(file, "%*s\n", 2,"  color change rgb 29 0.9800000190734863 0.0 0.23000000417232513");
  fprintf(file, "%*s\n", 2,"  color change rgb 30 0.8100000023841858 0.0 0.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 31 0.8899999856948853 0.3499999940395355 0.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 32 0.9599999785423279 0.7200000286102295 0.0");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"vmdrestoremycolors");
  fprintf(file, "%*s\n", 0,"label textsize 1.0");

  fprintf(file, "%*s\n", 0,"axes location Off");
  fprintf(file, "%*s\n", 0,"display rendermode GLSL");
  fclose(file);
} // end of generateCriticalPointsFile


void generateVMDnciFile(const std::string *rep)
{
  FILE* file=fopen("nci.vmd","w");
  fprintf(file, "%*s\n", 0,"#");
  fprintf(file, "%*s\n", 0,"##Copyright University of Reims Champagne-Ardenne");
  fprintf(file, "%*s\n", 0,"#Authors and Contributors: Akilan RAJAMANI, Corentin LEFEBVRE, Johanna KLEIN, Emmanuel PLUOT, Gaetan RUBEZ, Hassan Khartabil, Jean-Charles-BOISSON and Eric HENON");
  fprintf(file, "%*s\n", 0,"#Contributors: Hassan Khartabil, Miguel Ponce-Vargas, Julia Contreras-Garcia");
  fprintf(file, "%*s\n", 0,"##(24/07/2017)");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"##jean-charles.boisson@univ-reims.fr, eric.henon@univ-reims.fr");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"##This software is a computer program whose purpose is to ");
  fprintf(file, "%*s\n", 0,"##detect and prepare the plot of molecular interactions");
  fprintf(file, "%*s\n", 0,"##from electron density and IGM reference using promolecular");
  fprintf(file, "%*s\n", 0,"##electron density.");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"##This software is governed by the CeCILL-C license under French law and");
  fprintf(file, "%*s\n", 0,"##abiding by the rules of distribution of free software.  You can  use, ");
  fprintf(file, "%*s\n", 0,"##modify and/ or redistribute the software under the terms of the CeCILL-C");
  fprintf(file, "%*s\n", 0,"##license as circulated by CEA, CNRS and INRIA at the following URL");
  fprintf(file, "%*s\n", 0,"##\"http://www.cecill.info\". ");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"##As a counterpart to the access to the source code and  rights to copy,");
  fprintf(file, "%*s\n", 0,"##modify and redistribute granted by the license, users are provided only");
  fprintf(file, "%*s\n", 0,"##with a limited warranty  and the software\'s author,  the holder of the");
  fprintf(file, "%*s\n", 0,"##economic rights,  and the successive licensors  have only  limited");
  fprintf(file, "%*s\n", 0,"##liability. ");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"##In this respect, the user\'s attention is drawn to the risks associated");
  fprintf(file, "%*s\n", 0,"##with loading,  using,  modifying and/or developing or reproducing the");
  fprintf(file, "%*s\n", 0,"##software by the user in light of its specific status of free software,");
  fprintf(file, "%*s\n", 0,"##that may mean  that it is complicated to manipulate,  and  that  also");
  fprintf(file, "%*s\n", 0,"##therefore means  that it is reserved for developers  and  experienced");
  fprintf(file, "%*s\n", 0,"##professionals having in-depth computer knowledge. Users are therefore");
  fprintf(file, "%*s\n", 0,"##encouraged to load and test the software\'s suitability as regards their");
  fprintf(file, "%*s\n", 0,"##requirements in conditions enabling the security of their systems and/or ");
  fprintf(file, "%*s\n", 0,"##data to be ensured and,  more generally, to use and operate it in the ");
  fprintf(file, "%*s\n", 0,"##same conditions as regards security. ");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"##The fact that you are presently reading this means that you have had");
  fprintf(file, "%*s\n", 0,"##knowledge of the CeCILL-C license and that you accept its terms.");
  fprintf(file, "%*s\n", 0,"##");
  fprintf(file, "%*s\n", 0,"#");
  fprintf(file, "%*s\n", 0,"#");
  fprintf(file, "%*s\n", 0,"##!/usr/local/bin/vmd");
  fprintf(file, "%*s\n", 0,"# VMD script written by save_state $Revision: 1.46 $");
  fprintf(file, "%*s\n", 0,"# VMD version: 1.9.2beta1optixtest4");
  fprintf(file, "%*s\n", 0,"proc vmdrestoremymaterials {} {");
  fprintf(file, "%*s\n", 2,"  set mlist { Opaque Transparent BrushedMetal Diffuse Ghost Glass1 Glass2 Glass3 Glossy HardPlastic MetallicPastel Steel Translucent Edgy EdgyShiny EdgyGlass Goodsell AOShiny AOChalky AOEdgy BlownGlass GlassBubble }");
  fprintf(file, "%*s\n", 2,"  set mymlist [material list]");
  fprintf(file, "%*s\n", 2,"  foreach mat $mlist {");
  fprintf(file, "%*s\n", 4,"    if { [lsearch $mymlist $mat] == -1 } { ");
  fprintf(file, "%*s\n", 6,"      material add $mat");
  fprintf(file, "%*s\n", 4,"    }");
  fprintf(file, "%*s\n", 2,"  }");
  fprintf(file, "%*s\n", 2,"  material change ambient Opaque 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Opaque 0.650000");
  fprintf(file, "%*s\n", 2,"  material change specular Opaque 0.500000");
  fprintf(file, "%*s\n", 2,"  material change shininess Opaque 0.534020");
  fprintf(file, "%*s\n", 2,"  material change opacity Opaque 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline Opaque 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Opaque 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Opaque 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Transparent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Transparent 0.650000");
  fprintf(file, "%*s\n", 2,"  material change specular Transparent 0.500000");
  fprintf(file, "%*s\n", 2,"  material change shininess Transparent 0.534020");
  fprintf(file, "%*s\n", 2,"  material change opacity Transparent 0.300000");
  fprintf(file, "%*s\n", 2,"  material change outline Transparent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Transparent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Transparent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient BrushedMetal 0.080000");
  fprintf(file, "%*s\n", 2,"  material change diffuse BrushedMetal 0.390000");
  fprintf(file, "%*s\n", 2,"  material change specular BrushedMetal 0.340000");
  fprintf(file, "%*s\n", 2,"  material change shininess BrushedMetal 0.150000");
  fprintf(file, "%*s\n", 2,"  material change opacity BrushedMetal 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline BrushedMetal 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth BrushedMetal 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode BrushedMetal 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Diffuse 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Diffuse 0.620000");
  fprintf(file, "%*s\n", 2,"  material change specular Diffuse 0.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess Diffuse 0.530000");
  fprintf(file, "%*s\n", 2,"  material change opacity Diffuse 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline Diffuse 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Diffuse 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Diffuse 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Ghost 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Ghost 0.000000");
  fprintf(file, "%*s\n", 2,"  material change specular Ghost 1.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess Ghost 0.230000");
  fprintf(file, "%*s\n", 2,"  material change opacity Ghost 0.100000");
  fprintf(file, "%*s\n", 2,"  material change outline Ghost 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Ghost 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Ghost 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Glass1 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Glass1 0.500000");
  fprintf(file, "%*s\n", 2,"  material change specular Glass1 0.650000");
  fprintf(file, "%*s\n", 2,"  material change shininess Glass1 0.530000");
  fprintf(file, "%*s\n", 2,"  material change opacity Glass1 0.150000");
  fprintf(file, "%*s\n", 2,"  material change outline Glass1 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Glass1 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Glass1 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Glass2 0.520000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Glass2 0.760000");
  fprintf(file, "%*s\n", 2,"  material change specular Glass2 0.220000");
  fprintf(file, "%*s\n", 2,"  material change shininess Glass2 0.590000");
  fprintf(file, "%*s\n", 2,"  material change opacity Glass2 0.680000");
  fprintf(file, "%*s\n", 2,"  material change outline Glass2 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Glass2 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Glass2 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Glass3 0.150000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Glass3 0.250000");
  fprintf(file, "%*s\n", 2,"  material change specular Glass3 0.750000");
  fprintf(file, "%*s\n", 2,"  material change shininess Glass3 0.800000");
  fprintf(file, "%*s\n", 2,"  material change opacity Glass3 0.500000");
  fprintf(file, "%*s\n", 2,"  material change outline Glass3 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Glass3 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Glass3 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Glossy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Glossy 0.650000");
  fprintf(file, "%*s\n", 2,"  material change specular Glossy 1.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess Glossy 0.880000");
  fprintf(file, "%*s\n", 2,"  material change opacity Glossy 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline Glossy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Glossy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Glossy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient HardPlastic 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse HardPlastic 0.560000");
  fprintf(file, "%*s\n", 2,"  material change specular HardPlastic 0.280000");
  fprintf(file, "%*s\n", 2,"  material change shininess HardPlastic 0.690000");
  fprintf(file, "%*s\n", 2,"  material change opacity HardPlastic 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline HardPlastic 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth HardPlastic 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode HardPlastic 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient MetallicPastel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse MetallicPastel 0.260000");
  fprintf(file, "%*s\n", 2,"  material change specular MetallicPastel 0.550000");
  fprintf(file, "%*s\n", 2,"  material change shininess MetallicPastel 0.190000");
  fprintf(file, "%*s\n", 2,"  material change opacity MetallicPastel 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline MetallicPastel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth MetallicPastel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode MetallicPastel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Steel 0.250000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Steel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change specular Steel 0.380000");
  fprintf(file, "%*s\n", 2,"  material change shininess Steel 0.320000");
  fprintf(file, "%*s\n", 2,"  material change opacity Steel 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline Steel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Steel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Steel 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Translucent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Translucent 0.700000");
  fprintf(file, "%*s\n", 2,"  material change specular Translucent 0.600000");
  fprintf(file, "%*s\n", 2,"  material change shininess Translucent 0.300000");
  fprintf(file, "%*s\n", 2,"  material change opacity Translucent 0.800000");
  fprintf(file, "%*s\n", 2,"  material change outline Translucent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Translucent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode Translucent 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Edgy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Edgy 0.660000");
  fprintf(file, "%*s\n", 2,"  material change specular Edgy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess Edgy 0.750000");
  fprintf(file, "%*s\n", 2,"  material change opacity Edgy 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline Edgy 0.620000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Edgy 0.940000");
  fprintf(file, "%*s\n", 2,"  material change transmode Edgy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient EdgyShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse EdgyShiny 0.660000");
  fprintf(file, "%*s\n", 2,"  material change specular EdgyShiny 0.960000");
  fprintf(file, "%*s\n", 2,"  material change shininess EdgyShiny 0.750000");
  fprintf(file, "%*s\n", 2,"  material change opacity EdgyShiny 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline EdgyShiny 0.760000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth EdgyShiny 0.940000");
  fprintf(file, "%*s\n", 2,"  material change transmode EdgyShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient EdgyGlass 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse EdgyGlass 0.660000");
  fprintf(file, "%*s\n", 2,"  material change specular EdgyGlass 0.500000");
  fprintf(file, "%*s\n", 2,"  material change shininess EdgyGlass 0.750000");
  fprintf(file, "%*s\n", 2,"  material change opacity EdgyGlass 0.620000");
  fprintf(file, "%*s\n", 2,"  material change outline EdgyGlass 0.620000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth EdgyGlass 0.940000");
  fprintf(file, "%*s\n", 2,"  material change transmode EdgyGlass 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient Goodsell 0.520000");
  fprintf(file, "%*s\n", 2,"  material change diffuse Goodsell 1.000000");
  fprintf(file, "%*s\n", 2,"  material change specular Goodsell 0.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess Goodsell 0.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity Goodsell 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline Goodsell 4.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth Goodsell 0.900000");
  fprintf(file, "%*s\n", 2,"  material change transmode Goodsell 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient AOShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse AOShiny 0.850000");
  fprintf(file, "%*s\n", 2,"  material change specular AOShiny 0.200000");
  fprintf(file, "%*s\n", 2,"  material change shininess AOShiny 0.530000");
  fprintf(file, "%*s\n", 2,"  material change opacity AOShiny 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline AOShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth AOShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode AOShiny 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient AOChalky 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse AOChalky 0.850000");
  fprintf(file, "%*s\n", 2,"  material change specular AOChalky 0.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess AOChalky 0.530000");
  fprintf(file, "%*s\n", 2,"  material change opacity AOChalky 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline AOChalky 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth AOChalky 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode AOChalky 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient AOEdgy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change diffuse AOEdgy 0.900000");
  fprintf(file, "%*s\n", 2,"  material change specular AOEdgy 0.200000");
  fprintf(file, "%*s\n", 2,"  material change shininess AOEdgy 0.530000");
  fprintf(file, "%*s\n", 2,"  material change opacity AOEdgy 1.000000");
  fprintf(file, "%*s\n", 2,"  material change outline AOEdgy 0.620000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth AOEdgy 0.930000");
  fprintf(file, "%*s\n", 2,"  material change transmode AOEdgy 0.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient BlownGlass 0.040000");
  fprintf(file, "%*s\n", 2,"  material change diffuse BlownGlass 0.340000");
  fprintf(file, "%*s\n", 2,"  material change specular BlownGlass 1.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess BlownGlass 1.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity BlownGlass 0.100000");
  fprintf(file, "%*s\n", 2,"  material change outline BlownGlass 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth BlownGlass 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode BlownGlass 1.000000");
  fprintf(file, "%*s\n", 2,"  material change ambient GlassBubble 0.250000");
  fprintf(file, "%*s\n", 2,"  material change diffuse GlassBubble 0.340000");
  fprintf(file, "%*s\n", 2,"  material change specular GlassBubble 1.000000");
  fprintf(file, "%*s\n", 2,"  material change shininess GlassBubble 1.000000");
  fprintf(file, "%*s\n", 2,"  material change opacity GlassBubble 0.040000");
  fprintf(file, "%*s\n", 2,"  material change outline GlassBubble 0.000000");
  fprintf(file, "%*s\n", 2,"  material change outlinewidth GlassBubble 0.000000");
  fprintf(file, "%*s\n", 2,"  material change transmode GlassBubble 1.000000");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"vmdrestoremymaterials");
  fprintf(file, "%*s\n", 0,"# Atom selection macros");
  fprintf(file, "%*s\n", 0,"atomselect macro at {resname ADE A THY T");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro acidic {resname ASP GLU");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro cyclic {resname HIS PHE PRO TRP TYR");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro acyclic {protein and not cyclic");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro aliphatic {resname ALA GLY ILE LEU VAL");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro alpha {protein and name CA");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro amino {protein");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro aromatic {resname HIS PHE TRP TYR");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro basic {resname ARG HIS LYS HSP");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro bonded {numbonds > 0");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro buried {resname ALA LEU VAL ILE PHE CYS MET TRP");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro cg {resname CYT C GUA G");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro charged {basic or acidic");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro hetero {not (protein or nucleic)");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro hydrophobic {resname ALA LEU VAL ILE PRO PHE MET TRP");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro small {resname ALA GLY SER");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro medium {resname VAL THR ASP ASN PRO CYS ASX PCA HYP");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro large {protein and not (small or medium)");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro neutral {resname VAL PHE GLN TYR HIS CYS MET TRP ASX GLX PCA HYP");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro polar {protein and not hydrophobic");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro purine {resname ADE A GUA G");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro pyrimidine {resname CYT C THY T URA U");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro surface {protein and not buried");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro lipid {resname DLPE DMPC DPPC GPC LPPC PALM PC PGCL POPC POPE");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro lipids {lipid");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro ion {resname AL BA CA CAL CD CES CLA CL CO CS CU CU1 CUA HG IN IOD K MG MN3 MO3 MO4 MO5 MO6 NA NAW OC7 PB POT PT RB SOD TB TL WO4 YB ZN ZN1 ZN2");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro ions {ion");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro sugar {resname AGLC");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro solvent {not (protein or sugar or nucleic or lipid)");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro carbon {name \"C.*\" and not ion");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro hydrogen {name \"[0-9]?H.*\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro nitrogen {name \"N.*\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro oxygen {name \"O.*\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro sulfur {name \"S.*\" and not ion");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro noh {not hydrogen");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro heme {resname HEM HEME");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationall {altloc \"\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationA {altloc \"\" or altloc \"A\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationB {altloc \"\" or altloc \"B\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationC {altloc \"\" or altloc \"C\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationD {altloc \"\" or altloc \"D\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationE {altloc \"\" or altloc \"E\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro conformationF {altloc \"\" or altloc \"F\"");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro drude {type DRUD or type LP");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"atomselect macro unparametrized beta<1");
  fprintf(file, "%*s\n", 0,"atomselect macro addedmolefacture {occupancy 0.8}");
  fprintf(file, "%*s\n", 0,"# Display settings");
  fprintf(file, "%*s\n", 0,"display eyesep       0.065000");
  fprintf(file, "%*s\n", 0,"display focallength  2.000000");
  fprintf(file, "%*s\n", 0,"display height       6.000000");
  fprintf(file, "%*s\n", 0,"display distance     -2.000000");
  fprintf(file, "%*s\n", 0,"display projection   Perspective");
  fprintf(file, "%*s\n", 0,"display nearclip set 0.500000");
  fprintf(file, "%*s\n", 0,"display farclip  set 10.000000");
  fprintf(file, "%*s\n", 0,"display depthcue   off");
  fprintf(file, "%*s\n", 0,"display cuestart   0.500000");
  fprintf(file, "%*s\n", 0,"display cueend     10.000000");
  fprintf(file, "%*s\n", 0,"display cuestart   0.500000");
  fprintf(file, "%*s\n", 0,"display cueend     10.000000");
  fprintf(file, "%*s\n", 0,"display cuedensity 0.320000");
  fprintf(file, "%*s\n", 0,"display cuemode    Exp2");
  fprintf(file, "%*s\n", 0,"display shadows off");
  fprintf(file, "%*s\n", 0,"display ambientocclusion off");
  fprintf(file, "%*s\n", 0,"display aoambient 0.800000");
  fprintf(file, "%*s\n", 0,"display aodirect 0.300000");
  fprintf(file, "%*s\n", 0,"display dof off");
  fprintf(file, "%*s\n", 0,"display dof_fnumber 64.000000");
  fprintf(file, "%*s\n", 0,"display dof_focaldist 0.700000");
  fprintf(file, "%*s%s%s\n", 0, "mol new ", rep[RDG].c_str(), " type cube first 0 last -1 step 1 filebonds 1 autobonds 1 waitfor all");
  fprintf(file, "%*s%s%s\n", 0, "mol addfile ", rep[DENS].c_str(), " type cube first 0 last -1 step 1 filebonds 1 autobonds 1 waitfor all");
  fprintf(file, "%*s\n", 0,"mol delrep 0 top");
  fprintf(file, "%*s\n", 0,"mol representation CPK 0.600000 0.100000 12.000000 12.000000");
  fprintf(file, "%*s\n", 0,"mol color Name");
  fprintf(file, "%*s\n", 0,"mol selection {all}");
  fprintf(file, "%*s\n", 0,"mol material Opaque");
  fprintf(file, "%*s\n", 0,"mol addrep top");
  fprintf(file, "%*s\n", 0,"mol selupdate 0 top 0");
  fprintf(file, "%*s\n", 0,"mol colupdate 0 top 0");
  fprintf(file, "%*s\n", 0,"mol scaleminmax top 0 0.000000 0.000000");
  fprintf(file, "%*s\n", 0,"mol smoothrep top 0 0");
  fprintf(file, "%*s\n", 0,"mol drawframes top 0 {now}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 0 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  0 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 0 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 0 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 1 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  1 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 1 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 1 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 2 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  2 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 2 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 2 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 3 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  3 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 3 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 3 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 4 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  4 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 4 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 4 0 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 5 0 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  5 0 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 5 0 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 5 0 top {0}");
  fprintf(file, "%*s%s%s\n", 0, "mol representation Isosurface ", rep[CUTPLOT2].c_str(), " 0 0 0 1 1");
  fprintf(file, "%*s\n", 0,"mol color Volume 1");
  fprintf(file, "%*s\n", 0,"mol selection {all}");
  fprintf(file, "%*s\n", 0,"mol material Opaque");
  fprintf(file, "%*s\n", 0,"mol addrep top");
  fprintf(file, "%*s\n", 0,"mol selupdate 1 top 0");
  fprintf(file, "%*s\n", 0,"mol colupdate 1 top 0");
  fprintf(file, "%*s%s%s%s%s\n", 0, "mol scaleminmax top 1 -", rep[CUTPLOT1].c_str(), " ", rep[CUTPLOT1].c_str(), "");
  fprintf(file, "%*s\n", 0,"mol smoothrep top 1 0");
  fprintf(file, "%*s\n", 0,"mol drawframes top 1 {now}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 0 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  0 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 0 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 0 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 1 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  1 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 1 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 1 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 2 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  2 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 2 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 2 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 3 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  3 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 3 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 3 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 4 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  4 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 4 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 4 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol clipplane center 5 1 top {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane color  5 1 top {0.5 0.5 0.5 }");
  fprintf(file, "%*s\n", 0,"mol clipplane normal 5 1 top {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"mol clipplane status 5 1 top {0}");
  fprintf(file, "%*s\n", 0,"mol rename top RDG.cube");
  //fprintf(file, "%*s\n", 0,"set viewpoints([molinfo top]) {{{1 0 0 -0.104413} {0 1 0 -0.00878046} {0 0 1 0} {0 0 0 1}} {{0.894917 -0.249936 -0.369662 0} {0.445913 0.531933 0.719865 0} {0.0167139 -0.80906 0.587488 0} {0 0 0 1}} {{0.414977 0 0 0} {0 0.414977 0 0} {0 0 0.414977 0} {0 0 0 1}} {{1 0 0 0} {0 1 0 0} {0 0 1 0} {0 0 0 1}}}");
  //fprintf(file, "%*s\n", 0,"lappend viewplist [molinfo top]");
  fprintf(file, "%*s\n", 0,"set topmol [molinfo top]");
  fprintf(file, "%*s\n", 0,"# done with molecule 0");
  //fprintf(file, "%*s\n", 0,"foreach v $viewplist {");
  //fprintf(file, "%*s\n", 2,"  molinfo $v set {center_matrix rotate_matrix scale_matrix global_matrix} $viewpoints($v)");
  //fprintf(file, "%*s\n", 0,"}");
  //fprintf(file, "%*s\n", 0,"foreach v $fixedlist {");
  //fprintf(file, "%*s\n", 2,"  molinfo $v set fixed 1");
  //fprintf(file, "%*s\n", 0,"}");
  //fprintf(file, "%*s\n", 0,"unset viewplist");
  //fprintf(file, "%*s\n", 0,"unset fixedlist");
  fprintf(file, "%*s\n", 0,"mol top $topmol");
  fprintf(file, "%*s\n", 0,"unset topmol");
  fprintf(file, "%*s\n", 0,"proc vmdrestoremycolors {} {");
  fprintf(file, "%*s\n", 0,"color scale colors RWB {1.0 0.0 0.0} {1.0 1.0 1.0} {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"color scale colors BWR {0.0 0.0 1.0} {1.0 1.0 1.0} {1.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"color scale colors RGryB {1.0 0.0 0.0} {0.5 0.5 0.5} {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"color scale colors BGryR {0.0 0.0 1.0} {0.5 0.5 0.5} {1.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"color scale colors RGB {1.0 0.0 0.0} {0.0 1.0 0.0} {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"color scale colors BGR {0.0 0.0 1.0} {0.0 1.0 0.0} {1.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"color scale colors RWG {1.0 0.0 0.0} {1.0 1.0 1.0} {0.0 1.0 0.0}");
  fprintf(file, "%*s\n", 0,"color scale colors GWR {0.0 1.0 0.0} {1.0 1.0 1.0} {1.0 0.0 0.0}");
  fprintf(file, "%*s\n", 0,"color scale colors GWB {0.0 1.0 0.0} {1.0 1.0 1.0} {0.0 0.0 1.0}");
  fprintf(file, "%*s\n", 0,"color scale colors BWG {0.0 0.0 1.0} {1.0 1.0 1.0} {0.0 1.0 0.0}");
  fprintf(file, "%*s\n", 0,"color scale colors BlkW {0.0 0.0 0.0} {0.5 0.5 0.5} {1.0 1.0 1.0}");
  fprintf(file, "%*s\n", 0,"color scale colors WBlk {1.0 1.0 1.0} {0.5 0.5 0.5} {0.0 0.0 0.0}");
  fprintf(file, "%*s\n", 2,"  color scale method BGR");
  fprintf(file, "%*s\n", 2,"  set colorcmds {");
  fprintf(file, "%*s\n", 4,"    {color Display {BackgroundTop} black}");
  fprintf(file, "%*s\n", 4,"    {color Display {BackgroundBot} blue2}");
  fprintf(file, "%*s\n", 4,"    {color Display {FPS} white}");
  fprintf(file, "%*s\n", 4,"    {color Name {LPA} green}");
  fprintf(file, "%*s\n", 4,"    {color Name {LPB} green}");
  fprintf(file, "%*s\n", 4,"    {color Type {LP} green}");
  fprintf(file, "%*s\n", 4,"    {color Type {DRUD} pink}");
  fprintf(file, "%*s\n", 4,"    {color Element {X} cyan}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ac} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ag} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Al} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Am} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ar} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {As} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {At} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Au} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {B} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ba} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Be} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Bh} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Bi} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Bk} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Br} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ca} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cd} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ce} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cf} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cl} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cm} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Co} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cs} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Cu} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Db} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ds} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Dy} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Er} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Es} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Eu} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {F} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Fe} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Fm} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Fr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ga} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Gd} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ge} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {He} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Hf} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Hg} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ho} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Hs} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {I} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {In} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ir} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {K} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Kr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {La} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Li} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Lr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Lu} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Md} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Mg} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Mn} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Mo} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Mt} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Na} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Nb} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Nd} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ne} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ni} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {No} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Np} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Os} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pa} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pb} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pd} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pm} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Po} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pt} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Pu} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ra} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Rb} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Re} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Rf} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Rg} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Rh} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Rn} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ru} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Sb} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Sc} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Se} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Sg} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Si} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Sm} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Sn} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Sr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ta} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Tb} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Tc} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Te} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Th} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Ti} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Tl} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Tm} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {U} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {V} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {W} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Xe} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Y} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Yb} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Element {Zr} ochre}");
  fprintf(file, "%*s\n", 4,"    {color Resname {} silver}");
  fprintf(file, "%*s\n", 4,"    {color Chain {X} blue}");
  fprintf(file, "%*s\n", 4,"    {color Segname {} blue}");
  fprintf(file, "%*s\n", 4,"    {color Conformation {all} blue}");
  fprintf(file, "%*s\n", 4,"    {color Molecule {0} blue}");
  fprintf(file, "%*s\n", 4,"    {color Molecule {RDG.cube} blue}");
  fprintf(file, "%*s\n", 4,"    {color Structure {3_10_Helix} blue}");
  fprintf(file, "%*s\n", 4,"    {color Surface {Grasp} gray}");
  fprintf(file, "%*s\n", 4,"    {color Labels {Springs} orange}");
  fprintf(file, "%*s\n", 4,"    {color Stage {Even} gray}");
  fprintf(file, "%*s\n", 4,"    {color Stage {Odd} silver}");
  fprintf(file, "%*s\n", 2,"  }");
  fprintf(file, "%*s\n", 2,"  foreach colcmd $colorcmds {");
  fprintf(file, "%*s\n", 4,"    set val [catch {eval $colcmd}]");
  fprintf(file, "%*s\n", 2,"  }");
  fprintf(file, "%*s\n", 2,"  color change rgb 0 0.0 0.0 1.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 2 0.3499999940395355 0.3499999940395355 0.3499999940395355");
  fprintf(file, "%*s\n", 2,"  color change rgb 3 1.0 0.5 0.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 4 1.0 1.0 0.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 5 0.5 0.5 0.20000000298023224");
  fprintf(file, "%*s\n", 2,"  color change rgb 6 0.6000000238418579 0.6000000238418579 0.6000000238418579");
  fprintf(file, "%*s\n", 2,"  color change rgb 7 0.0 1.0 0.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 9 1.0 0.6000000238418579 0.6000000238418579");
  fprintf(file, "%*s\n", 2,"  color change rgb 11 0.6499999761581421 0.0 0.6499999761581421");
  fprintf(file, "%*s\n", 2,"  color change rgb 12 0.5 0.8999999761581421 0.4000000059604645");
  fprintf(file, "%*s\n", 2,"  color change rgb 13 0.8999999761581421 0.4000000059604645 0.699999988079071");
  fprintf(file, "%*s\n", 2,"  color change rgb 14 0.5 0.30000001192092896 0.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 15 0.5 0.5 0.75");
  fprintf(file, "%*s\n", 2,"  color change rgb 17 0.8799999952316284 0.9700000286102295 0.019999999552965164");
  fprintf(file, "%*s\n", 2,"  color change rgb 18 0.550000011920929 0.8999999761581421 0.019999999552965164");
  fprintf(file, "%*s\n", 2,"  color change rgb 19 0.0 0.8999999761581421 0.03999999910593033");
  fprintf(file, "%*s\n", 2,"  color change rgb 20 0.0 0.8999999761581421 0.5");
  fprintf(file, "%*s\n", 2,"  color change rgb 21 0.0 0.8799999952316284 1.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 22 0.0 0.7599999904632568 1.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 23 0.019999999552965164 0.3799999952316284 0.6700000166893005");
  fprintf(file, "%*s\n", 2,"  color change rgb 24 0.009999999776482582 0.03999999910593033 0.9300000071525574");
  fprintf(file, "%*s\n", 2,"  color change rgb 25 0.27000001072883606 0.0 0.9800000190734863");
  fprintf(file, "%*s\n", 2,"  color change rgb 26 0.44999998807907104 0.0 0.8999999761581421");
  fprintf(file, "%*s\n", 2,"  color change rgb 27 0.8999999761581421 0.0 0.8999999761581421");
  fprintf(file, "%*s\n", 2,"  color change rgb 28 1.0 0.0 0.6600000262260437");
  fprintf(file, "%*s\n", 2,"  color change rgb 29 0.9800000190734863 0.0 0.23000000417232513");
  fprintf(file, "%*s\n", 2,"  color change rgb 30 0.8100000023841858 0.0 0.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 31 0.8899999856948853 0.3499999940395355 0.0");
  fprintf(file, "%*s\n", 2,"  color change rgb 32 0.9599999785423279 0.7200000286102295 0.0");
  fprintf(file, "%*s\n", 0,"}");
  fprintf(file, "%*s\n", 0,"vmdrestoremycolors");
  fprintf(file, "%*s\n", 0,"label textsize 1.0");
  fprintf(file, "%*s\n", 0,"");
  fprintf(file, "%*s\n", 0,"axes location Off");
  fprintf(file, "%*s\n", 0,"display rendermode GLSL");
  fprintf(file, "%*s\n", 0,"display depthcue off");
  fprintf(file, "%*s\n", 0,"");
  fclose(file);
}


// Function to remove spaces 
std::string convertToVMDAtomSelect(std::string str)
{

    std::stringstream ss;
    std::string tmp;

    // Storing the whole string 
    // into string stream 
    ss << str;

    // Making the string empty 
    str = "";

    // ==================================== //
    //    d e a l   w i t h    s p a c e s  //
    // ==================================== //
      
    while (!ss.eof()) {

        // Extracting word by word from stream 
        ss >> tmp;


        // replace the space by ") or (" string
        tmp = tmp + ") or (serial ";

        // Concatenating in the string to be  returned
        str = str + tmp;

        // clear the temporary variable
        tmp="";

    } // end of WHILE

    // ============================================ //
    //     r e f i n e d  b e g i n  a n d   e n d 
    // ============================================ //

    str = "(serial " + str;
    str = str.substr(0,str.size()-12);
    
    // ==================================== //
    //    d e a l   w i t h     d a s h e s //
    // ==================================== //
    size_t pos;
    std::string x = "-";
    std::string y = " to ";
    while ((pos = str.find(x)) != std::string::npos) {
        str.replace(pos, 1, y);
    }

    return str;
} // end of convertToVMDAtomSelect


#endif
