# Derived from nixpkgs f870c6ccc8951fc48aeb293cf3e98ade6ac42668 by instrumenting
# builtins.match to collect at most 2 non-matching and 2 matching cases of every
# regex used when running:
# `nix-env --query --available --out-path --eval-system x86_64-linux`.

builtins.map
  (
    list:
    let
      re = builtins.head list;
      str = builtins.elemAt list 1;
    in
    builtins.match re str
  )
  [
    [
      ''(.*)e?abi.*''
      ''linux''
    ]
    [
      ''(.*)e?abi.*''
      ''linux''
    ]
    [
      ''.*-none.*''
      ''x86_64-unknown-linux-gnu''
    ]
    [
      ''.*nvptx.*''
      ''x86_64-unknown-linux-gnu''
    ]
    [
      ''.*switch.*''
      ''x86_64-unknown-linux-gnu''
    ]
    [
      ''.*-uefi.*''
      ''x86_64-unknown-linux-gnu''
    ]
    [
      ''.*-none.*''
      ''x86_64-unknown-linux-gnu''
    ]
    [
      ''.*nvptx.*''
      ''x86_64-unknown-linux-gnu''
    ]
    [
      ''.*switch.*''
      ''x86_64-unknown-linux-gnu''
    ]
    [
      ''.*-uefi.*''
      ''x86_64-unknown-linux-gnu''
    ]
    [
      ''[[:alnum:]+_?=-][[:alnum:]+._?=-]*''
      ''bootstrap-stage0-glibc-bootstrapFiles''
    ]
    [
      ''[[:alnum:]+_?=-][[:alnum:]+._?=-]*''
      ''glibc-2.40-66''
    ]
    [
      ''mirror://([a-z]+)/(.*)''
      ''https://github.com/madler/zlib/releases/download/v1.3.1/zlib-1.3.1.tar.gz''
    ]
    [
      ''mirror://([a-z]+)/(.*)''
      ''https://git.savannah.gnu.org/cgit/config.git/plain/config.guess?id=948ae97ca5703224bd3eada06b7a69f40dd15a02''
    ]
    [
      ''.*/.*''
      ''mktemp''
    ]
    [
      ''.*/.*''
      ''rm''
    ]
    [
      ''mirror://([a-z]+)/(.*)''
      ''mirror://gnu/m4/m4-1.4.19.tar.bz2''
    ]
    [
      ''5\.[0-9]*[13579]\..+''
      ''5.40.0''
    ]
    [
      ''mirror://([a-z]+)/(.*)''
      ''mirror://cpan/src/5.0/perl-5.40.0.tar.gz''
    ]
    [
      ''5\.[0-9]*[13579]\..+''
      ''5.40.0''
    ]
    [
      ''^([0-9][0-9\.]*)(.*)$''
      ''addons''
    ]
    [
      ''^([0-9][0-9\.]*)(.*)$''
      ''extras''
    ]
    [
      ''^([0-9][0-9\.]*)(.*)$''
      ''10''
    ]
    [
      ''^([0-9][0-9\.]*)(.*)$''
      ''11''
    ]
    [
      ''[[:space:]]*0*(-?[[:digit:]]+)[[:space:]]*''
      ''36''
    ]
    [
      ''0+''
      ''36''
    ]
    [
      ''/bin/([^/]+)''
      ''/bin/exec''
    ]
    [
      ''[[:alnum:],._+:@%/-]+''
      ''/bin/exec''
    ]
    [
      ''[[:alnum:],._+:@%/-]+''
      ''''
    ]
    [
      ''[[:space:]]*(-?[[:digit:]]+)[[:space:]]*''
      ''26''
    ]
    [
      ''0[[:digit:]]+''
      ''26''
    ]
    [
      ''[[:space:]]*(-?[[:digit:]]+)[[:space:]]*''
      ''26''
    ]
    [
      ''0[[:digit:]]+''
      ''26''
    ]
    [
      ''[[:alnum:],._+:@%/-]+''
      ''@tcl@''
    ]
    [
      ''[[:alnum:],._+:@%/-]+''
      ''@[a-zA-Z_][0-9A-Za-z_'-]*@''
    ]
    [
      ''.*pypy.*''
      ''/nix/store/8w718rm43x7z73xhw9d6vh8s4snrq67h-python3-3.12.10/bin/python3.12''
    ]
    [
      ''(.*/)?\.\.(/.*)?''
      ''package.nix''
    ]
    [
      ''/bin/([^/]+)''
      ''''
    ]
    [
      ''[[:alnum:]+_?=-][[:alnum:]+._?=-]*''
      ''meson.patch?h=mingw-w64-xorgproto&id=7b817efc3144a50e6766817c4ca7242f8ce49307''
    ]
    [
      ''\.*(.*)''
      ''meson.patch?h=mingw-w64-xorgproto&id=7b817efc3144a50e6766817c4ca7242f8ce49307''
    ]
    [
      ''/bin/([^/]+)''
      ''''
    ]
    [
      ''.*-rc.*''
      ''2.49.0''
    ]
    [
      ''(.*)\.git''
      ''xmlto.git''
    ]
    [
      ''[a-f0-9]*''
      ''0.0.29''
    ]
    [
      ''.*-rc.*''
      ''2.49.0''
    ]
    [
      ''/bin/([^/]+)''
      ''/bin/exec''
    ]
    [
      ''.*-polly.*''
      ''/nix/store/0yxfdnfxbzczjxhgdpac81jnas194wfj-gnu-install-dirs.patch''
    ]
    [
      ''.*-polly.*''
      ''/nix/store/jh2pda7psaasq85b2rrigmkjdbl8d0a1-llvm-lit-cfg-add-libs-to-dylib-path.patch''
    ]
    [
      ''.*-polly.*''
      ''/nix/store/x868j4ih7wqiivf6wr9m4g424jav0hpq-gnu-install-dirs-polly.patch''
    ]
    [
      ''.*-polly.*''
      ''/nix/store/gr73nf6sca9nyzl88x58y3qxrav04yhd-polly-lit-cfg-add-libs-to-dylib-path.patch''
    ]
    [
      ''(.*/)?\.\.(/.*)?''
      ''package.nix''
    ]
    [
      ''[[:alnum:]+_?=-][[:alnum:]+._?=-]*''
      ''coconutbattery-4.0.2,152''
    ]
    [
      ''\.*(.*)''
      ''coconutbattery-4.0.2,152''
    ]
    [
      ''^([[:digit:]]+)\.([[:digit:]]+)$''
      ''12.0''
    ]
    [
      ''^([[:digit:]]+)\.([[:digit:]]+)$''
      ''12.8''
    ]
    [
      ''^([[:digit:]]+)\.([[:digit:]]+)\.([[:digit:]]+)\.([[:digit:]]+)$''
      ''8.9.5.30''
    ]
    [
      ''^([[:digit:]]+)\.([[:digit:]]+)\.([[:digit:]]+)\.([[:digit:]]+)$''
      ''9.7.1.26''
    ]
    [
      ''^/.*''
      ''8.20''
    ]
    [
      ''^/.*''
      ''8.20''
    ]
    [
      ''^github.*''
      ''github.com''
    ]
    [
      ''^github.*''
      ''github.com''
    ]
    [
      ''^github.*''
      ''gitlab.inria.fr''
    ]
    [
      ''^gitlab.*''
      ''gitlab.inria.fr''
    ]
    [
      ''^github.*''
      ''gitlab.inria.fr''
    ]
    [
      ''^gitlab.*''
      ''gitlab.inria.fr''
    ]
    [
      ''^gitlab.*''
      ''sf.snu.ac.kr''
    ]
    [
      ''^gitlab.*''
      ''sf.snu.ac.kr''
    ]
    [
      ''^(@([^/]+)/)?([^/]+)$''
      ''draupnir''
    ]
    [
      ''^[[:digit:]].*''
      ''0xproto''
    ]
    [
      ''^[[:digit:]].*''
      ''3270''
    ]
    [
      ''^[[:digit:]].*''
      ''adwaita-mono''
    ]
    [
      ''^[[:digit:]].*''
      ''agave''
    ]
    [
      ''^(@([^/]+)/)?([^/]+)$''
      ''renderer''
    ]
    [
      ''[^[:space:]]*''
      ''900,906,908,1010,1012,1030''
    ]
    [
      ''[^[:space:]]*''
      ''''
    ]
    [
      ''.*[0-9]_LIN(UX)?.sh''
      ''Wolfram_14.2.1_LIN.sh''
    ]
    [
      ''.*[0-9]_LIN(UX)?.sh''
      ''Wolfram_14.2.1_LIN_Bndl.sh''
    ]
    [
      ''.*[0-9]_LIN(UX)?.sh''
      ''Wolfram_14.2.0_LIN.sh''
    ]
    [
      ''.*[0-9]_LIN(UX)?.sh''
      ''Wolfram_14.2.0_LIN_Bndl.sh''
    ]
    [
      ''[A-Z]''
      ''b''
    ]
    [
      ''[A-Z]''
      ''l''
    ]
    [
      ''[A-Z]''
      ''E''
    ]
    [
      ''[A-Z]''
      ''T''
    ]
    [
      ''([0-9A-Za-z._])[0-9A-Za-z._-]*''
      ''pythoncheck.sh''
    ]
    [
      ''([0-9A-Za-z._])[0-9A-Za-z._-]*''
      ''pythoncheck.sh''
    ]
    [
      ''(.*)\.git''
      ''systemtap.git''
    ]
    [
      ''[a-f0-9]*''
      ''release-5.2''
    ]
    [
      ''[a-f0-9]*''
      ''b7a857659f8485ee3c6769c27a3e74b0af910746''
    ]
    [
      ''.*pypy.*''
      ''/nix/store/8w718rm43x7z73xhw9d6vh8s4snrq67h-python3-3.12.10/bin/python3.12''
    ]
    [
      ''(.*)\.git''
      ''gn''
    ]
    [
      ''[a-f0-9]*''
      ''df98b86690c83b81aedc909ded18857296406159''
    ]
    [
      ''.*-rc\..*''
      ''22.14.0''
    ]
    [
      ''.*/linux-gecko-(.*).tar.bz2''
      ''https://static.replay.io/downloads/linux-gecko-20220722-71c783507536-b7eae18423ef.tar.bz2''
    ]
    [
      ''.*/linux-node-(.*)''
      ''https://static.replay.io/downloads/linux-node-20220726-bac6d66b5ca1-5b966f2f136c''
    ]
    [
      ''.*-DSQLITE_ENABLE_FTS3.*''
      ''-DSQLITE_ENABLE_COLUMN_METADATA -DSQLITE_ENABLE_DBSTAT_VTAB -DSQLITE_ENABLE_JSON1 -DSQLITE_ENABLE_FTS3 -DSQLITE_ENABLE_FTS3_PARENTHESIS -DSQLITE_ENABLE_FTS3_TOKENIZER -DSQLITE_ENABLE_FTS4 -DSQLITE_ENABLE_FTS5 -DSQLITE_ENABLE_PREUPDATE_HOOK -DSQLITE_ENABLE_RTREE -DSQLITE_ENABLE_SESSION -DSQLITE_ENABLE_STMT_SCANSTATUS -DSQLITE_ENABLE_UNLOCK_NOTIFY -DSQLITE_SOUNDEX -DSQLITE_SECURE_DELETE -DSQLITE_MAX_VARIABLE_NUMBER=250000 -DSQLITE_MAX_EXPR_DEPTH=10000''
    ]
    [
      ''
        [ 	
        ]*(.*[^ 	
        ])[ 	
        ]*''
      ''
        0.3.2308
      ''
    ]
    [
      ''(.*)\.git''
      ''rtmpdump''
    ]
    [
      ''.*;.*''
      ''Game''
    ]
    [
      ''.*;.*''
      ''Game''
    ]
    [
      ''(.+)+(.+)''
      ''17.0.14+7''
    ]
    [
      ''^#(.*)$''
      ''20240715''
    ]
    [
      ''[[:alpha:]_][[:alnum:]_]*(\.[[:alpha:]_][[:alnum:]_]*)*''
      ''external_deps_dirs''
    ]
    [
      ''[[:alpha:]_][[:alnum:]_]*(\.[[:alpha:]_][[:alnum:]_]*)*''
      ''local_cache''
    ]
    [
      ''^#(.*)$''
      ''20240715''
    ]
    [
      ''.*-rc\..*''
      ''20.19.2''
    ]
    [
      ''(.+)+(.+)''
      ''21.0.7+6''
    ]
    [
      ''.*llvm-tblgen.*''
      ''-DLLVM_INSTALL_PACKAGE_DIR:STRING=/02qcpld1y6xhs5gz9bchpxaw0xdhmsp5dv88lh25r2ss44kh8dxz/lib/cmake/llvm''
    ]
    [
      ''.*llvm-tblgen.*''
      ''-DLLVM_ENABLE_RTTI:BOOL=TRUE''
    ]
    [
      ''.*llvm-tblgen.*''
      ''-DLLVM_TABLEGEN:STRING=/nix/store/xp9hkw8nsw9p81d69yvcg1yr6f7vh71c-llvm-tblgen-18.1.8/bin/llvm-tblgen''
    ]
    [
      ''.*llvm-tblgen.*''
      ''-DLLVM_TABLEGEN_EXE:STRING=/nix/store/xp9hkw8nsw9p81d69yvcg1yr6f7vh71c-llvm-tblgen-18.1.8/bin/llvm-tblgen''
    ]
    [
      ''(.+)-b(.+)''
      ''8u442-b06''
    ]
    [
      ''.*-DSQLITE_ENABLE_FTS3.*''
      ''-DSQLITE_ENABLE_COLUMN_METADATA -DSQLITE_ENABLE_DBSTAT_VTAB -DSQLITE_ENABLE_JSON1 -DSQLITE_ENABLE_FTS3 -DSQLITE_ENABLE_FTS3_PARENTHESIS -DSQLITE_ENABLE_FTS3_TOKENIZER -DSQLITE_ENABLE_FTS4 -DSQLITE_ENABLE_FTS5 -DSQLITE_ENABLE_PREUPDATE_HOOK -DSQLITE_ENABLE_RTREE -DSQLITE_ENABLE_SESSION -DSQLITE_ENABLE_STMT_SCANSTATUS -DSQLITE_ENABLE_UNLOCK_NOTIFY -DSQLITE_SOUNDEX -DSQLITE_SECURE_DELETE -DSQLITE_MAX_VARIABLE_NUMBER=250000 -DSQLITE_MAX_EXPR_DEPTH=10000''
    ]
    [
      ''([^/]*)/([^/]*)(/SNAPSHOT)?(/.*)?''
      ''jna/5.6.0''
    ]
    [
      ''([^/]*)/([^/]*)(/SNAPSHOT)?(/.*)?''
      ''jna/5.6.0''
    ]
    [
      ''[0-9]+''
      ''2''
    ]
    [
      ''[0-9]+''
      ''3''
    ]
    [
      ''[0-9]+''
      ''unstable''
    ]
    [
      ''[[:space:]]*0*(-?[[:digit:]]+)[[:space:]]*''
      ''2''
    ]
    [
      ''0+''
      ''2''
    ]
    [
      ''0+''
      ''0''
    ]
    [
      ''.*org/eclipse/jdt/ecj.*''
      ''https://repo.maven.apache.org/maven2/org/eclipse/jdt/ecj/maven-metadata.xml''
    ]
    [
      ''.*[<>"'&].*''
      ''org.eclipse.jdt''
    ]
    [
      ''.*[<>"'&].*''
      ''20241203050026''
    ]
    [
      ''[a-zA-Z_][a-zA-Z0-9_'-]*''
      ''cpu''
    ]
    [
      ''[a-zA-Z_][a-zA-Z0-9_'-]*''
      ''bits''
    ]
    [
      ''armv[67]l-linux''
      ''x86_64-linux''
    ]
    [
      ''armv[67]l-linux''
      ''x86_64-linux''
    ]
    [
      ''0+''
      ''0''
    ]
    [
      ''[0-9]+''
      ''rc''
    ]
    [
      ''.*tensorflow_cpu.*''
      ''https://storage.googleapis.com/tensorflow/versions/2.19.0/tensorflow_cpu-2.19.0-cp312-cp312-manylinux_2_17_x86_64.manylinux2014_x86_64.whl''
    ]
    [
      ''git\+([^?]+)(\?(rev|tag|branch)=(.*))?#(.*)''
      ''git+https://github.com/GRA0007/google-cloud-rs.git#4a2db92efd57a896e14d18877458c6ae43418aec''
    ]
    [
      ''git\+([^?]+)(\?(rev|tag|branch)=(.*))?#(.*)''
      ''git+https://github.com/GRA0007/google-cloud-rs.git#4a2db92efd57a896e14d18877458c6ae43418aec''
    ]
    [
      ''mpv[-_](.*)''
      ''detect-image''
    ]
    [
      ''.*org/bouncycastle/bcutil-lts8on.*''
      ''https://plugins.gradle.org/m2/org/bouncycastle/bcutil-lts8on/maven-metadata.xml''
    ]
    [
      ''^.*-unstable-([[:digit:]]{4})-([[:digit:]]{2})-([[:digit:]]{2})$''
      ''0.9.0''
    ]
    [
      ''(.+)/(.+)''
      ''rejeep/ansi.el''
    ]
    [
      ''^.*-unstable-([[:digit:]]{4})-([[:digit:]]{2})-([[:digit:]]{2})$''
      ''20230306.1823''
    ]
    [
      ''(.+)/(.+)''
      ''rejeep/commander.el''
    ]
    [
      ''mpv[-_](.*)''
      ''equalizer''
    ]
    [
      ''(.*)-([^-]*)-([^-]*)''
      ''2.2.4-20231021.200112-6''
    ]
    [
      ''(.*)-([^-]*)-([^-]*)''
      ''2.2.4-20231021.200112-6''
    ]
    [
      ''.*com/badlogicgames/gdx-controllers/gdx-controllers-core.*''
      ''https://oss.sonatype.org/content/repositories/snapshots/com/badlogicgames/gdx-controllers/gdx-controllers-core/2.2.4-SNAPSHOT/maven-metadata.xml''
    ]
    [
      ''.*com/badlogicgames/gdx-controllers/gdx-controllers-desktop.*''
      ''https://oss.sonatype.org/content/repositories/snapshots/com/badlogicgames/gdx-controllers/gdx-controllers-desktop/2.2.4-SNAPSHOT/maven-metadata.xml''
    ]
    [
      ''^(#.*|$)''
      ''.git''
    ]
    [
      ''^(#.*|$)''
      ''__pycache__''
    ]
    [
      ''^(#.*|$)''
      ''''
    ]
    [
      ''^(!?)(.*)''
      ''.git''
    ]
    [
      ''^(/?)(.*)''
      ''\.git''
    ]
    [
      ''.+/.+''
      ''\.git''
    ]
    [
      ''^(.*)/$''
      ''(^|.*/)\.git''
    ]
    [
      ''(^|.*/)\.git''
      ''.flake8''
    ]
    [
      ''^(!?)(.*)''
      ''__pycache__''
    ]
    [
      ''^(/?)(.*)''
      ''__pycache__''
    ]
    [
      ''.+/.+''
      ''__pycache__''
    ]
    [
      ''^(.*)/$''
      ''(^|.*/)__pycache__''
    ]
    [
      ''(^|.*/)__pycache__''
      ''.flake8''
    ]
    [
      ''^(#.*|$)''
      ''''
    ]
    [
      ''(^|.*/)\.git''
      ''.gitignore''
    ]
    [
      ''(^|.*/)__pycache__''
      ''.gitignore''
    ]
    [
      ''^[a-fA-F0-9]{40}$''
      ''3a667bdb3d7f0955a5a51c8468eac83210c1439e''
    ]
    [
      ''.*com/android/tools/build/gradle.*''
      ''https://repo.maven.apache.org/maven2/com/android/tools/build/gradle/maven-metadata.xml''
    ]
    [
      ''^[a-fA-F0-9]{40}$''
      ''dc0a228a5544988d4a920cfb40be9cd28db41423''
    ]
    [
      ''(.+)-b(.+)''
      ''8u442-b06''
    ]
    [
      ''.*com/tobiasdiez/easybind.*''
      ''https://oss.sonatype.org/content/groups/public/com/tobiasdiez/easybind/2.2.1-SNAPSHOT/maven-metadata.xml''
    ]
    [
      ''.*org/hamcrest/hamcrest.*''
      ''https://repo.maven.apache.org/maven2/org/hamcrest/hamcrest/maven-metadata.xml''
    ]
    [
      ''^.*CONFIG_BOARD_DIRECTORY="([a-zA-Z0-9_]+)".*$''
      ''
        # CONFIG_LOW_LEVEL_OPTIONS is not set
        # CONFIG_MACH_AVR is not set
        # CONFIG_MACH_ATSAM is not set
        # CONFIG_MACH_ATSAMD is not set
        # CONFIG_MACH_LPC176X is not set
        # CONFIG_MACH_STM32 is not set
        # CONFIG_MACH_HC32F460 is not set
        # CONFIG_MACH_RPXXXX is not set
        # CONFIG_MACH_PRU is not set
        # CONFIG_MACH_AR100 is not set
        # CONFIG_MACH_LINUX is not set
        CONFIG_MACH_SIMU=y
        CONFIG_BOARD_DIRECTORY="simulator"
        CONFIG_CLOCK_FREQ=20000000
        CONFIG_SERIAL=y
        CONFIG_SIMULATOR_SELECT=y
        CONFIG_SERIAL_BAUD=250000
        CONFIG_USB_VENDOR_ID=0x1d50
        CONFIG_USB_DEVICE_ID=0x614e
        CONFIG_USB_SERIAL_NUMBER="12345"
        CONFIG_WANT_ADC=y
        CONFIG_WANT_SPI=y
        CONFIG_WANT_SOFTWARE_SPI=y
        CONFIG_WANT_HARD_PWM=y
        CONFIG_WANT_BUTTONS=y
        CONFIG_WANT_TMCUART=y
        CONFIG_WANT_NEOPIXEL=y
        CONFIG_WANT_PULSE_COUNTER=y
        CONFIG_WANT_ST7920=y
        CONFIG_WANT_HD44780=y
        CONFIG_WANT_ADXL345=y
        CONFIG_WANT_LIS2DW=y
        CONFIG_WANT_THERMOCOUPLE=y
        CONFIG_WANT_HX71X=y
        CONFIG_WANT_ADS1220=y
        CONFIG_WANT_SENSOR_ANGLE=y
        CONFIG_NEED_SENSOR_BULK=y
        CONFIG_CANBUS_FREQUENCY=1000000
        CONFIG_INLINE_STEPPER_HACK=y
        CONFIG_HAVE_GPIO=y
        CONFIG_HAVE_GPIO_ADC=y
        CONFIG_HAVE_GPIO_SPI=y
        CONFIG_HAVE_GPIO_HARD_PWM=y
      ''
    ]
    [
      ''[^.]*[.][^.]*-.*''
      ''5.15.183-rt85''
    ]
    [
      ''[^.]*[.][^.]*-.*''
      ''6.1.134-rt51''
    ]
    [
      ''^\.sw[a-z]$''
      ''package.nix''
    ]
    [
      ''^\..*\.sw[a-z]$''
      ''package.nix''
    ]
    [
      ''^\.sw[a-z]$''
      ''pyproject.toml''
    ]
    [
      ''^\..*\.sw[a-z]$''
      ''pyproject.toml''
    ]
    [
      ''mpv[-_](.*)''
      ''mpv-notify-send''
    ]
    [
      ''mpv[-_](.*)''
      ''mpv-playlistmanager''
    ]
    [
      ''.*ch/qos/logback/logback-core.*''
      ''https://repo.maven.apache.org/maven2/ch/qos/logback/logback-core/maven-metadata.xml''
    ]
    [
      ''.*commons-codec/commons-codec.*''
      ''https://repo.maven.apache.org/maven2/commons-codec/commons-codec/maven-metadata.xml''
    ]
    [
      ''/[0-9a-z]{52}''
      ''/run/opengl-driver''
    ]
    [
      ''/[0-9a-z]{52}''
      ''/dev/dri''
    ]
    [
      ''<(.*)>''
      ''_module''
    ]
    [
      ''<(.*)>''
      ''args''
    ]
    [
      ''<(.*)>''
      ''<name>''
    ]
    [
      ''<(.*)>''
      ''<name>''
    ]
    [
      ''[a-zA-Z_][a-zA-Z0-9_'-]*''
      ''2bwm''
    ]
    [
      ''[a-zA-Z_][a-zA-Z0-9_'-]*''
      ''pm.max_children''
    ]
    [
      ''(pypy|python)([[:digit:]]*)''
      ''override''
    ]
    [
      ''(pypy|python)([[:digit:]]*)''
      ''overrideDerivation''
    ]
    [
      ''(pypy|python)([[:digit:]]*)''
      ''pypy27''
    ]
    [
      ''(pypy|python)([[:digit:]]*)''
      ''pypy310''
    ]
    [
      ''^ref: (.*)$''
      ''ref: refs/heads/master''
    ]
    [
      ''^ref: (.*)$''
      ''f870c6ccc8951fc48aeb293cf3e98ade6ac42668''
    ]
    [
      ''^ref: (.*)$''
      ''ref: refs/heads/master''
    ]
    [
      ''^ref: (.*)$''
      ''f870c6ccc8951fc48aeb293cf3e98ade6ac42668''
    ]
    [
      ''.*\.post[0-9]+''
      ''1.7.2''
    ]
    [
      ''.*tensorflow_cpu.*''
      ''https://storage.googleapis.com/tensorflow/versions/2.19.0/tensorflow_cpu-2.19.0-cp312-cp312-manylinux_2_17_x86_64.manylinux2014_x86_64.whl''
    ]
    [
      ''.*tensorflow_cpu.*''
      ''https://storage.googleapis.com/tensorflow/versions/2.19.0/tensorflow-2.19.0-cp312-cp312-manylinux_2_17_x86_64.manylinux2014_x86_64.whl''
    ]
    [
      ''.*\.post[0-9]+''
      ''1.7.2''
    ]
    [
      ''.*darwin.*''
      ''i686-cygwin''
    ]
    [
      ''.*darwin.*''
      ''x86_64-cygwin''
    ]
    [
      ''.*darwin.*''
      ''x86_64-darwin''
    ]
    [
      ''.*darwin.*''
      ''aarch64-darwin''
    ]
    [
      ''.*com/badlogicgames/gdx-controllers/gdx-controllers-core.*''
      ''https://oss.sonatype.org/content/repositories/snapshots/com/badlogicgames/gdx-controllers/gdx-controllers-core/2.2.4-SNAPSHOT/maven-metadata.xml''
    ]
    [
      ''.*com/badlogicgames/gdx-controllers/gdx-controllers-desktop.*''
      ''https://oss.sonatype.org/content/repositories/snapshots/com/badlogicgames/gdx-controllers/gdx-controllers-desktop/2.2.4-SNAPSHOT/maven-metadata.xml''
    ]
    [
      ''.*/linux-recordreplay-(.*).tgz''
      ''https://static.replay.io/downloads/linux-recordreplay-b7eae18423ef.tgz''
    ]
    [
      ''.*/linux-node-(.*)''
      ''https://static.replay.io/downloads/linux-node-20220726-bac6d66b5ca1-5b966f2f136c''
    ]
    [
      ''.*-large-wordlist.*''
      ''hunspell-dict-cs-cz-libreoffice-6.3.0.4''
    ]
    [
      ''.*-large-wordlist.*''
      ''hunspell-dict-da-dk-2.5.189''
    ]
    [
      ''.*-large-wordlist.*''
      ''hunspell-dict-en-au-large-wordlist-2018.04.16''
    ]
    [
      ''.*-large-wordlist.*''
      ''hunspell-dict-en-ca-large-wordlist-2018.04.16''
    ]
    [
      ''.*com/fazecast/jSerialComm.*''
      ''https://oss.sonatype.org/content/repositories/snapshots/com/fazecast/jSerialComm/2.11.1-SNAPSHOT/maven-metadata.xml''
    ]
    [
      ''.*net/java/dev/jna/jna-platform.*''
      ''https://oss.sonatype.org/content/repositories/snapshots/net/java/dev/jna/jna-platform/5.1.1-SNAPSHOT/maven-metadata.xml''
    ]
    [
      ''.*net/java/dev/jna/jna-platform.*''
      ''https://oss.sonatype.org/content/repositories/snapshots/net/java/dev/jna/jna-platform/maven-metadata.xml''
    ]
    [
      ''.*net/java/dev/jna/jna.*''
      ''https://oss.sonatype.org/content/repositories/snapshots/net/java/dev/jna/jna/5.1.1-SNAPSHOT/maven-metadata.xml''
    ]
    [
      ''.*net/java/dev/jna/jna.*''
      ''https://oss.sonatype.org/content/repositories/snapshots/net/java/dev/jna/jna/maven-metadata.xml''
    ]
    [
      ''.*org/java-websocket/Java-WebSocket.*''
      ''https://oss.sonatype.org/content/repositories/snapshots/org/java-websocket/Java-WebSocket/1.3.10-SNAPSHOT/maven-metadata.xml''
    ]
    [
      ''.*org/java-websocket/Java-WebSocket.*''
      ''https://oss.sonatype.org/content/repositories/snapshots/org/java-websocket/Java-WebSocket/maven-metadata.xml''
    ]
    [
      ''.*com/melloware/jintellitype.*''
      ''https://repo.maven.apache.org/maven2/com/melloware/jintellitype/maven-metadata.xml''
    ]
    [
      ''[0-9.]*([a-z]*)''
      ''2025.1.1''
    ]
    [
      ''.*com/velocitypowered/velocity-brigadier.*''
      ''https://repo.papermc.io/repository/maven-public/com/velocitypowered/velocity-brigadier/1.0.0-SNAPSHOT/maven-metadata.xml''
    ]
  ]
