# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.hdinsight.aio import HDInsightManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestHDInsightManagementApplicationsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(HDInsightManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_cluster(self, resource_group):
        response = self.client.applications.list_by_cluster(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2024-08-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get(self, resource_group):
        response = await self.client.applications.get(
            resource_group_name=resource_group.name,
            cluster_name="str",
            application_name="str",
            api_version="2024-08-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create(self, resource_group):
        response = await (
            await self.client.applications.begin_create(
                resource_group_name=resource_group.name,
                cluster_name="str",
                application_name="str",
                parameters={
                    "etag": "str",
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "applicationState": "str",
                        "applicationType": "str",
                        "computeProfile": {
                            "roles": [
                                {
                                    "VMGroupName": "str",
                                    "autoscale": {
                                        "capacity": {"maxInstanceCount": 0, "minInstanceCount": 0},
                                        "recurrence": {
                                            "schedule": [
                                                {
                                                    "days": ["str"],
                                                    "timeAndCapacity": {
                                                        "maxInstanceCount": 0,
                                                        "minInstanceCount": 0,
                                                        "time": "str",
                                                    },
                                                }
                                            ],
                                            "timeZone": "str",
                                        },
                                    },
                                    "dataDisksGroups": [
                                        {"diskSizeGB": 0, "disksPerNode": 0, "storageAccountType": "str"}
                                    ],
                                    "encryptDataDisks": False,
                                    "hardwareProfile": {"vmSize": "str"},
                                    "minInstanceCount": 0,
                                    "name": "str",
                                    "osProfile": {
                                        "linuxOperatingSystemProfile": {
                                            "password": "str",
                                            "sshProfile": {"publicKeys": [{"certificateData": "str"}]},
                                            "username": "str",
                                        }
                                    },
                                    "scriptActions": [{"name": "str", "parameters": "str", "uri": "str"}],
                                    "targetInstanceCount": 0,
                                    "virtualNetworkProfile": {"id": "str", "subnet": "str"},
                                }
                            ]
                        },
                        "createdDate": "str",
                        "errors": [{"code": "str", "message": "str"}],
                        "httpsEndpoints": [
                            {
                                "accessModes": ["str"],
                                "destinationPort": 0,
                                "disableGatewayAuth": bool,
                                "location": "str",
                                "privateIPAddress": "str",
                                "publicPort": 0,
                                "subDomainSuffix": "str",
                            }
                        ],
                        "installScriptActions": [
                            {
                                "name": "str",
                                "roles": ["str"],
                                "uri": "str",
                                "applicationName": "str",
                                "parameters": "str",
                            }
                        ],
                        "marketplaceIdentifier": "str",
                        "privateLinkConfigurations": [
                            {
                                "groupId": "str",
                                "ipConfigurations": [
                                    {
                                        "name": "str",
                                        "id": "str",
                                        "primary": bool,
                                        "privateIPAddress": "str",
                                        "privateIPAllocationMethod": "str",
                                        "provisioningState": "str",
                                        "subnet": {"id": "str"},
                                        "type": "str",
                                    }
                                ],
                                "name": "str",
                                "id": "str",
                                "provisioningState": "str",
                                "type": "str",
                            }
                        ],
                        "provisioningState": "str",
                        "sshEndpoints": [
                            {"destinationPort": 0, "location": "str", "privateIPAddress": "str", "publicPort": 0}
                        ],
                        "uninstallScriptActions": [
                            {
                                "name": "str",
                                "roles": ["str"],
                                "uri": "str",
                                "applicationName": "str",
                                "parameters": "str",
                            }
                        ],
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-08-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete(self, resource_group):
        response = await (
            await self.client.applications.begin_delete(
                resource_group_name=resource_group.name,
                cluster_name="str",
                application_name="str",
                api_version="2024-08-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_azure_async_operation_status(self, resource_group):
        response = await self.client.applications.get_azure_async_operation_status(
            resource_group_name=resource_group.name,
            cluster_name="str",
            application_name="str",
            operation_id="str",
            api_version="2024-08-01-preview",
        )

        # please add some check logic here by yourself
        # ...
