% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrange.R
\name{arrange}
\alias{arrange}
\alias{arrange.data.frame}
\title{Order rows using column values}
\usage{
arrange(.data, ..., .by_group = FALSE)

\method{arrange}{data.frame}(.data, ..., .by_group = FALSE, .locale = NULL)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Variables, or
functions of variables. Use \code{\link[=desc]{desc()}} to sort a variable in descending
order.}

\item{.by_group}{If \code{TRUE}, will sort first by grouping variable. Applies to
grouped data frames only.}

\item{.locale}{The locale to sort character vectors in.
\itemize{
\item If \code{NULL}, the default, uses the \code{"C"} locale unless the deprecated
\code{dplyr.legacy_locale} global option escape hatch is active. See the
\link{dplyr-locale} help page for more details.
\item If a single string from \code{\link[stringi:stri_locale_list]{stringi::stri_locale_list()}} is supplied, then
this will be used as the locale to sort with. For example, \code{"en"} will
sort with the American English locale. This requires the stringi package.
\item If \code{"C"} is supplied, then character vectors will always be sorted in the
C locale. This does not require stringi and is often much faster than
supplying a locale identifier.
}

The C locale is not the same as English locales, such as \code{"en"},
particularly when it comes to data containing a mix of upper and lower case
letters. This is explained in more detail on the \link[=dplyr-locale]{locale}
help page under the \verb{Default locale} section.}
}
\value{
An object of the same type as \code{.data}. The output has the following
properties:
\itemize{
\item All rows appear in the output, but (usually) in a different place.
\item Columns are not modified.
\item Groups are not modified.
\item Data frame attributes are preserved.
}
}
\description{
\code{arrange()} orders the rows of a data frame by the values of selected
columns.

Unlike other dplyr verbs, \code{arrange()} largely ignores grouping; you
need to explicitly mention grouping variables (or use  \code{.by_group = TRUE})
in order to group by them, and functions of variables are evaluated
once per data frame, not once per group.
}
\details{
\subsection{Missing values}{

Unlike base sorting with \code{sort()}, \code{NA} are:
\itemize{
\item always sorted to the end for local data, even when wrapped with \code{desc()}.
\item treated differently for remote data, depending on the backend.
}
}
}
\section{Methods}{

This function is a \strong{generic}, which means that packages can provide
implementations (methods) for other classes. See the documentation of
individual methods for extra arguments and differences in behaviour.

The following methods are currently available in loaded packages:
\Sexpr[stage=render,results=rd]{dplyr:::methods_rd("arrange")}.
}

\examples{
arrange(mtcars, cyl, disp)
arrange(mtcars, desc(disp))

# grouped arrange ignores groups
by_cyl <- mtcars |> group_by(cyl)
by_cyl |> arrange(desc(wt))
# Unless you specifically ask:
by_cyl |> arrange(desc(wt), .by_group = TRUE)

# use embracing when wrapping in a function;
# see ?rlang::args_data_masking for more details
tidy_eval_arrange <- function(.data, var) {
  .data |>
    arrange({{ var }})
}
tidy_eval_arrange(mtcars, mpg)

# Use `across()` or `pick()` to select columns with tidy-select
iris |> arrange(pick(starts_with("Sepal")))
iris |> arrange(across(starts_with("Sepal"), desc))
}
\seealso{
Other single table verbs: 
\code{\link{filter}()},
\code{\link{mutate}()},
\code{\link{reframe}()},
\code{\link{rename}()},
\code{\link{select}()},
\code{\link{slice}()},
\code{\link{summarise}()}
}
\concept{single table verbs}
