% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeRows.R
\name{mergeRows}
\alias{mergeRows}
\alias{mergeRows.data.frame}
\title{Function to Merge Rows of Two Data Frames}
\usage{
mergeRows(X, Y, common.only = FALSE, ...)

\method{mergeRows}{data.frame}(X, Y, common.only = FALSE, ...)
}
\arguments{
\item{X}{First data frame.}

\item{Y}{Second data frame.}

\item{common.only}{If \code{TRUE}, only variables (columns) common to the two data frame are included in the merged data set; the default is \code{FALSE}.}

\item{\dots}{Not used.}
}
\value{
A data frame containing the rows from both input data frames.
}
\description{
Function to Merge Rows of Two Data Frames
}
\details{
This function merges two data frames by combining their rows.
}
\examples{
data(Duncan)
D1 <- Duncan[1:20,]
D2 <- Duncan[21:45,]
D <- mergeRows(D1, D2)
print(D)
dim(D)

}
\seealso{
For column merges and more complex merges, see \code{\link[base]{merge}}.
}
\author{
John Fox
}
\keyword{manip}
