% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assay.R
\name{split.Assay}
\alias{split.Assay}
\title{Split an Assay}
\usage{
\method{split}{Assay}(x, f, drop = FALSE, layers = NA, ...)
}
\arguments{
\item{x}{An \code{\link{Assay}} object}

\item{f}{a \sQuote{factor} in the sense that \code{\link[base]{as.factor}(f)}
    defines the grouping, or a list of such factors in which case their
    interaction is used for the grouping. If \code{x} is a data frame,
    \code{f} can also be a formula of the form \code{ ~ g} to split by
    the variable \code{g}, or more generally of the form \code{ ~ g1 +
      \dots + gk} to split by the interaction of the variables
    \code{g1}, \dots, \code{gk}, where these variables are evaluated in
    the data frame \code{x} using the usual non-standard evaluation
    rules.}

\item{drop}{logical indicating if levels that do not occur should be dropped
    (if \code{f} is a \code{factor} or a list).}

\item{layers}{Names of layers to include in the split; pass \code{NA} for
all layers; pass \code{NULL} for the \link[=DefaultLayer]{default layer}}

\item{...}{Ignored}
}
\value{
Returns a v5 assay with splitted layers
}
\description{
Split an Assay
}
\seealso{
v3 Assay object, validity, and interaction methods:
\code{\link{$.Assay}()},
\code{\link{Assay-class}},
\code{\link{Assay-validity}},
\code{\link{CreateAssayObject}()},
\code{\link{[.Assay}()},
\code{\link{[[.Assay}()},
\code{\link{dim.Assay}()},
\code{\link{dimnames.Assay}()},
\code{\link{merge.Assay}()},
\code{\link{subset.Assay}()}
}
\concept{assay}
