/* automatically generated by rust-bindgen 0.71.1 */

pub const LZMA_H_INTERNAL: u32 = 1;
pub const LZMA_VERSION_MAJOR: u32 = 5;
pub const LZMA_VERSION_MINOR: u32 = 8;
pub const LZMA_VERSION_PATCH: u32 = 1;
pub const LZMA_VERSION_COMMIT: &[u8; 1] = b"\0";
pub const LZMA_VERSION_STABILITY_ALPHA: u32 = 0;
pub const LZMA_VERSION_STABILITY_BETA: u32 = 1;
pub const LZMA_VERSION_STABILITY_STABLE: u32 = 2;
pub const LZMA_VERSION_STABILITY_STRING: &[u8; 1] = b"\0";
pub const LZMA_VLI_MAX: lzma_vli = u64::MAX / 2;
pub const LZMA_VLI_UNKNOWN: lzma_vli = u64::MAX;
pub const LZMA_VLI_BYTES_MAX: usize = 9;
pub const LZMA_CHECK_ID_MAX: u32 = 15;
pub const LZMA_CHECK_SIZE_MAX: u32 = 64;
pub const LZMA_FILTERS_MAX: u32 = 4;
pub const LZMA_DELTA_DIST_MIN: u32 = 1;
pub const LZMA_DELTA_DIST_MAX: u32 = 256;
pub const LZMA_LCLP_MIN: u32 = 0;
pub const LZMA_LCLP_MAX: u32 = 4;
pub const LZMA_LC_DEFAULT: u32 = 3;
pub const LZMA_LP_DEFAULT: u32 = 0;
pub const LZMA_PB_MIN: u32 = 0;
pub const LZMA_PB_MAX: u32 = 4;
pub const LZMA_PB_DEFAULT: u32 = 2;
pub const LZMA_STREAM_HEADER_SIZE: u32 = 12;
pub const LZMA_BLOCK_HEADER_SIZE_MIN: u32 = 8;
pub const LZMA_BLOCK_HEADER_SIZE_MAX: u32 = 1024;

#[cfg(target_env = "msvc")]
#[doc(hidden)]
pub type __enum_ty = ::std::os::raw::c_int;
#[cfg(not(target_env = "msvc"))]
#[doc(hidden)]
pub type __enum_ty = ::std::os::raw::c_uint;

extern "C" {
    pub fn lzma_version_number() -> u32;
}
extern "C" {
    pub fn lzma_version_string() -> *const ::std::os::raw::c_char;
}
pub type lzma_bool = ::std::os::raw::c_uchar;
pub const lzma_reserved_enum_LZMA_RESERVED_ENUM: lzma_reserved_enum = 0;
pub type lzma_reserved_enum = __enum_ty;
pub const lzma_ret_LZMA_OK: lzma_ret = 0;
pub const lzma_ret_LZMA_STREAM_END: lzma_ret = 1;
pub const lzma_ret_LZMA_NO_CHECK: lzma_ret = 2;
pub const lzma_ret_LZMA_UNSUPPORTED_CHECK: lzma_ret = 3;
pub const lzma_ret_LZMA_GET_CHECK: lzma_ret = 4;
pub const lzma_ret_LZMA_MEM_ERROR: lzma_ret = 5;
pub const lzma_ret_LZMA_MEMLIMIT_ERROR: lzma_ret = 6;
pub const lzma_ret_LZMA_FORMAT_ERROR: lzma_ret = 7;
pub const lzma_ret_LZMA_OPTIONS_ERROR: lzma_ret = 8;
pub const lzma_ret_LZMA_DATA_ERROR: lzma_ret = 9;
pub const lzma_ret_LZMA_BUF_ERROR: lzma_ret = 10;
pub const lzma_ret_LZMA_PROG_ERROR: lzma_ret = 11;
pub const lzma_ret_LZMA_SEEK_NEEDED: lzma_ret = 12;
pub const lzma_ret_LZMA_RET_INTERNAL1: lzma_ret = 101;
pub const lzma_ret_LZMA_RET_INTERNAL2: lzma_ret = 102;
pub const lzma_ret_LZMA_RET_INTERNAL3: lzma_ret = 103;
pub const lzma_ret_LZMA_RET_INTERNAL4: lzma_ret = 104;
pub const lzma_ret_LZMA_RET_INTERNAL5: lzma_ret = 105;
pub const lzma_ret_LZMA_RET_INTERNAL6: lzma_ret = 106;
pub const lzma_ret_LZMA_RET_INTERNAL7: lzma_ret = 107;
pub const lzma_ret_LZMA_RET_INTERNAL8: lzma_ret = 108;
pub type lzma_ret = __enum_ty;
pub const lzma_action_LZMA_RUN: lzma_action = 0;
pub const lzma_action_LZMA_SYNC_FLUSH: lzma_action = 1;
pub const lzma_action_LZMA_FULL_FLUSH: lzma_action = 2;
pub const lzma_action_LZMA_FULL_BARRIER: lzma_action = 4;
pub const lzma_action_LZMA_FINISH: lzma_action = 3;
pub type lzma_action = __enum_ty;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lzma_allocator {
    pub alloc: ::std::option::Option<
        unsafe extern "C" fn(
            opaque: *mut ::std::os::raw::c_void,
            nmemb: usize,
            size: usize,
        ) -> *mut ::std::os::raw::c_void,
    >,
    pub free: ::std::option::Option<
        unsafe extern "C" fn(opaque: *mut ::std::os::raw::c_void, ptr: *mut ::std::os::raw::c_void),
    >,
    pub opaque: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_lzma_allocator() {
    const UNINIT: ::std::mem::MaybeUninit<lzma_allocator> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<lzma_allocator>(),
        24usize,
        "Size of lzma_allocator"
    );
    assert_eq!(
        ::std::mem::align_of::<lzma_allocator>(),
        8usize,
        "Alignment of lzma_allocator"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).alloc) as usize - ptr as usize },
        0usize,
        "Offset of field: lzma_allocator::alloc"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).free) as usize - ptr as usize },
        8usize,
        "Offset of field: lzma_allocator::free"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).opaque) as usize - ptr as usize },
        16usize,
        "Offset of field: lzma_allocator::opaque"
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lzma_internal_s {
    _unused: [u8; 0],
}
pub type lzma_internal = lzma_internal_s;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lzma_stream {
    pub next_in: *const u8,
    pub avail_in: usize,
    pub total_in: u64,
    pub next_out: *mut u8,
    pub avail_out: usize,
    pub total_out: u64,
    pub allocator: *const lzma_allocator,
    pub internal: *mut lzma_internal,
    pub reserved_ptr1: *mut ::std::os::raw::c_void,
    pub reserved_ptr2: *mut ::std::os::raw::c_void,
    pub reserved_ptr3: *mut ::std::os::raw::c_void,
    pub reserved_ptr4: *mut ::std::os::raw::c_void,
    pub seek_pos: u64,
    pub reserved_int2: u64,
    pub reserved_int3: usize,
    pub reserved_int4: usize,
    pub reserved_enum1: lzma_reserved_enum,
    pub reserved_enum2: lzma_reserved_enum,
}
#[test]
fn bindgen_test_layout_lzma_stream() {
    const UNINIT: ::std::mem::MaybeUninit<lzma_stream> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<lzma_stream>(),
        136usize,
        "Size of lzma_stream"
    );
    assert_eq!(
        ::std::mem::align_of::<lzma_stream>(),
        8usize,
        "Alignment of lzma_stream"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).next_in) as usize - ptr as usize },
        0usize,
        "Offset of field: lzma_stream::next_in"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).avail_in) as usize - ptr as usize },
        8usize,
        "Offset of field: lzma_stream::avail_in"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).total_in) as usize - ptr as usize },
        16usize,
        "Offset of field: lzma_stream::total_in"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).next_out) as usize - ptr as usize },
        24usize,
        "Offset of field: lzma_stream::next_out"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).avail_out) as usize - ptr as usize },
        32usize,
        "Offset of field: lzma_stream::avail_out"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).total_out) as usize - ptr as usize },
        40usize,
        "Offset of field: lzma_stream::total_out"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).allocator) as usize - ptr as usize },
        48usize,
        "Offset of field: lzma_stream::allocator"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).internal) as usize - ptr as usize },
        56usize,
        "Offset of field: lzma_stream::internal"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_ptr1) as usize - ptr as usize },
        64usize,
        "Offset of field: lzma_stream::reserved_ptr1"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_ptr2) as usize - ptr as usize },
        72usize,
        "Offset of field: lzma_stream::reserved_ptr2"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_ptr3) as usize - ptr as usize },
        80usize,
        "Offset of field: lzma_stream::reserved_ptr3"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_ptr4) as usize - ptr as usize },
        88usize,
        "Offset of field: lzma_stream::reserved_ptr4"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).seek_pos) as usize - ptr as usize },
        96usize,
        "Offset of field: lzma_stream::seek_pos"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_int2) as usize - ptr as usize },
        104usize,
        "Offset of field: lzma_stream::reserved_int2"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_int3) as usize - ptr as usize },
        112usize,
        "Offset of field: lzma_stream::reserved_int3"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_int4) as usize - ptr as usize },
        120usize,
        "Offset of field: lzma_stream::reserved_int4"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_enum1) as usize - ptr as usize },
        128usize,
        "Offset of field: lzma_stream::reserved_enum1"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_enum2) as usize - ptr as usize },
        132usize,
        "Offset of field: lzma_stream::reserved_enum2"
    );
}
extern "C" {
    pub fn lzma_code(strm: *mut lzma_stream, action: lzma_action) -> lzma_ret;
}
extern "C" {
    pub fn lzma_end(strm: *mut lzma_stream);
}
extern "C" {
    pub fn lzma_get_progress(strm: *mut lzma_stream, progress_in: *mut u64, progress_out: *mut u64);
}
extern "C" {
    pub fn lzma_memusage(strm: *const lzma_stream) -> u64;
}
extern "C" {
    pub fn lzma_memlimit_get(strm: *const lzma_stream) -> u64;
}
extern "C" {
    pub fn lzma_memlimit_set(strm: *mut lzma_stream, memlimit: u64) -> lzma_ret;
}
pub type lzma_vli = u64;
extern "C" {
    pub fn lzma_vli_encode(
        vli: lzma_vli,
        vli_pos: *mut usize,
        out: *mut u8,
        out_pos: *mut usize,
        out_size: usize,
    ) -> lzma_ret;
}
extern "C" {
    pub fn lzma_vli_decode(
        vli: *mut lzma_vli,
        vli_pos: *mut usize,
        in_: *const u8,
        in_pos: *mut usize,
        in_size: usize,
    ) -> lzma_ret;
}
extern "C" {
    pub fn lzma_vli_size(vli: lzma_vli) -> u32;
}
pub const lzma_check_LZMA_CHECK_NONE: lzma_check = 0;
pub const lzma_check_LZMA_CHECK_CRC32: lzma_check = 1;
pub const lzma_check_LZMA_CHECK_CRC64: lzma_check = 4;
pub const lzma_check_LZMA_CHECK_SHA256: lzma_check = 10;
pub type lzma_check = __enum_ty;
extern "C" {
    pub fn lzma_check_is_supported(check: lzma_check) -> lzma_bool;
}
extern "C" {
    pub fn lzma_check_size(check: lzma_check) -> u32;
}
extern "C" {
    pub fn lzma_crc32(buf: *const u8, size: usize, crc: u32) -> u32;
}
extern "C" {
    pub fn lzma_crc64(buf: *const u8, size: usize, crc: u64) -> u64;
}
extern "C" {
    pub fn lzma_get_check(strm: *const lzma_stream) -> lzma_check;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lzma_filter {
    pub id: lzma_vli,
    pub options: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_lzma_filter() {
    const UNINIT: ::std::mem::MaybeUninit<lzma_filter> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<lzma_filter>(),
        16usize,
        "Size of lzma_filter"
    );
    assert_eq!(
        ::std::mem::align_of::<lzma_filter>(),
        8usize,
        "Alignment of lzma_filter"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).id) as usize - ptr as usize },
        0usize,
        "Offset of field: lzma_filter::id"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).options) as usize - ptr as usize },
        8usize,
        "Offset of field: lzma_filter::options"
    );
}
extern "C" {
    pub fn lzma_filter_encoder_is_supported(id: lzma_vli) -> lzma_bool;
}
extern "C" {
    pub fn lzma_filter_decoder_is_supported(id: lzma_vli) -> lzma_bool;
}
extern "C" {
    pub fn lzma_filters_copy(
        src: *const lzma_filter,
        dest: *mut lzma_filter,
        allocator: *const lzma_allocator,
    ) -> lzma_ret;
}
extern "C" {
    pub fn lzma_filters_free(filters: *mut lzma_filter, allocator: *const lzma_allocator);
}
extern "C" {
    pub fn lzma_raw_encoder_memusage(filters: *const lzma_filter) -> u64;
}
extern "C" {
    pub fn lzma_raw_decoder_memusage(filters: *const lzma_filter) -> u64;
}
extern "C" {
    pub fn lzma_raw_encoder(strm: *mut lzma_stream, filters: *const lzma_filter) -> lzma_ret;
}
extern "C" {
    pub fn lzma_raw_decoder(strm: *mut lzma_stream, filters: *const lzma_filter) -> lzma_ret;
}
extern "C" {
    pub fn lzma_filters_update(strm: *mut lzma_stream, filters: *const lzma_filter) -> lzma_ret;
}
extern "C" {
    pub fn lzma_raw_buffer_encode(
        filters: *const lzma_filter,
        allocator: *const lzma_allocator,
        in_: *const u8,
        in_size: usize,
        out: *mut u8,
        out_pos: *mut usize,
        out_size: usize,
    ) -> lzma_ret;
}
extern "C" {
    pub fn lzma_raw_buffer_decode(
        filters: *const lzma_filter,
        allocator: *const lzma_allocator,
        in_: *const u8,
        in_pos: *mut usize,
        in_size: usize,
        out: *mut u8,
        out_pos: *mut usize,
        out_size: usize,
    ) -> lzma_ret;
}
extern "C" {
    pub fn lzma_properties_size(size: *mut u32, filter: *const lzma_filter) -> lzma_ret;
}
extern "C" {
    pub fn lzma_properties_encode(filter: *const lzma_filter, props: *mut u8) -> lzma_ret;
}
extern "C" {
    pub fn lzma_properties_decode(
        filter: *mut lzma_filter,
        allocator: *const lzma_allocator,
        props: *const u8,
        props_size: usize,
    ) -> lzma_ret;
}
extern "C" {
    pub fn lzma_filter_flags_size(size: *mut u32, filter: *const lzma_filter) -> lzma_ret;
}
extern "C" {
    pub fn lzma_filter_flags_encode(
        filter: *const lzma_filter,
        out: *mut u8,
        out_pos: *mut usize,
        out_size: usize,
    ) -> lzma_ret;
}
extern "C" {
    pub fn lzma_filter_flags_decode(
        filter: *mut lzma_filter,
        allocator: *const lzma_allocator,
        in_: *const u8,
        in_pos: *mut usize,
        in_size: usize,
    ) -> lzma_ret;
}
extern "C" {
    pub fn lzma_str_to_filters(
        str_: *const ::std::os::raw::c_char,
        error_pos: *mut ::std::os::raw::c_int,
        filters: *mut lzma_filter,
        flags: u32,
        allocator: *const lzma_allocator,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn lzma_str_from_filters(
        str_: *mut *mut ::std::os::raw::c_char,
        filters: *const lzma_filter,
        flags: u32,
        allocator: *const lzma_allocator,
    ) -> lzma_ret;
}
extern "C" {
    pub fn lzma_str_list_filters(
        str_: *mut *mut ::std::os::raw::c_char,
        filter_id: lzma_vli,
        flags: u32,
        allocator: *const lzma_allocator,
    ) -> lzma_ret;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lzma_options_bcj {
    pub start_offset: u32,
}
#[test]
fn bindgen_test_layout_lzma_options_bcj() {
    const UNINIT: ::std::mem::MaybeUninit<lzma_options_bcj> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<lzma_options_bcj>(),
        4usize,
        "Size of lzma_options_bcj"
    );
    assert_eq!(
        ::std::mem::align_of::<lzma_options_bcj>(),
        4usize,
        "Alignment of lzma_options_bcj"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).start_offset) as usize - ptr as usize },
        0usize,
        "Offset of field: lzma_options_bcj::start_offset"
    );
}
extern "C" {
    pub fn lzma_bcj_arm64_encode(start_offset: u32, buf: *mut u8, size: usize) -> usize;
}
extern "C" {
    pub fn lzma_bcj_arm64_decode(start_offset: u32, buf: *mut u8, size: usize) -> usize;
}
extern "C" {
    pub fn lzma_bcj_riscv_encode(start_offset: u32, buf: *mut u8, size: usize) -> usize;
}
extern "C" {
    pub fn lzma_bcj_riscv_decode(start_offset: u32, buf: *mut u8, size: usize) -> usize;
}
extern "C" {
    pub fn lzma_bcj_x86_encode(start_offset: u32, buf: *mut u8, size: usize) -> usize;
}
extern "C" {
    pub fn lzma_bcj_x86_decode(start_offset: u32, buf: *mut u8, size: usize) -> usize;
}
pub const lzma_delta_type_LZMA_DELTA_TYPE_BYTE: lzma_delta_type = 0;
pub type lzma_delta_type = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lzma_options_delta {
    pub type_: lzma_delta_type,
    pub dist: u32,
    pub reserved_int1: u32,
    pub reserved_int2: u32,
    pub reserved_int3: u32,
    pub reserved_int4: u32,
    pub reserved_ptr1: *mut ::std::os::raw::c_void,
    pub reserved_ptr2: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_lzma_options_delta() {
    const UNINIT: ::std::mem::MaybeUninit<lzma_options_delta> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<lzma_options_delta>(),
        40usize,
        "Size of lzma_options_delta"
    );
    assert_eq!(
        ::std::mem::align_of::<lzma_options_delta>(),
        8usize,
        "Alignment of lzma_options_delta"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        0usize,
        "Offset of field: lzma_options_delta::type_"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dist) as usize - ptr as usize },
        4usize,
        "Offset of field: lzma_options_delta::dist"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_int1) as usize - ptr as usize },
        8usize,
        "Offset of field: lzma_options_delta::reserved_int1"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_int2) as usize - ptr as usize },
        12usize,
        "Offset of field: lzma_options_delta::reserved_int2"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_int3) as usize - ptr as usize },
        16usize,
        "Offset of field: lzma_options_delta::reserved_int3"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_int4) as usize - ptr as usize },
        20usize,
        "Offset of field: lzma_options_delta::reserved_int4"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_ptr1) as usize - ptr as usize },
        24usize,
        "Offset of field: lzma_options_delta::reserved_ptr1"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_ptr2) as usize - ptr as usize },
        32usize,
        "Offset of field: lzma_options_delta::reserved_ptr2"
    );
}
pub const lzma_match_finder_LZMA_MF_HC3: lzma_match_finder = 3;
pub const lzma_match_finder_LZMA_MF_HC4: lzma_match_finder = 4;
pub const lzma_match_finder_LZMA_MF_BT2: lzma_match_finder = 18;
pub const lzma_match_finder_LZMA_MF_BT3: lzma_match_finder = 19;
pub const lzma_match_finder_LZMA_MF_BT4: lzma_match_finder = 20;
pub type lzma_match_finder = __enum_ty;
extern "C" {
    pub fn lzma_mf_is_supported(match_finder: lzma_match_finder) -> lzma_bool;
}
pub const lzma_mode_LZMA_MODE_FAST: lzma_mode = 1;
pub const lzma_mode_LZMA_MODE_NORMAL: lzma_mode = 2;
pub type lzma_mode = __enum_ty;
extern "C" {
    pub fn lzma_mode_is_supported(mode: lzma_mode) -> lzma_bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lzma_options_lzma {
    pub dict_size: u32,
    pub preset_dict: *const u8,
    pub preset_dict_size: u32,
    pub lc: u32,
    pub lp: u32,
    pub pb: u32,
    pub mode: lzma_mode,
    pub nice_len: u32,
    pub mf: lzma_match_finder,
    pub depth: u32,
    pub ext_flags: u32,
    pub ext_size_low: u32,
    pub ext_size_high: u32,
    pub reserved_int4: u32,
    pub reserved_int5: u32,
    pub reserved_int6: u32,
    pub reserved_int7: u32,
    pub reserved_int8: u32,
    pub reserved_enum1: lzma_reserved_enum,
    pub reserved_enum2: lzma_reserved_enum,
    pub reserved_enum3: lzma_reserved_enum,
    pub reserved_enum4: lzma_reserved_enum,
    pub reserved_ptr1: *mut ::std::os::raw::c_void,
    pub reserved_ptr2: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_lzma_options_lzma() {
    const UNINIT: ::std::mem::MaybeUninit<lzma_options_lzma> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<lzma_options_lzma>(),
        112usize,
        "Size of lzma_options_lzma"
    );
    assert_eq!(
        ::std::mem::align_of::<lzma_options_lzma>(),
        8usize,
        "Alignment of lzma_options_lzma"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dict_size) as usize - ptr as usize },
        0usize,
        "Offset of field: lzma_options_lzma::dict_size"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).preset_dict) as usize - ptr as usize },
        8usize,
        "Offset of field: lzma_options_lzma::preset_dict"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).preset_dict_size) as usize - ptr as usize },
        16usize,
        "Offset of field: lzma_options_lzma::preset_dict_size"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lc) as usize - ptr as usize },
        20usize,
        "Offset of field: lzma_options_lzma::lc"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lp) as usize - ptr as usize },
        24usize,
        "Offset of field: lzma_options_lzma::lp"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pb) as usize - ptr as usize },
        28usize,
        "Offset of field: lzma_options_lzma::pb"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mode) as usize - ptr as usize },
        32usize,
        "Offset of field: lzma_options_lzma::mode"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nice_len) as usize - ptr as usize },
        36usize,
        "Offset of field: lzma_options_lzma::nice_len"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mf) as usize - ptr as usize },
        40usize,
        "Offset of field: lzma_options_lzma::mf"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).depth) as usize - ptr as usize },
        44usize,
        "Offset of field: lzma_options_lzma::depth"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ext_flags) as usize - ptr as usize },
        48usize,
        "Offset of field: lzma_options_lzma::ext_flags"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ext_size_low) as usize - ptr as usize },
        52usize,
        "Offset of field: lzma_options_lzma::ext_size_low"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ext_size_high) as usize - ptr as usize },
        56usize,
        "Offset of field: lzma_options_lzma::ext_size_high"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_int4) as usize - ptr as usize },
        60usize,
        "Offset of field: lzma_options_lzma::reserved_int4"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_int5) as usize - ptr as usize },
        64usize,
        "Offset of field: lzma_options_lzma::reserved_int5"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_int6) as usize - ptr as usize },
        68usize,
        "Offset of field: lzma_options_lzma::reserved_int6"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_int7) as usize - ptr as usize },
        72usize,
        "Offset of field: lzma_options_lzma::reserved_int7"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_int8) as usize - ptr as usize },
        76usize,
        "Offset of field: lzma_options_lzma::reserved_int8"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_enum1) as usize - ptr as usize },
        80usize,
        "Offset of field: lzma_options_lzma::reserved_enum1"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_enum2) as usize - ptr as usize },
        84usize,
        "Offset of field: lzma_options_lzma::reserved_enum2"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_enum3) as usize - ptr as usize },
        88usize,
        "Offset of field: lzma_options_lzma::reserved_enum3"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_enum4) as usize - ptr as usize },
        92usize,
        "Offset of field: lzma_options_lzma::reserved_enum4"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_ptr1) as usize - ptr as usize },
        96usize,
        "Offset of field: lzma_options_lzma::reserved_ptr1"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_ptr2) as usize - ptr as usize },
        104usize,
        "Offset of field: lzma_options_lzma::reserved_ptr2"
    );
}
extern "C" {
    pub fn lzma_lzma_preset(options: *mut lzma_options_lzma, preset: u32) -> lzma_bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lzma_mt {
    pub flags: u32,
    pub threads: u32,
    pub block_size: u64,
    pub timeout: u32,
    pub preset: u32,
    pub filters: *const lzma_filter,
    pub check: lzma_check,
    pub reserved_enum1: lzma_reserved_enum,
    pub reserved_enum2: lzma_reserved_enum,
    pub reserved_enum3: lzma_reserved_enum,
    pub reserved_int1: u32,
    pub reserved_int2: u32,
    pub reserved_int3: u32,
    pub reserved_int4: u32,
    pub memlimit_threading: u64,
    pub memlimit_stop: u64,
    pub reserved_int7: u64,
    pub reserved_int8: u64,
    pub reserved_ptr1: *mut ::std::os::raw::c_void,
    pub reserved_ptr2: *mut ::std::os::raw::c_void,
    pub reserved_ptr3: *mut ::std::os::raw::c_void,
    pub reserved_ptr4: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_lzma_mt() {
    const UNINIT: ::std::mem::MaybeUninit<lzma_mt> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<lzma_mt>(),
        128usize,
        "Size of lzma_mt"
    );
    assert_eq!(
        ::std::mem::align_of::<lzma_mt>(),
        8usize,
        "Alignment of lzma_mt"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        "Offset of field: lzma_mt::flags"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).threads) as usize - ptr as usize },
        4usize,
        "Offset of field: lzma_mt::threads"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).block_size) as usize - ptr as usize },
        8usize,
        "Offset of field: lzma_mt::block_size"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).timeout) as usize - ptr as usize },
        16usize,
        "Offset of field: lzma_mt::timeout"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).preset) as usize - ptr as usize },
        20usize,
        "Offset of field: lzma_mt::preset"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).filters) as usize - ptr as usize },
        24usize,
        "Offset of field: lzma_mt::filters"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).check) as usize - ptr as usize },
        32usize,
        "Offset of field: lzma_mt::check"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_enum1) as usize - ptr as usize },
        36usize,
        "Offset of field: lzma_mt::reserved_enum1"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_enum2) as usize - ptr as usize },
        40usize,
        "Offset of field: lzma_mt::reserved_enum2"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_enum3) as usize - ptr as usize },
        44usize,
        "Offset of field: lzma_mt::reserved_enum3"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_int1) as usize - ptr as usize },
        48usize,
        "Offset of field: lzma_mt::reserved_int1"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_int2) as usize - ptr as usize },
        52usize,
        "Offset of field: lzma_mt::reserved_int2"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_int3) as usize - ptr as usize },
        56usize,
        "Offset of field: lzma_mt::reserved_int3"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_int4) as usize - ptr as usize },
        60usize,
        "Offset of field: lzma_mt::reserved_int4"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).memlimit_threading) as usize - ptr as usize },
        64usize,
        "Offset of field: lzma_mt::memlimit_threading"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).memlimit_stop) as usize - ptr as usize },
        72usize,
        "Offset of field: lzma_mt::memlimit_stop"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_int7) as usize - ptr as usize },
        80usize,
        "Offset of field: lzma_mt::reserved_int7"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_int8) as usize - ptr as usize },
        88usize,
        "Offset of field: lzma_mt::reserved_int8"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_ptr1) as usize - ptr as usize },
        96usize,
        "Offset of field: lzma_mt::reserved_ptr1"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_ptr2) as usize - ptr as usize },
        104usize,
        "Offset of field: lzma_mt::reserved_ptr2"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_ptr3) as usize - ptr as usize },
        112usize,
        "Offset of field: lzma_mt::reserved_ptr3"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_ptr4) as usize - ptr as usize },
        120usize,
        "Offset of field: lzma_mt::reserved_ptr4"
    );
}
extern "C" {
    pub fn lzma_easy_encoder_memusage(preset: u32) -> u64;
}
extern "C" {
    pub fn lzma_easy_decoder_memusage(preset: u32) -> u64;
}
extern "C" {
    pub fn lzma_easy_encoder(strm: *mut lzma_stream, preset: u32, check: lzma_check) -> lzma_ret;
}
extern "C" {
    pub fn lzma_easy_buffer_encode(
        preset: u32,
        check: lzma_check,
        allocator: *const lzma_allocator,
        in_: *const u8,
        in_size: usize,
        out: *mut u8,
        out_pos: *mut usize,
        out_size: usize,
    ) -> lzma_ret;
}
extern "C" {
    pub fn lzma_stream_encoder(
        strm: *mut lzma_stream,
        filters: *const lzma_filter,
        check: lzma_check,
    ) -> lzma_ret;
}
extern "C" {
    pub fn lzma_stream_encoder_mt_memusage(options: *const lzma_mt) -> u64;
}
extern "C" {
    pub fn lzma_stream_encoder_mt(strm: *mut lzma_stream, options: *const lzma_mt) -> lzma_ret;
}
extern "C" {
    pub fn lzma_mt_block_size(filters: *const lzma_filter) -> u64;
}
extern "C" {
    pub fn lzma_alone_encoder(
        strm: *mut lzma_stream,
        options: *const lzma_options_lzma,
    ) -> lzma_ret;
}
extern "C" {
    pub fn lzma_stream_buffer_bound(uncompressed_size: usize) -> usize;
}
extern "C" {
    pub fn lzma_stream_buffer_encode(
        filters: *mut lzma_filter,
        check: lzma_check,
        allocator: *const lzma_allocator,
        in_: *const u8,
        in_size: usize,
        out: *mut u8,
        out_pos: *mut usize,
        out_size: usize,
    ) -> lzma_ret;
}
extern "C" {
    pub fn lzma_microlzma_encoder(
        strm: *mut lzma_stream,
        options: *const lzma_options_lzma,
    ) -> lzma_ret;
}
extern "C" {
    pub fn lzma_stream_decoder(strm: *mut lzma_stream, memlimit: u64, flags: u32) -> lzma_ret;
}
extern "C" {
    pub fn lzma_stream_decoder_mt(strm: *mut lzma_stream, options: *const lzma_mt) -> lzma_ret;
}
extern "C" {
    pub fn lzma_auto_decoder(strm: *mut lzma_stream, memlimit: u64, flags: u32) -> lzma_ret;
}
extern "C" {
    pub fn lzma_alone_decoder(strm: *mut lzma_stream, memlimit: u64) -> lzma_ret;
}
extern "C" {
    pub fn lzma_lzip_decoder(strm: *mut lzma_stream, memlimit: u64, flags: u32) -> lzma_ret;
}
extern "C" {
    pub fn lzma_stream_buffer_decode(
        memlimit: *mut u64,
        flags: u32,
        allocator: *const lzma_allocator,
        in_: *const u8,
        in_pos: *mut usize,
        in_size: usize,
        out: *mut u8,
        out_pos: *mut usize,
        out_size: usize,
    ) -> lzma_ret;
}
extern "C" {
    pub fn lzma_microlzma_decoder(
        strm: *mut lzma_stream,
        comp_size: u64,
        uncomp_size: u64,
        uncomp_size_is_exact: lzma_bool,
        dict_size: u32,
    ) -> lzma_ret;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lzma_stream_flags {
    pub version: u32,
    pub backward_size: lzma_vli,
    pub check: lzma_check,
    pub reserved_enum1: lzma_reserved_enum,
    pub reserved_enum2: lzma_reserved_enum,
    pub reserved_enum3: lzma_reserved_enum,
    pub reserved_enum4: lzma_reserved_enum,
    pub reserved_bool1: lzma_bool,
    pub reserved_bool2: lzma_bool,
    pub reserved_bool3: lzma_bool,
    pub reserved_bool4: lzma_bool,
    pub reserved_bool5: lzma_bool,
    pub reserved_bool6: lzma_bool,
    pub reserved_bool7: lzma_bool,
    pub reserved_bool8: lzma_bool,
    pub reserved_int1: u32,
    pub reserved_int2: u32,
}
#[test]
fn bindgen_test_layout_lzma_stream_flags() {
    const UNINIT: ::std::mem::MaybeUninit<lzma_stream_flags> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<lzma_stream_flags>(),
        56usize,
        "Size of lzma_stream_flags"
    );
    assert_eq!(
        ::std::mem::align_of::<lzma_stream_flags>(),
        8usize,
        "Alignment of lzma_stream_flags"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).version) as usize - ptr as usize },
        0usize,
        "Offset of field: lzma_stream_flags::version"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).backward_size) as usize - ptr as usize },
        8usize,
        "Offset of field: lzma_stream_flags::backward_size"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).check) as usize - ptr as usize },
        16usize,
        "Offset of field: lzma_stream_flags::check"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_enum1) as usize - ptr as usize },
        20usize,
        "Offset of field: lzma_stream_flags::reserved_enum1"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_enum2) as usize - ptr as usize },
        24usize,
        "Offset of field: lzma_stream_flags::reserved_enum2"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_enum3) as usize - ptr as usize },
        28usize,
        "Offset of field: lzma_stream_flags::reserved_enum3"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_enum4) as usize - ptr as usize },
        32usize,
        "Offset of field: lzma_stream_flags::reserved_enum4"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_bool1) as usize - ptr as usize },
        36usize,
        "Offset of field: lzma_stream_flags::reserved_bool1"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_bool2) as usize - ptr as usize },
        37usize,
        "Offset of field: lzma_stream_flags::reserved_bool2"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_bool3) as usize - ptr as usize },
        38usize,
        "Offset of field: lzma_stream_flags::reserved_bool3"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_bool4) as usize - ptr as usize },
        39usize,
        "Offset of field: lzma_stream_flags::reserved_bool4"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_bool5) as usize - ptr as usize },
        40usize,
        "Offset of field: lzma_stream_flags::reserved_bool5"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_bool6) as usize - ptr as usize },
        41usize,
        "Offset of field: lzma_stream_flags::reserved_bool6"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_bool7) as usize - ptr as usize },
        42usize,
        "Offset of field: lzma_stream_flags::reserved_bool7"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_bool8) as usize - ptr as usize },
        43usize,
        "Offset of field: lzma_stream_flags::reserved_bool8"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_int1) as usize - ptr as usize },
        44usize,
        "Offset of field: lzma_stream_flags::reserved_int1"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_int2) as usize - ptr as usize },
        48usize,
        "Offset of field: lzma_stream_flags::reserved_int2"
    );
}
extern "C" {
    pub fn lzma_stream_header_encode(options: *const lzma_stream_flags, out: *mut u8) -> lzma_ret;
}
extern "C" {
    pub fn lzma_stream_footer_encode(options: *const lzma_stream_flags, out: *mut u8) -> lzma_ret;
}
extern "C" {
    pub fn lzma_stream_header_decode(options: *mut lzma_stream_flags, in_: *const u8) -> lzma_ret;
}
extern "C" {
    pub fn lzma_stream_footer_decode(options: *mut lzma_stream_flags, in_: *const u8) -> lzma_ret;
}
extern "C" {
    pub fn lzma_stream_flags_compare(
        a: *const lzma_stream_flags,
        b: *const lzma_stream_flags,
    ) -> lzma_ret;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lzma_block {
    pub version: u32,
    pub header_size: u32,
    pub check: lzma_check,
    pub compressed_size: lzma_vli,
    pub uncompressed_size: lzma_vli,
    pub filters: *mut lzma_filter,
    pub raw_check: [u8; 64usize],
    pub reserved_ptr1: *mut ::std::os::raw::c_void,
    pub reserved_ptr2: *mut ::std::os::raw::c_void,
    pub reserved_ptr3: *mut ::std::os::raw::c_void,
    pub reserved_int1: u32,
    pub reserved_int2: u32,
    pub reserved_int3: lzma_vli,
    pub reserved_int4: lzma_vli,
    pub reserved_int5: lzma_vli,
    pub reserved_int6: lzma_vli,
    pub reserved_int7: lzma_vli,
    pub reserved_int8: lzma_vli,
    pub reserved_enum1: lzma_reserved_enum,
    pub reserved_enum2: lzma_reserved_enum,
    pub reserved_enum3: lzma_reserved_enum,
    pub reserved_enum4: lzma_reserved_enum,
    pub ignore_check: lzma_bool,
    pub reserved_bool2: lzma_bool,
    pub reserved_bool3: lzma_bool,
    pub reserved_bool4: lzma_bool,
    pub reserved_bool5: lzma_bool,
    pub reserved_bool6: lzma_bool,
    pub reserved_bool7: lzma_bool,
    pub reserved_bool8: lzma_bool,
}
#[test]
fn bindgen_test_layout_lzma_block() {
    const UNINIT: ::std::mem::MaybeUninit<lzma_block> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<lzma_block>(),
        208usize,
        "Size of lzma_block"
    );
    assert_eq!(
        ::std::mem::align_of::<lzma_block>(),
        8usize,
        "Alignment of lzma_block"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).version) as usize - ptr as usize },
        0usize,
        "Offset of field: lzma_block::version"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).header_size) as usize - ptr as usize },
        4usize,
        "Offset of field: lzma_block::header_size"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).check) as usize - ptr as usize },
        8usize,
        "Offset of field: lzma_block::check"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).compressed_size) as usize - ptr as usize },
        16usize,
        "Offset of field: lzma_block::compressed_size"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).uncompressed_size) as usize - ptr as usize },
        24usize,
        "Offset of field: lzma_block::uncompressed_size"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).filters) as usize - ptr as usize },
        32usize,
        "Offset of field: lzma_block::filters"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).raw_check) as usize - ptr as usize },
        40usize,
        "Offset of field: lzma_block::raw_check"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_ptr1) as usize - ptr as usize },
        104usize,
        "Offset of field: lzma_block::reserved_ptr1"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_ptr2) as usize - ptr as usize },
        112usize,
        "Offset of field: lzma_block::reserved_ptr2"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_ptr3) as usize - ptr as usize },
        120usize,
        "Offset of field: lzma_block::reserved_ptr3"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_int1) as usize - ptr as usize },
        128usize,
        "Offset of field: lzma_block::reserved_int1"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_int2) as usize - ptr as usize },
        132usize,
        "Offset of field: lzma_block::reserved_int2"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_int3) as usize - ptr as usize },
        136usize,
        "Offset of field: lzma_block::reserved_int3"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_int4) as usize - ptr as usize },
        144usize,
        "Offset of field: lzma_block::reserved_int4"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_int5) as usize - ptr as usize },
        152usize,
        "Offset of field: lzma_block::reserved_int5"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_int6) as usize - ptr as usize },
        160usize,
        "Offset of field: lzma_block::reserved_int6"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_int7) as usize - ptr as usize },
        168usize,
        "Offset of field: lzma_block::reserved_int7"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_int8) as usize - ptr as usize },
        176usize,
        "Offset of field: lzma_block::reserved_int8"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_enum1) as usize - ptr as usize },
        184usize,
        "Offset of field: lzma_block::reserved_enum1"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_enum2) as usize - ptr as usize },
        188usize,
        "Offset of field: lzma_block::reserved_enum2"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_enum3) as usize - ptr as usize },
        192usize,
        "Offset of field: lzma_block::reserved_enum3"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_enum4) as usize - ptr as usize },
        196usize,
        "Offset of field: lzma_block::reserved_enum4"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ignore_check) as usize - ptr as usize },
        200usize,
        "Offset of field: lzma_block::ignore_check"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_bool2) as usize - ptr as usize },
        201usize,
        "Offset of field: lzma_block::reserved_bool2"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_bool3) as usize - ptr as usize },
        202usize,
        "Offset of field: lzma_block::reserved_bool3"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_bool4) as usize - ptr as usize },
        203usize,
        "Offset of field: lzma_block::reserved_bool4"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_bool5) as usize - ptr as usize },
        204usize,
        "Offset of field: lzma_block::reserved_bool5"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_bool6) as usize - ptr as usize },
        205usize,
        "Offset of field: lzma_block::reserved_bool6"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_bool7) as usize - ptr as usize },
        206usize,
        "Offset of field: lzma_block::reserved_bool7"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_bool8) as usize - ptr as usize },
        207usize,
        "Offset of field: lzma_block::reserved_bool8"
    );
}
extern "C" {
    pub fn lzma_block_header_size(block: *mut lzma_block) -> lzma_ret;
}
extern "C" {
    pub fn lzma_block_header_encode(block: *const lzma_block, out: *mut u8) -> lzma_ret;
}
extern "C" {
    pub fn lzma_block_header_decode(
        block: *mut lzma_block,
        allocator: *const lzma_allocator,
        in_: *const u8,
    ) -> lzma_ret;
}
extern "C" {
    pub fn lzma_block_compressed_size(block: *mut lzma_block, unpadded_size: lzma_vli) -> lzma_ret;
}
extern "C" {
    pub fn lzma_block_unpadded_size(block: *const lzma_block) -> lzma_vli;
}
extern "C" {
    pub fn lzma_block_total_size(block: *const lzma_block) -> lzma_vli;
}
extern "C" {
    pub fn lzma_block_encoder(strm: *mut lzma_stream, block: *mut lzma_block) -> lzma_ret;
}
extern "C" {
    pub fn lzma_block_decoder(strm: *mut lzma_stream, block: *mut lzma_block) -> lzma_ret;
}
extern "C" {
    pub fn lzma_block_buffer_bound(uncompressed_size: usize) -> usize;
}
extern "C" {
    pub fn lzma_block_buffer_encode(
        block: *mut lzma_block,
        allocator: *const lzma_allocator,
        in_: *const u8,
        in_size: usize,
        out: *mut u8,
        out_pos: *mut usize,
        out_size: usize,
    ) -> lzma_ret;
}
extern "C" {
    pub fn lzma_block_uncomp_encode(
        block: *mut lzma_block,
        in_: *const u8,
        in_size: usize,
        out: *mut u8,
        out_pos: *mut usize,
        out_size: usize,
    ) -> lzma_ret;
}
extern "C" {
    pub fn lzma_block_buffer_decode(
        block: *mut lzma_block,
        allocator: *const lzma_allocator,
        in_: *const u8,
        in_pos: *mut usize,
        in_size: usize,
        out: *mut u8,
        out_pos: *mut usize,
        out_size: usize,
    ) -> lzma_ret;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lzma_index_s {
    _unused: [u8; 0],
}
pub type lzma_index = lzma_index_s;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct lzma_index_iter {
    pub stream: lzma_index_iter__bindgen_ty_1,
    pub block: lzma_index_iter__bindgen_ty_2,
    pub internal: [lzma_index_iter__bindgen_ty_3; 6usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lzma_index_iter__bindgen_ty_1 {
    pub flags: *const lzma_stream_flags,
    pub reserved_ptr1: *const ::std::os::raw::c_void,
    pub reserved_ptr2: *const ::std::os::raw::c_void,
    pub reserved_ptr3: *const ::std::os::raw::c_void,
    pub number: lzma_vli,
    pub block_count: lzma_vli,
    pub compressed_offset: lzma_vli,
    pub uncompressed_offset: lzma_vli,
    pub compressed_size: lzma_vli,
    pub uncompressed_size: lzma_vli,
    pub padding: lzma_vli,
    pub reserved_vli1: lzma_vli,
    pub reserved_vli2: lzma_vli,
    pub reserved_vli3: lzma_vli,
    pub reserved_vli4: lzma_vli,
}
#[test]
fn bindgen_test_layout_lzma_index_iter__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<lzma_index_iter__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<lzma_index_iter__bindgen_ty_1>(),
        120usize,
        "Size of lzma_index_iter__bindgen_ty_1"
    );
    assert_eq!(
        ::std::mem::align_of::<lzma_index_iter__bindgen_ty_1>(),
        8usize,
        "Alignment of lzma_index_iter__bindgen_ty_1"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        "Offset of field: lzma_index_iter__bindgen_ty_1::flags"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_ptr1) as usize - ptr as usize },
        8usize,
        "Offset of field: lzma_index_iter__bindgen_ty_1::reserved_ptr1"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_ptr2) as usize - ptr as usize },
        16usize,
        "Offset of field: lzma_index_iter__bindgen_ty_1::reserved_ptr2"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_ptr3) as usize - ptr as usize },
        24usize,
        "Offset of field: lzma_index_iter__bindgen_ty_1::reserved_ptr3"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).number) as usize - ptr as usize },
        32usize,
        "Offset of field: lzma_index_iter__bindgen_ty_1::number"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).block_count) as usize - ptr as usize },
        40usize,
        "Offset of field: lzma_index_iter__bindgen_ty_1::block_count"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).compressed_offset) as usize - ptr as usize },
        48usize,
        "Offset of field: lzma_index_iter__bindgen_ty_1::compressed_offset"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).uncompressed_offset) as usize - ptr as usize },
        56usize,
        "Offset of field: lzma_index_iter__bindgen_ty_1::uncompressed_offset"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).compressed_size) as usize - ptr as usize },
        64usize,
        "Offset of field: lzma_index_iter__bindgen_ty_1::compressed_size"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).uncompressed_size) as usize - ptr as usize },
        72usize,
        "Offset of field: lzma_index_iter__bindgen_ty_1::uncompressed_size"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).padding) as usize - ptr as usize },
        80usize,
        "Offset of field: lzma_index_iter__bindgen_ty_1::padding"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_vli1) as usize - ptr as usize },
        88usize,
        "Offset of field: lzma_index_iter__bindgen_ty_1::reserved_vli1"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_vli2) as usize - ptr as usize },
        96usize,
        "Offset of field: lzma_index_iter__bindgen_ty_1::reserved_vli2"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_vli3) as usize - ptr as usize },
        104usize,
        "Offset of field: lzma_index_iter__bindgen_ty_1::reserved_vli3"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_vli4) as usize - ptr as usize },
        112usize,
        "Offset of field: lzma_index_iter__bindgen_ty_1::reserved_vli4"
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lzma_index_iter__bindgen_ty_2 {
    pub number_in_file: lzma_vli,
    pub compressed_file_offset: lzma_vli,
    pub uncompressed_file_offset: lzma_vli,
    pub number_in_stream: lzma_vli,
    pub compressed_stream_offset: lzma_vli,
    pub uncompressed_stream_offset: lzma_vli,
    pub uncompressed_size: lzma_vli,
    pub unpadded_size: lzma_vli,
    pub total_size: lzma_vli,
    pub reserved_vli1: lzma_vli,
    pub reserved_vli2: lzma_vli,
    pub reserved_vli3: lzma_vli,
    pub reserved_vli4: lzma_vli,
    pub reserved_ptr1: *const ::std::os::raw::c_void,
    pub reserved_ptr2: *const ::std::os::raw::c_void,
    pub reserved_ptr3: *const ::std::os::raw::c_void,
    pub reserved_ptr4: *const ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_lzma_index_iter__bindgen_ty_2() {
    const UNINIT: ::std::mem::MaybeUninit<lzma_index_iter__bindgen_ty_2> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<lzma_index_iter__bindgen_ty_2>(),
        136usize,
        "Size of lzma_index_iter__bindgen_ty_2"
    );
    assert_eq!(
        ::std::mem::align_of::<lzma_index_iter__bindgen_ty_2>(),
        8usize,
        "Alignment of lzma_index_iter__bindgen_ty_2"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).number_in_file) as usize - ptr as usize },
        0usize,
        "Offset of field: lzma_index_iter__bindgen_ty_2::number_in_file"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).compressed_file_offset) as usize - ptr as usize },
        8usize,
        "Offset of field: lzma_index_iter__bindgen_ty_2::compressed_file_offset"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).uncompressed_file_offset) as usize - ptr as usize },
        16usize,
        "Offset of field: lzma_index_iter__bindgen_ty_2::uncompressed_file_offset"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).number_in_stream) as usize - ptr as usize },
        24usize,
        "Offset of field: lzma_index_iter__bindgen_ty_2::number_in_stream"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).compressed_stream_offset) as usize - ptr as usize },
        32usize,
        "Offset of field: lzma_index_iter__bindgen_ty_2::compressed_stream_offset"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).uncompressed_stream_offset) as usize - ptr as usize },
        40usize,
        "Offset of field: lzma_index_iter__bindgen_ty_2::uncompressed_stream_offset"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).uncompressed_size) as usize - ptr as usize },
        48usize,
        "Offset of field: lzma_index_iter__bindgen_ty_2::uncompressed_size"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).unpadded_size) as usize - ptr as usize },
        56usize,
        "Offset of field: lzma_index_iter__bindgen_ty_2::unpadded_size"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).total_size) as usize - ptr as usize },
        64usize,
        "Offset of field: lzma_index_iter__bindgen_ty_2::total_size"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_vli1) as usize - ptr as usize },
        72usize,
        "Offset of field: lzma_index_iter__bindgen_ty_2::reserved_vli1"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_vli2) as usize - ptr as usize },
        80usize,
        "Offset of field: lzma_index_iter__bindgen_ty_2::reserved_vli2"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_vli3) as usize - ptr as usize },
        88usize,
        "Offset of field: lzma_index_iter__bindgen_ty_2::reserved_vli3"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_vli4) as usize - ptr as usize },
        96usize,
        "Offset of field: lzma_index_iter__bindgen_ty_2::reserved_vli4"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_ptr1) as usize - ptr as usize },
        104usize,
        "Offset of field: lzma_index_iter__bindgen_ty_2::reserved_ptr1"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_ptr2) as usize - ptr as usize },
        112usize,
        "Offset of field: lzma_index_iter__bindgen_ty_2::reserved_ptr2"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_ptr3) as usize - ptr as usize },
        120usize,
        "Offset of field: lzma_index_iter__bindgen_ty_2::reserved_ptr3"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_ptr4) as usize - ptr as usize },
        128usize,
        "Offset of field: lzma_index_iter__bindgen_ty_2::reserved_ptr4"
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union lzma_index_iter__bindgen_ty_3 {
    pub p: *const ::std::os::raw::c_void,
    pub s: usize,
    pub v: lzma_vli,
}
#[test]
fn bindgen_test_layout_lzma_index_iter__bindgen_ty_3() {
    const UNINIT: ::std::mem::MaybeUninit<lzma_index_iter__bindgen_ty_3> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<lzma_index_iter__bindgen_ty_3>(),
        8usize,
        "Size of lzma_index_iter__bindgen_ty_3"
    );
    assert_eq!(
        ::std::mem::align_of::<lzma_index_iter__bindgen_ty_3>(),
        8usize,
        "Alignment of lzma_index_iter__bindgen_ty_3"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).p) as usize - ptr as usize },
        0usize,
        "Offset of field: lzma_index_iter__bindgen_ty_3::p"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).s) as usize - ptr as usize },
        0usize,
        "Offset of field: lzma_index_iter__bindgen_ty_3::s"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        "Offset of field: lzma_index_iter__bindgen_ty_3::v"
    );
}
#[test]
fn bindgen_test_layout_lzma_index_iter() {
    const UNINIT: ::std::mem::MaybeUninit<lzma_index_iter> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<lzma_index_iter>(),
        304usize,
        "Size of lzma_index_iter"
    );
    assert_eq!(
        ::std::mem::align_of::<lzma_index_iter>(),
        8usize,
        "Alignment of lzma_index_iter"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).stream) as usize - ptr as usize },
        0usize,
        "Offset of field: lzma_index_iter::stream"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).block) as usize - ptr as usize },
        120usize,
        "Offset of field: lzma_index_iter::block"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).internal) as usize - ptr as usize },
        256usize,
        "Offset of field: lzma_index_iter::internal"
    );
}
pub const lzma_index_iter_mode_LZMA_INDEX_ITER_ANY: lzma_index_iter_mode = 0;
pub const lzma_index_iter_mode_LZMA_INDEX_ITER_STREAM: lzma_index_iter_mode = 1;
pub const lzma_index_iter_mode_LZMA_INDEX_ITER_BLOCK: lzma_index_iter_mode = 2;
pub const lzma_index_iter_mode_LZMA_INDEX_ITER_NONEMPTY_BLOCK: lzma_index_iter_mode = 3;
pub type lzma_index_iter_mode = ::std::os::raw::c_uint;
extern "C" {
    pub fn lzma_index_memusage(streams: lzma_vli, blocks: lzma_vli) -> u64;
}
extern "C" {
    pub fn lzma_index_memused(i: *const lzma_index) -> u64;
}
extern "C" {
    pub fn lzma_index_init(allocator: *const lzma_allocator) -> *mut lzma_index;
}
extern "C" {
    pub fn lzma_index_end(i: *mut lzma_index, allocator: *const lzma_allocator);
}
extern "C" {
    pub fn lzma_index_append(
        i: *mut lzma_index,
        allocator: *const lzma_allocator,
        unpadded_size: lzma_vli,
        uncompressed_size: lzma_vli,
    ) -> lzma_ret;
}
extern "C" {
    pub fn lzma_index_stream_flags(
        i: *mut lzma_index,
        stream_flags: *const lzma_stream_flags,
    ) -> lzma_ret;
}
extern "C" {
    pub fn lzma_index_checks(i: *const lzma_index) -> u32;
}
extern "C" {
    pub fn lzma_index_stream_padding(i: *mut lzma_index, stream_padding: lzma_vli) -> lzma_ret;
}
extern "C" {
    pub fn lzma_index_stream_count(i: *const lzma_index) -> lzma_vli;
}
extern "C" {
    pub fn lzma_index_block_count(i: *const lzma_index) -> lzma_vli;
}
extern "C" {
    pub fn lzma_index_size(i: *const lzma_index) -> lzma_vli;
}
extern "C" {
    pub fn lzma_index_stream_size(i: *const lzma_index) -> lzma_vli;
}
extern "C" {
    pub fn lzma_index_total_size(i: *const lzma_index) -> lzma_vli;
}
extern "C" {
    pub fn lzma_index_file_size(i: *const lzma_index) -> lzma_vli;
}
extern "C" {
    pub fn lzma_index_uncompressed_size(i: *const lzma_index) -> lzma_vli;
}
extern "C" {
    pub fn lzma_index_iter_init(iter: *mut lzma_index_iter, i: *const lzma_index);
}
extern "C" {
    pub fn lzma_index_iter_rewind(iter: *mut lzma_index_iter);
}
extern "C" {
    pub fn lzma_index_iter_next(
        iter: *mut lzma_index_iter,
        mode: lzma_index_iter_mode,
    ) -> lzma_bool;
}
extern "C" {
    pub fn lzma_index_iter_locate(iter: *mut lzma_index_iter, target: lzma_vli) -> lzma_bool;
}
extern "C" {
    pub fn lzma_index_cat(
        dest: *mut lzma_index,
        src: *mut lzma_index,
        allocator: *const lzma_allocator,
    ) -> lzma_ret;
}
extern "C" {
    pub fn lzma_index_dup(
        i: *const lzma_index,
        allocator: *const lzma_allocator,
    ) -> *mut lzma_index;
}
extern "C" {
    pub fn lzma_index_encoder(strm: *mut lzma_stream, i: *const lzma_index) -> lzma_ret;
}
extern "C" {
    pub fn lzma_index_decoder(
        strm: *mut lzma_stream,
        i: *mut *mut lzma_index,
        memlimit: u64,
    ) -> lzma_ret;
}
extern "C" {
    pub fn lzma_index_buffer_encode(
        i: *const lzma_index,
        out: *mut u8,
        out_pos: *mut usize,
        out_size: usize,
    ) -> lzma_ret;
}
extern "C" {
    pub fn lzma_index_buffer_decode(
        i: *mut *mut lzma_index,
        memlimit: *mut u64,
        allocator: *const lzma_allocator,
        in_: *const u8,
        in_pos: *mut usize,
        in_size: usize,
    ) -> lzma_ret;
}
extern "C" {
    pub fn lzma_file_info_decoder(
        strm: *mut lzma_stream,
        dest_index: *mut *mut lzma_index,
        memlimit: u64,
        file_size: u64,
    ) -> lzma_ret;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lzma_index_hash_s {
    _unused: [u8; 0],
}
pub type lzma_index_hash = lzma_index_hash_s;
extern "C" {
    pub fn lzma_index_hash_init(
        index_hash: *mut lzma_index_hash,
        allocator: *const lzma_allocator,
    ) -> *mut lzma_index_hash;
}
extern "C" {
    pub fn lzma_index_hash_end(index_hash: *mut lzma_index_hash, allocator: *const lzma_allocator);
}
extern "C" {
    pub fn lzma_index_hash_append(
        index_hash: *mut lzma_index_hash,
        unpadded_size: lzma_vli,
        uncompressed_size: lzma_vli,
    ) -> lzma_ret;
}
extern "C" {
    pub fn lzma_index_hash_decode(
        index_hash: *mut lzma_index_hash,
        in_: *const u8,
        in_pos: *mut usize,
        in_size: usize,
    ) -> lzma_ret;
}
extern "C" {
    pub fn lzma_index_hash_size(index_hash: *const lzma_index_hash) -> lzma_vli;
}
extern "C" {
    pub fn lzma_physmem() -> u64;
}
extern "C" {
    pub fn lzma_cputhreads() -> u32;
}
