#!/usr/bin/env bash

set -e
cd $(dirname "$0")
out=parameterized-icmp.clif
CCS="eq ne ult ule ugt uge slt sle sgt sge"

function main {
    cat << EOF > $out
test optimize precise-output
set opt_level=speed
target x86_64

;; !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;; !!! GENERATED BY 'make-icmp-parameterized-tests.sh' DO NOT EDIT !!!
;; !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;; run with the 'CRANELIFT_TEST_BLESS=1' env var set to update this file

EOF

    # Reflexivity/irreflexivity of `icmp`` cond codes:
    # for reflexive cond codes,   (icmp cc x x) == true.
    # for irreflexive cond codes, (icmp cc x x) == false.
    for cc in $CCS; do
        cat << EOF >> $out
function %icmp_${cc}_self(i32) -> i8 {
block0(v0: i32):
    v1 = icmp ${cc} v0, v0
    return v1
}

EOF
    done

    # Comparisons against largest/smallest signed/unsigned values:
    for cc in $CCS; do
        cat << EOF >> $out
function %icmp_${cc}_umin(i32) -> i8 {
block0(v0: i32):
    v1 = iconst.i32 0
    v2 = icmp ${cc} v0, v1
    return v2
}

function %icmp_${cc}_umax(i32) -> i8 {
block0(v0: i32):
    v1 = iconst.i32 0xFFFF_FFFF
    v2 = icmp ${cc} v0, v1
    return v2
}

function %icmp_${cc}_smin(i32) -> i8 {
block0(v0: i32):
    v1 = iconst.i32 0x8000_0000
    v2 = icmp ${cc} v0, v1
    return v2
}

function %icmp_${cc}_smax(i32) -> i8 {
block0(v0: i32):
    v1 = iconst.i32 0x7FFF_FFFF
    v2 = icmp ${cc} v0, v1
    return v2
}

EOF
    done

    # `band`/`bor` of 2 comparisons:
    for op in "and" "or"; do
        for cc1 in $CCS; do
            for cc2 in $CCS; do
                cat << EOF >> $out
function %icmp_${op}_${cc1}_${cc2}(i32, i32) -> i8 {
block0(v0: i32, v1: i32):
    v2 = icmp ${cc1} v0, v1
    v3 = icmp ${cc2} v0, v1
    v4 = b${op} v2, v3
    return v4
}

EOF
            done
        done
    done
}

main
