/*
   Unix SMB/CIFS implementation.
   User/Group specific flags

   Copyright (C) Andrew Tridgell 2001-2003

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* Please keep this list in sync with the flag_mapping.c and pydsdb.c */

/* User flags for "userAccountControl" */
#define UF_SCRIPT	 			0x00000001  /* NT or Lan Manager Login script must be executed */
#define UF_ACCOUNTDISABLE			0x00000002
#define UF_00000004				0x00000004
#define UF_HOMEDIR_REQUIRED			0x00000008

#define UF_LOCKOUT				0x00000010
#define UF_PASSWD_NOTREQD			0x00000020
#define UF_PASSWD_CANT_CHANGE			0x00000040
#define UF_ENCRYPTED_TEXT_PASSWORD_ALLOWED	0x00000080

#define UF_TEMP_DUPLICATE_ACCOUNT		0x00000100 /* Local user account in usrmgr */
#define UF_NORMAL_ACCOUNT			0x00000200
#define UF_00000400				0x00000400
#define UF_INTERDOMAIN_TRUST_ACCOUNT		0x00000800

#define UF_WORKSTATION_TRUST_ACCOUNT		0x00001000
#define UF_SERVER_TRUST_ACCOUNT			0x00002000
#define UF_00004000				0x00004000
#define UF_00008000				0x00008000

#define UF_DONT_EXPIRE_PASSWD			0x00010000
#define UF_MNS_LOGON_ACCOUNT			0x00020000
#define UF_SMARTCARD_REQUIRED			0x00040000
#define UF_TRUSTED_FOR_DELEGATION		0x00080000

#define UF_NOT_DELEGATED			0x00100000
#define UF_USE_DES_KEY_ONLY			0x00200000
#define UF_DONT_REQUIRE_PREAUTH			0x00400000
#define UF_PASSWORD_EXPIRED			0x00800000
#define UF_TRUSTED_TO_AUTHENTICATE_FOR_DELEGATION 0x01000000
#define UF_NO_AUTH_DATA_REQUIRED		0x02000000
#define UF_PARTIAL_SECRETS_ACCOUNT		0x04000000
#define UF_USE_AES_KEYS                         0x08000000

/* Please keep this list in sync with the flag_mapping.c and pydsdb.c */


#define UF_TRUST_ACCOUNT_MASK (\
		UF_INTERDOMAIN_TRUST_ACCOUNT |\
		UF_WORKSTATION_TRUST_ACCOUNT |\
		UF_SERVER_TRUST_ACCOUNT \
		)

#define UF_ACCOUNT_TYPE_MASK (\
		UF_TEMP_DUPLICATE_ACCOUNT |\
		UF_NORMAL_ACCOUNT |\
		UF_INTERDOMAIN_TRUST_ACCOUNT |\
		UF_WORKSTATION_TRUST_ACCOUNT |\
		UF_SERVER_TRUST_ACCOUNT \
                )

/*
 * MS-SAMR 2.2.1.13 UF_FLAG Codes states that some bits are ignored by
 * clients and servers.  Other flags (like UF_LOCKOUT have special
 * behaviours, but are not set in the traditional sense).
 *
 * See the samldb module for the use of this define.
 */

#define UF_SETTABLE_BITS (\
		UF_ACCOUNTDISABLE |\
		UF_HOMEDIR_REQUIRED  |\
		UF_PASSWD_NOTREQD |\
		UF_ACCOUNT_TYPE_MASK | \
		UF_DONT_EXPIRE_PASSWD | \
		UF_MNS_LOGON_ACCOUNT |\
		UF_ENCRYPTED_TEXT_PASSWORD_ALLOWED |\
		UF_SMARTCARD_REQUIRED |\
		UF_TRUSTED_FOR_DELEGATION |\
		UF_NOT_DELEGATED |\
		UF_USE_DES_KEY_ONLY  |\
		UF_DONT_REQUIRE_PREAUTH |\
	        UF_TRUSTED_TO_AUTHENTICATE_FOR_DELEGATION |\
	        UF_NO_AUTH_DATA_REQUIRED |\
		UF_PARTIAL_SECRETS_ACCOUNT |\
		UF_USE_AES_KEYS \
		)

/* Group flags for "groupType" */
#define GROUP_TYPE_BUILTIN_LOCAL_GROUP		0x00000001
#define GROUP_TYPE_ACCOUNT_GROUP		0x00000002
#define GROUP_TYPE_RESOURCE_GROUP		0x00000004
#define GROUP_TYPE_UNIVERSAL_GROUP		0x00000008
#define GROUP_TYPE_APP_BASIC_GROUP		0x00000010
#define GROUP_TYPE_APP_QUERY_GROUP		0x00000020
#define GROUP_TYPE_SECURITY_ENABLED		0x80000000

#define GTYPE_SECURITY_BUILTIN_LOCAL_GROUP ( \
		/* 0x80000005 -2147483643 */ \
		GROUP_TYPE_BUILTIN_LOCAL_GROUP| \
		GROUP_TYPE_RESOURCE_GROUP| \
		GROUP_TYPE_SECURITY_ENABLED \
		)
#define GTYPE_SECURITY_DOMAIN_LOCAL_GROUP ( \
		/* 0x80000004 -2147483644 */ \
		GROUP_TYPE_RESOURCE_GROUP| \
		GROUP_TYPE_SECURITY_ENABLED \
		)
#define GTYPE_SECURITY_GLOBAL_GROUP ( \
		/* 0x80000002 -2147483646 */ \
		GROUP_TYPE_ACCOUNT_GROUP| \
		GROUP_TYPE_SECURITY_ENABLED \
		)
#define GTYPE_SECURITY_UNIVERSAL_GROUP ( \
		/* 0x80000008 -2147483640 */ \
		GROUP_TYPE_UNIVERSAL_GROUP| \
		GROUP_TYPE_SECURITY_ENABLED \
		)
#define GTYPE_DISTRIBUTION_GLOBAL_GROUP		0x00000002	/* 2 */
#define GTYPE_DISTRIBUTION_DOMAIN_LOCAL_GROUP	0x00000004	/* 4 */
#define GTYPE_DISTRIBUTION_UNIVERSAL_GROUP	0x00000008	/* 8 */

/* Account flags for "sAMAccountType" */
#define ATYPE_NORMAL_ACCOUNT			0x30000000 /* 805306368 */
#define ATYPE_WORKSTATION_TRUST			0x30000001 /* 805306369 */
#define ATYPE_INTERDOMAIN_TRUST			0x30000002 /* 805306370 */
#define ATYPE_SECURITY_GLOBAL_GROUP		0x10000000 /* 268435456 */
#define ATYPE_SECURITY_LOCAL_GROUP		0x20000000 /* 536870912 */
#define ATYPE_SECURITY_UNIVERSAL_GROUP		ATYPE_SECURITY_GLOBAL_GROUP
#define ATYPE_DISTRIBUTION_GLOBAL_GROUP		0x10000001 /* 268435457 */
#define ATYPE_DISTRIBUTION_LOCAL_GROUP		0x20000001 /* 536870913 */
#define ATYPE_DISTRIBUTION_UNIVERSAL_GROUP	ATYPE_DISTRIBUTION_GLOBAL_GROUP

#define ATYPE_ACCOUNT		ATYPE_NORMAL_ACCOUNT		/* 0x30000000 805306368 */
#define ATYPE_GLOBAL_GROUP	ATYPE_SECURITY_GLOBAL_GROUP	/* 0x10000000 268435456 */
#define ATYPE_LOCAL_GROUP	ATYPE_SECURITY_LOCAL_GROUP	/* 0x20000000 536870912 */

/* "instanceType" */
#define INSTANCE_TYPE_IS_NC_HEAD	0x00000001
#define INSTANCE_TYPE_UNINSTANT		0x00000002
#define INSTANCE_TYPE_WRITE		0x00000004
#define INSTANCE_TYPE_NC_ABOVE		0x00000008
#define INSTANCE_TYPE_NC_COMING		0x00000010
#define INSTANCE_TYPE_NC_GOING		0x00000020

/* "systemFlags" */
#define SYSTEM_FLAG_CR_NTDS_NC			0x00000001
#define SYSTEM_FLAG_CR_NTDS_DOMAIN		0x00000002
#define SYSTEM_FLAG_CR_NTDS_NOT_GC_REPLICATED	0x00000004
#define SYSTEM_FLAG_SCHEMA_BASE_OBJECT		0x00000010
#define SYSTEM_FLAG_ATTR_IS_RDN			0x00000020
#define SYSTEM_FLAG_DISALLOW_MOVE_ON_DELETE	0x02000000
#define SYSTEM_FLAG_DOMAIN_DISALLOW_MOVE	0x04000000
#define SYSTEM_FLAG_DOMAIN_DISALLOW_RENAME	0x08000000
#define SYSTEM_FLAG_CONFIG_ALLOW_LIMITED_MOVE	0x10000000
#define SYSTEM_FLAG_CONFIG_ALLOW_MOVE		0x20000000
#define SYSTEM_FLAG_CONFIG_ALLOW_RENAME		0x40000000
#define SYSTEM_FLAG_DISALLOW_DELETE		0x80000000

/* schemaFlags_Ex */
#define SCHEMA_FLAG_ATTR_IS_CRITICAL	0x0000001

/* "searchFlags" */
#define SEARCH_FLAG_ATTINDEX		0x0000001
#define SEARCH_FLAG_PDNTATTINDEX	0x0000002
#define SEARCH_FLAG_ANR			0x0000004
#define SEARCH_FLAG_PRESERVEONDELETE	0x0000008
#define SEARCH_FLAG_COPY		0x0000010
#define SEARCH_FLAG_TUPLEINDEX		0x0000020
#define SEARCH_FLAG_SUBTREEATTRINDEX	0x0000040
#define SEARCH_FLAG_CONFIDENTIAL	0x0000080
#define SEARCH_FLAG_NEVERVALUEAUDIT	0x0000100
#define SEARCH_FLAG_RODC_ATTRIBUTE	0x0000200

/* "domainFunctionality", "forestFunctionality" and "domainControllerFunctionality" in the rootDSE */
#define DS_DOMAIN_FUNCTION_2000		0
#define DS_DOMAIN_FUNCTION_2003_MIXED	1 /* Not a valid/meaningful
					   * domainControllerFunctionality
					   * Level */
#define DS_DOMAIN_FUNCTION_2003		2
#define DS_DOMAIN_FUNCTION_2008		3
#define DS_DOMAIN_FUNCTION_2008_R2	4
#define DS_DOMAIN_FUNCTION_2012 	5
#define DS_DOMAIN_FUNCTION_2012_R2	6
#define DS_DOMAIN_FUNCTION_2016		7

/* sa->systemFlags on attributes */
#define DS_FLAG_ATTR_NOT_REPLICATED    0x00000001
#define DS_FLAG_ATTR_REQ_PARTIAL_SET_MEMBER 0x00000002
#define DS_FLAG_ATTR_IS_CONSTRUCTED    0x00000004

/* 7.1.1.2.2.1.1		nTDSSiteSettings Object options */
#define DS_NTDSSETTINGS_OPT_IS_AUTO_TOPOLOGY_DISABLED			0x00000001
#define DS_NTDSSETTINGS_OPT_IS_TOPL_CLEANUP_DISABLED			0x00000002
#define DS_NTDSSETTINGS_OPT_IS_TOPL_MIN_HOPS_DISABLED			0x00000004
#define DS_NTDSSETTINGS_OPT_IS_TOPL_DETECT_STALE_DISABLED		0x00000008
#define DS_NTDSSETTINGS_OPT_IS_INTER_SITE_AUTO_TOPOLOGY_DISABLED 	0x00000010
#define DS_NTDSSETTINGS_OPT_IS_GROUP_CACHING_ENABLED			0x00000020
#define DS_NTDSSETTINGS_OPT_FORCE_KCC_WHISTLER_BEHAVIOR			0x00000040
#define DS_NTDSSETTINGS_OPT_IS_RAND_BH_SELECTION_DISABLED		0x00000100
#define DS_NTDSSETTINGS_OPT_IS_SCHEDULE_HASHING_ENABLED			0x00000200
#define DS_NTDSSETTINGS_OPT_IS_REDUNDANT_SERVER_TOPOLOGY_ENABLED 	0x00000400

/* 7.1.1.2.2.1.2.1.1           nTDSDSA Object options flags */
#define DS_NTDSDSA_OPT_IS_GC                    0x00000001
#define DS_NTDSDSA_OPT_DISABLE_INBOUND_REPL     0x00000002
#define DS_NTDSDSA_OPT_DISABLE_OUTBOUND_REPL    0x00000004
#define DS_NTDSDSA_OPT_DISABLE_NTDSCONN_XLATE   0x00000008
#define DS_NTDSDSA_OPT_DISABLE_SPN_REGISTRATION 0x00000010

/* wellknown GUID strings for AD objects. See MS-ADTS 7.1.1.4 */
#define DS_GUID_COMPUTERS_CONTAINER                   "AA312825768811D1ADED00C04FD8D5CD"
#define DS_GUID_DELETED_OBJECTS_CONTAINER             "18E2EA80684F11D2B9AA00C04F79F805"
#define DS_GUID_DOMAIN_CONTROLLERS_CONTAINER          "A361B2FFFFD211D1AA4B00C04FD7D83A"
#define DS_GUID_FOREIGNSECURITYPRINCIPALS_CONTAINER   "22B70C67D56E4EFB91E9300FCA3DC1AA"
#define DS_GUID_INFRASTRUCTURE_CONTAINER              "2FBAC1870ADE11D297C400C04FD8D5CD"
#define DS_GUID_LOSTANDFOUND_CONTAINER                "AB8153B7768811D1ADED00C04FD8D5CD"
#define DS_GUID_MICROSOFT_PROGRAM_DATA_CONTAINER      "F4BE92A4C777485E878E9421D53087DB"
#define DS_GUID_NTDS_QUOTAS_CONTAINER                 "6227F0AF1FC2410D8E3BB10615BB5B0F"
#define DS_GUID_PROGRAM_DATA_CONTAINER                "09460C08AE1E4A4EA0F64AEE7DAA1E5A"
#define DS_GUID_SYSTEMS_CONTAINER                     "AB1D30F3768811D1ADED00C04FD8D5CD"
#define DS_GUID_USERS_CONTAINER                       "A9D1CA15768811D1ADED00C04FD8D5CD"
#define DS_GUID_MANAGED_SERVICE_ACCOUNTS_CONTAINER    "1EB93889E40C45DF9F0C64D23BBB6237"

/* wellknown GUIDs for optional directory features */
#define DS_GUID_FEATURE_RECYCLE_BIN		      "766ddcd8-acd0-445e-f3b9-a7f9b6744f2a"

/* GUIDs for AD schema attributes and classes */
#define DS_GUID_SCHEMA_ATTR_DEPARTMENT                "bf96794f-0de6-11d0-a285-00aa003049e2"
#define DS_GUID_SCHEMA_ATTR_DNS_HOST_NAME             "72e39547-7b18-11d1-adef-00c04fd8d5cd"
#define DS_GUID_SCHEMA_ATTR_INSTANCE_TYPE             "bf96798c-0de6-11d0-a285-00aa003049e2"
#define DS_GUID_SCHEMA_ATTR_MS_DS_KEY_CREDENTIAL_LINK "5b47d60f-6090-40b2-9f37-2a4de88f3063"
#define DS_GUID_SCHEMA_ATTR_MS_SFU_30                 "16c5d1d3-35c2-4061-a870-a5cefda804f0"
#define DS_GUID_SCHEMA_ATTR_NT_SECURITY_DESCRIPTOR    "bf9679e3-0de6-11d0-a285-00aa003049e2"
#define DS_GUID_SCHEMA_ATTR_PRIMARY_GROUP_ID          "bf967a00-0de6-11d0-a285-00aa003049e2"
#define DS_GUID_SCHEMA_ATTR_SAM_ACCOUNT_NAME          "3e0abfd0-126a-11d0-a060-00aa006c33ed"
#define DS_GUID_SCHEMA_ATTR_SERVICE_PRINCIPAL_NAME    "f3a64788-5306-11d1-a9c5-0000f80367c1"
#define DS_GUID_SCHEMA_ATTR_USER_ACCOUNT_CONTROL      "bf967a68-0de6-11d0-a285-00aa003049e2"
#define DS_GUID_SCHEMA_ATTR_USER_PASSWORD             "bf967a6e-0de6-11d0-a285-00aa003049e2"
#define DS_GUID_SCHEMA_CLASS_COMPUTER                 "bf967a86-0de6-11d0-a285-00aa003049e2"
#define DS_GUID_SCHEMA_CLASS_MANAGED_SERVICE_ACCOUNT  "ce206244-5827-4a86-ba1c-1c0c386c1b64"
#define DS_GUID_SCHEMA_CLASS_USER                     "bf967aba-0de6-11d0-a285-00aa003049e2"

/* dsHeuristics character indexes see MS-ADTS 7.1.1.2.4.1.2 */

#define DS_HR_SUPFIRSTLASTANR                     0x00000001
#define DS_HR_SUPLASTFIRSTANR                     0x00000002
#define DS_HR_DOLISTOBJECT                        0x00000003
#define DS_HR_DONICKRES                           0x00000004
#define DS_HR_LDAP_USEPERMMOD                     0x00000005
#define DS_HR_HIDEDSID                            0x00000006
#define DS_HR_BLOCK_ANONYMOUS_OPS                 0x00000007
#define DS_HR_ALLOW_ANON_NSPI                     0x00000008
#define DS_HR_USER_PASSWORD_SUPPORT               0x00000009
#define DS_HR_TENTH_CHAR                          0x0000000A
#define DS_HR_SPECIFY_GUID_ON_ADD                 0x0000000B
#define DS_HR_NO_STANDARD_SD                      0x0000000C
#define DS_HR_ALLOW_NONSECURE_PWD_OPS             0x0000000D
#define DS_HR_NO_PROPAGATE_ON_NOCHANGE            0x0000000E
#define DS_HR_COMPUTE_ANR_STATS                   0x0000000F
#define DS_HR_ADMINSDEXMASK                       0x00000010
#define DS_HR_KVNOEMUW2K                          0x00000011

#define DS_HR_TWENTIETH_CHAR                      0x00000014
#define DS_HR_ATTR_AUTHZ_ON_LDAP_ADD              0x0000001C
#define DS_HR_BLOCK_OWNER_IMPLICIT_RIGHTS         0x0000001D
#define DS_HR_THIRTIETH_CHAR                      0x0000001E
#define DS_HR_FOURTIETH_CHAR                      0x00000028
#define DS_HR_FIFTIETH_CHAR                       0x00000032
#define DS_HR_SIXTIETH_CHAR                       0x0000003C
#define DS_HR_SEVENTIETH_CHAR                     0x00000046
#define DS_HR_EIGHTIETH_CHAR                      0x00000050
#define DS_HR_NINETIETH_CHAR                      0x0000005A

/* mS-DS-ReplicatesNCReason */
#define NTDSCONN_KCC_GC_TOPOLOGY		     0x00000001
#define NTDSCONN_KCC_RING_TOPOLOGY		     0x00000002
#define NTDSCONN_KCC_MINIMIZE_HOPS_TOPOLOGY          0x00000004
#define NTDSCONN_KCC_STALE_SERVERS_TOPOLOGY          0x00000008
#define NTDSCONN_KCC_OSCILLATING_CONNECTION_TOPOLOGY 0x00000010
#define NTDSCONN_KCC_INTERSITE_GC_TOPOLOGY	     0x00000020
#define NTDSCONN_KCC_INTERSITE_TOPOLOGY              0x00000040
#define NTDSCONN_KCC_SERVER_FAILOVER_TOPOLOGY        0x00000080
#define NTDSCONN_KCC_SITE_FAILOVER_TOPOLOGY          0x00000100
#define NTDSCONN_KCC_REDUNDANT_SERVER_TOPOLOGY       0x00000200

#define NTDSCONN_OPT_IS_GENERATED			0x00000001
#define NTDSCONN_OPT_TWOWAY_SYNC			0x00000002
#define NTDSCONN_OPT_OVERRIDE_NOTIFY_DEFAULT		0x00000004
#define NTDSCONN_OPT_USE_NOTIFY				0x00000008
#define NTDSCONN_OPT_DISABLE_INTERSITE_COMPRESSION	0x00000010
#define NTDSCONN_OPT_USER_OWNED_SCHEDULE		0x00000020
#define NTDSCONN_OPT_RODC_TOPOLOGY			0x00000040

/* 7.1.1.2.2.3.3      Site Link Object options flags */
#define NTDSSITELINK_OPT_USE_NOTIFY                     0x00000001
#define NTDSSITELINK_OPT_TWOWAY_SYNC                    0x00000002
#define NTDSSITELINK_OPT_DISABLE_COMPRESSION            0x00000004
