//#define XERR
#include "loop.ih"

// define the column headers of the rounds table

    // by headerrounds.cc

void Loop::roundsColHdrs(CSVTable &tab) const
{
    auto const &active = d_modalities.activeMods();
    size_t nActive = active.size(); 

    tab.more() << ' ';                      // skip the 1st column (round nr)

            // IDs of the modalities
    for (size_t idx = 0, end = nActive - 1; idx != end; ++idx)
        tab.more() << join(4, FMT::CENTER) << active[idx]->id();
    tab.row() << join(4, FMT::CENTER) << active.back()->id();

    roundsMidLevelCols(tab);

    roundsBottomColNames(tab);

    tab << hline();                         // line before the rounds data
}

