<?php

return static function (mixed $data, \Psr\Container\ContainerInterface $valueTransformers, array $options): \Traversable {
    try {
        if (\is_array($data)) {
            yield '{';
            $prefix = '';
            foreach ($data as $key1 => $value1) {
                $key1 = \substr(\json_encode($key1), 1, -1);
                yield "{$prefix}\"{$key1}\":";
                yield '{"@id":';
                yield \json_encode($value1->id, \JSON_THROW_ON_ERROR, 510);
                yield ',"name":';
                yield \json_encode($value1->name, \JSON_THROW_ON_ERROR, 510);
                yield '}';
                $prefix = ',';
            }
            yield '}';
        } elseif (null === $data) {
            yield 'null';
        } else {
            throw new \Symfony\Component\JsonStreamer\Exception\UnexpectedValueException(\sprintf('Unexpected "%s" value.', \get_debug_type($data)));
        }
    } catch (\JsonException $e) {
        throw new \Symfony\Component\JsonStreamer\Exception\NotEncodableValueException($e->getMessage(), 0, $e);
    }
};
