#!/usr/bin/bash

common_modules=(address-allocation \
  address-environment address-table binder builtins cloning \
  common \
  common-procedure-utilities \
  configuration constructors cycles debug entities \
  errors-common expression-rebinding \
  expression-translation expressions hash-tables instances \
  translator-keywords \
  param-cache param-cache-opt parametrized-definitions \
  parametrized-instances pcode-common representation \
  special-procedures symbol-table target-object-printing \
  time translation-common type-system type-translation var-names \
  platform-specific statprof-work parameters)

compiler_modules=(compilation-errors compilation-utilities compiler-core-def \
  compilation1 compilation2 compile-unit compiler-constructors \
  fields \
  interface-pcode-reading \
  letrec-compilation letrec-env \
  macro-base macro-base2 macro-config macro-language macros \
  phase2-compilation primitive-expansion)

linker_modules=(linker-core-def linker-errors implementation-pcode-reading \
  link-program link-program-split linker-instantiation \
  scheme0-target-compilation \
  scheme-target-common scheme-target-compilation scheme-target-objects \
  stripping target-compilation-common tree-il-target-compilation \
  module-linking)

modules=("${common_modules[@]}" "${compiler_modules[@]}" "${linker_modules[@]}")

programs=(theme-d-compile-b theme-d-link-b)

for fl in ${modules[@]} ; do
    ../../../tools/compute-theme-d-pcode-deps.scm $fl.thi theme-d-in-theme-d
done

for fl in ${modules[@]} ; do
    ../../../tools/compute-theme-d-pcode-deps.scm $fl.thb theme-d-in-theme-d
done

for fl in ${programs[@]} ; do
    ../../../tools/compute-theme-d-pcode-deps.scm $fl.thp theme-d-in-theme-d
done
