// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file final.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#ifndef FAST_DDS_GENERATED__FINAL_HPP
#define FAST_DDS_GENERATED__FINAL_HPP

#include <cstdint>
#include <string>
#include <utility>
#include <fastcdr/cdr/fixed_size_string.hpp>
#include "helpers/basic_inner_types.hpp"

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(FINAL_SOURCE)
#define FINAL_DllAPI __declspec( dllexport )
#else
#define FINAL_DllAPI __declspec( dllimport )
#endif // FINAL_SOURCE
#else
#define FINAL_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define FINAL_DllAPI
#endif // _WIN32

/*!
 * @brief This class represents the structure FinalShortStruct defined by the user in the IDL file.
 * @ingroup final
 */
class FinalShortStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport FinalShortStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~FinalShortStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object FinalShortStruct that will be copied.
     */
    eProsima_user_DllExport FinalShortStruct(
            const FinalShortStruct& x)
    {
                    m_var_short = x.m_var_short;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object FinalShortStruct that will be copied.
     */
    eProsima_user_DllExport FinalShortStruct(
            FinalShortStruct&& x) noexcept
    {
        m_var_short = x.m_var_short;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object FinalShortStruct that will be copied.
     */
    eProsima_user_DllExport FinalShortStruct& operator =(
            const FinalShortStruct& x)
    {

                    m_var_short = x.m_var_short;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object FinalShortStruct that will be copied.
     */
    eProsima_user_DllExport FinalShortStruct& operator =(
            FinalShortStruct&& x) noexcept
    {

        m_var_short = x.m_var_short;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x FinalShortStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const FinalShortStruct& x) const
    {
        return (m_var_short == x.m_var_short);
    }

    /*!
     * @brief Comparison operator.
     * @param x FinalShortStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const FinalShortStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_short
     * @param _var_short New value for member var_short
     */
    eProsima_user_DllExport void var_short(
            int16_t _var_short)
    {
        m_var_short = _var_short;
    }

    /*!
     * @brief This function returns the value of member var_short
     * @return Value of member var_short
     */
    eProsima_user_DllExport int16_t var_short() const
    {
        return m_var_short;
    }

    /*!
     * @brief This function returns a reference to member var_short
     * @return Reference to member var_short
     */
    eProsima_user_DllExport int16_t& var_short()
    {
        return m_var_short;
    }



private:

    int16_t m_var_short{0};

};
/*!
 * @brief This class represents the structure FinalUShortStruct defined by the user in the IDL file.
 * @ingroup final
 */
class FinalUShortStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport FinalUShortStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~FinalUShortStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object FinalUShortStruct that will be copied.
     */
    eProsima_user_DllExport FinalUShortStruct(
            const FinalUShortStruct& x)
    {
                    m_var_ushort = x.m_var_ushort;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object FinalUShortStruct that will be copied.
     */
    eProsima_user_DllExport FinalUShortStruct(
            FinalUShortStruct&& x) noexcept
    {
        m_var_ushort = x.m_var_ushort;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object FinalUShortStruct that will be copied.
     */
    eProsima_user_DllExport FinalUShortStruct& operator =(
            const FinalUShortStruct& x)
    {

                    m_var_ushort = x.m_var_ushort;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object FinalUShortStruct that will be copied.
     */
    eProsima_user_DllExport FinalUShortStruct& operator =(
            FinalUShortStruct&& x) noexcept
    {

        m_var_ushort = x.m_var_ushort;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x FinalUShortStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const FinalUShortStruct& x) const
    {
        return (m_var_ushort == x.m_var_ushort);
    }

    /*!
     * @brief Comparison operator.
     * @param x FinalUShortStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const FinalUShortStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_ushort
     * @param _var_ushort New value for member var_ushort
     */
    eProsima_user_DllExport void var_ushort(
            uint16_t _var_ushort)
    {
        m_var_ushort = _var_ushort;
    }

    /*!
     * @brief This function returns the value of member var_ushort
     * @return Value of member var_ushort
     */
    eProsima_user_DllExport uint16_t var_ushort() const
    {
        return m_var_ushort;
    }

    /*!
     * @brief This function returns a reference to member var_ushort
     * @return Reference to member var_ushort
     */
    eProsima_user_DllExport uint16_t& var_ushort()
    {
        return m_var_ushort;
    }



private:

    uint16_t m_var_ushort{0};

};
/*!
 * @brief This class represents the structure FinalLongStruct defined by the user in the IDL file.
 * @ingroup final
 */
class FinalLongStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport FinalLongStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~FinalLongStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object FinalLongStruct that will be copied.
     */
    eProsima_user_DllExport FinalLongStruct(
            const FinalLongStruct& x)
    {
                    m_var_long = x.m_var_long;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object FinalLongStruct that will be copied.
     */
    eProsima_user_DllExport FinalLongStruct(
            FinalLongStruct&& x) noexcept
    {
        m_var_long = x.m_var_long;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object FinalLongStruct that will be copied.
     */
    eProsima_user_DllExport FinalLongStruct& operator =(
            const FinalLongStruct& x)
    {

                    m_var_long = x.m_var_long;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object FinalLongStruct that will be copied.
     */
    eProsima_user_DllExport FinalLongStruct& operator =(
            FinalLongStruct&& x) noexcept
    {

        m_var_long = x.m_var_long;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x FinalLongStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const FinalLongStruct& x) const
    {
        return (m_var_long == x.m_var_long);
    }

    /*!
     * @brief Comparison operator.
     * @param x FinalLongStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const FinalLongStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_long
     * @param _var_long New value for member var_long
     */
    eProsima_user_DllExport void var_long(
            int32_t _var_long)
    {
        m_var_long = _var_long;
    }

    /*!
     * @brief This function returns the value of member var_long
     * @return Value of member var_long
     */
    eProsima_user_DllExport int32_t var_long() const
    {
        return m_var_long;
    }

    /*!
     * @brief This function returns a reference to member var_long
     * @return Reference to member var_long
     */
    eProsima_user_DllExport int32_t& var_long()
    {
        return m_var_long;
    }



private:

    int32_t m_var_long{0};

};
/*!
 * @brief This class represents the structure FinalULongStruct defined by the user in the IDL file.
 * @ingroup final
 */
class FinalULongStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport FinalULongStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~FinalULongStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object FinalULongStruct that will be copied.
     */
    eProsima_user_DllExport FinalULongStruct(
            const FinalULongStruct& x)
    {
                    m_var_ulong = x.m_var_ulong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object FinalULongStruct that will be copied.
     */
    eProsima_user_DllExport FinalULongStruct(
            FinalULongStruct&& x) noexcept
    {
        m_var_ulong = x.m_var_ulong;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object FinalULongStruct that will be copied.
     */
    eProsima_user_DllExport FinalULongStruct& operator =(
            const FinalULongStruct& x)
    {

                    m_var_ulong = x.m_var_ulong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object FinalULongStruct that will be copied.
     */
    eProsima_user_DllExport FinalULongStruct& operator =(
            FinalULongStruct&& x) noexcept
    {

        m_var_ulong = x.m_var_ulong;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x FinalULongStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const FinalULongStruct& x) const
    {
        return (m_var_ulong == x.m_var_ulong);
    }

    /*!
     * @brief Comparison operator.
     * @param x FinalULongStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const FinalULongStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_ulong
     * @param _var_ulong New value for member var_ulong
     */
    eProsima_user_DllExport void var_ulong(
            uint32_t _var_ulong)
    {
        m_var_ulong = _var_ulong;
    }

    /*!
     * @brief This function returns the value of member var_ulong
     * @return Value of member var_ulong
     */
    eProsima_user_DllExport uint32_t var_ulong() const
    {
        return m_var_ulong;
    }

    /*!
     * @brief This function returns a reference to member var_ulong
     * @return Reference to member var_ulong
     */
    eProsima_user_DllExport uint32_t& var_ulong()
    {
        return m_var_ulong;
    }



private:

    uint32_t m_var_ulong{0};

};
/*!
 * @brief This class represents the structure FinalLongLongStruct defined by the user in the IDL file.
 * @ingroup final
 */
class FinalLongLongStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport FinalLongLongStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~FinalLongLongStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object FinalLongLongStruct that will be copied.
     */
    eProsima_user_DllExport FinalLongLongStruct(
            const FinalLongLongStruct& x)
    {
                    m_var_longlong = x.m_var_longlong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object FinalLongLongStruct that will be copied.
     */
    eProsima_user_DllExport FinalLongLongStruct(
            FinalLongLongStruct&& x) noexcept
    {
        m_var_longlong = x.m_var_longlong;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object FinalLongLongStruct that will be copied.
     */
    eProsima_user_DllExport FinalLongLongStruct& operator =(
            const FinalLongLongStruct& x)
    {

                    m_var_longlong = x.m_var_longlong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object FinalLongLongStruct that will be copied.
     */
    eProsima_user_DllExport FinalLongLongStruct& operator =(
            FinalLongLongStruct&& x) noexcept
    {

        m_var_longlong = x.m_var_longlong;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x FinalLongLongStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const FinalLongLongStruct& x) const
    {
        return (m_var_longlong == x.m_var_longlong);
    }

    /*!
     * @brief Comparison operator.
     * @param x FinalLongLongStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const FinalLongLongStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_longlong
     * @param _var_longlong New value for member var_longlong
     */
    eProsima_user_DllExport void var_longlong(
            int64_t _var_longlong)
    {
        m_var_longlong = _var_longlong;
    }

    /*!
     * @brief This function returns the value of member var_longlong
     * @return Value of member var_longlong
     */
    eProsima_user_DllExport int64_t var_longlong() const
    {
        return m_var_longlong;
    }

    /*!
     * @brief This function returns a reference to member var_longlong
     * @return Reference to member var_longlong
     */
    eProsima_user_DllExport int64_t& var_longlong()
    {
        return m_var_longlong;
    }



private:

    int64_t m_var_longlong{0};

};
/*!
 * @brief This class represents the structure FinalULongLongStruct defined by the user in the IDL file.
 * @ingroup final
 */
class FinalULongLongStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport FinalULongLongStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~FinalULongLongStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object FinalULongLongStruct that will be copied.
     */
    eProsima_user_DllExport FinalULongLongStruct(
            const FinalULongLongStruct& x)
    {
                    m_var_ulonglong = x.m_var_ulonglong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object FinalULongLongStruct that will be copied.
     */
    eProsima_user_DllExport FinalULongLongStruct(
            FinalULongLongStruct&& x) noexcept
    {
        m_var_ulonglong = x.m_var_ulonglong;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object FinalULongLongStruct that will be copied.
     */
    eProsima_user_DllExport FinalULongLongStruct& operator =(
            const FinalULongLongStruct& x)
    {

                    m_var_ulonglong = x.m_var_ulonglong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object FinalULongLongStruct that will be copied.
     */
    eProsima_user_DllExport FinalULongLongStruct& operator =(
            FinalULongLongStruct&& x) noexcept
    {

        m_var_ulonglong = x.m_var_ulonglong;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x FinalULongLongStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const FinalULongLongStruct& x) const
    {
        return (m_var_ulonglong == x.m_var_ulonglong);
    }

    /*!
     * @brief Comparison operator.
     * @param x FinalULongLongStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const FinalULongLongStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_ulonglong
     * @param _var_ulonglong New value for member var_ulonglong
     */
    eProsima_user_DllExport void var_ulonglong(
            uint64_t _var_ulonglong)
    {
        m_var_ulonglong = _var_ulonglong;
    }

    /*!
     * @brief This function returns the value of member var_ulonglong
     * @return Value of member var_ulonglong
     */
    eProsima_user_DllExport uint64_t var_ulonglong() const
    {
        return m_var_ulonglong;
    }

    /*!
     * @brief This function returns a reference to member var_ulonglong
     * @return Reference to member var_ulonglong
     */
    eProsima_user_DllExport uint64_t& var_ulonglong()
    {
        return m_var_ulonglong;
    }



private:

    uint64_t m_var_ulonglong{0};

};
/*!
 * @brief This class represents the structure FinalFloatStruct defined by the user in the IDL file.
 * @ingroup final
 */
class FinalFloatStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport FinalFloatStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~FinalFloatStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object FinalFloatStruct that will be copied.
     */
    eProsima_user_DllExport FinalFloatStruct(
            const FinalFloatStruct& x)
    {
                    m_var_float = x.m_var_float;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object FinalFloatStruct that will be copied.
     */
    eProsima_user_DllExport FinalFloatStruct(
            FinalFloatStruct&& x) noexcept
    {
        m_var_float = x.m_var_float;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object FinalFloatStruct that will be copied.
     */
    eProsima_user_DllExport FinalFloatStruct& operator =(
            const FinalFloatStruct& x)
    {

                    m_var_float = x.m_var_float;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object FinalFloatStruct that will be copied.
     */
    eProsima_user_DllExport FinalFloatStruct& operator =(
            FinalFloatStruct&& x) noexcept
    {

        m_var_float = x.m_var_float;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x FinalFloatStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const FinalFloatStruct& x) const
    {
        return (m_var_float == x.m_var_float);
    }

    /*!
     * @brief Comparison operator.
     * @param x FinalFloatStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const FinalFloatStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_float
     * @param _var_float New value for member var_float
     */
    eProsima_user_DllExport void var_float(
            float _var_float)
    {
        m_var_float = _var_float;
    }

    /*!
     * @brief This function returns the value of member var_float
     * @return Value of member var_float
     */
    eProsima_user_DllExport float var_float() const
    {
        return m_var_float;
    }

    /*!
     * @brief This function returns a reference to member var_float
     * @return Reference to member var_float
     */
    eProsima_user_DllExport float& var_float()
    {
        return m_var_float;
    }



private:

    float m_var_float{0.0};

};
/*!
 * @brief This class represents the structure FinalDoubleStruct defined by the user in the IDL file.
 * @ingroup final
 */
class FinalDoubleStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport FinalDoubleStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~FinalDoubleStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object FinalDoubleStruct that will be copied.
     */
    eProsima_user_DllExport FinalDoubleStruct(
            const FinalDoubleStruct& x)
    {
                    m_var_double = x.m_var_double;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object FinalDoubleStruct that will be copied.
     */
    eProsima_user_DllExport FinalDoubleStruct(
            FinalDoubleStruct&& x) noexcept
    {
        m_var_double = x.m_var_double;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object FinalDoubleStruct that will be copied.
     */
    eProsima_user_DllExport FinalDoubleStruct& operator =(
            const FinalDoubleStruct& x)
    {

                    m_var_double = x.m_var_double;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object FinalDoubleStruct that will be copied.
     */
    eProsima_user_DllExport FinalDoubleStruct& operator =(
            FinalDoubleStruct&& x) noexcept
    {

        m_var_double = x.m_var_double;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x FinalDoubleStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const FinalDoubleStruct& x) const
    {
        return (m_var_double == x.m_var_double);
    }

    /*!
     * @brief Comparison operator.
     * @param x FinalDoubleStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const FinalDoubleStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_double
     * @param _var_double New value for member var_double
     */
    eProsima_user_DllExport void var_double(
            double _var_double)
    {
        m_var_double = _var_double;
    }

    /*!
     * @brief This function returns the value of member var_double
     * @return Value of member var_double
     */
    eProsima_user_DllExport double var_double() const
    {
        return m_var_double;
    }

    /*!
     * @brief This function returns a reference to member var_double
     * @return Reference to member var_double
     */
    eProsima_user_DllExport double& var_double()
    {
        return m_var_double;
    }



private:

    double m_var_double{0.0};

};
/*!
 * @brief This class represents the structure FinalLongDoubleStruct defined by the user in the IDL file.
 * @ingroup final
 */
class FinalLongDoubleStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport FinalLongDoubleStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~FinalLongDoubleStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object FinalLongDoubleStruct that will be copied.
     */
    eProsima_user_DllExport FinalLongDoubleStruct(
            const FinalLongDoubleStruct& x)
    {
                    m_var_longdouble = x.m_var_longdouble;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object FinalLongDoubleStruct that will be copied.
     */
    eProsima_user_DllExport FinalLongDoubleStruct(
            FinalLongDoubleStruct&& x) noexcept
    {
        m_var_longdouble = x.m_var_longdouble;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object FinalLongDoubleStruct that will be copied.
     */
    eProsima_user_DllExport FinalLongDoubleStruct& operator =(
            const FinalLongDoubleStruct& x)
    {

                    m_var_longdouble = x.m_var_longdouble;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object FinalLongDoubleStruct that will be copied.
     */
    eProsima_user_DllExport FinalLongDoubleStruct& operator =(
            FinalLongDoubleStruct&& x) noexcept
    {

        m_var_longdouble = x.m_var_longdouble;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x FinalLongDoubleStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const FinalLongDoubleStruct& x) const
    {
        return (m_var_longdouble == x.m_var_longdouble);
    }

    /*!
     * @brief Comparison operator.
     * @param x FinalLongDoubleStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const FinalLongDoubleStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_longdouble
     * @param _var_longdouble New value for member var_longdouble
     */
    eProsima_user_DllExport void var_longdouble(
            long double _var_longdouble)
    {
        m_var_longdouble = _var_longdouble;
    }

    /*!
     * @brief This function returns the value of member var_longdouble
     * @return Value of member var_longdouble
     */
    eProsima_user_DllExport long double var_longdouble() const
    {
        return m_var_longdouble;
    }

    /*!
     * @brief This function returns a reference to member var_longdouble
     * @return Reference to member var_longdouble
     */
    eProsima_user_DllExport long double& var_longdouble()
    {
        return m_var_longdouble;
    }



private:

    long double m_var_longdouble{0.0};

};
/*!
 * @brief This class represents the structure FinalBooleanStruct defined by the user in the IDL file.
 * @ingroup final
 */
class FinalBooleanStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport FinalBooleanStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~FinalBooleanStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object FinalBooleanStruct that will be copied.
     */
    eProsima_user_DllExport FinalBooleanStruct(
            const FinalBooleanStruct& x)
    {
                    m_var_boolean = x.m_var_boolean;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object FinalBooleanStruct that will be copied.
     */
    eProsima_user_DllExport FinalBooleanStruct(
            FinalBooleanStruct&& x) noexcept
    {
        m_var_boolean = x.m_var_boolean;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object FinalBooleanStruct that will be copied.
     */
    eProsima_user_DllExport FinalBooleanStruct& operator =(
            const FinalBooleanStruct& x)
    {

                    m_var_boolean = x.m_var_boolean;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object FinalBooleanStruct that will be copied.
     */
    eProsima_user_DllExport FinalBooleanStruct& operator =(
            FinalBooleanStruct&& x) noexcept
    {

        m_var_boolean = x.m_var_boolean;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x FinalBooleanStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const FinalBooleanStruct& x) const
    {
        return (m_var_boolean == x.m_var_boolean);
    }

    /*!
     * @brief Comparison operator.
     * @param x FinalBooleanStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const FinalBooleanStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_boolean
     * @param _var_boolean New value for member var_boolean
     */
    eProsima_user_DllExport void var_boolean(
            bool _var_boolean)
    {
        m_var_boolean = _var_boolean;
    }

    /*!
     * @brief This function returns the value of member var_boolean
     * @return Value of member var_boolean
     */
    eProsima_user_DllExport bool var_boolean() const
    {
        return m_var_boolean;
    }

    /*!
     * @brief This function returns a reference to member var_boolean
     * @return Reference to member var_boolean
     */
    eProsima_user_DllExport bool& var_boolean()
    {
        return m_var_boolean;
    }



private:

    bool m_var_boolean{false};

};
/*!
 * @brief This class represents the structure FinalOctetStruct defined by the user in the IDL file.
 * @ingroup final
 */
class FinalOctetStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport FinalOctetStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~FinalOctetStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object FinalOctetStruct that will be copied.
     */
    eProsima_user_DllExport FinalOctetStruct(
            const FinalOctetStruct& x)
    {
                    m_var_octet = x.m_var_octet;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object FinalOctetStruct that will be copied.
     */
    eProsima_user_DllExport FinalOctetStruct(
            FinalOctetStruct&& x) noexcept
    {
        m_var_octet = x.m_var_octet;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object FinalOctetStruct that will be copied.
     */
    eProsima_user_DllExport FinalOctetStruct& operator =(
            const FinalOctetStruct& x)
    {

                    m_var_octet = x.m_var_octet;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object FinalOctetStruct that will be copied.
     */
    eProsima_user_DllExport FinalOctetStruct& operator =(
            FinalOctetStruct&& x) noexcept
    {

        m_var_octet = x.m_var_octet;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x FinalOctetStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const FinalOctetStruct& x) const
    {
        return (m_var_octet == x.m_var_octet);
    }

    /*!
     * @brief Comparison operator.
     * @param x FinalOctetStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const FinalOctetStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_octet
     * @param _var_octet New value for member var_octet
     */
    eProsima_user_DllExport void var_octet(
            uint8_t _var_octet)
    {
        m_var_octet = _var_octet;
    }

    /*!
     * @brief This function returns the value of member var_octet
     * @return Value of member var_octet
     */
    eProsima_user_DllExport uint8_t var_octet() const
    {
        return m_var_octet;
    }

    /*!
     * @brief This function returns a reference to member var_octet
     * @return Reference to member var_octet
     */
    eProsima_user_DllExport uint8_t& var_octet()
    {
        return m_var_octet;
    }



private:

    uint8_t m_var_octet{0};

};
/*!
 * @brief This class represents the structure FinalCharStruct defined by the user in the IDL file.
 * @ingroup final
 */
class FinalCharStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport FinalCharStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~FinalCharStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object FinalCharStruct that will be copied.
     */
    eProsima_user_DllExport FinalCharStruct(
            const FinalCharStruct& x)
    {
                    m_var_char8 = x.m_var_char8;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object FinalCharStruct that will be copied.
     */
    eProsima_user_DllExport FinalCharStruct(
            FinalCharStruct&& x) noexcept
    {
        m_var_char8 = x.m_var_char8;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object FinalCharStruct that will be copied.
     */
    eProsima_user_DllExport FinalCharStruct& operator =(
            const FinalCharStruct& x)
    {

                    m_var_char8 = x.m_var_char8;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object FinalCharStruct that will be copied.
     */
    eProsima_user_DllExport FinalCharStruct& operator =(
            FinalCharStruct&& x) noexcept
    {

        m_var_char8 = x.m_var_char8;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x FinalCharStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const FinalCharStruct& x) const
    {
        return (m_var_char8 == x.m_var_char8);
    }

    /*!
     * @brief Comparison operator.
     * @param x FinalCharStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const FinalCharStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_char8
     * @param _var_char8 New value for member var_char8
     */
    eProsima_user_DllExport void var_char8(
            char _var_char8)
    {
        m_var_char8 = _var_char8;
    }

    /*!
     * @brief This function returns the value of member var_char8
     * @return Value of member var_char8
     */
    eProsima_user_DllExport char var_char8() const
    {
        return m_var_char8;
    }

    /*!
     * @brief This function returns a reference to member var_char8
     * @return Reference to member var_char8
     */
    eProsima_user_DllExport char& var_char8()
    {
        return m_var_char8;
    }



private:

    char m_var_char8{0};

};
/*!
 * @brief This class represents the structure FinalWCharStruct defined by the user in the IDL file.
 * @ingroup final
 */
class FinalWCharStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport FinalWCharStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~FinalWCharStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object FinalWCharStruct that will be copied.
     */
    eProsima_user_DllExport FinalWCharStruct(
            const FinalWCharStruct& x)
    {
                    m_var_char16 = x.m_var_char16;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object FinalWCharStruct that will be copied.
     */
    eProsima_user_DllExport FinalWCharStruct(
            FinalWCharStruct&& x) noexcept
    {
        m_var_char16 = x.m_var_char16;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object FinalWCharStruct that will be copied.
     */
    eProsima_user_DllExport FinalWCharStruct& operator =(
            const FinalWCharStruct& x)
    {

                    m_var_char16 = x.m_var_char16;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object FinalWCharStruct that will be copied.
     */
    eProsima_user_DllExport FinalWCharStruct& operator =(
            FinalWCharStruct&& x) noexcept
    {

        m_var_char16 = x.m_var_char16;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x FinalWCharStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const FinalWCharStruct& x) const
    {
        return (m_var_char16 == x.m_var_char16);
    }

    /*!
     * @brief Comparison operator.
     * @param x FinalWCharStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const FinalWCharStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_char16
     * @param _var_char16 New value for member var_char16
     */
    eProsima_user_DllExport void var_char16(
            wchar_t _var_char16)
    {
        m_var_char16 = _var_char16;
    }

    /*!
     * @brief This function returns the value of member var_char16
     * @return Value of member var_char16
     */
    eProsima_user_DllExport wchar_t var_char16() const
    {
        return m_var_char16;
    }

    /*!
     * @brief This function returns a reference to member var_char16
     * @return Reference to member var_char16
     */
    eProsima_user_DllExport wchar_t& var_char16()
    {
        return m_var_char16;
    }



private:

    wchar_t m_var_char16{0};

};
/*!
 * @brief This class represents the structure FinalUnionStruct defined by the user in the IDL file.
 * @ingroup final
 */
class FinalUnionStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport FinalUnionStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~FinalUnionStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object FinalUnionStruct that will be copied.
     */
    eProsima_user_DllExport FinalUnionStruct(
            const FinalUnionStruct& x)
    {
                    m_var_union = x.m_var_union;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object FinalUnionStruct that will be copied.
     */
    eProsima_user_DllExport FinalUnionStruct(
            FinalUnionStruct&& x) noexcept
    {
        m_var_union = std::move(x.m_var_union);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object FinalUnionStruct that will be copied.
     */
    eProsima_user_DllExport FinalUnionStruct& operator =(
            const FinalUnionStruct& x)
    {

                    m_var_union = x.m_var_union;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object FinalUnionStruct that will be copied.
     */
    eProsima_user_DllExport FinalUnionStruct& operator =(
            FinalUnionStruct&& x) noexcept
    {

        m_var_union = std::move(x.m_var_union);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x FinalUnionStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const FinalUnionStruct& x) const
    {
        return (m_var_union == x.m_var_union);
    }

    /*!
     * @brief Comparison operator.
     * @param x FinalUnionStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const FinalUnionStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union
     * @param _var_union New value to be copied in member var_union
     */
    eProsima_user_DllExport void var_union(
            const InnerUnionHelper& _var_union)
    {
        m_var_union = _var_union;
    }

    /*!
     * @brief This function moves the value in member var_union
     * @param _var_union New value to be moved in member var_union
     */
    eProsima_user_DllExport void var_union(
            InnerUnionHelper&& _var_union)
    {
        m_var_union = std::move(_var_union);
    }

    /*!
     * @brief This function returns a constant reference to member var_union
     * @return Constant reference to member var_union
     */
    eProsima_user_DllExport const InnerUnionHelper& var_union() const
    {
        return m_var_union;
    }

    /*!
     * @brief This function returns a reference to member var_union
     * @return Reference to member var_union
     */
    eProsima_user_DllExport InnerUnionHelper& var_union()
    {
        return m_var_union;
    }



private:

    InnerUnionHelper m_var_union;

};
/*!
 * @brief This class represents the structure FinalEmptyStruct defined by the user in the IDL file.
 * @ingroup final
 */
class FinalEmptyStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport FinalEmptyStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~FinalEmptyStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object FinalEmptyStruct that will be copied.
     */
    eProsima_user_DllExport FinalEmptyStruct(
            const FinalEmptyStruct& x)
    {
        static_cast<void>(x);
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object FinalEmptyStruct that will be copied.
     */
    eProsima_user_DllExport FinalEmptyStruct(
            FinalEmptyStruct&& x) noexcept
    {
        static_cast<void>(x);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object FinalEmptyStruct that will be copied.
     */
    eProsima_user_DllExport FinalEmptyStruct& operator =(
            const FinalEmptyStruct& x)
    {

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object FinalEmptyStruct that will be copied.
     */
    eProsima_user_DllExport FinalEmptyStruct& operator =(
            FinalEmptyStruct&& x) noexcept
    {

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x FinalEmptyStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const FinalEmptyStruct& x) const
    {
        static_cast<void>(x);
        return true;
    }

    /*!
     * @brief Comparison operator.
     * @param x FinalEmptyStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const FinalEmptyStruct& x) const
    {
        return !(*this == x);
    }



private:


};
/*!
 * @brief This class represents the structure FinalEmptyInheritanceStruct defined by the user in the IDL file.
 * @ingroup final
 */
class FinalEmptyInheritanceStruct : public FinalEmptyStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport FinalEmptyInheritanceStruct()
        : FinalEmptyStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~FinalEmptyInheritanceStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object FinalEmptyInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport FinalEmptyInheritanceStruct(
            const FinalEmptyInheritanceStruct& x)
        : FinalEmptyStruct(x)
    {
                    m_var_str = x.m_var_str;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object FinalEmptyInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport FinalEmptyInheritanceStruct(
            FinalEmptyInheritanceStruct&& x) noexcept
        : FinalEmptyStruct(std::move(x))

    {
        m_var_str = std::move(x.m_var_str);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object FinalEmptyInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport FinalEmptyInheritanceStruct& operator =(
            const FinalEmptyInheritanceStruct& x)
    {
        FinalEmptyStruct::operator =(x);

                    m_var_str = x.m_var_str;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object FinalEmptyInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport FinalEmptyInheritanceStruct& operator =(
            FinalEmptyInheritanceStruct&& x) noexcept
    {
        FinalEmptyStruct::operator =(std::move(x));

        m_var_str = std::move(x.m_var_str);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x FinalEmptyInheritanceStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const FinalEmptyInheritanceStruct& x) const
    {
        if (FinalEmptyStruct::operator !=(x))
                {
                    return false;
                }
        return (m_var_str == x.m_var_str);
    }

    /*!
     * @brief Comparison operator.
     * @param x FinalEmptyInheritanceStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const FinalEmptyInheritanceStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_str
     * @param _var_str New value to be copied in member var_str
     */
    eProsima_user_DllExport void var_str(
            const std::string& _var_str)
    {
        m_var_str = _var_str;
    }

    /*!
     * @brief This function moves the value in member var_str
     * @param _var_str New value to be moved in member var_str
     */
    eProsima_user_DllExport void var_str(
            std::string&& _var_str)
    {
        m_var_str = std::move(_var_str);
    }

    /*!
     * @brief This function returns a constant reference to member var_str
     * @return Constant reference to member var_str
     */
    eProsima_user_DllExport const std::string& var_str() const
    {
        return m_var_str;
    }

    /*!
     * @brief This function returns a reference to member var_str
     * @return Reference to member var_str
     */
    eProsima_user_DllExport std::string& var_str()
    {
        return m_var_str;
    }



private:

    std::string m_var_str;

};
/*!
 * @brief This class represents the structure FinalInheritanceStruct defined by the user in the IDL file.
 * @ingroup final
 */
class FinalInheritanceStruct : public FinalShortStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport FinalInheritanceStruct()
        : FinalShortStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~FinalInheritanceStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object FinalInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport FinalInheritanceStruct(
            const FinalInheritanceStruct& x)
        : FinalShortStruct(x)
    {
                    m_var_str = x.m_var_str;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object FinalInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport FinalInheritanceStruct(
            FinalInheritanceStruct&& x) noexcept
        : FinalShortStruct(std::move(x))

    {
        m_var_str = std::move(x.m_var_str);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object FinalInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport FinalInheritanceStruct& operator =(
            const FinalInheritanceStruct& x)
    {
        FinalShortStruct::operator =(x);

                    m_var_str = x.m_var_str;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object FinalInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport FinalInheritanceStruct& operator =(
            FinalInheritanceStruct&& x) noexcept
    {
        FinalShortStruct::operator =(std::move(x));

        m_var_str = std::move(x.m_var_str);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x FinalInheritanceStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const FinalInheritanceStruct& x) const
    {
        if (FinalShortStruct::operator !=(x))
                {
                    return false;
                }
        return (m_var_str == x.m_var_str);
    }

    /*!
     * @brief Comparison operator.
     * @param x FinalInheritanceStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const FinalInheritanceStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_str
     * @param _var_str New value to be copied in member var_str
     */
    eProsima_user_DllExport void var_str(
            const std::string& _var_str)
    {
        m_var_str = _var_str;
    }

    /*!
     * @brief This function moves the value in member var_str
     * @param _var_str New value to be moved in member var_str
     */
    eProsima_user_DllExport void var_str(
            std::string&& _var_str)
    {
        m_var_str = std::move(_var_str);
    }

    /*!
     * @brief This function returns a constant reference to member var_str
     * @return Constant reference to member var_str
     */
    eProsima_user_DllExport const std::string& var_str() const
    {
        return m_var_str;
    }

    /*!
     * @brief This function returns a reference to member var_str
     * @return Reference to member var_str
     */
    eProsima_user_DllExport std::string& var_str()
    {
        return m_var_str;
    }



private:

    std::string m_var_str;

};
/*!
 * @brief This class represents the structure InheritanceEmptyStruct defined by the user in the IDL file.
 * @ingroup final
 */
class InheritanceEmptyStruct : public FinalShortStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport InheritanceEmptyStruct()
        : FinalShortStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~InheritanceEmptyStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object InheritanceEmptyStruct that will be copied.
     */
    eProsima_user_DllExport InheritanceEmptyStruct(
            const InheritanceEmptyStruct& x)
        : FinalShortStruct(x)
    {
        static_cast<void>(x);
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object InheritanceEmptyStruct that will be copied.
     */
    eProsima_user_DllExport InheritanceEmptyStruct(
            InheritanceEmptyStruct&& x) noexcept
        : FinalShortStruct(std::move(x))

    {
        static_cast<void>(x);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object InheritanceEmptyStruct that will be copied.
     */
    eProsima_user_DllExport InheritanceEmptyStruct& operator =(
            const InheritanceEmptyStruct& x)
    {
        FinalShortStruct::operator =(x);

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object InheritanceEmptyStruct that will be copied.
     */
    eProsima_user_DllExport InheritanceEmptyStruct& operator =(
            InheritanceEmptyStruct&& x) noexcept
    {
        FinalShortStruct::operator =(std::move(x));

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x InheritanceEmptyStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const InheritanceEmptyStruct& x) const
    {
        if (FinalShortStruct::operator !=(x))
                {
                    return false;
                }
        static_cast<void>(x);
        return true;
    }

    /*!
     * @brief Comparison operator.
     * @param x InheritanceEmptyStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const InheritanceEmptyStruct& x) const
    {
        return !(*this == x);
    }



private:


};
/*!
 * @brief This class represents the structure FinalExtensibilityInheritance defined by the user in the IDL file.
 * @ingroup final
 */
class FinalExtensibilityInheritance : public FinalShortStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport FinalExtensibilityInheritance()
        : FinalShortStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~FinalExtensibilityInheritance()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object FinalExtensibilityInheritance that will be copied.
     */
    eProsima_user_DllExport FinalExtensibilityInheritance(
            const FinalExtensibilityInheritance& x)
        : FinalShortStruct(x)
    {
                    m_var_long = x.m_var_long;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object FinalExtensibilityInheritance that will be copied.
     */
    eProsima_user_DllExport FinalExtensibilityInheritance(
            FinalExtensibilityInheritance&& x) noexcept
        : FinalShortStruct(std::move(x))

    {
        m_var_long = x.m_var_long;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object FinalExtensibilityInheritance that will be copied.
     */
    eProsima_user_DllExport FinalExtensibilityInheritance& operator =(
            const FinalExtensibilityInheritance& x)
    {
        FinalShortStruct::operator =(x);

                    m_var_long = x.m_var_long;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object FinalExtensibilityInheritance that will be copied.
     */
    eProsima_user_DllExport FinalExtensibilityInheritance& operator =(
            FinalExtensibilityInheritance&& x) noexcept
    {
        FinalShortStruct::operator =(std::move(x));

        m_var_long = x.m_var_long;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x FinalExtensibilityInheritance object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const FinalExtensibilityInheritance& x) const
    {
        if (FinalShortStruct::operator !=(x))
                {
                    return false;
                }
        return (m_var_long == x.m_var_long);
    }

    /*!
     * @brief Comparison operator.
     * @param x FinalExtensibilityInheritance object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const FinalExtensibilityInheritance& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_long
     * @param _var_long New value for member var_long
     */
    eProsima_user_DllExport void var_long(
            int32_t _var_long)
    {
        m_var_long = _var_long;
    }

    /*!
     * @brief This function returns the value of member var_long
     * @return Value of member var_long
     */
    eProsima_user_DllExport int32_t var_long() const
    {
        return m_var_long;
    }

    /*!
     * @brief This function returns a reference to member var_long
     * @return Reference to member var_long
     */
    eProsima_user_DllExport int32_t& var_long()
    {
        return m_var_long;
    }



private:

    int32_t m_var_long{0};

};

#endif // _FAST_DDS_GENERATED_FINAL_HPP_


