// Copyright 2017 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v3.21.12
// source: kms_envelope.proto

package kms_envelope_go_proto

import (
	tink_go_proto "github.com/tink-crypto/tink-go/v2/proto/tink_go_proto"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type KmsEnvelopeAeadKeyFormat struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Required.
	// The location of the KEK in a remote KMS.
	// With Google Cloud KMS, valid values have this format:
	// gcp-kms://projects/*/locations/*/keyRings/*/cryptoKeys/*.
	// With AWS KMS, valid values have this format:
	// aws-kms://arn:aws:kms:<region>:<account-id>:key/<key-id>
	KekUri string `protobuf:"bytes,1,opt,name=kek_uri,json=kekUri,proto3" json:"kek_uri,omitempty"`
	// Key template of the Data Encryption Key, e.g., AesCtrHmacAeadKeyFormat.
	// Required.
	DekTemplate   *tink_go_proto.KeyTemplate `protobuf:"bytes,2,opt,name=dek_template,json=dekTemplate,proto3" json:"dek_template,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *KmsEnvelopeAeadKeyFormat) Reset() {
	*x = KmsEnvelopeAeadKeyFormat{}
	mi := &file_kms_envelope_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KmsEnvelopeAeadKeyFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KmsEnvelopeAeadKeyFormat) ProtoMessage() {}

func (x *KmsEnvelopeAeadKeyFormat) ProtoReflect() protoreflect.Message {
	mi := &file_kms_envelope_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KmsEnvelopeAeadKeyFormat.ProtoReflect.Descriptor instead.
func (*KmsEnvelopeAeadKeyFormat) Descriptor() ([]byte, []int) {
	return file_kms_envelope_proto_rawDescGZIP(), []int{0}
}

func (x *KmsEnvelopeAeadKeyFormat) GetKekUri() string {
	if x != nil {
		return x.KekUri
	}
	return ""
}

func (x *KmsEnvelopeAeadKeyFormat) GetDekTemplate() *tink_go_proto.KeyTemplate {
	if x != nil {
		return x.DekTemplate
	}
	return nil
}

// There is no actual key material in the key.
type KmsEnvelopeAeadKey struct {
	state   protoimpl.MessageState `protogen:"open.v1"`
	Version uint32                 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// The key format also contains the params.
	Params        *KmsEnvelopeAeadKeyFormat `protobuf:"bytes,2,opt,name=params,proto3" json:"params,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *KmsEnvelopeAeadKey) Reset() {
	*x = KmsEnvelopeAeadKey{}
	mi := &file_kms_envelope_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KmsEnvelopeAeadKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KmsEnvelopeAeadKey) ProtoMessage() {}

func (x *KmsEnvelopeAeadKey) ProtoReflect() protoreflect.Message {
	mi := &file_kms_envelope_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KmsEnvelopeAeadKey.ProtoReflect.Descriptor instead.
func (*KmsEnvelopeAeadKey) Descriptor() ([]byte, []int) {
	return file_kms_envelope_proto_rawDescGZIP(), []int{1}
}

func (x *KmsEnvelopeAeadKey) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *KmsEnvelopeAeadKey) GetParams() *KmsEnvelopeAeadKeyFormat {
	if x != nil {
		return x.Params
	}
	return nil
}

var File_kms_envelope_proto protoreflect.FileDescriptor

const file_kms_envelope_proto_rawDesc = "" +
	"\n" +
	"\x12kms_envelope.proto\x12\x12google.crypto.tink\x1a\x10proto/tink.proto\"w\n" +
	"\x18KmsEnvelopeAeadKeyFormat\x12\x17\n" +
	"\akek_uri\x18\x01 \x01(\tR\x06kekUri\x12B\n" +
	"\fdek_template\x18\x02 \x01(\v2\x1f.google.crypto.tink.KeyTemplateR\vdekTemplate\"t\n" +
	"\x12KmsEnvelopeAeadKey\x12\x18\n" +
	"\aversion\x18\x01 \x01(\rR\aversion\x12D\n" +
	"\x06params\x18\x02 \x01(\v2,.google.crypto.tink.KmsEnvelopeAeadKeyFormatR\x06paramsB_\n" +
	"\x1ccom.google.crypto.tink.protoP\x01Z=github.com/tink-crypto/tink-go/v2/proto/kms_envelope_go_protob\x06proto3"

var (
	file_kms_envelope_proto_rawDescOnce sync.Once
	file_kms_envelope_proto_rawDescData []byte
)

func file_kms_envelope_proto_rawDescGZIP() []byte {
	file_kms_envelope_proto_rawDescOnce.Do(func() {
		file_kms_envelope_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_kms_envelope_proto_rawDesc), len(file_kms_envelope_proto_rawDesc)))
	})
	return file_kms_envelope_proto_rawDescData
}

var file_kms_envelope_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_kms_envelope_proto_goTypes = []any{
	(*KmsEnvelopeAeadKeyFormat)(nil),  // 0: google.crypto.tink.KmsEnvelopeAeadKeyFormat
	(*KmsEnvelopeAeadKey)(nil),        // 1: google.crypto.tink.KmsEnvelopeAeadKey
	(*tink_go_proto.KeyTemplate)(nil), // 2: google.crypto.tink.KeyTemplate
}
var file_kms_envelope_proto_depIdxs = []int32{
	2, // 0: google.crypto.tink.KmsEnvelopeAeadKeyFormat.dek_template:type_name -> google.crypto.tink.KeyTemplate
	0, // 1: google.crypto.tink.KmsEnvelopeAeadKey.params:type_name -> google.crypto.tink.KmsEnvelopeAeadKeyFormat
	2, // [2:2] is the sub-list for method output_type
	2, // [2:2] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_kms_envelope_proto_init() }
func file_kms_envelope_proto_init() {
	if File_kms_envelope_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_kms_envelope_proto_rawDesc), len(file_kms_envelope_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_kms_envelope_proto_goTypes,
		DependencyIndexes: file_kms_envelope_proto_depIdxs,
		MessageInfos:      file_kms_envelope_proto_msgTypes,
	}.Build()
	File_kms_envelope_proto = out.File
	file_kms_envelope_proto_goTypes = nil
	file_kms_envelope_proto_depIdxs = nil
}
