# gophian

**Tools to help with Debianizing Go software**

> Please report any issues to https://codeberg.org/Maytha8/gophian/issues or
> send an email to `maytham@debian.org`.

Gophian is a featureful and intelligent tool to assist developers in packaging
Go software for the Debian distribution.

Refer to the manual pages provided for more information.

`gophian make` is **fully configurable**! You are encouraged to tweak Gophian
using its environment variables (see `gophian-make(1)` manual page).

## Features

- `gophian make`
  - Check if the software has already been packaged for Debian, and whether
    it's in unstable, experimental or in the NEW queue.
  - Check for an ITP/RFP, tell you about it, and fill in debian/changelog
  - Check for an existing Salsa repo with the name of the source package
  - Uses templates for d/control, d/changelog, d/watch, and d/copyright
    instead of creating them inside the program.
  - Ability to select from multiple package types to accomodate different types
    of software.
  - Ability to select source package name if your package is binary-only or
    binary-and-library.
  - Asks you which binaries you'd like to include, ensuring that you can
    exclude testing binaries.
  - Extra short hostnames for websites like codeberg.org.
  - Check for unpackaged dependencies and warn about them, and optionally write
    them to a debian/TODO file.
- `gophian estimate`
  - Specify maximum depth with `--max-depth` or go all the way.
  - Can exclude packaged dependencies.
  - Check if dependencies have already been packaged for Debian, and whether
    they are in unstable, experimental or in the NEW queue.
- `gophian estimate-graphviz` (requires python3-graphviz)
  - Visualise the dependency tree using graphviz.

## Why not dh-make-golang?

In my experience, dh-make-golang is a little underfeatured and isn't very
reliable. `dh-make-golang make` doesn't work half the time, it doesn't
automatically fill in (Build-)Depends, and `dh-make-golang estimate` doesn't
work at all ([Debian#1050523](https://bugs.debian.org/1050523),
[Debian#1058936](https://bugs.debian.org/1058936)). This is because
dh-make-golang still relies on the deprecated and removed
golang.org/x/tools/go/vcs package to work out the root repo of import paths
([Debian#1043070](https://bugs.debian.org/1043070),
[dh-make-golang#200](https://github.com/Debian/dh-make-golang/issues/200)).

gophian seeks to change that, by avoiding the use of `go get` completely (and
replicating it with the session module), and providing something that *just
works*, as well as adding on more features and more intelligence. This CLI aims
to be a full alternative to dh-make-golang.

## Install

gophian is available in [Debian unstable](https://tracker.debian.org/pkg/gophian).

From git:

```sh
pipx install git+https://codeberg.org/Maytha8/gophian.git
# or with graphviz support
pipx install git+https://codeberg.org/Maytha8/gophian.git[graphviz]
```

## Runtime Dependencies

This program requires `git`, `go`, and `git-buildpackage` in order to run.

## Optional Features

- `graphviz` - enables the estimate-graphviz command

## Contributing

See [CONTRIBUTING](./CONTRIBUTING.md).

## Contact

Report any bugs or issues to https://codeberg.org/Maytha8/gophian/issues

Alternatively, you can email me at `maytham@debian.org`.

## License

```
gophian -- tools to help with Debianizing Go software
Copyright (C) 2024-2025 Maytham Alsudany <maytham@debian.org>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.
```
