%feature("docstring") OT::PostAnalyticalSimulation
"Post analytical simulation.

See also
--------
PostAnalyticalImportanceSampling, PostAnalyticalControlledImportanceSampling

Notes
-----
This class inherits from EventSimulation.

The principle is to perform a simulation study to evaluate the threshold
exceedance probability according to an importance density centered around the
design point, in the standard space. The importance distribution is the standard
distribution of the standard space.

A PostAnalyticalSimulation object can be created only through its derivative
classes : :class:`~openturns.PostAnalyticalImportanceSampling` or
:class:`~openturns.PostAnalyticalControlledImportanceSampling`."

// ---------------------------------------------------------------------

%feature("docstring") OT::PostAnalyticalSimulation::getAnalyticalResult
"Accessor to the analytical result.

Returns
-------
result : :class:`~openturns.AnalyticalResult`
    Result of the analytical study which has been performed just before the 
    simulation study centered around the importance factor."

// ---------------------------------------------------------------------

%feature("docstring") OT::PostAnalyticalSimulation::getControlProbability
R"RAW(Accessor to the control probability.

Returns
-------
p : float,
    The probability of the analytical result.

Notes
-----
The control probability :math:`p` is deduced from the corresponding analytical result:

.. math::

    p = E(-\beta_{HL})

where :math:`\beta_{HL}` denotes the Hasofer reliability index and :math:`E`
the univariate standard CDF of the elliptical distribution in the standard space.)RAW"
