// Copyright (C) 2025 Rivos Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Autogenerated by the ProtoZero Rust compiler plugin.
// Invoked by contrib/rust-sdk/tools/gen_rust_protos
// DO NOT EDIT.

use crate::pb_enum;
use crate::pb_msg;
use crate::protos::trace::track_event::chrome_active_processes::*;
use crate::protos::trace::track_event::chrome_application_state_info::*;
use crate::protos::trace::track_event::chrome_compositor_scheduler_state::*;
use crate::protos::trace::track_event::chrome_content_settings_event_info::*;
use crate::protos::trace::track_event::chrome_frame_reporter::*;
use crate::protos::trace::track_event::chrome_histogram_sample::*;
use crate::protos::trace::track_event::chrome_keyed_service::*;
use crate::protos::trace::track_event::chrome_latency_info::*;
use crate::protos::trace::track_event::chrome_legacy_ipc::*;
use crate::protos::trace::track_event::chrome_message_pump::*;
use crate::protos::trace::track_event::chrome_mojo_event_info::*;
use crate::protos::trace::track_event::chrome_renderer_scheduler_state::*;
use crate::protos::trace::track_event::chrome_user_event::*;
use crate::protos::trace::track_event::chrome_window_handle_event_info::*;
use crate::protos::trace::track_event::debug_annotation::*;
use crate::protos::trace::track_event::log_message::*;
use crate::protos::trace::track_event::screenshot::*;
use crate::protos::trace::track_event::source_location::*;
use crate::protos::trace::track_event::task_execution::*;

pb_enum!(TrackEventType {
    TYPE_UNSPECIFIED: 0,
    TYPE_SLICE_BEGIN: 1,
    TYPE_SLICE_END: 2,
    TYPE_INSTANT: 3,
    TYPE_COUNTER: 4,
});

pb_enum!(LegacyEventFlowDirection {
    FLOW_UNSPECIFIED: 0,
    FLOW_IN: 1,
    FLOW_OUT: 2,
    FLOW_INOUT: 3,
});

pb_enum!(LegacyEventInstantEventScope {
    SCOPE_UNSPECIFIED: 0,
    SCOPE_GLOBAL: 1,
    SCOPE_PROCESS: 2,
    SCOPE_THREAD: 3,
});

pb_msg!(EventName {
    iid: u64, primitive, 1,
    name: String, primitive, 2,
});

pb_msg!(EventCategory {
    iid: u64, primitive, 1,
    name: String, primitive, 2,
});

pb_msg!(TrackEventDefaults {
    track_uuid: u64, primitive, 11,
    extra_counter_track_uuids: u64, primitive, 31,
    extra_double_counter_track_uuids: u64, primitive, 45,
});

pb_msg!(TrackEvent {
    category_iids: u64, primitive, 3,
    categories: String, primitive, 22,
    name_iid: u64, primitive, 10,
    name: String, primitive, 23,
    type: TrackEventType, enum, 9,
    track_uuid: u64, primitive, 11,
    counter_value: i64, primitive, 30,
    double_counter_value: f64, primitive, 44,
    extra_counter_track_uuids: u64, primitive, 31,
    extra_counter_values: i64, primitive, 12,
    extra_double_counter_track_uuids: u64, primitive, 45,
    extra_double_counter_values: f64, primitive, 46,
    flow_ids_old: u64, primitive, 36,
    flow_ids: u64, primitive, 47,
    terminating_flow_ids_old: u64, primitive, 42,
    terminating_flow_ids: u64, primitive, 48,
    correlation_id: u64, primitive, 52,
    correlation_id_str: String, primitive, 53,
    correlation_id_str_iid: u64, primitive, 54,
    callstack: Callstack, msg, 55,
    callstack_iid: u64, primitive, 56,
    debug_annotations: DebugAnnotation, msg, 4,
    task_execution: TaskExecution, msg, 5,
    log_message: LogMessage, msg, 21,
    cc_scheduler_state: ChromeCompositorSchedulerState, msg, 24,
    chrome_user_event: ChromeUserEvent, msg, 25,
    chrome_keyed_service: ChromeKeyedService, msg, 26,
    chrome_legacy_ipc: ChromeLegacyIpc, msg, 27,
    chrome_histogram_sample: ChromeHistogramSample, msg, 28,
    chrome_latency_info: ChromeLatencyInfo, msg, 29,
    chrome_frame_reporter: ChromeFrameReporter, msg, 32,
    chrome_application_state_info: ChromeApplicationStateInfo, msg, 39,
    chrome_renderer_scheduler_state: ChromeRendererSchedulerState, msg, 40,
    chrome_window_handle_event_info: ChromeWindowHandleEventInfo, msg, 41,
    chrome_content_settings_event_info: ChromeContentSettingsEventInfo, msg, 43,
    chrome_active_processes: ChromeActiveProcesses, msg, 49,
    screenshot: Screenshot, msg, 50,
    source_location: SourceLocation, msg, 33,
    source_location_iid: u64, primitive, 34,
    chrome_message_pump: ChromeMessagePump, msg, 35,
    chrome_mojo_event_info: ChromeMojoEventInfo, msg, 38,
    timestamp_delta_us: i64, primitive, 1,
    timestamp_absolute_us: i64, primitive, 16,
    thread_time_delta_us: i64, primitive, 2,
    thread_time_absolute_us: i64, primitive, 17,
    thread_instruction_count_delta: i64, primitive, 8,
    thread_instruction_count_absolute: i64, primitive, 20,
    legacy_event: LegacyEvent, msg, 6,
});

pb_msg!(LegacyEvent {
    name_iid: u64, primitive, 1,
    phase: i32, primitive, 2,
    duration_us: i64, primitive, 3,
    thread_duration_us: i64, primitive, 4,
    thread_instruction_delta: i64, primitive, 15,
    unscoped_id: u64, primitive, 6,
    local_id: u64, primitive, 10,
    global_id: u64, primitive, 11,
    id_scope: String, primitive, 7,
    use_async_tts: bool, primitive, 9,
    bind_id: u64, primitive, 8,
    bind_to_enclosing: bool, primitive, 12,
    flow_direction: LegacyEventFlowDirection, enum, 13,
    instant_event_scope: LegacyEventInstantEventScope, enum, 14,
    pid_override: i32, primitive, 18,
    tid_override: i32, primitive, 19,
});

pb_msg!(Callstack {
    frames: Frame, msg, 1,
});

pb_msg!(Frame {
    function_name: String, primitive, 1,
    source_file: String, primitive, 2,
    line_number: u32, primitive, 3,
});
