/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Autogenerated by:
// ../../src/tools/ftrace_proto_gen/ftrace_descriptor_gen.cc
// Do not edit.

#include "src/trace_processor/importers/ftrace/ftrace_descriptors.h"

namespace perfetto {
namespace trace_processor {
namespace {

std::array<FtraceMessageDescriptor, 596> descriptors{{
    {nullptr, 0, {}},
    {nullptr, 0, {}},
    {nullptr, 0, {}},
    {
        "print",
        2,
        {
            {},
            {"ip", ProtoSchemaType::kUint64},
            {"buf", ProtoSchemaType::kString},
        },
    },
    {
        "sched_switch",
        7,
        {
            {},
            {"prev_comm", ProtoSchemaType::kString},
            {"prev_pid", ProtoSchemaType::kInt32},
            {"prev_prio", ProtoSchemaType::kInt32},
            {"prev_state", ProtoSchemaType::kInt64},
            {"next_comm", ProtoSchemaType::kString},
            {"next_pid", ProtoSchemaType::kInt32},
            {"next_prio", ProtoSchemaType::kInt32},
        },
    },
    {nullptr, 0, {}},
    {nullptr, 0, {}},
    {nullptr, 0, {}},
    {nullptr, 0, {}},
    {nullptr, 0, {}},
    {nullptr, 0, {}},
    {
        "cpu_frequency",
        2,
        {
            {},
            {"state", ProtoSchemaType::kUint32},
            {"cpu_id", ProtoSchemaType::kUint32},
        },
    },
    {
        "cpu_frequency_limits",
        3,
        {
            {},
            {"min_freq", ProtoSchemaType::kUint32},
            {"max_freq", ProtoSchemaType::kUint32},
            {"cpu_id", ProtoSchemaType::kUint32},
        },
    },
    {
        "cpu_idle",
        2,
        {
            {},
            {"state", ProtoSchemaType::kUint32},
            {"cpu_id", ProtoSchemaType::kUint32},
        },
    },
    {
        "clock_enable",
        3,
        {
            {},
            {"name", ProtoSchemaType::kString},
            {"state", ProtoSchemaType::kUint64},
            {"cpu_id", ProtoSchemaType::kUint64},
        },
    },
    {
        "clock_disable",
        3,
        {
            {},
            {"name", ProtoSchemaType::kString},
            {"state", ProtoSchemaType::kUint64},
            {"cpu_id", ProtoSchemaType::kUint64},
        },
    },
    {
        "clock_set_rate",
        3,
        {
            {},
            {"name", ProtoSchemaType::kString},
            {"state", ProtoSchemaType::kUint64},
            {"cpu_id", ProtoSchemaType::kUint64},
        },
    },
    {
        "sched_wakeup",
        5,
        {
            {},
            {"comm", ProtoSchemaType::kString},
            {"pid", ProtoSchemaType::kInt32},
            {"prio", ProtoSchemaType::kInt32},
            {"success", ProtoSchemaType::kInt32},
            {"target_cpu", ProtoSchemaType::kInt32},
        },
    },
    {
        "sched_blocked_reason",
        3,
        {
            {},
            {"pid", ProtoSchemaType::kInt32},
            {"caller", ProtoSchemaType::kUint64},
            {"io_wait", ProtoSchemaType::kUint32},
        },
    },
    {
        "sched_cpu_hotplug",
        3,
        {
            {},
            {"affected_cpu", ProtoSchemaType::kInt32},
            {"error", ProtoSchemaType::kInt32},
            {"status", ProtoSchemaType::kInt32},
        },
    },
    {
        "sched_waking",
        5,
        {
            {},
            {"comm", ProtoSchemaType::kString},
            {"pid", ProtoSchemaType::kInt32},
            {"prio", ProtoSchemaType::kInt32},
            {"success", ProtoSchemaType::kInt32},
            {"target_cpu", ProtoSchemaType::kInt32},
        },
    },
    {
        "ipi_entry",
        1,
        {
            {},
            {"reason", ProtoSchemaType::kString},
        },
    },
    {
        "ipi_exit",
        1,
        {
            {},
            {"reason", ProtoSchemaType::kString},
        },
    },
    {
        "ipi_raise",
        2,
        {
            {},
            {"target_cpus", ProtoSchemaType::kUint32},
            {"reason", ProtoSchemaType::kString},
        },
    },
    {
        "softirq_entry",
        1,
        {
            {},
            {"vec", ProtoSchemaType::kUint32},
        },
    },
    {
        "softirq_exit",
        1,
        {
            {},
            {"vec", ProtoSchemaType::kUint32},
        },
    },
    {
        "softirq_raise",
        1,
        {
            {},
            {"vec", ProtoSchemaType::kUint32},
        },
    },
    {
        "i2c_read",
        5,
        {
            {},
            {"adapter_nr", ProtoSchemaType::kInt32},
            {"msg_nr", ProtoSchemaType::kUint32},
            {"addr", ProtoSchemaType::kUint32},
            {"flags", ProtoSchemaType::kUint32},
            {"len", ProtoSchemaType::kUint32},
        },
    },
    {
        "i2c_write",
        6,
        {
            {},
            {"adapter_nr", ProtoSchemaType::kInt32},
            {"msg_nr", ProtoSchemaType::kUint32},
            {"addr", ProtoSchemaType::kUint32},
            {"flags", ProtoSchemaType::kUint32},
            {"len", ProtoSchemaType::kUint32},
            {"buf", ProtoSchemaType::kUint32},
        },
    },
    {
        "i2c_result",
        3,
        {
            {},
            {"adapter_nr", ProtoSchemaType::kInt32},
            {"nr_msgs", ProtoSchemaType::kUint32},
            {"ret", ProtoSchemaType::kInt32},
        },
    },
    {
        "i2c_reply",
        6,
        {
            {},
            {"adapter_nr", ProtoSchemaType::kInt32},
            {"msg_nr", ProtoSchemaType::kUint32},
            {"addr", ProtoSchemaType::kUint32},
            {"flags", ProtoSchemaType::kUint32},
            {"len", ProtoSchemaType::kUint32},
            {"buf", ProtoSchemaType::kUint32},
        },
    },
    {
        "smbus_read",
        5,
        {
            {},
            {"adapter_nr", ProtoSchemaType::kInt32},
            {"flags", ProtoSchemaType::kUint32},
            {"addr", ProtoSchemaType::kUint32},
            {"command", ProtoSchemaType::kUint32},
            {"protocol", ProtoSchemaType::kUint32},
        },
    },
    {
        "smbus_write",
        6,
        {
            {},
            {"adapter_nr", ProtoSchemaType::kInt32},
            {"addr", ProtoSchemaType::kUint32},
            {"flags", ProtoSchemaType::kUint32},
            {"command", ProtoSchemaType::kUint32},
            {"len", ProtoSchemaType::kUint32},
            {"protocol", ProtoSchemaType::kUint32},
        },
    },
    {
        "smbus_result",
        7,
        {
            {},
            {"adapter_nr", ProtoSchemaType::kInt32},
            {"addr", ProtoSchemaType::kUint32},
            {"flags", ProtoSchemaType::kUint32},
            {"read_write", ProtoSchemaType::kUint32},
            {"command", ProtoSchemaType::kUint32},
            {"res", ProtoSchemaType::kInt32},
            {"protocol", ProtoSchemaType::kUint32},
        },
    },
    {
        "smbus_reply",
        6,
        {
            {},
            {"adapter_nr", ProtoSchemaType::kInt32},
            {"addr", ProtoSchemaType::kUint32},
            {"flags", ProtoSchemaType::kUint32},
            {"command", ProtoSchemaType::kUint32},
            {"len", ProtoSchemaType::kUint32},
            {"protocol", ProtoSchemaType::kUint32},
        },
    },
    {
        "lowmemory_kill",
        5,
        {
            {},
            {"comm", ProtoSchemaType::kString},
            {"pid", ProtoSchemaType::kInt32},
            {"pagecache_size", ProtoSchemaType::kInt64},
            {"pagecache_limit", ProtoSchemaType::kInt64},
            {"free", ProtoSchemaType::kInt64},
        },
    },
    {
        "irq_handler_entry",
        3,
        {
            {},
            {"irq", ProtoSchemaType::kInt32},
            {"name", ProtoSchemaType::kString},
            {"handler", ProtoSchemaType::kUint32},
        },
    },
    {
        "irq_handler_exit",
        2,
        {
            {},
            {"irq", ProtoSchemaType::kInt32},
            {"ret", ProtoSchemaType::kInt32},
        },
    },
    {
        "sync_pt",
        2,
        {
            {},
            {"timeline", ProtoSchemaType::kString},
            {"value", ProtoSchemaType::kString},
        },
    },
    {
        "sync_timeline",
        2,
        {
            {},
            {"name", ProtoSchemaType::kString},
            {"value", ProtoSchemaType::kString},
        },
    },
    {
        "sync_wait",
        3,
        {
            {},
            {"name", ProtoSchemaType::kString},
            {"status", ProtoSchemaType::kInt32},
            {"begin", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_da_write_begin",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"pos", ProtoSchemaType::kInt64},
            {"len", ProtoSchemaType::kUint32},
            {"flags", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_da_write_end",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"pos", ProtoSchemaType::kInt64},
            {"len", ProtoSchemaType::kUint32},
            {"copied", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_sync_file_enter",
        4,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"parent", ProtoSchemaType::kUint64},
            {"datasync", ProtoSchemaType::kInt32},
        },
    },
    {
        "ext4_sync_file_exit",
        3,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"ret", ProtoSchemaType::kInt32},
        },
    },
    {
        "block_rq_issue",
        7,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"sector", ProtoSchemaType::kUint64},
            {"nr_sector", ProtoSchemaType::kUint32},
            {"bytes", ProtoSchemaType::kUint32},
            {"rwbs", ProtoSchemaType::kString},
            {"comm", ProtoSchemaType::kString},
            {"cmd", ProtoSchemaType::kString},
        },
    },
    {
        "mm_vmscan_direct_reclaim_begin",
        3,
        {
            {},
            {"order", ProtoSchemaType::kInt32},
            {"may_writepage", ProtoSchemaType::kInt32},
            {"gfp_flags", ProtoSchemaType::kUint32},
        },
    },
    {
        "mm_vmscan_direct_reclaim_end",
        1,
        {
            {},
            {"nr_reclaimed", ProtoSchemaType::kUint64},
        },
    },
    {
        "mm_vmscan_kswapd_wake",
        3,
        {
            {},
            {"nid", ProtoSchemaType::kInt32},
            {"order", ProtoSchemaType::kInt32},
            {"zid", ProtoSchemaType::kInt32},
        },
    },
    {
        "mm_vmscan_kswapd_sleep",
        1,
        {
            {},
            {"nid", ProtoSchemaType::kInt32},
        },
    },
    {
        "binder_transaction",
        7,
        {
            {},
            {"debug_id", ProtoSchemaType::kInt32},
            {"target_node", ProtoSchemaType::kInt32},
            {"to_proc", ProtoSchemaType::kInt32},
            {"to_thread", ProtoSchemaType::kInt32},
            {"reply", ProtoSchemaType::kInt32},
            {"code", ProtoSchemaType::kUint32},
            {"flags", ProtoSchemaType::kUint32},
        },
    },
    {
        "binder_transaction_received",
        1,
        {
            {},
            {"debug_id", ProtoSchemaType::kInt32},
        },
    },
    {
        "binder_set_priority",
        5,
        {
            {},
            {"proc", ProtoSchemaType::kInt32},
            {"thread", ProtoSchemaType::kInt32},
            {"old_prio", ProtoSchemaType::kUint32},
            {"new_prio", ProtoSchemaType::kUint32},
            {"desired_prio", ProtoSchemaType::kUint32},
        },
    },
    {
        "binder_lock",
        1,
        {
            {},
            {"tag", ProtoSchemaType::kString},
        },
    },
    {
        "binder_locked",
        1,
        {
            {},
            {"tag", ProtoSchemaType::kString},
        },
    },
    {
        "binder_unlock",
        1,
        {
            {},
            {"tag", ProtoSchemaType::kString},
        },
    },
    {
        "workqueue_activate_work",
        1,
        {
            {},
            {"work", ProtoSchemaType::kUint64},
        },
    },
    {
        "workqueue_execute_end",
        2,
        {
            {},
            {"work", ProtoSchemaType::kUint64},
            {"function", ProtoSchemaType::kUint64},
        },
    },
    {
        "workqueue_execute_start",
        2,
        {
            {},
            {"work", ProtoSchemaType::kUint64},
            {"function", ProtoSchemaType::kUint64},
        },
    },
    {
        "workqueue_queue_work",
        5,
        {
            {},
            {"work", ProtoSchemaType::kUint64},
            {"function", ProtoSchemaType::kUint64},
            {"workqueue", ProtoSchemaType::kUint64},
            {"req_cpu", ProtoSchemaType::kUint32},
            {"cpu", ProtoSchemaType::kUint32},
        },
    },
    {
        "regulator_disable",
        1,
        {
            {},
            {"name", ProtoSchemaType::kString},
        },
    },
    {
        "regulator_disable_complete",
        1,
        {
            {},
            {"name", ProtoSchemaType::kString},
        },
    },
    {
        "regulator_enable",
        1,
        {
            {},
            {"name", ProtoSchemaType::kString},
        },
    },
    {
        "regulator_enable_complete",
        1,
        {
            {},
            {"name", ProtoSchemaType::kString},
        },
    },
    {
        "regulator_enable_delay",
        1,
        {
            {},
            {"name", ProtoSchemaType::kString},
        },
    },
    {
        "regulator_set_voltage",
        3,
        {
            {},
            {"name", ProtoSchemaType::kString},
            {"min", ProtoSchemaType::kInt32},
            {"max", ProtoSchemaType::kInt32},
        },
    },
    {
        "regulator_set_voltage_complete",
        2,
        {
            {},
            {"name", ProtoSchemaType::kString},
            {"val", ProtoSchemaType::kUint32},
        },
    },
    {
        "cgroup_attach_task",
        7,
        {
            {},
            {"dst_root", ProtoSchemaType::kInt32},
            {"dst_id", ProtoSchemaType::kInt32},
            {"pid", ProtoSchemaType::kInt32},
            {"comm", ProtoSchemaType::kString},
            {"cname", ProtoSchemaType::kString},
            {"dst_level", ProtoSchemaType::kInt32},
            {"dst_path", ProtoSchemaType::kString},
        },
    },
    {
        "cgroup_mkdir",
        5,
        {
            {},
            {"root", ProtoSchemaType::kInt32},
            {"id", ProtoSchemaType::kInt32},
            {"cname", ProtoSchemaType::kString},
            {"level", ProtoSchemaType::kInt32},
            {"path", ProtoSchemaType::kString},
        },
    },
    {
        "cgroup_remount",
        3,
        {
            {},
            {"root", ProtoSchemaType::kInt32},
            {"ss_mask", ProtoSchemaType::kUint32},
            {"name", ProtoSchemaType::kString},
        },
    },
    {
        "cgroup_rmdir",
        5,
        {
            {},
            {"root", ProtoSchemaType::kInt32},
            {"id", ProtoSchemaType::kInt32},
            {"cname", ProtoSchemaType::kString},
            {"level", ProtoSchemaType::kInt32},
            {"path", ProtoSchemaType::kString},
        },
    },
    {
        "cgroup_transfer_tasks",
        7,
        {
            {},
            {"dst_root", ProtoSchemaType::kInt32},
            {"dst_id", ProtoSchemaType::kInt32},
            {"pid", ProtoSchemaType::kInt32},
            {"comm", ProtoSchemaType::kString},
            {"cname", ProtoSchemaType::kString},
            {"dst_level", ProtoSchemaType::kInt32},
            {"dst_path", ProtoSchemaType::kString},
        },
    },
    {
        "cgroup_destroy_root",
        3,
        {
            {},
            {"root", ProtoSchemaType::kInt32},
            {"ss_mask", ProtoSchemaType::kUint32},
            {"name", ProtoSchemaType::kString},
        },
    },
    {
        "cgroup_release",
        5,
        {
            {},
            {"root", ProtoSchemaType::kInt32},
            {"id", ProtoSchemaType::kInt32},
            {"cname", ProtoSchemaType::kString},
            {"level", ProtoSchemaType::kInt32},
            {"path", ProtoSchemaType::kString},
        },
    },
    {
        "cgroup_rename",
        5,
        {
            {},
            {"root", ProtoSchemaType::kInt32},
            {"id", ProtoSchemaType::kInt32},
            {"cname", ProtoSchemaType::kString},
            {"level", ProtoSchemaType::kInt32},
            {"path", ProtoSchemaType::kString},
        },
    },
    {
        "cgroup_setup_root",
        3,
        {
            {},
            {"root", ProtoSchemaType::kInt32},
            {"ss_mask", ProtoSchemaType::kUint32},
            {"name", ProtoSchemaType::kString},
        },
    },
    {
        "mdp_cmd_kickoff",
        2,
        {
            {},
            {"ctl_num", ProtoSchemaType::kUint32},
            {"kickoff_cnt", ProtoSchemaType::kInt32},
        },
    },
    {
        "mdp_commit",
        4,
        {
            {},
            {"num", ProtoSchemaType::kUint32},
            {"play_cnt", ProtoSchemaType::kUint32},
            {"clk_rate", ProtoSchemaType::kUint32},
            {"bandwidth", ProtoSchemaType::kUint64},
        },
    },
    {
        "mdp_perf_set_ot",
        4,
        {
            {},
            {"pnum", ProtoSchemaType::kUint32},
            {"xin_id", ProtoSchemaType::kUint32},
            {"rd_lim", ProtoSchemaType::kUint32},
            {"is_vbif_rt", ProtoSchemaType::kUint32},
        },
    },
    {
        "mdp_sspp_change",
        16,
        {
            {},
            {"num", ProtoSchemaType::kUint32},
            {"play_cnt", ProtoSchemaType::kUint32},
            {"mixer", ProtoSchemaType::kUint32},
            {"stage", ProtoSchemaType::kUint32},
            {"flags", ProtoSchemaType::kUint32},
            {"format", ProtoSchemaType::kUint32},
            {"img_w", ProtoSchemaType::kUint32},
            {"img_h", ProtoSchemaType::kUint32},
            {"src_x", ProtoSchemaType::kUint32},
            {"src_y", ProtoSchemaType::kUint32},
            {"src_w", ProtoSchemaType::kUint32},
            {"src_h", ProtoSchemaType::kUint32},
            {"dst_x", ProtoSchemaType::kUint32},
            {"dst_y", ProtoSchemaType::kUint32},
            {"dst_w", ProtoSchemaType::kUint32},
            {"dst_h", ProtoSchemaType::kUint32},
        },
    },
    {
        "tracing_mark_write",
        3,
        {
            {},
            {"pid", ProtoSchemaType::kInt32},
            {"trace_name", ProtoSchemaType::kString},
            {"trace_begin", ProtoSchemaType::kUint32},
        },
    },
    {
        "mdp_cmd_pingpong_done",
        4,
        {
            {},
            {"ctl_num", ProtoSchemaType::kUint32},
            {"intf_num", ProtoSchemaType::kUint32},
            {"pp_num", ProtoSchemaType::kUint32},
            {"koff_cnt", ProtoSchemaType::kInt32},
        },
    },
    {
        "mdp_compare_bw",
        8,
        {
            {},
            {"new_ab", ProtoSchemaType::kUint64},
            {"new_ib", ProtoSchemaType::kUint64},
            {"new_wb", ProtoSchemaType::kUint64},
            {"old_ab", ProtoSchemaType::kUint64},
            {"old_ib", ProtoSchemaType::kUint64},
            {"old_wb", ProtoSchemaType::kUint64},
            {"params_changed", ProtoSchemaType::kUint32},
            {"update_bw", ProtoSchemaType::kUint32},
        },
    },
    {
        "mdp_perf_set_panic_luts",
        5,
        {
            {},
            {"pnum", ProtoSchemaType::kUint32},
            {"fmt", ProtoSchemaType::kUint32},
            {"mode", ProtoSchemaType::kUint32},
            {"panic_lut", ProtoSchemaType::kUint32},
            {"robust_lut", ProtoSchemaType::kUint32},
        },
    },
    {
        "mdp_sspp_set",
        16,
        {
            {},
            {"num", ProtoSchemaType::kUint32},
            {"play_cnt", ProtoSchemaType::kUint32},
            {"mixer", ProtoSchemaType::kUint32},
            {"stage", ProtoSchemaType::kUint32},
            {"flags", ProtoSchemaType::kUint32},
            {"format", ProtoSchemaType::kUint32},
            {"img_w", ProtoSchemaType::kUint32},
            {"img_h", ProtoSchemaType::kUint32},
            {"src_x", ProtoSchemaType::kUint32},
            {"src_y", ProtoSchemaType::kUint32},
            {"src_w", ProtoSchemaType::kUint32},
            {"src_h", ProtoSchemaType::kUint32},
            {"dst_x", ProtoSchemaType::kUint32},
            {"dst_y", ProtoSchemaType::kUint32},
            {"dst_w", ProtoSchemaType::kUint32},
            {"dst_h", ProtoSchemaType::kUint32},
        },
    },
    {
        "mdp_cmd_readptr_done",
        2,
        {
            {},
            {"ctl_num", ProtoSchemaType::kUint32},
            {"koff_cnt", ProtoSchemaType::kInt32},
        },
    },
    {
        "mdp_misr_crc",
        3,
        {
            {},
            {"block_id", ProtoSchemaType::kUint32},
            {"vsync_cnt", ProtoSchemaType::kUint32},
            {"crc", ProtoSchemaType::kUint32},
        },
    },
    {
        "mdp_perf_set_qos_luts",
        7,
        {
            {},
            {"pnum", ProtoSchemaType::kUint32},
            {"fmt", ProtoSchemaType::kUint32},
            {"intf", ProtoSchemaType::kUint32},
            {"rot", ProtoSchemaType::kUint32},
            {"fl", ProtoSchemaType::kUint32},
            {"lut", ProtoSchemaType::kUint32},
            {"linear", ProtoSchemaType::kUint32},
        },
    },
    {
        "mdp_trace_counter",
        3,
        {
            {},
            {"pid", ProtoSchemaType::kInt32},
            {"counter_name", ProtoSchemaType::kString},
            {"value", ProtoSchemaType::kInt32},
        },
    },
    {
        "mdp_cmd_release_bw",
        1,
        {
            {},
            {"ctl_num", ProtoSchemaType::kUint32},
        },
    },
    {
        "mdp_mixer_update",
        1,
        {
            {},
            {"mixer_num", ProtoSchemaType::kUint32},
        },
    },
    {
        "mdp_perf_set_wm_levels",
        8,
        {
            {},
            {"pnum", ProtoSchemaType::kUint32},
            {"use_space", ProtoSchemaType::kUint32},
            {"priority_bytes", ProtoSchemaType::kUint32},
            {"wm0", ProtoSchemaType::kUint32},
            {"wm1", ProtoSchemaType::kUint32},
            {"wm2", ProtoSchemaType::kUint32},
            {"mb_cnt", ProtoSchemaType::kUint32},
            {"mb_size", ProtoSchemaType::kUint32},
        },
    },
    {
        "mdp_video_underrun_done",
        2,
        {
            {},
            {"ctl_num", ProtoSchemaType::kUint32},
            {"underrun_cnt", ProtoSchemaType::kUint32},
        },
    },
    {
        "mdp_cmd_wait_pingpong",
        2,
        {
            {},
            {"ctl_num", ProtoSchemaType::kUint32},
            {"kickoff_cnt", ProtoSchemaType::kInt32},
        },
    },
    {
        "mdp_perf_prefill_calc",
        10,
        {
            {},
            {"pnum", ProtoSchemaType::kUint32},
            {"latency_buf", ProtoSchemaType::kUint32},
            {"ot", ProtoSchemaType::kUint32},
            {"y_buf", ProtoSchemaType::kUint32},
            {"y_scaler", ProtoSchemaType::kUint32},
            {"pp_lines", ProtoSchemaType::kUint32},
            {"pp_bytes", ProtoSchemaType::kUint32},
            {"post_sc", ProtoSchemaType::kUint32},
            {"fbc_bytes", ProtoSchemaType::kUint32},
            {"prefill_bytes", ProtoSchemaType::kUint32},
        },
    },
    {
        "mdp_perf_update_bus",
        3,
        {
            {},
            {"client", ProtoSchemaType::kInt32},
            {"ab_quota", ProtoSchemaType::kUint64},
            {"ib_quota", ProtoSchemaType::kUint64},
        },
    },
    {
        "rotator_bw_ao_as_context",
        1,
        {
            {},
            {"state", ProtoSchemaType::kUint32},
        },
    },
    {
        "mm_filemap_add_to_page_cache",
        5,
        {
            {},
            {"pfn", ProtoSchemaType::kUint64},
            {"i_ino", ProtoSchemaType::kUint64},
            {"index", ProtoSchemaType::kUint64},
            {"s_dev", ProtoSchemaType::kUint64},
            {"page", ProtoSchemaType::kUint64},
        },
    },
    {
        "mm_filemap_delete_from_page_cache",
        5,
        {
            {},
            {"pfn", ProtoSchemaType::kUint64},
            {"i_ino", ProtoSchemaType::kUint64},
            {"index", ProtoSchemaType::kUint64},
            {"s_dev", ProtoSchemaType::kUint64},
            {"page", ProtoSchemaType::kUint64},
        },
    },
    {
        "mm_compaction_begin",
        5,
        {
            {},
            {"zone_start", ProtoSchemaType::kUint64},
            {"migrate_pfn", ProtoSchemaType::kUint64},
            {"free_pfn", ProtoSchemaType::kUint64},
            {"zone_end", ProtoSchemaType::kUint64},
            {"sync", ProtoSchemaType::kUint32},
        },
    },
    {
        "mm_compaction_defer_compaction",
        6,
        {
            {},
            {"nid", ProtoSchemaType::kInt32},
            {"idx", ProtoSchemaType::kUint32},
            {"order", ProtoSchemaType::kInt32},
            {"considered", ProtoSchemaType::kUint32},
            {"defer_shift", ProtoSchemaType::kUint32},
            {"order_failed", ProtoSchemaType::kInt32},
        },
    },
    {
        "mm_compaction_deferred",
        6,
        {
            {},
            {"nid", ProtoSchemaType::kInt32},
            {"idx", ProtoSchemaType::kUint32},
            {"order", ProtoSchemaType::kInt32},
            {"considered", ProtoSchemaType::kUint32},
            {"defer_shift", ProtoSchemaType::kUint32},
            {"order_failed", ProtoSchemaType::kInt32},
        },
    },
    {
        "mm_compaction_defer_reset",
        6,
        {
            {},
            {"nid", ProtoSchemaType::kInt32},
            {"idx", ProtoSchemaType::kUint32},
            {"order", ProtoSchemaType::kInt32},
            {"considered", ProtoSchemaType::kUint32},
            {"defer_shift", ProtoSchemaType::kUint32},
            {"order_failed", ProtoSchemaType::kInt32},
        },
    },
    {
        "mm_compaction_end",
        6,
        {
            {},
            {"zone_start", ProtoSchemaType::kUint64},
            {"migrate_pfn", ProtoSchemaType::kUint64},
            {"free_pfn", ProtoSchemaType::kUint64},
            {"zone_end", ProtoSchemaType::kUint64},
            {"sync", ProtoSchemaType::kUint32},
            {"status", ProtoSchemaType::kInt32},
        },
    },
    {
        "mm_compaction_finished",
        4,
        {
            {},
            {"nid", ProtoSchemaType::kInt32},
            {"idx", ProtoSchemaType::kUint32},
            {"order", ProtoSchemaType::kInt32},
            {"ret", ProtoSchemaType::kInt32},
        },
    },
    {
        "mm_compaction_isolate_freepages",
        4,
        {
            {},
            {"start_pfn", ProtoSchemaType::kUint64},
            {"end_pfn", ProtoSchemaType::kUint64},
            {"nr_scanned", ProtoSchemaType::kUint64},
            {"nr_taken", ProtoSchemaType::kUint64},
        },
    },
    {
        "mm_compaction_isolate_migratepages",
        4,
        {
            {},
            {"start_pfn", ProtoSchemaType::kUint64},
            {"end_pfn", ProtoSchemaType::kUint64},
            {"nr_scanned", ProtoSchemaType::kUint64},
            {"nr_taken", ProtoSchemaType::kUint64},
        },
    },
    {
        "mm_compaction_kcompactd_sleep",
        1,
        {
            {},
            {"nid", ProtoSchemaType::kInt32},
        },
    },
    {
        "mm_compaction_kcompactd_wake",
        4,
        {
            {},
            {"nid", ProtoSchemaType::kInt32},
            {"order", ProtoSchemaType::kInt32},
            {"classzone_idx", ProtoSchemaType::kUint32},
            {"highest_zoneidx", ProtoSchemaType::kUint32},
        },
    },
    {
        "mm_compaction_migratepages",
        2,
        {
            {},
            {"nr_migrated", ProtoSchemaType::kUint64},
            {"nr_failed", ProtoSchemaType::kUint64},
        },
    },
    {
        "mm_compaction_suitable",
        4,
        {
            {},
            {"nid", ProtoSchemaType::kInt32},
            {"idx", ProtoSchemaType::kUint32},
            {"order", ProtoSchemaType::kInt32},
            {"ret", ProtoSchemaType::kInt32},
        },
    },
    {
        "mm_compaction_try_to_compact_pages",
        4,
        {
            {},
            {"order", ProtoSchemaType::kInt32},
            {"gfp_mask", ProtoSchemaType::kUint32},
            {"mode", ProtoSchemaType::kUint32},
            {"prio", ProtoSchemaType::kInt32},
        },
    },
    {
        "mm_compaction_wakeup_kcompactd",
        4,
        {
            {},
            {"nid", ProtoSchemaType::kInt32},
            {"order", ProtoSchemaType::kInt32},
            {"classzone_idx", ProtoSchemaType::kUint32},
            {"highest_zoneidx", ProtoSchemaType::kUint32},
        },
    },
    {
        "suspend_resume",
        3,
        {
            {},
            {"action", ProtoSchemaType::kString},
            {"val", ProtoSchemaType::kInt32},
            {"start", ProtoSchemaType::kUint32},
        },
    },
    {
        "sched_wakeup_new",
        5,
        {
            {},
            {"comm", ProtoSchemaType::kString},
            {"pid", ProtoSchemaType::kInt32},
            {"prio", ProtoSchemaType::kInt32},
            {"success", ProtoSchemaType::kInt32},
            {"target_cpu", ProtoSchemaType::kInt32},
        },
    },
    {
        "block_bio_backmerge",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"sector", ProtoSchemaType::kUint64},
            {"nr_sector", ProtoSchemaType::kUint32},
            {"rwbs", ProtoSchemaType::kString},
            {"comm", ProtoSchemaType::kString},
        },
    },
    {
        "block_bio_bounce",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"sector", ProtoSchemaType::kUint64},
            {"nr_sector", ProtoSchemaType::kUint32},
            {"rwbs", ProtoSchemaType::kString},
            {"comm", ProtoSchemaType::kString},
        },
    },
    {
        "block_bio_complete",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"sector", ProtoSchemaType::kUint64},
            {"nr_sector", ProtoSchemaType::kUint32},
            {"error", ProtoSchemaType::kInt32},
            {"rwbs", ProtoSchemaType::kString},
        },
    },
    {
        "block_bio_frontmerge",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"sector", ProtoSchemaType::kUint64},
            {"nr_sector", ProtoSchemaType::kUint32},
            {"rwbs", ProtoSchemaType::kString},
            {"comm", ProtoSchemaType::kString},
        },
    },
    {
        "block_bio_queue",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"sector", ProtoSchemaType::kUint64},
            {"nr_sector", ProtoSchemaType::kUint32},
            {"rwbs", ProtoSchemaType::kString},
            {"comm", ProtoSchemaType::kString},
        },
    },
    {
        "block_bio_remap",
        6,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"sector", ProtoSchemaType::kUint64},
            {"nr_sector", ProtoSchemaType::kUint32},
            {"old_dev", ProtoSchemaType::kUint64},
            {"old_sector", ProtoSchemaType::kUint64},
            {"rwbs", ProtoSchemaType::kString},
        },
    },
    {
        "block_dirty_buffer",
        3,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"sector", ProtoSchemaType::kUint64},
            {"size", ProtoSchemaType::kUint64},
        },
    },
    {
        "block_getrq",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"sector", ProtoSchemaType::kUint64},
            {"nr_sector", ProtoSchemaType::kUint32},
            {"rwbs", ProtoSchemaType::kString},
            {"comm", ProtoSchemaType::kString},
        },
    },
    {
        "block_plug",
        1,
        {
            {},
            {"comm", ProtoSchemaType::kString},
        },
    },
    {
        "block_rq_abort",
        6,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"sector", ProtoSchemaType::kUint64},
            {"nr_sector", ProtoSchemaType::kUint32},
            {"errors", ProtoSchemaType::kInt32},
            {"rwbs", ProtoSchemaType::kString},
            {"cmd", ProtoSchemaType::kString},
        },
    },
    {
        "block_rq_complete",
        7,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"sector", ProtoSchemaType::kUint64},
            {"nr_sector", ProtoSchemaType::kUint32},
            {"errors", ProtoSchemaType::kInt32},
            {"rwbs", ProtoSchemaType::kString},
            {"cmd", ProtoSchemaType::kString},
            {"error", ProtoSchemaType::kInt32},
        },
    },
    {
        "block_rq_insert",
        7,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"sector", ProtoSchemaType::kUint64},
            {"nr_sector", ProtoSchemaType::kUint32},
            {"bytes", ProtoSchemaType::kUint32},
            {"rwbs", ProtoSchemaType::kString},
            {"comm", ProtoSchemaType::kString},
            {"cmd", ProtoSchemaType::kString},
        },
    },
    {nullptr, 0, {}},
    {
        "block_rq_remap",
        7,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"sector", ProtoSchemaType::kUint64},
            {"nr_sector", ProtoSchemaType::kUint32},
            {"old_dev", ProtoSchemaType::kUint64},
            {"old_sector", ProtoSchemaType::kUint64},
            {"nr_bios", ProtoSchemaType::kUint32},
            {"rwbs", ProtoSchemaType::kString},
        },
    },
    {
        "block_rq_requeue",
        6,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"sector", ProtoSchemaType::kUint64},
            {"nr_sector", ProtoSchemaType::kUint32},
            {"errors", ProtoSchemaType::kInt32},
            {"rwbs", ProtoSchemaType::kString},
            {"cmd", ProtoSchemaType::kString},
        },
    },
    {
        "block_sleeprq",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"sector", ProtoSchemaType::kUint64},
            {"nr_sector", ProtoSchemaType::kUint32},
            {"rwbs", ProtoSchemaType::kString},
            {"comm", ProtoSchemaType::kString},
        },
    },
    {
        "block_split",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"sector", ProtoSchemaType::kUint64},
            {"new_sector", ProtoSchemaType::kUint64},
            {"rwbs", ProtoSchemaType::kString},
            {"comm", ProtoSchemaType::kString},
        },
    },
    {
        "block_touch_buffer",
        3,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"sector", ProtoSchemaType::kUint64},
            {"size", ProtoSchemaType::kUint64},
        },
    },
    {
        "block_unplug",
        2,
        {
            {},
            {"nr_rq", ProtoSchemaType::kInt32},
            {"comm", ProtoSchemaType::kString},
        },
    },
    {
        "ext4_alloc_da_blocks",
        4,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"data_blocks", ProtoSchemaType::kUint32},
            {"meta_blocks", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_allocate_blocks",
        11,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"block", ProtoSchemaType::kUint64},
            {"len", ProtoSchemaType::kUint32},
            {"logical", ProtoSchemaType::kUint32},
            {"lleft", ProtoSchemaType::kUint32},
            {"lright", ProtoSchemaType::kUint32},
            {"goal", ProtoSchemaType::kUint64},
            {"pleft", ProtoSchemaType::kUint64},
            {"pright", ProtoSchemaType::kUint64},
            {"flags", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_allocate_inode",
        4,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"dir", ProtoSchemaType::kUint64},
            {"mode", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_begin_ordered_truncate",
        3,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"new_size", ProtoSchemaType::kInt64},
        },
    },
    {
        "ext4_collapse_range",
        4,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"offset", ProtoSchemaType::kInt64},
            {"len", ProtoSchemaType::kInt64},
        },
    },
    {
        "ext4_da_release_space",
        8,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"i_blocks", ProtoSchemaType::kUint64},
            {"freed_blocks", ProtoSchemaType::kInt32},
            {"reserved_data_blocks", ProtoSchemaType::kInt32},
            {"reserved_meta_blocks", ProtoSchemaType::kInt32},
            {"allocated_meta_blocks", ProtoSchemaType::kInt32},
            {"mode", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_da_reserve_space",
        7,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"i_blocks", ProtoSchemaType::kUint64},
            {"reserved_data_blocks", ProtoSchemaType::kInt32},
            {"reserved_meta_blocks", ProtoSchemaType::kInt32},
            {"mode", ProtoSchemaType::kUint32},
            {"md_needed", ProtoSchemaType::kInt32},
        },
    },
    {
        "ext4_da_update_reserve_space",
        9,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"i_blocks", ProtoSchemaType::kUint64},
            {"used_blocks", ProtoSchemaType::kInt32},
            {"reserved_data_blocks", ProtoSchemaType::kInt32},
            {"reserved_meta_blocks", ProtoSchemaType::kInt32},
            {"allocated_meta_blocks", ProtoSchemaType::kInt32},
            {"quota_claim", ProtoSchemaType::kInt32},
            {"mode", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_da_write_pages",
        10,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"first_page", ProtoSchemaType::kUint64},
            {"nr_to_write", ProtoSchemaType::kInt64},
            {"sync_mode", ProtoSchemaType::kInt32},
            {"b_blocknr", ProtoSchemaType::kUint64},
            {"b_size", ProtoSchemaType::kUint32},
            {"b_state", ProtoSchemaType::kUint32},
            {"io_done", ProtoSchemaType::kInt32},
            {"pages_written", ProtoSchemaType::kInt32},
        },
    },
    {
        "ext4_da_write_pages_extent",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"lblk", ProtoSchemaType::kUint64},
            {"len", ProtoSchemaType::kUint32},
            {"flags", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_direct_IO_enter",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"pos", ProtoSchemaType::kInt64},
            {"len", ProtoSchemaType::kUint64},
            {"rw", ProtoSchemaType::kInt32},
        },
    },
    {
        "ext4_direct_IO_exit",
        6,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"pos", ProtoSchemaType::kInt64},
            {"len", ProtoSchemaType::kUint64},
            {"rw", ProtoSchemaType::kInt32},
            {"ret", ProtoSchemaType::kInt32},
        },
    },
    {
        "ext4_discard_blocks",
        3,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"blk", ProtoSchemaType::kUint64},
            {"count", ProtoSchemaType::kUint64},
        },
    },
    {
        "ext4_discard_preallocations",
        4,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"len", ProtoSchemaType::kUint32},
            {"needed", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_drop_inode",
        3,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"drop", ProtoSchemaType::kInt32},
        },
    },
    {
        "ext4_es_cache_extent",
        6,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"lblk", ProtoSchemaType::kUint32},
            {"len", ProtoSchemaType::kUint32},
            {"pblk", ProtoSchemaType::kUint64},
            {"status", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_es_find_delayed_extent_range_enter",
        3,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"lblk", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_es_find_delayed_extent_range_exit",
        6,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"lblk", ProtoSchemaType::kUint32},
            {"len", ProtoSchemaType::kUint32},
            {"pblk", ProtoSchemaType::kUint64},
            {"status", ProtoSchemaType::kUint64},
        },
    },
    {
        "ext4_es_insert_extent",
        6,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"lblk", ProtoSchemaType::kUint32},
            {"len", ProtoSchemaType::kUint32},
            {"pblk", ProtoSchemaType::kUint64},
            {"status", ProtoSchemaType::kUint64},
        },
    },
    {
        "ext4_es_lookup_extent_enter",
        3,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"lblk", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_es_lookup_extent_exit",
        7,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"lblk", ProtoSchemaType::kUint32},
            {"len", ProtoSchemaType::kUint32},
            {"pblk", ProtoSchemaType::kUint64},
            {"status", ProtoSchemaType::kUint64},
            {"found", ProtoSchemaType::kInt32},
        },
    },
    {
        "ext4_es_remove_extent",
        4,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"lblk", ProtoSchemaType::kInt64},
            {"len", ProtoSchemaType::kInt64},
        },
    },
    {
        "ext4_es_shrink",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"nr_shrunk", ProtoSchemaType::kInt32},
            {"scan_time", ProtoSchemaType::kUint64},
            {"nr_skipped", ProtoSchemaType::kInt32},
            {"retried", ProtoSchemaType::kInt32},
        },
    },
    {
        "ext4_es_shrink_count",
        3,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"nr_to_scan", ProtoSchemaType::kInt32},
            {"cache_cnt", ProtoSchemaType::kInt32},
        },
    },
    {
        "ext4_es_shrink_scan_enter",
        3,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"nr_to_scan", ProtoSchemaType::kInt32},
            {"cache_cnt", ProtoSchemaType::kInt32},
        },
    },
    {
        "ext4_es_shrink_scan_exit",
        3,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"nr_shrunk", ProtoSchemaType::kInt32},
            {"cache_cnt", ProtoSchemaType::kInt32},
        },
    },
    {
        "ext4_evict_inode",
        3,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"nlink", ProtoSchemaType::kInt32},
        },
    },
    {
        "ext4_ext_convert_to_initialized_enter",
        7,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"m_lblk", ProtoSchemaType::kUint32},
            {"m_len", ProtoSchemaType::kUint32},
            {"u_lblk", ProtoSchemaType::kUint32},
            {"u_len", ProtoSchemaType::kUint32},
            {"u_pblk", ProtoSchemaType::kUint64},
        },
    },
    {
        "ext4_ext_convert_to_initialized_fastpath",
        10,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"m_lblk", ProtoSchemaType::kUint32},
            {"m_len", ProtoSchemaType::kUint32},
            {"u_lblk", ProtoSchemaType::kUint32},
            {"u_len", ProtoSchemaType::kUint32},
            {"u_pblk", ProtoSchemaType::kUint64},
            {"i_lblk", ProtoSchemaType::kUint32},
            {"i_len", ProtoSchemaType::kUint32},
            {"i_pblk", ProtoSchemaType::kUint64},
        },
    },
    {
        "ext4_ext_handle_unwritten_extents",
        8,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"flags", ProtoSchemaType::kInt32},
            {"lblk", ProtoSchemaType::kUint32},
            {"pblk", ProtoSchemaType::kUint64},
            {"len", ProtoSchemaType::kUint32},
            {"allocated", ProtoSchemaType::kUint32},
            {"newblk", ProtoSchemaType::kUint64},
        },
    },
    {
        "ext4_ext_in_cache",
        4,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"lblk", ProtoSchemaType::kUint32},
            {"ret", ProtoSchemaType::kInt32},
        },
    },
    {
        "ext4_ext_load_extent",
        4,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"pblk", ProtoSchemaType::kUint64},
            {"lblk", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_ext_map_blocks_enter",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"lblk", ProtoSchemaType::kUint32},
            {"len", ProtoSchemaType::kUint32},
            {"flags", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_ext_map_blocks_exit",
        8,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"flags", ProtoSchemaType::kUint32},
            {"pblk", ProtoSchemaType::kUint64},
            {"lblk", ProtoSchemaType::kUint32},
            {"len", ProtoSchemaType::kUint32},
            {"mflags", ProtoSchemaType::kUint32},
            {"ret", ProtoSchemaType::kInt32},
        },
    },
    {
        "ext4_ext_put_in_cache",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"lblk", ProtoSchemaType::kUint32},
            {"len", ProtoSchemaType::kUint32},
            {"start", ProtoSchemaType::kUint64},
        },
    },
    {
        "ext4_ext_remove_space",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"start", ProtoSchemaType::kUint32},
            {"end", ProtoSchemaType::kUint32},
            {"depth", ProtoSchemaType::kInt32},
        },
    },
    {
        "ext4_ext_remove_space_done",
        10,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"start", ProtoSchemaType::kUint32},
            {"end", ProtoSchemaType::kUint32},
            {"depth", ProtoSchemaType::kInt32},
            {"partial", ProtoSchemaType::kInt64},
            {"eh_entries", ProtoSchemaType::kUint32},
            {"pc_lblk", ProtoSchemaType::kUint32},
            {"pc_pclu", ProtoSchemaType::kUint64},
            {"pc_state", ProtoSchemaType::kInt32},
        },
    },
    {
        "ext4_ext_rm_idx",
        3,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"pblk", ProtoSchemaType::kUint64},
        },
    },
    {
        "ext4_ext_rm_leaf",
        10,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"partial", ProtoSchemaType::kInt64},
            {"start", ProtoSchemaType::kUint32},
            {"ee_lblk", ProtoSchemaType::kUint32},
            {"ee_pblk", ProtoSchemaType::kUint64},
            {"ee_len", ProtoSchemaType::kInt32},
            {"pc_lblk", ProtoSchemaType::kUint32},
            {"pc_pclu", ProtoSchemaType::kUint64},
            {"pc_state", ProtoSchemaType::kInt32},
        },
    },
    {
        "ext4_ext_show_extent",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"pblk", ProtoSchemaType::kUint64},
            {"lblk", ProtoSchemaType::kUint32},
            {"len", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_fallocate_enter",
        6,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"offset", ProtoSchemaType::kInt64},
            {"len", ProtoSchemaType::kInt64},
            {"mode", ProtoSchemaType::kInt32},
            {"pos", ProtoSchemaType::kInt64},
        },
    },
    {
        "ext4_fallocate_exit",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"pos", ProtoSchemaType::kInt64},
            {"blocks", ProtoSchemaType::kUint32},
            {"ret", ProtoSchemaType::kInt32},
        },
    },
    {
        "ext4_find_delalloc_range",
        7,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"from", ProtoSchemaType::kUint32},
            {"to", ProtoSchemaType::kUint32},
            {"reverse", ProtoSchemaType::kInt32},
            {"found", ProtoSchemaType::kInt32},
            {"found_blk", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_forget",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"block", ProtoSchemaType::kUint64},
            {"is_metadata", ProtoSchemaType::kInt32},
            {"mode", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_free_blocks",
        6,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"block", ProtoSchemaType::kUint64},
            {"count", ProtoSchemaType::kUint64},
            {"flags", ProtoSchemaType::kInt32},
            {"mode", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_free_inode",
        6,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"uid", ProtoSchemaType::kUint32},
            {"gid", ProtoSchemaType::kUint32},
            {"blocks", ProtoSchemaType::kUint64},
            {"mode", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_get_implied_cluster_alloc_exit",
        6,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"flags", ProtoSchemaType::kUint32},
            {"lblk", ProtoSchemaType::kUint32},
            {"pblk", ProtoSchemaType::kUint64},
            {"len", ProtoSchemaType::kUint32},
            {"ret", ProtoSchemaType::kInt32},
        },
    },
    {
        "ext4_get_reserved_cluster_alloc",
        4,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"lblk", ProtoSchemaType::kUint32},
            {"len", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_ind_map_blocks_enter",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"lblk", ProtoSchemaType::kUint32},
            {"len", ProtoSchemaType::kUint32},
            {"flags", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_ind_map_blocks_exit",
        8,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"flags", ProtoSchemaType::kUint32},
            {"pblk", ProtoSchemaType::kUint64},
            {"lblk", ProtoSchemaType::kUint32},
            {"len", ProtoSchemaType::kUint32},
            {"mflags", ProtoSchemaType::kUint32},
            {"ret", ProtoSchemaType::kInt32},
        },
    },
    {
        "ext4_insert_range",
        4,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"offset", ProtoSchemaType::kInt64},
            {"len", ProtoSchemaType::kInt64},
        },
    },
    {
        "ext4_invalidatepage",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"index", ProtoSchemaType::kUint64},
            {"offset", ProtoSchemaType::kUint64},
            {"length", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_journal_start",
        6,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ip", ProtoSchemaType::kUint64},
            {"blocks", ProtoSchemaType::kInt32},
            {"rsv_blocks", ProtoSchemaType::kInt32},
            {"nblocks", ProtoSchemaType::kInt32},
            {"revoke_creds", ProtoSchemaType::kInt32},
        },
    },
    {
        "ext4_journal_start_reserved",
        3,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ip", ProtoSchemaType::kUint64},
            {"blocks", ProtoSchemaType::kInt32},
        },
    },
    {
        "ext4_journalled_invalidatepage",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"index", ProtoSchemaType::kUint64},
            {"offset", ProtoSchemaType::kUint64},
            {"length", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_journalled_write_end",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"pos", ProtoSchemaType::kInt64},
            {"len", ProtoSchemaType::kUint32},
            {"copied", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_load_inode",
        2,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
        },
    },
    {
        "ext4_load_inode_bitmap",
        2,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"group", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_mark_inode_dirty",
        3,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"ip", ProtoSchemaType::kUint64},
        },
    },
    {
        "ext4_mb_bitmap_load",
        2,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"group", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_mb_buddy_bitmap_load",
        2,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"group", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_mb_discard_preallocations",
        2,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"needed", ProtoSchemaType::kInt32},
        },
    },
    {
        "ext4_mb_new_group_pa",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"pa_pstart", ProtoSchemaType::kUint64},
            {"pa_lstart", ProtoSchemaType::kUint64},
            {"pa_len", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_mb_new_inode_pa",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"pa_pstart", ProtoSchemaType::kUint64},
            {"pa_lstart", ProtoSchemaType::kUint64},
            {"pa_len", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_mb_release_group_pa",
        3,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"pa_pstart", ProtoSchemaType::kUint64},
            {"pa_len", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_mb_release_inode_pa",
        4,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"block", ProtoSchemaType::kUint64},
            {"count", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_mballoc_alloc",
        20,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"orig_logical", ProtoSchemaType::kUint32},
            {"orig_start", ProtoSchemaType::kInt32},
            {"orig_group", ProtoSchemaType::kUint32},
            {"orig_len", ProtoSchemaType::kInt32},
            {"goal_logical", ProtoSchemaType::kUint32},
            {"goal_start", ProtoSchemaType::kInt32},
            {"goal_group", ProtoSchemaType::kUint32},
            {"goal_len", ProtoSchemaType::kInt32},
            {"result_logical", ProtoSchemaType::kUint32},
            {"result_start", ProtoSchemaType::kInt32},
            {"result_group", ProtoSchemaType::kUint32},
            {"result_len", ProtoSchemaType::kInt32},
            {"found", ProtoSchemaType::kUint32},
            {"groups", ProtoSchemaType::kUint32},
            {"buddy", ProtoSchemaType::kUint32},
            {"flags", ProtoSchemaType::kUint32},
            {"tail", ProtoSchemaType::kUint32},
            {"cr", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_mballoc_discard",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"result_start", ProtoSchemaType::kInt32},
            {"result_group", ProtoSchemaType::kUint32},
            {"result_len", ProtoSchemaType::kInt32},
        },
    },
    {
        "ext4_mballoc_free",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"result_start", ProtoSchemaType::kInt32},
            {"result_group", ProtoSchemaType::kUint32},
            {"result_len", ProtoSchemaType::kInt32},
        },
    },
    {
        "ext4_mballoc_prealloc",
        10,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"orig_logical", ProtoSchemaType::kUint32},
            {"orig_start", ProtoSchemaType::kInt32},
            {"orig_group", ProtoSchemaType::kUint32},
            {"orig_len", ProtoSchemaType::kInt32},
            {"result_logical", ProtoSchemaType::kUint32},
            {"result_start", ProtoSchemaType::kInt32},
            {"result_group", ProtoSchemaType::kUint32},
            {"result_len", ProtoSchemaType::kInt32},
        },
    },
    {
        "ext4_other_inode_update_time",
        6,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"orig_ino", ProtoSchemaType::kUint64},
            {"uid", ProtoSchemaType::kUint32},
            {"gid", ProtoSchemaType::kUint32},
            {"mode", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_punch_hole",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"offset", ProtoSchemaType::kInt64},
            {"len", ProtoSchemaType::kInt64},
            {"mode", ProtoSchemaType::kInt32},
        },
    },
    {
        "ext4_read_block_bitmap_load",
        3,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"group", ProtoSchemaType::kUint32},
            {"prefetch", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_readpage",
        3,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"index", ProtoSchemaType::kUint64},
        },
    },
    {
        "ext4_releasepage",
        3,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"index", ProtoSchemaType::kUint64},
        },
    },
    {
        "ext4_remove_blocks",
        11,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"from", ProtoSchemaType::kUint32},
            {"to", ProtoSchemaType::kUint32},
            {"partial", ProtoSchemaType::kInt64},
            {"ee_pblk", ProtoSchemaType::kUint64},
            {"ee_lblk", ProtoSchemaType::kUint32},
            {"ee_len", ProtoSchemaType::kUint32},
            {"pc_lblk", ProtoSchemaType::kUint32},
            {"pc_pclu", ProtoSchemaType::kUint64},
            {"pc_state", ProtoSchemaType::kInt32},
        },
    },
    {
        "ext4_request_blocks",
        10,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"len", ProtoSchemaType::kUint32},
            {"logical", ProtoSchemaType::kUint32},
            {"lleft", ProtoSchemaType::kUint32},
            {"lright", ProtoSchemaType::kUint32},
            {"goal", ProtoSchemaType::kUint64},
            {"pleft", ProtoSchemaType::kUint64},
            {"pright", ProtoSchemaType::kUint64},
            {"flags", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_request_inode",
        3,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"dir", ProtoSchemaType::kUint64},
            {"mode", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_sync_fs",
        2,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"wait", ProtoSchemaType::kInt32},
        },
    },
    {
        "ext4_trim_all_free",
        5,
        {
            {},
            {"dev_major", ProtoSchemaType::kInt32},
            {"dev_minor", ProtoSchemaType::kInt32},
            {"group", ProtoSchemaType::kUint32},
            {"start", ProtoSchemaType::kInt32},
            {"len", ProtoSchemaType::kInt32},
        },
    },
    {
        "ext4_trim_extent",
        5,
        {
            {},
            {"dev_major", ProtoSchemaType::kInt32},
            {"dev_minor", ProtoSchemaType::kInt32},
            {"group", ProtoSchemaType::kUint32},
            {"start", ProtoSchemaType::kInt32},
            {"len", ProtoSchemaType::kInt32},
        },
    },
    {
        "ext4_truncate_enter",
        3,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"blocks", ProtoSchemaType::kUint64},
        },
    },
    {
        "ext4_truncate_exit",
        3,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"blocks", ProtoSchemaType::kUint64},
        },
    },
    {
        "ext4_unlink_enter",
        4,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"parent", ProtoSchemaType::kUint64},
            {"size", ProtoSchemaType::kInt64},
        },
    },
    {
        "ext4_unlink_exit",
        3,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"ret", ProtoSchemaType::kInt32},
        },
    },
    {
        "ext4_write_begin",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"pos", ProtoSchemaType::kInt64},
            {"len", ProtoSchemaType::kUint32},
            {"flags", ProtoSchemaType::kUint32},
        },
    },
    {nullptr, 0, {}},
    {nullptr, 0, {}},
    {nullptr, 0, {}},
    {nullptr, 0, {}},
    {nullptr, 0, {}},
    {nullptr, 0, {}},
    {nullptr, 0, {}},
    {nullptr, 0, {}},
    {nullptr, 0, {}},
    {nullptr, 0, {}},
    {
        "ext4_write_end",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"pos", ProtoSchemaType::kInt64},
            {"len", ProtoSchemaType::kUint32},
            {"copied", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_writepage",
        3,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"index", ProtoSchemaType::kUint64},
        },
    },
    {
        "ext4_writepages",
        10,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"nr_to_write", ProtoSchemaType::kInt64},
            {"pages_skipped", ProtoSchemaType::kInt64},
            {"range_start", ProtoSchemaType::kInt64},
            {"range_end", ProtoSchemaType::kInt64},
            {"writeback_index", ProtoSchemaType::kUint64},
            {"sync_mode", ProtoSchemaType::kInt32},
            {"for_kupdate", ProtoSchemaType::kUint32},
            {"range_cyclic", ProtoSchemaType::kUint32},
        },
    },
    {
        "ext4_writepages_result",
        7,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"ret", ProtoSchemaType::kInt32},
            {"pages_written", ProtoSchemaType::kInt32},
            {"pages_skipped", ProtoSchemaType::kInt64},
            {"writeback_index", ProtoSchemaType::kUint64},
            {"sync_mode", ProtoSchemaType::kInt32},
        },
    },
    {
        "ext4_zero_range",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"offset", ProtoSchemaType::kInt64},
            {"len", ProtoSchemaType::kInt64},
            {"mode", ProtoSchemaType::kInt32},
        },
    },
    {
        "task_newtask",
        4,
        {
            {},
            {"pid", ProtoSchemaType::kInt32},
            {"comm", ProtoSchemaType::kString},
            {"clone_flags", ProtoSchemaType::kUint64},
            {"oom_score_adj", ProtoSchemaType::kInt32},
        },
    },
    {
        "task_rename",
        4,
        {
            {},
            {"pid", ProtoSchemaType::kInt32},
            {"oldcomm", ProtoSchemaType::kString},
            {"newcomm", ProtoSchemaType::kString},
            {"oom_score_adj", ProtoSchemaType::kInt32},
        },
    },
    {
        "sched_process_exec",
        3,
        {
            {},
            {"filename", ProtoSchemaType::kString},
            {"pid", ProtoSchemaType::kInt32},
            {"old_pid", ProtoSchemaType::kInt32},
        },
    },
    {
        "sched_process_exit",
        4,
        {
            {},
            {"comm", ProtoSchemaType::kString},
            {"pid", ProtoSchemaType::kInt32},
            {"tgid", ProtoSchemaType::kInt32},
            {"prio", ProtoSchemaType::kInt32},
        },
    },
    {
        "sched_process_fork",
        4,
        {
            {},
            {"parent_comm", ProtoSchemaType::kString},
            {"parent_pid", ProtoSchemaType::kInt32},
            {"child_comm", ProtoSchemaType::kString},
            {"child_pid", ProtoSchemaType::kInt32},
        },
    },
    {
        "sched_process_free",
        3,
        {
            {},
            {"comm", ProtoSchemaType::kString},
            {"pid", ProtoSchemaType::kInt32},
            {"prio", ProtoSchemaType::kInt32},
        },
    },
    {
        "sched_process_hang",
        2,
        {
            {},
            {"comm", ProtoSchemaType::kString},
            {"pid", ProtoSchemaType::kInt32},
        },
    },
    {
        "sched_process_wait",
        3,
        {
            {},
            {"comm", ProtoSchemaType::kString},
            {"pid", ProtoSchemaType::kInt32},
            {"prio", ProtoSchemaType::kInt32},
        },
    },
    {
        "f2fs_do_submit_bio",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"btype", ProtoSchemaType::kInt32},
            {"sync", ProtoSchemaType::kUint32},
            {"sector", ProtoSchemaType::kUint64},
            {"size", ProtoSchemaType::kUint32},
        },
    },
    {
        "f2fs_evict_inode",
        8,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"pino", ProtoSchemaType::kUint64},
            {"mode", ProtoSchemaType::kUint32},
            {"size", ProtoSchemaType::kInt64},
            {"nlink", ProtoSchemaType::kUint32},
            {"blocks", ProtoSchemaType::kUint64},
            {"advise", ProtoSchemaType::kUint32},
        },
    },
    {
        "f2fs_fallocate",
        8,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"mode", ProtoSchemaType::kInt32},
            {"offset", ProtoSchemaType::kInt64},
            {"len", ProtoSchemaType::kInt64},
            {"size", ProtoSchemaType::kInt64},
            {"blocks", ProtoSchemaType::kUint64},
            {"ret", ProtoSchemaType::kInt32},
        },
    },
    {
        "f2fs_get_data_block",
        6,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"iblock", ProtoSchemaType::kUint64},
            {"bh_start", ProtoSchemaType::kUint64},
            {"bh_size", ProtoSchemaType::kUint64},
            {"ret", ProtoSchemaType::kInt32},
        },
    },
    {
        "f2fs_get_victim",
        11,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"type", ProtoSchemaType::kInt32},
            {"gc_type", ProtoSchemaType::kInt32},
            {"alloc_mode", ProtoSchemaType::kInt32},
            {"gc_mode", ProtoSchemaType::kInt32},
            {"victim", ProtoSchemaType::kUint32},
            {"ofs_unit", ProtoSchemaType::kUint32},
            {"pre_victim", ProtoSchemaType::kUint32},
            {"prefree", ProtoSchemaType::kUint32},
            {"free", ProtoSchemaType::kUint32},
            {"cost", ProtoSchemaType::kUint32},
        },
    },
    {
        "f2fs_iget",
        8,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"pino", ProtoSchemaType::kUint64},
            {"mode", ProtoSchemaType::kUint32},
            {"size", ProtoSchemaType::kInt64},
            {"nlink", ProtoSchemaType::kUint32},
            {"blocks", ProtoSchemaType::kUint64},
            {"advise", ProtoSchemaType::kUint32},
        },
    },
    {
        "f2fs_iget_exit",
        3,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"ret", ProtoSchemaType::kInt32},
        },
    },
    {
        "f2fs_new_inode",
        3,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"ret", ProtoSchemaType::kInt32},
        },
    },
    {
        "f2fs_readpage",
        8,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"index", ProtoSchemaType::kUint64},
            {"blkaddr", ProtoSchemaType::kUint64},
            {"type", ProtoSchemaType::kInt32},
            {"dir", ProtoSchemaType::kInt32},
            {"dirty", ProtoSchemaType::kInt32},
            {"uptodate", ProtoSchemaType::kInt32},
        },
    },
    {
        "f2fs_reserve_new_block",
        3,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"nid", ProtoSchemaType::kUint32},
            {"ofs_in_node", ProtoSchemaType::kUint32},
        },
    },
    {
        "f2fs_set_page_dirty",
        7,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"type", ProtoSchemaType::kInt32},
            {"dir", ProtoSchemaType::kInt32},
            {"index", ProtoSchemaType::kUint64},
            {"dirty", ProtoSchemaType::kInt32},
            {"uptodate", ProtoSchemaType::kInt32},
        },
    },
    {
        "f2fs_submit_write_page",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"type", ProtoSchemaType::kInt32},
            {"index", ProtoSchemaType::kUint64},
            {"block", ProtoSchemaType::kUint32},
        },
    },
    {
        "f2fs_sync_file_enter",
        8,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"pino", ProtoSchemaType::kUint64},
            {"mode", ProtoSchemaType::kUint32},
            {"size", ProtoSchemaType::kInt64},
            {"nlink", ProtoSchemaType::kUint32},
            {"blocks", ProtoSchemaType::kUint64},
            {"advise", ProtoSchemaType::kUint32},
        },
    },
    {
        "f2fs_sync_file_exit",
        6,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"need_cp", ProtoSchemaType::kUint32},
            {"datasync", ProtoSchemaType::kInt32},
            {"ret", ProtoSchemaType::kInt32},
            {"cp_reason", ProtoSchemaType::kInt32},
        },
    },
    {
        "f2fs_sync_fs",
        3,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"dirty", ProtoSchemaType::kInt32},
            {"wait", ProtoSchemaType::kInt32},
        },
    },
    {
        "f2fs_truncate",
        8,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"pino", ProtoSchemaType::kUint64},
            {"mode", ProtoSchemaType::kUint32},
            {"size", ProtoSchemaType::kInt64},
            {"nlink", ProtoSchemaType::kUint32},
            {"blocks", ProtoSchemaType::kUint64},
            {"advise", ProtoSchemaType::kUint32},
        },
    },
    {
        "f2fs_truncate_blocks_enter",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"size", ProtoSchemaType::kInt64},
            {"blocks", ProtoSchemaType::kUint64},
            {"from", ProtoSchemaType::kUint64},
        },
    },
    {
        "f2fs_truncate_blocks_exit",
        3,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"ret", ProtoSchemaType::kInt32},
        },
    },
    {
        "f2fs_truncate_data_blocks_range",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"nid", ProtoSchemaType::kUint32},
            {"ofs", ProtoSchemaType::kUint32},
            {"free", ProtoSchemaType::kInt32},
        },
    },
    {
        "f2fs_truncate_inode_blocks_enter",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"size", ProtoSchemaType::kInt64},
            {"blocks", ProtoSchemaType::kUint64},
            {"from", ProtoSchemaType::kUint64},
        },
    },
    {
        "f2fs_truncate_inode_blocks_exit",
        3,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"ret", ProtoSchemaType::kInt32},
        },
    },
    {
        "f2fs_truncate_node",
        4,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"nid", ProtoSchemaType::kUint32},
            {"blk_addr", ProtoSchemaType::kUint32},
        },
    },
    {
        "f2fs_truncate_nodes_enter",
        4,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"nid", ProtoSchemaType::kUint32},
            {"blk_addr", ProtoSchemaType::kUint32},
        },
    },
    {
        "f2fs_truncate_nodes_exit",
        3,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"ret", ProtoSchemaType::kInt32},
        },
    },
    {
        "f2fs_truncate_partial_nodes",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"nid", ProtoSchemaType::kUint32},
            {"depth", ProtoSchemaType::kInt32},
            {"err", ProtoSchemaType::kInt32},
        },
    },
    {
        "f2fs_unlink_enter",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"size", ProtoSchemaType::kInt64},
            {"blocks", ProtoSchemaType::kUint64},
            {"name", ProtoSchemaType::kString},
        },
    },
    {
        "f2fs_unlink_exit",
        3,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"ret", ProtoSchemaType::kInt32},
        },
    },
    {
        "f2fs_vm_page_mkwrite",
        7,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"type", ProtoSchemaType::kInt32},
            {"dir", ProtoSchemaType::kInt32},
            {"index", ProtoSchemaType::kUint64},
            {"dirty", ProtoSchemaType::kInt32},
            {"uptodate", ProtoSchemaType::kInt32},
        },
    },
    {
        "f2fs_write_begin",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"pos", ProtoSchemaType::kInt64},
            {"len", ProtoSchemaType::kUint32},
            {"flags", ProtoSchemaType::kUint32},
        },
    },
    {
        "f2fs_write_checkpoint",
        4,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"is_umount", ProtoSchemaType::kUint32},
            {"msg", ProtoSchemaType::kString},
            {"reason", ProtoSchemaType::kInt32},
        },
    },
    {
        "f2fs_write_end",
        5,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ino", ProtoSchemaType::kUint64},
            {"pos", ProtoSchemaType::kInt64},
            {"len", ProtoSchemaType::kUint32},
            {"copied", ProtoSchemaType::kUint32},
        },
    },
    {
        "alloc_pages_iommu_end",
        2,
        {
            {},
            {"gfp_flags", ProtoSchemaType::kUint32},
            {"order", ProtoSchemaType::kUint32},
        },
    },
    {
        "alloc_pages_iommu_fail",
        2,
        {
            {},
            {"gfp_flags", ProtoSchemaType::kUint32},
            {"order", ProtoSchemaType::kUint32},
        },
    },
    {
        "alloc_pages_iommu_start",
        2,
        {
            {},
            {"gfp_flags", ProtoSchemaType::kUint32},
            {"order", ProtoSchemaType::kUint32},
        },
    },
    {
        "alloc_pages_sys_end",
        2,
        {
            {},
            {"gfp_flags", ProtoSchemaType::kUint32},
            {"order", ProtoSchemaType::kUint32},
        },
    },
    {
        "alloc_pages_sys_fail",
        2,
        {
            {},
            {"gfp_flags", ProtoSchemaType::kUint32},
            {"order", ProtoSchemaType::kUint32},
        },
    },
    {
        "alloc_pages_sys_start",
        2,
        {
            {},
            {"gfp_flags", ProtoSchemaType::kUint32},
            {"order", ProtoSchemaType::kUint32},
        },
    },
    {
        "dma_alloc_contiguous_retry",
        1,
        {
            {},
            {"tries", ProtoSchemaType::kInt32},
        },
    },
    {
        "iommu_map_range",
        4,
        {
            {},
            {"chunk_size", ProtoSchemaType::kUint64},
            {"len", ProtoSchemaType::kUint64},
            {"pa", ProtoSchemaType::kUint64},
            {"va", ProtoSchemaType::kUint64},
        },
    },
    {
        "iommu_sec_ptbl_map_range_end",
        5,
        {
            {},
            {"len", ProtoSchemaType::kUint64},
            {"num", ProtoSchemaType::kInt32},
            {"pa", ProtoSchemaType::kUint32},
            {"sec_id", ProtoSchemaType::kInt32},
            {"va", ProtoSchemaType::kUint64},
        },
    },
    {
        "iommu_sec_ptbl_map_range_start",
        5,
        {
            {},
            {"len", ProtoSchemaType::kUint64},
            {"num", ProtoSchemaType::kInt32},
            {"pa", ProtoSchemaType::kUint32},
            {"sec_id", ProtoSchemaType::kInt32},
            {"va", ProtoSchemaType::kUint64},
        },
    },
    {
        "ion_alloc_buffer_end",
        5,
        {
            {},
            {"client_name", ProtoSchemaType::kString},
            {"flags", ProtoSchemaType::kUint32},
            {"heap_name", ProtoSchemaType::kString},
            {"len", ProtoSchemaType::kUint64},
            {"mask", ProtoSchemaType::kUint32},
        },
    },
    {
        "ion_alloc_buffer_fail",
        6,
        {
            {},
            {"client_name", ProtoSchemaType::kString},
            {"error", ProtoSchemaType::kInt64},
            {"flags", ProtoSchemaType::kUint32},
            {"heap_name", ProtoSchemaType::kString},
            {"len", ProtoSchemaType::kUint64},
            {"mask", ProtoSchemaType::kUint32},
        },
    },
    {
        "ion_alloc_buffer_fallback",
        6,
        {
            {},
            {"client_name", ProtoSchemaType::kString},
            {"error", ProtoSchemaType::kInt64},
            {"flags", ProtoSchemaType::kUint32},
            {"heap_name", ProtoSchemaType::kString},
            {"len", ProtoSchemaType::kUint64},
            {"mask", ProtoSchemaType::kUint32},
        },
    },
    {
        "ion_alloc_buffer_start",
        5,
        {
            {},
            {"client_name", ProtoSchemaType::kString},
            {"flags", ProtoSchemaType::kUint32},
            {"heap_name", ProtoSchemaType::kString},
            {"len", ProtoSchemaType::kUint64},
            {"mask", ProtoSchemaType::kUint32},
        },
    },
    {
        "ion_cp_alloc_retry",
        1,
        {
            {},
            {"tries", ProtoSchemaType::kInt32},
        },
    },
    {
        "ion_cp_secure_buffer_end",
        4,
        {
            {},
            {"align", ProtoSchemaType::kUint64},
            {"flags", ProtoSchemaType::kUint64},
            {"heap_name", ProtoSchemaType::kString},
            {"len", ProtoSchemaType::kUint64},
        },
    },
    {
        "ion_cp_secure_buffer_start",
        4,
        {
            {},
            {"align", ProtoSchemaType::kUint64},
            {"flags", ProtoSchemaType::kUint64},
            {"heap_name", ProtoSchemaType::kString},
            {"len", ProtoSchemaType::kUint64},
        },
    },
    {
        "ion_prefetching",
        1,
        {
            {},
            {"len", ProtoSchemaType::kUint64},
        },
    },
    {
        "ion_secure_cma_add_to_pool_end",
        3,
        {
            {},
            {"is_prefetch", ProtoSchemaType::kUint32},
            {"len", ProtoSchemaType::kUint64},
            {"pool_total", ProtoSchemaType::kInt32},
        },
    },
    {
        "ion_secure_cma_add_to_pool_start",
        3,
        {
            {},
            {"is_prefetch", ProtoSchemaType::kUint32},
            {"len", ProtoSchemaType::kUint64},
            {"pool_total", ProtoSchemaType::kInt32},
        },
    },
    {
        "ion_secure_cma_allocate_end",
        4,
        {
            {},
            {"align", ProtoSchemaType::kUint64},
            {"flags", ProtoSchemaType::kUint64},
            {"heap_name", ProtoSchemaType::kString},
            {"len", ProtoSchemaType::kUint64},
        },
    },
    {
        "ion_secure_cma_allocate_start",
        4,
        {
            {},
            {"align", ProtoSchemaType::kUint64},
            {"flags", ProtoSchemaType::kUint64},
            {"heap_name", ProtoSchemaType::kString},
            {"len", ProtoSchemaType::kUint64},
        },
    },
    {
        "ion_secure_cma_shrink_pool_end",
        2,
        {
            {},
            {"drained_size", ProtoSchemaType::kUint64},
            {"skipped_size", ProtoSchemaType::kUint64},
        },
    },
    {
        "ion_secure_cma_shrink_pool_start",
        2,
        {
            {},
            {"drained_size", ProtoSchemaType::kUint64},
            {"skipped_size", ProtoSchemaType::kUint64},
        },
    },
    {
        "kfree",
        2,
        {
            {},
            {"call_site", ProtoSchemaType::kUint64},
            {"ptr", ProtoSchemaType::kUint64},
        },
    },
    {
        "kmalloc",
        5,
        {
            {},
            {"bytes_alloc", ProtoSchemaType::kUint64},
            {"bytes_req", ProtoSchemaType::kUint64},
            {"call_site", ProtoSchemaType::kUint64},
            {"gfp_flags", ProtoSchemaType::kUint32},
            {"ptr", ProtoSchemaType::kUint64},
        },
    },
    {
        "kmalloc_node",
        6,
        {
            {},
            {"bytes_alloc", ProtoSchemaType::kUint64},
            {"bytes_req", ProtoSchemaType::kUint64},
            {"call_site", ProtoSchemaType::kUint64},
            {"gfp_flags", ProtoSchemaType::kUint32},
            {"node", ProtoSchemaType::kInt32},
            {"ptr", ProtoSchemaType::kUint64},
        },
    },
    {
        "kmem_cache_alloc",
        5,
        {
            {},
            {"bytes_alloc", ProtoSchemaType::kUint64},
            {"bytes_req", ProtoSchemaType::kUint64},
            {"call_site", ProtoSchemaType::kUint64},
            {"gfp_flags", ProtoSchemaType::kUint32},
            {"ptr", ProtoSchemaType::kUint64},
        },
    },
    {
        "kmem_cache_alloc_node",
        6,
        {
            {},
            {"bytes_alloc", ProtoSchemaType::kUint64},
            {"bytes_req", ProtoSchemaType::kUint64},
            {"call_site", ProtoSchemaType::kUint64},
            {"gfp_flags", ProtoSchemaType::kUint32},
            {"node", ProtoSchemaType::kInt32},
            {"ptr", ProtoSchemaType::kUint64},
        },
    },
    {
        "kmem_cache_free",
        2,
        {
            {},
            {"call_site", ProtoSchemaType::kUint64},
            {"ptr", ProtoSchemaType::kUint64},
        },
    },
    {
        "migrate_pages_end",
        1,
        {
            {},
            {"mode", ProtoSchemaType::kInt32},
        },
    },
    {
        "migrate_pages_start",
        1,
        {
            {},
            {"mode", ProtoSchemaType::kInt32},
        },
    },
    {
        "migrate_retry",
        1,
        {
            {},
            {"tries", ProtoSchemaType::kInt32},
        },
    },
    {
        "mm_page_alloc",
        5,
        {
            {},
            {"gfp_flags", ProtoSchemaType::kUint32},
            {"migratetype", ProtoSchemaType::kInt32},
            {"order", ProtoSchemaType::kUint32},
            {"page", ProtoSchemaType::kUint64},
            {"pfn", ProtoSchemaType::kUint64},
        },
    },
    {
        "mm_page_alloc_extfrag",
        7,
        {
            {},
            {"alloc_migratetype", ProtoSchemaType::kInt32},
            {"alloc_order", ProtoSchemaType::kInt32},
            {"fallback_migratetype", ProtoSchemaType::kInt32},
            {"fallback_order", ProtoSchemaType::kInt32},
            {"page", ProtoSchemaType::kUint64},
            {"change_ownership", ProtoSchemaType::kInt32},
            {"pfn", ProtoSchemaType::kUint64},
        },
    },
    {
        "mm_page_alloc_zone_locked",
        4,
        {
            {},
            {"migratetype", ProtoSchemaType::kInt32},
            {"order", ProtoSchemaType::kUint32},
            {"page", ProtoSchemaType::kUint64},
            {"pfn", ProtoSchemaType::kUint64},
        },
    },
    {
        "mm_page_free",
        3,
        {
            {},
            {"order", ProtoSchemaType::kUint32},
            {"page", ProtoSchemaType::kUint64},
            {"pfn", ProtoSchemaType::kUint64},
        },
    },
    {
        "mm_page_free_batched",
        3,
        {
            {},
            {"cold", ProtoSchemaType::kInt32},
            {"page", ProtoSchemaType::kUint64},
            {"pfn", ProtoSchemaType::kUint64},
        },
    },
    {
        "mm_page_pcpu_drain",
        4,
        {
            {},
            {"migratetype", ProtoSchemaType::kInt32},
            {"order", ProtoSchemaType::kUint32},
            {"page", ProtoSchemaType::kUint64},
            {"pfn", ProtoSchemaType::kUint64},
        },
    },
    {
        "rss_stat",
        4,
        {
            {},
            {"member", ProtoSchemaType::kInt32},
            {"size", ProtoSchemaType::kInt64},
            {"curr", ProtoSchemaType::kUint32},
            {"mm_id", ProtoSchemaType::kUint32},
        },
    },
    {
        "ion_heap_shrink",
        3,
        {
            {},
            {"heap_name", ProtoSchemaType::kString},
            {"len", ProtoSchemaType::kUint64},
            {"total_allocated", ProtoSchemaType::kInt64},
        },
    },
    {
        "ion_heap_grow",
        3,
        {
            {},
            {"heap_name", ProtoSchemaType::kString},
            {"len", ProtoSchemaType::kUint64},
            {"total_allocated", ProtoSchemaType::kInt64},
        },
    },
    {
        "fence_init",
        4,
        {
            {},
            {"context", ProtoSchemaType::kUint32},
            {"driver", ProtoSchemaType::kString},
            {"seqno", ProtoSchemaType::kUint32},
            {"timeline", ProtoSchemaType::kString},
        },
    },
    {
        "fence_destroy",
        4,
        {
            {},
            {"context", ProtoSchemaType::kUint32},
            {"driver", ProtoSchemaType::kString},
            {"seqno", ProtoSchemaType::kUint32},
            {"timeline", ProtoSchemaType::kString},
        },
    },
    {
        "fence_enable_signal",
        4,
        {
            {},
            {"context", ProtoSchemaType::kUint32},
            {"driver", ProtoSchemaType::kString},
            {"seqno", ProtoSchemaType::kUint32},
            {"timeline", ProtoSchemaType::kString},
        },
    },
    {
        "fence_signaled",
        4,
        {
            {},
            {"context", ProtoSchemaType::kUint32},
            {"driver", ProtoSchemaType::kString},
            {"seqno", ProtoSchemaType::kUint32},
            {"timeline", ProtoSchemaType::kString},
        },
    },
    {
        "clk_enable",
        1,
        {
            {},
            {"name", ProtoSchemaType::kString},
        },
    },
    {
        "clk_disable",
        1,
        {
            {},
            {"name", ProtoSchemaType::kString},
        },
    },
    {
        "clk_set_rate",
        2,
        {
            {},
            {"name", ProtoSchemaType::kString},
            {"rate", ProtoSchemaType::kUint64},
        },
    },
    {
        "binder_transaction_alloc_buf",
        4,
        {
            {},
            {"data_size", ProtoSchemaType::kUint64},
            {"debug_id", ProtoSchemaType::kInt32},
            {"offsets_size", ProtoSchemaType::kUint64},
            {"extra_buffers_size", ProtoSchemaType::kUint64},
        },
    },
    {
        "signal_deliver",
        3,
        {
            {},
            {"code", ProtoSchemaType::kInt32},
            {"sa_flags", ProtoSchemaType::kUint64},
            {"sig", ProtoSchemaType::kInt32},
        },
    },
    {
        "signal_generate",
        6,
        {
            {},
            {"code", ProtoSchemaType::kInt32},
            {"comm", ProtoSchemaType::kString},
            {"group", ProtoSchemaType::kInt32},
            {"pid", ProtoSchemaType::kInt32},
            {"result", ProtoSchemaType::kInt32},
            {"sig", ProtoSchemaType::kInt32},
        },
    },
    {
        "oom_score_adj_update",
        3,
        {
            {},
            {"comm", ProtoSchemaType::kString},
            {"oom_score_adj", ProtoSchemaType::kInt32},
            {"pid", ProtoSchemaType::kInt32},
        },
    },
    {
        "generic",
        2,
        {
            {},
            {"event_name", ProtoSchemaType::kString},
            {},
        },
    },
    {
        "mm_event_record",
        4,
        {
            {},
            {"avg_lat", ProtoSchemaType::kUint32},
            {"count", ProtoSchemaType::kUint32},
            {"max_lat", ProtoSchemaType::kUint32},
            {"type", ProtoSchemaType::kUint32},
        },
    },
    {
        "sys_enter",
        2,
        {
            {},
            {"id", ProtoSchemaType::kInt64},
            {"args", ProtoSchemaType::kUint64},
        },
    },
    {
        "sys_exit",
        2,
        {
            {},
            {"id", ProtoSchemaType::kInt64},
            {"ret", ProtoSchemaType::kInt64},
        },
    },
    {
        "zero",
        4,
        {
            {},
            {"flag", ProtoSchemaType::kInt32},
            {"name", ProtoSchemaType::kString},
            {"pid", ProtoSchemaType::kInt32},
            {"value", ProtoSchemaType::kInt64},
        },
    },
    {
        "gpu_frequency",
        2,
        {
            {},
            {"gpu_id", ProtoSchemaType::kUint32},
            {"state", ProtoSchemaType::kUint32},
        },
    },
    {
        "sde_tracing_mark_write",
        5,
        {
            {},
            {"pid", ProtoSchemaType::kInt32},
            {"trace_name", ProtoSchemaType::kString},
            {"trace_type", ProtoSchemaType::kUint32},
            {"value", ProtoSchemaType::kInt32},
            {"trace_begin", ProtoSchemaType::kUint32},
        },
    },
    {
        "mark_victim",
        1,
        {
            {},
            {"pid", ProtoSchemaType::kInt32},
        },
    },
    {
        "ion_stat",
        3,
        {
            {},
            {"buffer_id", ProtoSchemaType::kUint32},
            {"len", ProtoSchemaType::kInt64},
            {"total_allocated", ProtoSchemaType::kUint64},
        },
    },
    {
        "ion_buffer_create",
        2,
        {
            {},
            {"addr", ProtoSchemaType::kUint64},
            {"len", ProtoSchemaType::kUint64},
        },
    },
    {
        "ion_buffer_destroy",
        2,
        {
            {},
            {"addr", ProtoSchemaType::kUint64},
            {"len", ProtoSchemaType::kUint64},
        },
    },
    {
        "scm_call_start",
        3,
        {
            {},
            {"arginfo", ProtoSchemaType::kUint32},
            {"x0", ProtoSchemaType::kUint64},
            {"x5", ProtoSchemaType::kUint64},
        },
    },
    {
        "scm_call_end",
        0,
        {
            {},
        },
    },
    {
        "gpu_mem_total",
        3,
        {
            {},
            {"gpu_id", ProtoSchemaType::kUint32},
            {"pid", ProtoSchemaType::kUint32},
            {"size", ProtoSchemaType::kUint64},
        },
    },
    {
        "thermal_temperature",
        4,
        {
            {},
            {"id", ProtoSchemaType::kInt32},
            {"temp", ProtoSchemaType::kInt32},
            {"temp_prev", ProtoSchemaType::kInt32},
            {"thermal_zone", ProtoSchemaType::kString},
        },
    },
    {
        "cdev_update",
        2,
        {
            {},
            {"target", ProtoSchemaType::kUint64},
            {"type", ProtoSchemaType::kString},
        },
    },
    {
        "cpuhp_exit",
        4,
        {
            {},
            {"cpu", ProtoSchemaType::kUint32},
            {"idx", ProtoSchemaType::kInt32},
            {"ret", ProtoSchemaType::kInt32},
            {"state", ProtoSchemaType::kInt32},
        },
    },
    {
        "cpuhp_multi_enter",
        4,
        {
            {},
            {"cpu", ProtoSchemaType::kUint32},
            {"fun", ProtoSchemaType::kUint64},
            {"idx", ProtoSchemaType::kInt32},
            {"target", ProtoSchemaType::kInt32},
        },
    },
    {
        "cpuhp_enter",
        4,
        {
            {},
            {"cpu", ProtoSchemaType::kUint32},
            {"fun", ProtoSchemaType::kUint64},
            {"idx", ProtoSchemaType::kInt32},
            {"target", ProtoSchemaType::kInt32},
        },
    },
    {
        "cpuhp_latency",
        4,
        {
            {},
            {"cpu", ProtoSchemaType::kUint32},
            {"ret", ProtoSchemaType::kInt32},
            {"state", ProtoSchemaType::kUint32},
            {"time", ProtoSchemaType::kUint64},
        },
    },
    {
        "fastrpc_dma_stat",
        3,
        {
            {},
            {"cid", ProtoSchemaType::kInt32},
            {"len", ProtoSchemaType::kInt64},
            {"total_allocated", ProtoSchemaType::kUint64},
        },
    },
    {
        "dpu_tracing_mark_write",
        6,
        {
            {},
            {"pid", ProtoSchemaType::kInt32},
            {"trace_name", ProtoSchemaType::kString},
            {"trace_begin", ProtoSchemaType::kUint32},
            {"name", ProtoSchemaType::kString},
            {"type", ProtoSchemaType::kUint32},
            {"value", ProtoSchemaType::kInt32},
        },
    },
    {
        "g2d_tracing_mark_write",
        6,
        {
            {},
            {"pid", ProtoSchemaType::kInt32},
            {},
            {},
            {"name", ProtoSchemaType::kString},
            {"type", ProtoSchemaType::kUint32},
            {"value", ProtoSchemaType::kInt32},
        },
    },
    {
        "mali_tracing_mark_write",
        4,
        {
            {},
            {"name", ProtoSchemaType::kString},
            {"pid", ProtoSchemaType::kInt32},
            {"type", ProtoSchemaType::kUint32},
            {"value", ProtoSchemaType::kInt32},
        },
    },
    {
        "dma_heap_stat",
        3,
        {
            {},
            {"inode", ProtoSchemaType::kUint64},
            {"len", ProtoSchemaType::kInt64},
            {"total_allocated", ProtoSchemaType::kUint64},
        },
    },
    {
        "cpuhp_pause",
        4,
        {
            {},
            {"active_cpus", ProtoSchemaType::kUint32},
            {"cpus", ProtoSchemaType::kUint32},
            {"pause", ProtoSchemaType::kUint32},
            {"time", ProtoSchemaType::kUint32},
        },
    },
    {
        "sched_pi_setprio",
        4,
        {
            {},
            {"comm", ProtoSchemaType::kString},
            {"newprio", ProtoSchemaType::kInt32},
            {"oldprio", ProtoSchemaType::kInt32},
            {"pid", ProtoSchemaType::kInt32},
        },
    },
    {
        "sde_sde_evtlog",
        3,
        {
            {},
            {"evtlog_tag", ProtoSchemaType::kString},
            {"pid", ProtoSchemaType::kInt32},
            {"tag_id", ProtoSchemaType::kUint32},
        },
    },
    {
        "sde_sde_perf_calc_crtc",
        8,
        {
            {},
            {"bw_ctl_ebi", ProtoSchemaType::kUint64},
            {"bw_ctl_llcc", ProtoSchemaType::kUint64},
            {"bw_ctl_mnoc", ProtoSchemaType::kUint64},
            {"core_clk_rate", ProtoSchemaType::kUint32},
            {"crtc", ProtoSchemaType::kUint32},
            {"ib_ebi", ProtoSchemaType::kUint64},
            {"ib_llcc", ProtoSchemaType::kUint64},
            {"ib_mnoc", ProtoSchemaType::kUint64},
        },
    },
    {
        "sde_sde_perf_crtc_update",
        12,
        {
            {},
            {"bw_ctl_ebi", ProtoSchemaType::kUint64},
            {"bw_ctl_llcc", ProtoSchemaType::kUint64},
            {"bw_ctl_mnoc", ProtoSchemaType::kUint64},
            {"core_clk_rate", ProtoSchemaType::kUint32},
            {"crtc", ProtoSchemaType::kUint32},
            {"params", ProtoSchemaType::kInt32},
            {"per_pipe_ib_ebi", ProtoSchemaType::kUint64},
            {"per_pipe_ib_llcc", ProtoSchemaType::kUint64},
            {"per_pipe_ib_mnoc", ProtoSchemaType::kUint64},
            {"stop_req", ProtoSchemaType::kUint32},
            {"update_bus", ProtoSchemaType::kUint32},
            {"update_clk", ProtoSchemaType::kUint32},
        },
    },
    {
        "sde_sde_perf_set_qos_luts",
        6,
        {
            {},
            {"fl", ProtoSchemaType::kUint32},
            {"fmt", ProtoSchemaType::kUint32},
            {"lut", ProtoSchemaType::kUint64},
            {"lut_usage", ProtoSchemaType::kUint32},
            {"pnum", ProtoSchemaType::kUint32},
            {"rt", ProtoSchemaType::kUint32},
        },
    },
    {
        "sde_sde_perf_update_bus",
        4,
        {
            {},
            {"ab_quota", ProtoSchemaType::kUint64},
            {"bus_id", ProtoSchemaType::kUint32},
            {"client", ProtoSchemaType::kInt32},
            {"ib_quota", ProtoSchemaType::kUint64},
        },
    },
    {
        "rss_stat_throttled",
        4,
        {
            {},
            {"curr", ProtoSchemaType::kUint32},
            {"member", ProtoSchemaType::kInt32},
            {"mm_id", ProtoSchemaType::kUint32},
            {"size", ProtoSchemaType::kInt64},
        },
    },
    {
        "netif_receive_skb",
        3,
        {
            {},
            {"len", ProtoSchemaType::kUint32},
            {"name", ProtoSchemaType::kString},
            {"skbaddr", ProtoSchemaType::kUint64},
        },
    },
    {
        "net_dev_xmit",
        4,
        {
            {},
            {"len", ProtoSchemaType::kUint32},
            {"name", ProtoSchemaType::kString},
            {"rc", ProtoSchemaType::kInt32},
            {"skbaddr", ProtoSchemaType::kUint64},
        },
    },
    {
        "inet_sock_set_state",
        9,
        {
            {},
            {"daddr", ProtoSchemaType::kUint32},
            {"dport", ProtoSchemaType::kUint32},
            {"family", ProtoSchemaType::kUint32},
            {"newstate", ProtoSchemaType::kInt32},
            {"oldstate", ProtoSchemaType::kInt32},
            {"protocol", ProtoSchemaType::kUint32},
            {"saddr", ProtoSchemaType::kUint32},
            {"skaddr", ProtoSchemaType::kUint64},
            {"sport", ProtoSchemaType::kUint32},
        },
    },
    {
        "tcp_retransmit_skb",
        7,
        {
            {},
            {"daddr", ProtoSchemaType::kUint32},
            {"dport", ProtoSchemaType::kUint32},
            {"saddr", ProtoSchemaType::kUint32},
            {"skaddr", ProtoSchemaType::kUint64},
            {"skbaddr", ProtoSchemaType::kUint64},
            {"sport", ProtoSchemaType::kUint32},
            {"state", ProtoSchemaType::kInt32},
        },
    },
    {
        "cros_ec_sensorhub_data",
        6,
        {
            {},
            {"current_time", ProtoSchemaType::kInt64},
            {"current_timestamp", ProtoSchemaType::kInt64},
            {"delta", ProtoSchemaType::kInt64},
            {"ec_fifo_timestamp", ProtoSchemaType::kUint32},
            {"ec_sensor_num", ProtoSchemaType::kUint32},
            {"fifo_timestamp", ProtoSchemaType::kInt64},
        },
    },
    {
        "napi_gro_receive_entry",
        19,
        {
            {},
            {"data_len", ProtoSchemaType::kUint32},
            {"gso_size", ProtoSchemaType::kUint32},
            {"gso_type", ProtoSchemaType::kUint32},
            {"hash", ProtoSchemaType::kUint32},
            {"ip_summed", ProtoSchemaType::kUint32},
            {"l4_hash", ProtoSchemaType::kUint32},
            {"len", ProtoSchemaType::kUint32},
            {"mac_header", ProtoSchemaType::kInt32},
            {"mac_header_valid", ProtoSchemaType::kUint32},
            {"name", ProtoSchemaType::kString},
            {"napi_id", ProtoSchemaType::kUint32},
            {"nr_frags", ProtoSchemaType::kUint32},
            {"protocol", ProtoSchemaType::kUint32},
            {"queue_mapping", ProtoSchemaType::kUint32},
            {"skbaddr", ProtoSchemaType::kUint64},
            {"truesize", ProtoSchemaType::kUint32},
            {"vlan_proto", ProtoSchemaType::kUint32},
            {"vlan_tagged", ProtoSchemaType::kUint32},
            {"vlan_tci", ProtoSchemaType::kUint32},
        },
    },
    {
        "napi_gro_receive_exit",
        1,
        {
            {},
            {"ret", ProtoSchemaType::kInt32},
        },
    },
    {
        "kfree_skb",
        3,
        {
            {},
            {"location", ProtoSchemaType::kUint64},
            {"protocol", ProtoSchemaType::kUint32},
            {"skbaddr", ProtoSchemaType::kUint64},
        },
    },
    {
        "kvm_access_fault",
        1,
        {
            {},
            {"ipa", ProtoSchemaType::kUint64},
        },
    },
    {
        "kvm_ack_irq",
        2,
        {
            {},
            {"irqchip", ProtoSchemaType::kUint32},
            {"pin", ProtoSchemaType::kUint32},
        },
    },
    {
        "kvm_age_hva",
        2,
        {
            {},
            {"end", ProtoSchemaType::kUint64},
            {"start", ProtoSchemaType::kUint64},
        },
    },
    {
        "kvm_age_page",
        4,
        {
            {},
            {"gfn", ProtoSchemaType::kUint64},
            {"hva", ProtoSchemaType::kUint64},
            {"level", ProtoSchemaType::kUint32},
            {"referenced", ProtoSchemaType::kUint32},
        },
    },
    {
        "kvm_arm_clear_debug",
        1,
        {
            {},
            {"guest_debug", ProtoSchemaType::kUint32},
        },
    },
    {
        "kvm_arm_set_dreg32",
        2,
        {
            {},
            {"name", ProtoSchemaType::kString},
            {"value", ProtoSchemaType::kUint32},
        },
    },
    {
        "kvm_arm_set_regset",
        2,
        {
            {},
            {"len", ProtoSchemaType::kInt32},
            {"name", ProtoSchemaType::kString},
        },
    },
    {
        "kvm_arm_setup_debug",
        2,
        {
            {},
            {"guest_debug", ProtoSchemaType::kUint32},
            {"vcpu", ProtoSchemaType::kUint64},
        },
    },
    {
        "kvm_entry",
        1,
        {
            {},
            {"vcpu_pc", ProtoSchemaType::kUint64},
        },
    },
    {
        "kvm_exit",
        3,
        {
            {},
            {"esr_ec", ProtoSchemaType::kUint32},
            {"ret", ProtoSchemaType::kInt32},
            {"vcpu_pc", ProtoSchemaType::kUint64},
        },
    },
    {
        "kvm_fpu",
        1,
        {
            {},
            {"load", ProtoSchemaType::kUint32},
        },
    },
    {
        "kvm_get_timer_map",
        4,
        {
            {},
            {"direct_ptimer", ProtoSchemaType::kInt32},
            {"direct_vtimer", ProtoSchemaType::kInt32},
            {"emul_ptimer", ProtoSchemaType::kInt32},
            {"vcpu_id", ProtoSchemaType::kUint64},
        },
    },
    {
        "kvm_guest_fault",
        4,
        {
            {},
            {"hsr", ProtoSchemaType::kUint64},
            {"hxfar", ProtoSchemaType::kUint64},
            {"ipa", ProtoSchemaType::kUint64},
            {"vcpu_pc", ProtoSchemaType::kUint64},
        },
    },
    {
        "kvm_handle_sys_reg",
        1,
        {
            {},
            {"hsr", ProtoSchemaType::kUint64},
        },
    },
    {
        "kvm_hvc_arm64",
        3,
        {
            {},
            {"imm", ProtoSchemaType::kUint64},
            {"r0", ProtoSchemaType::kUint64},
            {"vcpu_pc", ProtoSchemaType::kUint64},
        },
    },
    {
        "kvm_irq_line",
        4,
        {
            {},
            {"irq_num", ProtoSchemaType::kInt32},
            {"level", ProtoSchemaType::kInt32},
            {"type", ProtoSchemaType::kUint32},
            {"vcpu_idx", ProtoSchemaType::kInt32},
        },
    },
    {
        "kvm_mmio",
        4,
        {
            {},
            {"gpa", ProtoSchemaType::kUint64},
            {"len", ProtoSchemaType::kUint32},
            {"type", ProtoSchemaType::kUint32},
            {"val", ProtoSchemaType::kUint64},
        },
    },
    {
        "kvm_mmio_emulate",
        3,
        {
            {},
            {"cpsr", ProtoSchemaType::kUint64},
            {"instr", ProtoSchemaType::kUint64},
            {"vcpu_pc", ProtoSchemaType::kUint64},
        },
    },
    {
        "kvm_set_guest_debug",
        2,
        {
            {},
            {"guest_debug", ProtoSchemaType::kUint32},
            {"vcpu", ProtoSchemaType::kUint64},
        },
    },
    {
        "kvm_set_irq",
        3,
        {
            {},
            {"gsi", ProtoSchemaType::kUint32},
            {"irq_source_id", ProtoSchemaType::kInt32},
            {"level", ProtoSchemaType::kInt32},
        },
    },
    {
        "kvm_set_spte_hva",
        1,
        {
            {},
            {"hva", ProtoSchemaType::kUint64},
        },
    },
    {
        "kvm_set_way_flush",
        2,
        {
            {},
            {"cache", ProtoSchemaType::kUint32},
            {"vcpu_pc", ProtoSchemaType::kUint64},
        },
    },
    {
        "kvm_sys_access",
        8,
        {
            {},
            {"CRm", ProtoSchemaType::kUint32},
            {"CRn", ProtoSchemaType::kUint32},
            {"Op0", ProtoSchemaType::kUint32},
            {"Op1", ProtoSchemaType::kUint32},
            {"Op2", ProtoSchemaType::kUint32},
            {"is_write", ProtoSchemaType::kUint32},
            {"name", ProtoSchemaType::kString},
            {"vcpu_pc", ProtoSchemaType::kUint64},
        },
    },
    {
        "kvm_test_age_hva",
        1,
        {
            {},
            {"hva", ProtoSchemaType::kUint64},
        },
    },
    {
        "kvm_timer_emulate",
        2,
        {
            {},
            {"should_fire", ProtoSchemaType::kUint32},
            {"timer_idx", ProtoSchemaType::kInt32},
        },
    },
    {
        "kvm_timer_hrtimer_expire",
        1,
        {
            {},
            {"timer_idx", ProtoSchemaType::kInt32},
        },
    },
    {
        "kvm_timer_restore_state",
        3,
        {
            {},
            {"ctl", ProtoSchemaType::kUint64},
            {"cval", ProtoSchemaType::kUint64},
            {"timer_idx", ProtoSchemaType::kInt32},
        },
    },
    {
        "kvm_timer_save_state",
        3,
        {
            {},
            {"ctl", ProtoSchemaType::kUint64},
            {"cval", ProtoSchemaType::kUint64},
            {"timer_idx", ProtoSchemaType::kInt32},
        },
    },
    {
        "kvm_timer_update_irq",
        3,
        {
            {},
            {"irq", ProtoSchemaType::kUint32},
            {"level", ProtoSchemaType::kInt32},
            {"vcpu_id", ProtoSchemaType::kUint64},
        },
    },
    {
        "kvm_toggle_cache",
        3,
        {
            {},
            {"now", ProtoSchemaType::kUint32},
            {"vcpu_pc", ProtoSchemaType::kUint64},
            {"was", ProtoSchemaType::kUint32},
        },
    },
    {
        "kvm_unmap_hva_range",
        2,
        {
            {},
            {"end", ProtoSchemaType::kUint64},
            {"start", ProtoSchemaType::kUint64},
        },
    },
    {
        "kvm_userspace_exit",
        1,
        {
            {},
            {"reason", ProtoSchemaType::kUint32},
        },
    },
    {
        "kvm_vcpu_wakeup",
        3,
        {
            {},
            {"ns", ProtoSchemaType::kUint64},
            {"valid", ProtoSchemaType::kUint32},
            {"waited", ProtoSchemaType::kUint32},
        },
    },
    {
        "kvm_wfx_arm64",
        2,
        {
            {},
            {"is_wfe", ProtoSchemaType::kUint32},
            {"vcpu_pc", ProtoSchemaType::kUint64},
        },
    },
    {
        "trap_reg",
        4,
        {
            {},
            {"fn", ProtoSchemaType::kString},
            {"is_write", ProtoSchemaType::kUint32},
            {"reg", ProtoSchemaType::kInt32},
            {"write_value", ProtoSchemaType::kUint64},
        },
    },
    {
        "vgic_update_irq_pending",
        3,
        {
            {},
            {"irq", ProtoSchemaType::kUint32},
            {"level", ProtoSchemaType::kUint32},
            {"vcpu_id", ProtoSchemaType::kUint64},
        },
    },
    {
        "wakeup_source_activate",
        2,
        {
            {},
            {"name", ProtoSchemaType::kString},
            {"state", ProtoSchemaType::kUint64},
        },
    },
    {
        "wakeup_source_deactivate",
        2,
        {
            {},
            {"name", ProtoSchemaType::kString},
            {"state", ProtoSchemaType::kUint64},
        },
    },
    {
        "ufshcd_command",
        10,
        {
            {},
            {"dev_name", ProtoSchemaType::kString},
            {"doorbell", ProtoSchemaType::kUint32},
            {"intr", ProtoSchemaType::kUint32},
            {"lba", ProtoSchemaType::kUint64},
            {"opcode", ProtoSchemaType::kUint32},
            {"str", ProtoSchemaType::kString},
            {"tag", ProtoSchemaType::kUint32},
            {"transfer_len", ProtoSchemaType::kInt32},
            {"group_id", ProtoSchemaType::kUint32},
            {"str_t", ProtoSchemaType::kUint32},
        },
    },
    {
        "ufshcd_clk_gating",
        2,
        {
            {},
            {"dev_name", ProtoSchemaType::kString},
            {"state", ProtoSchemaType::kInt32},
        },
    },
    {
        "console",
        1,
        {
            {},
            {"msg", ProtoSchemaType::kString},
        },
    },
    {
        "drm_vblank_event",
        4,
        {
            {},
            {"crtc", ProtoSchemaType::kInt32},
            {"high_prec", ProtoSchemaType::kUint32},
            {"seq", ProtoSchemaType::kUint32},
            {"time", ProtoSchemaType::kInt64},
        },
    },
    {
        "drm_vblank_event_delivered",
        3,
        {
            {},
            {"crtc", ProtoSchemaType::kInt32},
            {"file", ProtoSchemaType::kUint64},
            {"seq", ProtoSchemaType::kUint32},
        },
    },
    {
        "drm_sched_job",
        6,
        {
            {},
            {"entity", ProtoSchemaType::kUint64},
            {"fence", ProtoSchemaType::kUint64},
            {"hw_job_count", ProtoSchemaType::kInt32},
            {"id", ProtoSchemaType::kUint64},
            {"job_count", ProtoSchemaType::kUint32},
            {"name", ProtoSchemaType::kString},
        },
    },
    {
        "drm_run_job",
        6,
        {
            {},
            {"entity", ProtoSchemaType::kUint64},
            {"fence", ProtoSchemaType::kUint64},
            {"hw_job_count", ProtoSchemaType::kInt32},
            {"id", ProtoSchemaType::kUint64},
            {"job_count", ProtoSchemaType::kUint32},
            {"name", ProtoSchemaType::kString},
        },
    },
    {
        "drm_sched_process_job",
        1,
        {
            {},
            {"fence", ProtoSchemaType::kUint64},
        },
    },
    {
        "dma_fence_init",
        4,
        {
            {},
            {"context", ProtoSchemaType::kUint32},
            {"driver", ProtoSchemaType::kString},
            {"seqno", ProtoSchemaType::kUint32},
            {"timeline", ProtoSchemaType::kString},
        },
    },
    {
        "dma_fence_emit",
        4,
        {
            {},
            {"context", ProtoSchemaType::kUint32},
            {"driver", ProtoSchemaType::kString},
            {"seqno", ProtoSchemaType::kUint32},
            {"timeline", ProtoSchemaType::kString},
        },
    },
    {
        "dma_fence_signaled",
        4,
        {
            {},
            {"context", ProtoSchemaType::kUint32},
            {"driver", ProtoSchemaType::kString},
            {"seqno", ProtoSchemaType::kUint32},
            {"timeline", ProtoSchemaType::kString},
        },
    },
    {
        "dma_fence_wait_start",
        4,
        {
            {},
            {"context", ProtoSchemaType::kUint32},
            {"driver", ProtoSchemaType::kString},
            {"seqno", ProtoSchemaType::kUint32},
            {"timeline", ProtoSchemaType::kString},
        },
    },
    {
        "dma_fence_wait_end",
        4,
        {
            {},
            {"context", ProtoSchemaType::kUint32},
            {"driver", ProtoSchemaType::kString},
            {"seqno", ProtoSchemaType::kUint32},
            {"timeline", ProtoSchemaType::kString},
        },
    },
    {
        "f2fs_iostat",
        23,
        {
            {},
            {"app_bio", ProtoSchemaType::kUint64},
            {"app_brio", ProtoSchemaType::kUint64},
            {"app_dio", ProtoSchemaType::kUint64},
            {"app_drio", ProtoSchemaType::kUint64},
            {"app_mio", ProtoSchemaType::kUint64},
            {"app_mrio", ProtoSchemaType::kUint64},
            {"app_rio", ProtoSchemaType::kUint64},
            {"app_wio", ProtoSchemaType::kUint64},
            {"dev", ProtoSchemaType::kUint64},
            {"fs_cdrio", ProtoSchemaType::kUint64},
            {"fs_cp_dio", ProtoSchemaType::kUint64},
            {"fs_cp_mio", ProtoSchemaType::kUint64},
            {"fs_cp_nio", ProtoSchemaType::kUint64},
            {"fs_dio", ProtoSchemaType::kUint64},
            {"fs_discard", ProtoSchemaType::kUint64},
            {"fs_drio", ProtoSchemaType::kUint64},
            {"fs_gc_dio", ProtoSchemaType::kUint64},
            {"fs_gc_nio", ProtoSchemaType::kUint64},
            {"fs_gdrio", ProtoSchemaType::kUint64},
            {"fs_mio", ProtoSchemaType::kUint64},
            {"fs_mrio", ProtoSchemaType::kUint64},
            {"fs_nio", ProtoSchemaType::kUint64},
            {"fs_nrio", ProtoSchemaType::kUint64},
        },
    },
    {
        "f2fs_iostat_latency",
        28,
        {
            {},
            {"d_rd_avg", ProtoSchemaType::kUint32},
            {"d_rd_cnt", ProtoSchemaType::kUint32},
            {"d_rd_peak", ProtoSchemaType::kUint32},
            {"d_wr_as_avg", ProtoSchemaType::kUint32},
            {"d_wr_as_cnt", ProtoSchemaType::kUint32},
            {"d_wr_as_peak", ProtoSchemaType::kUint32},
            {"d_wr_s_avg", ProtoSchemaType::kUint32},
            {"d_wr_s_cnt", ProtoSchemaType::kUint32},
            {"d_wr_s_peak", ProtoSchemaType::kUint32},
            {"dev", ProtoSchemaType::kUint64},
            {"m_rd_avg", ProtoSchemaType::kUint32},
            {"m_rd_cnt", ProtoSchemaType::kUint32},
            {"m_rd_peak", ProtoSchemaType::kUint32},
            {"m_wr_as_avg", ProtoSchemaType::kUint32},
            {"m_wr_as_cnt", ProtoSchemaType::kUint32},
            {"m_wr_as_peak", ProtoSchemaType::kUint32},
            {"m_wr_s_avg", ProtoSchemaType::kUint32},
            {"m_wr_s_cnt", ProtoSchemaType::kUint32},
            {"m_wr_s_peak", ProtoSchemaType::kUint32},
            {"n_rd_avg", ProtoSchemaType::kUint32},
            {"n_rd_cnt", ProtoSchemaType::kUint32},
            {"n_rd_peak", ProtoSchemaType::kUint32},
            {"n_wr_as_avg", ProtoSchemaType::kUint32},
            {"n_wr_as_cnt", ProtoSchemaType::kUint32},
            {"n_wr_as_peak", ProtoSchemaType::kUint32},
            {"n_wr_s_avg", ProtoSchemaType::kUint32},
            {"n_wr_s_cnt", ProtoSchemaType::kUint32},
            {"n_wr_s_peak", ProtoSchemaType::kUint32},
        },
    },
    {
        "sched_cpu_util_cfs",
        15,
        {
            {},
            {"active", ProtoSchemaType::kInt32},
            {"capacity", ProtoSchemaType::kUint64},
            {"capacity_orig", ProtoSchemaType::kUint64},
            {"cpu", ProtoSchemaType::kUint32},
            {"cpu_importance", ProtoSchemaType::kUint64},
            {"cpu_util", ProtoSchemaType::kUint64},
            {"exit_lat", ProtoSchemaType::kUint32},
            {"group_capacity", ProtoSchemaType::kUint64},
            {"grp_overutilized", ProtoSchemaType::kUint32},
            {"idle_cpu", ProtoSchemaType::kUint32},
            {"nr_running", ProtoSchemaType::kUint32},
            {"spare_cap", ProtoSchemaType::kInt64},
            {"task_fits", ProtoSchemaType::kUint32},
            {"wake_group_util", ProtoSchemaType::kUint64},
            {"wake_util", ProtoSchemaType::kUint64},
        },
    },
    {
        "v4l2_qbuf",
        18,
        {
            {},
            {"bytesused", ProtoSchemaType::kUint32},
            {"field", ProtoSchemaType::kUint32},
            {"flags", ProtoSchemaType::kUint32},
            {"index", ProtoSchemaType::kUint32},
            {"minor", ProtoSchemaType::kInt32},
            {"sequence", ProtoSchemaType::kUint32},
            {"timecode_flags", ProtoSchemaType::kUint32},
            {"timecode_frames", ProtoSchemaType::kUint32},
            {"timecode_hours", ProtoSchemaType::kUint32},
            {"timecode_minutes", ProtoSchemaType::kUint32},
            {"timecode_seconds", ProtoSchemaType::kUint32},
            {"timecode_type", ProtoSchemaType::kUint32},
            {"timecode_userbits0", ProtoSchemaType::kUint32},
            {"timecode_userbits1", ProtoSchemaType::kUint32},
            {"timecode_userbits2", ProtoSchemaType::kUint32},
            {"timecode_userbits3", ProtoSchemaType::kUint32},
            {"timestamp", ProtoSchemaType::kInt64},
            {"type", ProtoSchemaType::kUint32},
        },
    },
    {
        "v4l2_dqbuf",
        18,
        {
            {},
            {"bytesused", ProtoSchemaType::kUint32},
            {"field", ProtoSchemaType::kUint32},
            {"flags", ProtoSchemaType::kUint32},
            {"index", ProtoSchemaType::kUint32},
            {"minor", ProtoSchemaType::kInt32},
            {"sequence", ProtoSchemaType::kUint32},
            {"timecode_flags", ProtoSchemaType::kUint32},
            {"timecode_frames", ProtoSchemaType::kUint32},
            {"timecode_hours", ProtoSchemaType::kUint32},
            {"timecode_minutes", ProtoSchemaType::kUint32},
            {"timecode_seconds", ProtoSchemaType::kUint32},
            {"timecode_type", ProtoSchemaType::kUint32},
            {"timecode_userbits0", ProtoSchemaType::kUint32},
            {"timecode_userbits1", ProtoSchemaType::kUint32},
            {"timecode_userbits2", ProtoSchemaType::kUint32},
            {"timecode_userbits3", ProtoSchemaType::kUint32},
            {"timestamp", ProtoSchemaType::kInt64},
            {"type", ProtoSchemaType::kUint32},
        },
    },
    {
        "vb2_v4l2_buf_queue",
        15,
        {
            {},
            {"field", ProtoSchemaType::kUint32},
            {"flags", ProtoSchemaType::kUint32},
            {"minor", ProtoSchemaType::kInt32},
            {"sequence", ProtoSchemaType::kUint32},
            {"timecode_flags", ProtoSchemaType::kUint32},
            {"timecode_frames", ProtoSchemaType::kUint32},
            {"timecode_hours", ProtoSchemaType::kUint32},
            {"timecode_minutes", ProtoSchemaType::kUint32},
            {"timecode_seconds", ProtoSchemaType::kUint32},
            {"timecode_type", ProtoSchemaType::kUint32},
            {"timecode_userbits0", ProtoSchemaType::kUint32},
            {"timecode_userbits1", ProtoSchemaType::kUint32},
            {"timecode_userbits2", ProtoSchemaType::kUint32},
            {"timecode_userbits3", ProtoSchemaType::kUint32},
            {"timestamp", ProtoSchemaType::kInt64},
        },
    },
    {
        "vb2_v4l2_buf_done",
        15,
        {
            {},
            {"field", ProtoSchemaType::kUint32},
            {"flags", ProtoSchemaType::kUint32},
            {"minor", ProtoSchemaType::kInt32},
            {"sequence", ProtoSchemaType::kUint32},
            {"timecode_flags", ProtoSchemaType::kUint32},
            {"timecode_frames", ProtoSchemaType::kUint32},
            {"timecode_hours", ProtoSchemaType::kUint32},
            {"timecode_minutes", ProtoSchemaType::kUint32},
            {"timecode_seconds", ProtoSchemaType::kUint32},
            {"timecode_type", ProtoSchemaType::kUint32},
            {"timecode_userbits0", ProtoSchemaType::kUint32},
            {"timecode_userbits1", ProtoSchemaType::kUint32},
            {"timecode_userbits2", ProtoSchemaType::kUint32},
            {"timecode_userbits3", ProtoSchemaType::kUint32},
            {"timestamp", ProtoSchemaType::kInt64},
        },
    },
    {
        "vb2_v4l2_qbuf",
        15,
        {
            {},
            {"field", ProtoSchemaType::kUint32},
            {"flags", ProtoSchemaType::kUint32},
            {"minor", ProtoSchemaType::kInt32},
            {"sequence", ProtoSchemaType::kUint32},
            {"timecode_flags", ProtoSchemaType::kUint32},
            {"timecode_frames", ProtoSchemaType::kUint32},
            {"timecode_hours", ProtoSchemaType::kUint32},
            {"timecode_minutes", ProtoSchemaType::kUint32},
            {"timecode_seconds", ProtoSchemaType::kUint32},
            {"timecode_type", ProtoSchemaType::kUint32},
            {"timecode_userbits0", ProtoSchemaType::kUint32},
            {"timecode_userbits1", ProtoSchemaType::kUint32},
            {"timecode_userbits2", ProtoSchemaType::kUint32},
            {"timecode_userbits3", ProtoSchemaType::kUint32},
            {"timestamp", ProtoSchemaType::kInt64},
        },
    },
    {
        "vb2_v4l2_dqbuf",
        15,
        {
            {},
            {"field", ProtoSchemaType::kUint32},
            {"flags", ProtoSchemaType::kUint32},
            {"minor", ProtoSchemaType::kInt32},
            {"sequence", ProtoSchemaType::kUint32},
            {"timecode_flags", ProtoSchemaType::kUint32},
            {"timecode_frames", ProtoSchemaType::kUint32},
            {"timecode_hours", ProtoSchemaType::kUint32},
            {"timecode_minutes", ProtoSchemaType::kUint32},
            {"timecode_seconds", ProtoSchemaType::kUint32},
            {"timecode_type", ProtoSchemaType::kUint32},
            {"timecode_userbits0", ProtoSchemaType::kUint32},
            {"timecode_userbits1", ProtoSchemaType::kUint32},
            {"timecode_userbits2", ProtoSchemaType::kUint32},
            {"timecode_userbits3", ProtoSchemaType::kUint32},
            {"timestamp", ProtoSchemaType::kInt64},
        },
    },
    {
        "dsi_cmd_fifo_status",
        2,
        {
            {},
            {"header", ProtoSchemaType::kUint32},
            {"payload", ProtoSchemaType::kUint32},
        },
    },
    {
        "dsi_rx",
        2,
        {
            {},
            {"cmd", ProtoSchemaType::kUint32},
            {"rx_buf", ProtoSchemaType::kUint32},
        },
    },
    {
        "dsi_tx",
        3,
        {
            {},
            {"last", ProtoSchemaType::kUint32},
            {"tx_buf", ProtoSchemaType::kUint32},
            {"type", ProtoSchemaType::kUint32},
        },
    },
    {
        "android_fs_dataread_end",
        3,
        {
            {},
            {"bytes", ProtoSchemaType::kInt32},
            {"ino", ProtoSchemaType::kUint64},
            {"offset", ProtoSchemaType::kInt64},
        },
    },
    {
        "android_fs_dataread_start",
        7,
        {
            {},
            {"bytes", ProtoSchemaType::kInt32},
            {"cmdline", ProtoSchemaType::kString},
            {"i_size", ProtoSchemaType::kInt64},
            {"ino", ProtoSchemaType::kUint64},
            {"offset", ProtoSchemaType::kInt64},
            {"pathbuf", ProtoSchemaType::kString},
            {"pid", ProtoSchemaType::kInt32},
        },
    },
    {
        "android_fs_datawrite_end",
        3,
        {
            {},
            {"bytes", ProtoSchemaType::kInt32},
            {"ino", ProtoSchemaType::kUint64},
            {"offset", ProtoSchemaType::kInt64},
        },
    },
    {
        "android_fs_datawrite_start",
        7,
        {
            {},
            {"bytes", ProtoSchemaType::kInt32},
            {"cmdline", ProtoSchemaType::kString},
            {"i_size", ProtoSchemaType::kInt64},
            {"ino", ProtoSchemaType::kUint64},
            {"offset", ProtoSchemaType::kInt64},
            {"pathbuf", ProtoSchemaType::kString},
            {"pid", ProtoSchemaType::kInt32},
        },
    },
    {
        "android_fs_fsync_end",
        3,
        {
            {},
            {"bytes", ProtoSchemaType::kInt32},
            {"ino", ProtoSchemaType::kUint64},
            {"offset", ProtoSchemaType::kInt64},
        },
    },
    {
        "android_fs_fsync_start",
        5,
        {
            {},
            {"cmdline", ProtoSchemaType::kString},
            {"i_size", ProtoSchemaType::kInt64},
            {"ino", ProtoSchemaType::kUint64},
            {"pathbuf", ProtoSchemaType::kString},
            {"pid", ProtoSchemaType::kInt32},
        },
    },
    {
        "funcgraph_entry",
        2,
        {
            {},
            {"depth", ProtoSchemaType::kInt32},
            {"func", ProtoSchemaType::kUint64},
        },
    },
    {
        "funcgraph_exit",
        5,
        {
            {},
            {"calltime", ProtoSchemaType::kUint64},
            {"depth", ProtoSchemaType::kInt32},
            {"func", ProtoSchemaType::kUint64},
            {"overrun", ProtoSchemaType::kUint64},
            {"rettime", ProtoSchemaType::kUint64},
        },
    },
    {
        "virtio_video_cmd",
        2,
        {
            {},
            {"stream_id", ProtoSchemaType::kUint32},
            {"type", ProtoSchemaType::kUint32},
        },
    },
    {
        "virtio_video_cmd_done",
        2,
        {
            {},
            {"stream_id", ProtoSchemaType::kUint32},
            {"type", ProtoSchemaType::kUint32},
        },
    },
    {
        "virtio_video_resource_queue",
        8,
        {
            {},
            {"data_size0", ProtoSchemaType::kUint32},
            {"data_size1", ProtoSchemaType::kUint32},
            {"data_size2", ProtoSchemaType::kUint32},
            {"data_size3", ProtoSchemaType::kUint32},
            {"queue_type", ProtoSchemaType::kUint32},
            {"resource_id", ProtoSchemaType::kInt32},
            {"stream_id", ProtoSchemaType::kInt32},
            {"timestamp", ProtoSchemaType::kUint64},
        },
    },
    {
        "virtio_video_resource_queue_done",
        8,
        {
            {},
            {"data_size0", ProtoSchemaType::kUint32},
            {"data_size1", ProtoSchemaType::kUint32},
            {"data_size2", ProtoSchemaType::kUint32},
            {"data_size3", ProtoSchemaType::kUint32},
            {"queue_type", ProtoSchemaType::kUint32},
            {"resource_id", ProtoSchemaType::kInt32},
            {"stream_id", ProtoSchemaType::kInt32},
            {"timestamp", ProtoSchemaType::kUint64},
        },
    },
    {
        "mm_shrink_slab_start",
        11,
        {
            {},
            {"cache_items", ProtoSchemaType::kUint64},
            {"delta", ProtoSchemaType::kUint64},
            {"gfp_flags", ProtoSchemaType::kUint32},
            {"lru_pgs", ProtoSchemaType::kUint64},
            {"nr_objects_to_shrink", ProtoSchemaType::kInt64},
            {"pgs_scanned", ProtoSchemaType::kUint64},
            {"shr", ProtoSchemaType::kUint64},
            {"shrink", ProtoSchemaType::kUint64},
            {"total_scan", ProtoSchemaType::kUint64},
            {"nid", ProtoSchemaType::kInt32},
            {"priority", ProtoSchemaType::kInt32},
        },
    },
    {
        "mm_shrink_slab_end",
        7,
        {
            {},
            {"new_scan", ProtoSchemaType::kInt64},
            {"retval", ProtoSchemaType::kInt32},
            {"shr", ProtoSchemaType::kUint64},
            {"shrink", ProtoSchemaType::kUint64},
            {"total_scan", ProtoSchemaType::kInt64},
            {"unused_scan", ProtoSchemaType::kInt64},
            {"nid", ProtoSchemaType::kInt32},
        },
    },
    {
        "trusty_smc",
        4,
        {
            {},
            {"r0", ProtoSchemaType::kUint64},
            {"r1", ProtoSchemaType::kUint64},
            {"r2", ProtoSchemaType::kUint64},
            {"r3", ProtoSchemaType::kUint64},
        },
    },
    {
        "trusty_smc_done",
        1,
        {
            {},
            {"ret", ProtoSchemaType::kUint64},
        },
    },
    {
        "trusty_std_call32",
        4,
        {
            {},
            {"r0", ProtoSchemaType::kUint64},
            {"r1", ProtoSchemaType::kUint64},
            {"r2", ProtoSchemaType::kUint64},
            {"r3", ProtoSchemaType::kUint64},
        },
    },
    {
        "trusty_std_call32_done",
        1,
        {
            {},
            {"ret", ProtoSchemaType::kInt64},
        },
    },
    {
        "trusty_share_memory",
        3,
        {
            {},
            {"len", ProtoSchemaType::kUint64},
            {"lend", ProtoSchemaType::kUint32},
            {"nents", ProtoSchemaType::kUint32},
        },
    },
    {
        "trusty_share_memory_done",
        5,
        {
            {},
            {"handle", ProtoSchemaType::kUint64},
            {"len", ProtoSchemaType::kUint64},
            {"lend", ProtoSchemaType::kUint32},
            {"nents", ProtoSchemaType::kUint32},
            {"ret", ProtoSchemaType::kInt32},
        },
    },
    {
        "trusty_reclaim_memory",
        1,
        {
            {},
            {"id", ProtoSchemaType::kUint64},
        },
    },
    {
        "trusty_reclaim_memory_done",
        2,
        {
            {},
            {"id", ProtoSchemaType::kUint64},
            {"ret", ProtoSchemaType::kInt32},
        },
    },
    {
        "trusty_irq",
        1,
        {
            {},
            {"irq", ProtoSchemaType::kInt32},
        },
    },
    {
        "trusty_ipc_handle_event",
        3,
        {
            {},
            {"chan", ProtoSchemaType::kUint32},
            {"event_id", ProtoSchemaType::kUint32},
            {"srv_name", ProtoSchemaType::kString},
        },
    },
    {
        "trusty_ipc_connect",
        3,
        {
            {},
            {"chan", ProtoSchemaType::kUint32},
            {"port", ProtoSchemaType::kString},
            {"state", ProtoSchemaType::kInt32},
        },
    },
    {
        "trusty_ipc_connect_end",
        3,
        {
            {},
            {"chan", ProtoSchemaType::kUint32},
            {"err", ProtoSchemaType::kInt32},
            {"state", ProtoSchemaType::kInt32},
        },
    },
    {
        "trusty_ipc_write",
        6,
        {
            {},
            {"buf_id", ProtoSchemaType::kUint64},
            {"chan", ProtoSchemaType::kUint32},
            {"kind_shm", ProtoSchemaType::kInt32},
            {"len_or_err", ProtoSchemaType::kInt32},
            {"shm_cnt", ProtoSchemaType::kUint64},
            {"srv_name", ProtoSchemaType::kString},
        },
    },
    {
        "trusty_ipc_poll",
        3,
        {
            {},
            {"chan", ProtoSchemaType::kUint32},
            {"poll_mask", ProtoSchemaType::kUint32},
            {"srv_name", ProtoSchemaType::kString},
        },
    },
    {nullptr, 0, {}},
    {
        "trusty_ipc_read",
        2,
        {
            {},
            {"chan", ProtoSchemaType::kUint32},
            {"srv_name", ProtoSchemaType::kString},
        },
    },
    {
        "trusty_ipc_read_end",
        5,
        {
            {},
            {"buf_id", ProtoSchemaType::kUint64},
            {"chan", ProtoSchemaType::kUint32},
            {"len_or_err", ProtoSchemaType::kInt32},
            {"shm_cnt", ProtoSchemaType::kUint64},
            {"srv_name", ProtoSchemaType::kString},
        },
    },
    {
        "trusty_ipc_rx",
        3,
        {
            {},
            {"buf_id", ProtoSchemaType::kUint64},
            {"chan", ProtoSchemaType::kUint32},
            {"srv_name", ProtoSchemaType::kString},
        },
    },
    {nullptr, 0, {}},
    {
        "trusty_enqueue_nop",
        3,
        {
            {},
            {"arg1", ProtoSchemaType::kUint32},
            {"arg2", ProtoSchemaType::kUint32},
            {"arg3", ProtoSchemaType::kUint32},
        },
    },
    {
        "cma_alloc_start",
        3,
        {
            {},
            {"align", ProtoSchemaType::kUint32},
            {"count", ProtoSchemaType::kUint32},
            {"name", ProtoSchemaType::kString},
        },
    },
    {
        "cma_alloc_info",
        10,
        {
            {},
            {"align", ProtoSchemaType::kUint32},
            {"count", ProtoSchemaType::kUint32},
            {"err_iso", ProtoSchemaType::kUint32},
            {"err_mig", ProtoSchemaType::kUint32},
            {"err_test", ProtoSchemaType::kUint32},
            {"name", ProtoSchemaType::kString},
            {"nr_mapped", ProtoSchemaType::kUint64},
            {"nr_migrated", ProtoSchemaType::kUint64},
            {"nr_reclaimed", ProtoSchemaType::kUint64},
            {"pfn", ProtoSchemaType::kUint64},
        },
    },
    {
        "lwis_tracing_mark_write",
        5,
        {
            {},
            {"lwis_name", ProtoSchemaType::kString},
            {"type", ProtoSchemaType::kUint32},
            {"pid", ProtoSchemaType::kInt32},
            {"func_name", ProtoSchemaType::kString},
            {"value", ProtoSchemaType::kInt64},
        },
    },
    {
        "virtio_gpu_cmd_queue",
        9,
        {
            {},
            {"ctx_id", ProtoSchemaType::kUint32},
            {"dev", ProtoSchemaType::kInt32},
            {"fence_id", ProtoSchemaType::kUint64},
            {"flags", ProtoSchemaType::kUint32},
            {"name", ProtoSchemaType::kString},
            {"num_free", ProtoSchemaType::kUint32},
            {"seqno", ProtoSchemaType::kUint32},
            {"type", ProtoSchemaType::kUint32},
            {"vq", ProtoSchemaType::kUint32},
        },
    },
    {
        "virtio_gpu_cmd_response",
        9,
        {
            {},
            {"ctx_id", ProtoSchemaType::kUint32},
            {"dev", ProtoSchemaType::kInt32},
            {"fence_id", ProtoSchemaType::kUint64},
            {"flags", ProtoSchemaType::kUint32},
            {"name", ProtoSchemaType::kString},
            {"num_free", ProtoSchemaType::kUint32},
            {"seqno", ProtoSchemaType::kUint32},
            {"type", ProtoSchemaType::kUint32},
            {"vq", ProtoSchemaType::kUint32},
        },
    },
    {
        "mali_mali_KCPU_CQS_SET",
        5,
        {
            {},
            {"id", ProtoSchemaType::kUint32},
            {"info_val1", ProtoSchemaType::kUint64},
            {"info_val2", ProtoSchemaType::kUint64},
            {"kctx_id", ProtoSchemaType::kUint32},
            {"kctx_tgid", ProtoSchemaType::kInt32},
        },
    },
    {
        "mali_mali_KCPU_CQS_WAIT_START",
        5,
        {
            {},
            {"id", ProtoSchemaType::kUint32},
            {"info_val1", ProtoSchemaType::kUint64},
            {"info_val2", ProtoSchemaType::kUint64},
            {"kctx_id", ProtoSchemaType::kUint32},
            {"kctx_tgid", ProtoSchemaType::kInt32},
        },
    },
    {
        "mali_mali_KCPU_CQS_WAIT_END",
        5,
        {
            {},
            {"id", ProtoSchemaType::kUint32},
            {"info_val1", ProtoSchemaType::kUint64},
            {"info_val2", ProtoSchemaType::kUint64},
            {"kctx_id", ProtoSchemaType::kUint32},
            {"kctx_tgid", ProtoSchemaType::kInt32},
        },
    },
    {
        "mali_mali_KCPU_FENCE_SIGNAL",
        5,
        {
            {},
            {"info_val1", ProtoSchemaType::kUint64},
            {"info_val2", ProtoSchemaType::kUint64},
            {"kctx_tgid", ProtoSchemaType::kInt32},
            {"kctx_id", ProtoSchemaType::kUint32},
            {"id", ProtoSchemaType::kUint32},
        },
    },
    {
        "mali_mali_KCPU_FENCE_WAIT_START",
        5,
        {
            {},
            {"info_val1", ProtoSchemaType::kUint64},
            {"info_val2", ProtoSchemaType::kUint64},
            {"kctx_tgid", ProtoSchemaType::kInt32},
            {"kctx_id", ProtoSchemaType::kUint32},
            {"id", ProtoSchemaType::kUint32},
        },
    },
    {
        "mali_mali_KCPU_FENCE_WAIT_END",
        5,
        {
            {},
            {"info_val1", ProtoSchemaType::kUint64},
            {"info_val2", ProtoSchemaType::kUint64},
            {"kctx_tgid", ProtoSchemaType::kInt32},
            {"kctx_id", ProtoSchemaType::kUint32},
            {"id", ProtoSchemaType::kUint32},
        },
    },
    {
        "hyp_enter",
        0,
        {
            {},
        },
    },
    {
        "hyp_exit",
        0,
        {
            {},
        },
    },
    {
        "host_hcall",
        2,
        {
            {},
            {"id", ProtoSchemaType::kUint32},
            {"invalid", ProtoSchemaType::kUint32},
        },
    },
    {
        "host_smc",
        2,
        {
            {},
            {"id", ProtoSchemaType::kUint64},
            {"forwarded", ProtoSchemaType::kUint32},
        },
    },
    {
        "host_mem_abort",
        2,
        {
            {},
            {"esr", ProtoSchemaType::kUint64},
            {"addr", ProtoSchemaType::kUint64},
        },
    },
    {
        "suspend_resume_minimal",
        1,
        {
            {},
            {"start", ProtoSchemaType::kUint32},
        },
    },
    {
        "mali_mali_CSF_INTERRUPT_START",
        3,
        {
            {},
            {"kctx_tgid", ProtoSchemaType::kInt32},
            {"kctx_id", ProtoSchemaType::kUint32},
            {"info_val", ProtoSchemaType::kUint64},
        },
    },
    {
        "mali_mali_CSF_INTERRUPT_END",
        3,
        {
            {},
            {"kctx_tgid", ProtoSchemaType::kInt32},
            {"kctx_id", ProtoSchemaType::kUint32},
            {"info_val", ProtoSchemaType::kUint64},
        },
    },
    {
        "samsung_tracing_mark_write",
        5,
        {
            {},
            {"pid", ProtoSchemaType::kInt32},
            {"trace_name", ProtoSchemaType::kString},
            {"trace_begin", ProtoSchemaType::kUint32},
            {"trace_type", ProtoSchemaType::kUint32},
            {"value", ProtoSchemaType::kInt32},
        },
    },
    {
        "binder_command",
        1,
        {
            {},
            {"cmd", ProtoSchemaType::kUint32},
        },
    },
    {
        "binder_return",
        1,
        {
            {},
            {"cmd", ProtoSchemaType::kUint32},
        },
    },
    {
        "sched_switch_with_ctrs",
        23,
        {
            {},
            {"old_pid", ProtoSchemaType::kInt32},
            {"new_pid", ProtoSchemaType::kInt32},
            {"cctr", ProtoSchemaType::kUint64},
            {"ctr0", ProtoSchemaType::kUint64},
            {"ctr1", ProtoSchemaType::kUint64},
            {"ctr2", ProtoSchemaType::kUint64},
            {"ctr3", ProtoSchemaType::kUint64},
            {"lctr0", ProtoSchemaType::kUint32},
            {"lctr1", ProtoSchemaType::kUint32},
            {"ctr4", ProtoSchemaType::kUint64},
            {"ctr5", ProtoSchemaType::kUint64},
            {"prev_comm", ProtoSchemaType::kString},
            {"prev_pid", ProtoSchemaType::kInt32},
            {"cyc", ProtoSchemaType::kUint32},
            {"inst", ProtoSchemaType::kUint32},
            {"stallbm", ProtoSchemaType::kUint32},
            {"l3dm", ProtoSchemaType::kUint32},
            {"next_pid", ProtoSchemaType::kInt32},
            {"next_comm", ProtoSchemaType::kString},
            {"prev_state", ProtoSchemaType::kInt64},
            {"amu0", ProtoSchemaType::kUint64},
            {"amu1", ProtoSchemaType::kUint64},
            {"amu2", ProtoSchemaType::kUint64},
        },
    },
    {
        "gpu_work_period",
        5,
        {
            {},
            {"gpu_id", ProtoSchemaType::kUint32},
            {"uid", ProtoSchemaType::kUint32},
            {"start_time_ns", ProtoSchemaType::kUint64},
            {"end_time_ns", ProtoSchemaType::kUint64},
            {"total_active_duration_ns", ProtoSchemaType::kUint64},
        },
    },
    {
        "rpm_status",
        2,
        {
            {},
            {"name", ProtoSchemaType::kString},
            {"status", ProtoSchemaType::kInt32},
        },
    },
    {
        "panel_write_generic",
        6,
        {
            {},
            {"pid", ProtoSchemaType::kInt32},
            {"trace_name", ProtoSchemaType::kString},
            {"trace_begin", ProtoSchemaType::kUint32},
            {"name", ProtoSchemaType::kString},
            {"type", ProtoSchemaType::kUint32},
            {"value", ProtoSchemaType::kInt32},
        },
    },
    {
        "sched_migrate_task",
        7,
        {
            {},
            {"comm", ProtoSchemaType::kString},
            {"pid", ProtoSchemaType::kInt32},
            {"prio", ProtoSchemaType::kInt32},
            {"orig_cpu", ProtoSchemaType::kInt32},
            {"dest_cpu", ProtoSchemaType::kInt32},
            {"running", ProtoSchemaType::kInt32},
            {"load", ProtoSchemaType::kUint32},
        },
    },
    {
        "dpu_dsi_cmd_fifo_status",
        2,
        {
            {},
            {"header", ProtoSchemaType::kUint32},
            {"payload", ProtoSchemaType::kUint32},
        },
    },
    {
        "dpu_dsi_rx",
        2,
        {
            {},
            {"cmd", ProtoSchemaType::kUint32},
            {"rx_buf", ProtoSchemaType::kUint32},
        },
    },
    {
        "dpu_dsi_tx",
        4,
        {
            {},
            {"type", ProtoSchemaType::kUint32},
            {"tx_buf", ProtoSchemaType::kUint32},
            {"last", ProtoSchemaType::kUint32},
            {"delay_ms", ProtoSchemaType::kUint32},
        },
    },
    {
        "f2fs_background_gc",
        4,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"wait_ms", ProtoSchemaType::kUint32},
            {"prefree", ProtoSchemaType::kUint32},
            {"free", ProtoSchemaType::kUint32},
        },
    },
    {
        "f2fs_gc_begin",
        13,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"sync", ProtoSchemaType::kUint32},
            {"background", ProtoSchemaType::kUint32},
            {"dirty_nodes", ProtoSchemaType::kInt64},
            {"dirty_dents", ProtoSchemaType::kInt64},
            {"dirty_imeta", ProtoSchemaType::kInt64},
            {"free_sec", ProtoSchemaType::kUint32},
            {"free_seg", ProtoSchemaType::kUint32},
            {"reserved_seg", ProtoSchemaType::kInt32},
            {"prefree_seg", ProtoSchemaType::kUint32},
            {"gc_type", ProtoSchemaType::kInt32},
            {"no_bg_gc", ProtoSchemaType::kUint32},
            {"nr_free_secs", ProtoSchemaType::kUint32},
        },
    },
    {
        "f2fs_gc_end",
        11,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"ret", ProtoSchemaType::kInt32},
            {"seg_freed", ProtoSchemaType::kInt32},
            {"sec_freed", ProtoSchemaType::kInt32},
            {"dirty_nodes", ProtoSchemaType::kInt64},
            {"dirty_dents", ProtoSchemaType::kInt64},
            {"dirty_imeta", ProtoSchemaType::kInt64},
            {"free_sec", ProtoSchemaType::kUint32},
            {"free_seg", ProtoSchemaType::kUint32},
            {"reserved_seg", ProtoSchemaType::kInt32},
            {"prefree_seg", ProtoSchemaType::kUint32},
        },
    },
    {
        "fastrpc_dma_free",
        3,
        {
            {},
            {"cid", ProtoSchemaType::kInt32},
            {"phys", ProtoSchemaType::kUint64},
            {"size", ProtoSchemaType::kUint64},
        },
    },
    {
        "fastrpc_dma_alloc",
        5,
        {
            {},
            {"cid", ProtoSchemaType::kInt32},
            {"phys", ProtoSchemaType::kUint64},
            {"size", ProtoSchemaType::kUint64},
            {"attr", ProtoSchemaType::kUint64},
            {"mflags", ProtoSchemaType::kInt32},
        },
    },
    {
        "fastrpc_dma_unmap",
        3,
        {
            {},
            {"cid", ProtoSchemaType::kInt32},
            {"phys", ProtoSchemaType::kUint64},
            {"size", ProtoSchemaType::kUint64},
        },
    },
    {
        "fastrpc_dma_map",
        7,
        {
            {},
            {"cid", ProtoSchemaType::kInt32},
            {"fd", ProtoSchemaType::kInt32},
            {"phys", ProtoSchemaType::kUint64},
            {"size", ProtoSchemaType::kUint64},
            {"len", ProtoSchemaType::kUint64},
            {"attr", ProtoSchemaType::kUint32},
            {"mflags", ProtoSchemaType::kInt32},
        },
    },
    {
        "google_icc_event",
        2,
        {
            {},
            {"event", ProtoSchemaType::kString},
            {"timestamp", ProtoSchemaType::kUint64},
        },
    },
    {
        "google_irm_event",
        2,
        {
            {},
            {"event", ProtoSchemaType::kString},
            {"timestamp", ProtoSchemaType::kUint64},
        },
    },
    {
        "device_pm_callback_start",
        5,
        {
            {},
            {"device", ProtoSchemaType::kString},
            {"driver", ProtoSchemaType::kString},
            {"parent", ProtoSchemaType::kString},
            {"pm_ops", ProtoSchemaType::kString},
            {"event", ProtoSchemaType::kInt32},
        },
    },
    {
        "device_pm_callback_end",
        3,
        {
            {},
            {"device", ProtoSchemaType::kString},
            {"driver", ProtoSchemaType::kString},
            {"error", ProtoSchemaType::kInt32},
        },
    },
    {
        "thermal_exynos_acpm_bulk",
        11,
        {
            {},
            {"tz_id", ProtoSchemaType::kUint32},
            {"current_temp", ProtoSchemaType::kUint32},
            {"ctrl_temp", ProtoSchemaType::kUint32},
            {"cdev_state", ProtoSchemaType::kUint32},
            {"pid_et_p", ProtoSchemaType::kInt32},
            {"pid_power_range", ProtoSchemaType::kInt32},
            {"pid_p", ProtoSchemaType::kInt32},
            {"pid_i", ProtoSchemaType::kInt32},
            {"k_p", ProtoSchemaType::kInt32},
            {"k_i", ProtoSchemaType::kInt32},
            {"timestamp", ProtoSchemaType::kUint64},
        },
    },
    {
        "thermal_exynos_acpm_high_overhead",
        7,
        {
            {},
            {"tz_id", ProtoSchemaType::kInt32},
            {"current_temp", ProtoSchemaType::kUint32},
            {"ctrl_temp", ProtoSchemaType::kUint32},
            {"cdev_state", ProtoSchemaType::kUint32},
            {"pid_et_p", ProtoSchemaType::kInt32},
            {"k_p", ProtoSchemaType::kInt32},
            {"k_i", ProtoSchemaType::kInt32},
        },
    },
    {
        "dcvsh_freq",
        2,
        {
            {},
            {"cpu", ProtoSchemaType::kUint64},
            {"freq", ProtoSchemaType::kUint64},
        },
    },
    {
        "kgsl_gpu_frequency",
        2,
        {
            {},
            {"gpu_freq", ProtoSchemaType::kUint32},
            {"gpu_id", ProtoSchemaType::kUint32},
        },
    },
    {
        "mali_mali_PM_MCU_HCTL_CORES_DOWN_SCALE_NOTIFY_PEND",
        3,
        {
            {},
            {"kctx_tgid", ProtoSchemaType::kInt32},
            {"kctx_id", ProtoSchemaType::kUint32},
            {"info_val", ProtoSchemaType::kUint64},
        },
    },
    {
        "mali_mali_PM_MCU_HCTL_CORES_NOTIFY_PEND",
        3,
        {
            {},
            {"kctx_tgid", ProtoSchemaType::kInt32},
            {"kctx_id", ProtoSchemaType::kUint32},
            {"info_val", ProtoSchemaType::kUint64},
        },
    },
    {
        "mali_mali_PM_MCU_HCTL_CORE_INACTIVE_PEND",
        3,
        {
            {},
            {"kctx_tgid", ProtoSchemaType::kInt32},
            {"kctx_id", ProtoSchemaType::kUint32},
            {"info_val", ProtoSchemaType::kUint64},
        },
    },
    {
        "mali_mali_PM_MCU_HCTL_MCU_ON_RECHECK",
        3,
        {
            {},
            {"kctx_tgid", ProtoSchemaType::kInt32},
            {"kctx_id", ProtoSchemaType::kUint32},
            {"info_val", ProtoSchemaType::kUint64},
        },
    },
    {
        "mali_mali_PM_MCU_HCTL_SHADERS_CORE_OFF_PEND",
        3,
        {
            {},
            {"kctx_tgid", ProtoSchemaType::kInt32},
            {"kctx_id", ProtoSchemaType::kUint32},
            {"info_val", ProtoSchemaType::kUint64},
        },
    },
    {
        "mali_mali_PM_MCU_HCTL_SHADERS_PEND_OFF",
        3,
        {
            {},
            {"kctx_tgid", ProtoSchemaType::kInt32},
            {"kctx_id", ProtoSchemaType::kUint32},
            {"info_val", ProtoSchemaType::kUint64},
        },
    },
    {
        "mali_mali_PM_MCU_HCTL_SHADERS_PEND_ON",
        3,
        {
            {},
            {"kctx_tgid", ProtoSchemaType::kInt32},
            {"kctx_id", ProtoSchemaType::kUint32},
            {"info_val", ProtoSchemaType::kUint64},
        },
    },
    {
        "mali_mali_PM_MCU_HCTL_SHADERS_READY_OFF",
        3,
        {
            {},
            {"kctx_tgid", ProtoSchemaType::kInt32},
            {"kctx_id", ProtoSchemaType::kUint32},
            {"info_val", ProtoSchemaType::kUint64},
        },
    },
    {
        "mali_mali_PM_MCU_IN_SLEEP",
        3,
        {
            {},
            {"kctx_tgid", ProtoSchemaType::kInt32},
            {"kctx_id", ProtoSchemaType::kUint32},
            {"info_val", ProtoSchemaType::kUint64},
        },
    },
    {
        "mali_mali_PM_MCU_OFF",
        3,
        {
            {},
            {"kctx_tgid", ProtoSchemaType::kInt32},
            {"kctx_id", ProtoSchemaType::kUint32},
            {"info_val", ProtoSchemaType::kUint64},
        },
    },
    {
        "mali_mali_PM_MCU_ON",
        3,
        {
            {},
            {"kctx_tgid", ProtoSchemaType::kInt32},
            {"kctx_id", ProtoSchemaType::kUint32},
            {"info_val", ProtoSchemaType::kUint64},
        },
    },
    {
        "mali_mali_PM_MCU_ON_CORE_ATTR_UPDATE_PEND",
        3,
        {
            {},
            {"kctx_tgid", ProtoSchemaType::kInt32},
            {"kctx_id", ProtoSchemaType::kUint32},
            {"info_val", ProtoSchemaType::kUint64},
        },
    },
    {
        "mali_mali_PM_MCU_ON_GLB_REINIT_PEND",
        3,
        {
            {},
            {"kctx_tgid", ProtoSchemaType::kInt32},
            {"kctx_id", ProtoSchemaType::kUint32},
            {"info_val", ProtoSchemaType::kUint64},
        },
    },
    {
        "mali_mali_PM_MCU_ON_HALT",
        3,
        {
            {},
            {"kctx_tgid", ProtoSchemaType::kInt32},
            {"kctx_id", ProtoSchemaType::kUint32},
            {"info_val", ProtoSchemaType::kUint64},
        },
    },
    {
        "mali_mali_PM_MCU_ON_HWCNT_DISABLE",
        3,
        {
            {},
            {"kctx_tgid", ProtoSchemaType::kInt32},
            {"kctx_id", ProtoSchemaType::kUint32},
            {"info_val", ProtoSchemaType::kUint64},
        },
    },
    {
        "mali_mali_PM_MCU_ON_HWCNT_ENABLE",
        3,
        {
            {},
            {"kctx_tgid", ProtoSchemaType::kInt32},
            {"kctx_id", ProtoSchemaType::kUint32},
            {"info_val", ProtoSchemaType::kUint64},
        },
    },
    {
        "mali_mali_PM_MCU_ON_PEND_HALT",
        3,
        {
            {},
            {"kctx_tgid", ProtoSchemaType::kInt32},
            {"kctx_id", ProtoSchemaType::kUint32},
            {"info_val", ProtoSchemaType::kUint64},
        },
    },
    {
        "mali_mali_PM_MCU_ON_PEND_SLEEP",
        3,
        {
            {},
            {"kctx_tgid", ProtoSchemaType::kInt32},
            {"kctx_id", ProtoSchemaType::kUint32},
            {"info_val", ProtoSchemaType::kUint64},
        },
    },
    {
        "mali_mali_PM_MCU_ON_SLEEP_INITIATE",
        3,
        {
            {},
            {"kctx_tgid", ProtoSchemaType::kInt32},
            {"kctx_id", ProtoSchemaType::kUint32},
            {"info_val", ProtoSchemaType::kUint64},
        },
    },
    {
        "mali_mali_PM_MCU_PEND_OFF",
        3,
        {
            {},
            {"kctx_tgid", ProtoSchemaType::kInt32},
            {"kctx_id", ProtoSchemaType::kUint32},
            {"info_val", ProtoSchemaType::kUint64},
        },
    },
    {
        "mali_mali_PM_MCU_PEND_ON_RELOAD",
        3,
        {
            {},
            {"kctx_tgid", ProtoSchemaType::kInt32},
            {"kctx_id", ProtoSchemaType::kUint32},
            {"info_val", ProtoSchemaType::kUint64},
        },
    },
    {
        "mali_mali_PM_MCU_POWER_DOWN",
        3,
        {
            {},
            {"kctx_tgid", ProtoSchemaType::kInt32},
            {"kctx_id", ProtoSchemaType::kUint32},
            {"info_val", ProtoSchemaType::kUint64},
        },
    },
    {
        "mali_mali_PM_MCU_RESET_WAIT",
        3,
        {
            {},
            {"kctx_tgid", ProtoSchemaType::kInt32},
            {"kctx_id", ProtoSchemaType::kUint32},
            {"info_val", ProtoSchemaType::kUint64},
        },
    },
    {
        "bcl_irq_trigger",
        9,
        {
            {},
            {"id", ProtoSchemaType::kInt32},
            {"throttle", ProtoSchemaType::kInt32},
            {"cpu0_limit", ProtoSchemaType::kInt32},
            {"cpu1_limit", ProtoSchemaType::kInt32},
            {"cpu2_limit", ProtoSchemaType::kInt32},
            {"tpu_limit", ProtoSchemaType::kInt32},
            {"gpu_limit", ProtoSchemaType::kInt32},
            {"voltage", ProtoSchemaType::kInt32},
            {"capacity", ProtoSchemaType::kInt32},
        },
    },
    {
        "kgsl_adreno_cmdbatch_queued",
        5,
        {
            {},
            {"id", ProtoSchemaType::kUint32},
            {"timestamp", ProtoSchemaType::kUint32},
            {"queued", ProtoSchemaType::kUint32},
            {"flags", ProtoSchemaType::kUint32},
            {"prio", ProtoSchemaType::kUint32},
        },
    },
    {
        "kgsl_adreno_cmdbatch_submitted",
        13,
        {
            {},
            {"id", ProtoSchemaType::kUint32},
            {"timestamp", ProtoSchemaType::kUint32},
            {"inflight", ProtoSchemaType::kInt64},
            {"flags", ProtoSchemaType::kUint32},
            {"ticks", ProtoSchemaType::kUint64},
            {"secs", ProtoSchemaType::kUint64},
            {"usecs", ProtoSchemaType::kUint64},
            {"prio", ProtoSchemaType::kInt32},
            {"rb_id", ProtoSchemaType::kInt32},
            {"rptr", ProtoSchemaType::kUint32},
            {"wptr", ProtoSchemaType::kUint32},
            {"q_inflight", ProtoSchemaType::kInt32},
            {"dispatch_queue", ProtoSchemaType::kInt32},
        },
    },
    {
        "kgsl_adreno_cmdbatch_sync",
        4,
        {
            {},
            {"id", ProtoSchemaType::kUint32},
            {"timestamp", ProtoSchemaType::kUint32},
            {"ticks", ProtoSchemaType::kUint64},
            {"prio", ProtoSchemaType::kInt32},
        },
    },
    {
        "kgsl_adreno_cmdbatch_retired",
        17,
        {
            {},
            {"id", ProtoSchemaType::kUint32},
            {"timestamp", ProtoSchemaType::kUint32},
            {"inflight", ProtoSchemaType::kInt64},
            {"recovery", ProtoSchemaType::kUint32},
            {"flags", ProtoSchemaType::kUint32},
            {"start", ProtoSchemaType::kUint64},
            {"retire", ProtoSchemaType::kUint64},
            {"prio", ProtoSchemaType::kInt32},
            {"rb_id", ProtoSchemaType::kInt32},
            {"rptr", ProtoSchemaType::kUint32},
            {"wptr", ProtoSchemaType::kUint32},
            {"q_inflight", ProtoSchemaType::kInt32},
            {"fault_recovery", ProtoSchemaType::kUint64},
            {"dispatch_queue", ProtoSchemaType::kUint32},
            {"submitted_to_rb", ProtoSchemaType::kUint64},
            {"retired_on_gmu", ProtoSchemaType::kUint64},
            {"active", ProtoSchemaType::kUint64},
        },
    },
    {
        "pixel_mm_kswapd_wake",
        1,
        {
            {},
            {"whatever", ProtoSchemaType::kInt32},
        },
    },
    {
        "pixel_mm_kswapd_done",
        4,
        {
            {},
            {"delta_nr_scanned", ProtoSchemaType::kUint64},
            {"delta_nr_reclaimed", ProtoSchemaType::kUint64},
            {"delta_nr_allocated", ProtoSchemaType::kUint64},
            {"duration_ns", ProtoSchemaType::kUint64},
        },
    },
    {
        "sched_wakeup_task_attr",
        5,
        {
            {},
            {"pid", ProtoSchemaType::kInt32},
            {"cpu_affinity", ProtoSchemaType::kUint64},
            {"task_util", ProtoSchemaType::kUint64},
            {"uclamp_min", ProtoSchemaType::kUint64},
            {"vruntime", ProtoSchemaType::kUint64},
        },
    },
    {
        "devfreq_frequency",
        5,
        {
            {},
            {"dev_name", ProtoSchemaType::kString},
            {"freq", ProtoSchemaType::kUint64},
            {"prev_freq", ProtoSchemaType::kUint64},
            {"busy_time", ProtoSchemaType::kUint64},
            {"total_time", ProtoSchemaType::kUint64},
        },
    },
    {
        "kprobe_event",
        2,
        {
            {},
            {"name", ProtoSchemaType::kString},
            {"type", ProtoSchemaType::kInt32},
        },
    },
    {
        "param_set_value_cpm",
        3,
        {
            {},
            {"body", ProtoSchemaType::kString},
            {"value", ProtoSchemaType::kUint32},
            {"timestamp", ProtoSchemaType::kInt64},
        },
    },
    {
        "do_sys_open",
        3,
        {
            {},
            {"filename", ProtoSchemaType::kString},
            {"flags", ProtoSchemaType::kInt32},
            {"mode", ProtoSchemaType::kInt32},
        },
    },
    {
        "open_exec",
        1,
        {
            {},
            {"filename", ProtoSchemaType::kString},
        },
    },
    {
        "block_io_start",
        8,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"sector", ProtoSchemaType::kUint64},
            {"nr_sector", ProtoSchemaType::kUint32},
            {"bytes", ProtoSchemaType::kUint32},
            {"ioprio", ProtoSchemaType::kUint32},
            {"rwbs", ProtoSchemaType::kString},
            {"comm", ProtoSchemaType::kString},
            {"cmd", ProtoSchemaType::kString},
        },
    },
    {
        "block_io_done",
        8,
        {
            {},
            {"dev", ProtoSchemaType::kUint64},
            {"sector", ProtoSchemaType::kUint64},
            {"nr_sector", ProtoSchemaType::kUint32},
            {"bytes", ProtoSchemaType::kUint32},
            {"ioprio", ProtoSchemaType::kUint32},
            {"rwbs", ProtoSchemaType::kString},
            {"comm", ProtoSchemaType::kString},
            {"cmd", ProtoSchemaType::kString},
        },
    },
    {
        "mali_gpu_power_state",
        3,
        {
            {},
            {"change_ns", ProtoSchemaType::kUint64},
            {"from_state", ProtoSchemaType::kInt32},
            {"to_state", ProtoSchemaType::kInt32},
        },
    },
    {
        "dpu_disp_dpu_underrun",
        3,
        {
            {},
            {"id", ProtoSchemaType::kInt32},
            {"frames_pending", ProtoSchemaType::kInt32},
            {"vsync_count", ProtoSchemaType::kInt32},
        },
    },
    {
        "dpu_disp_vblank_irq_enable",
        3,
        {
            {},
            {"id", ProtoSchemaType::kInt32},
            {"output_id", ProtoSchemaType::kInt32},
            {"enable", ProtoSchemaType::kInt32},
        },
    },
    {
        "hrtimer_start",
        5,
        {
            {},
            {"hrtimer", ProtoSchemaType::kUint64},
            {"function", ProtoSchemaType::kUint64},
            {"expires", ProtoSchemaType::kInt64},
            {"softexpires", ProtoSchemaType::kInt64},
            {"mode", ProtoSchemaType::kUint32},
        },
    },
    {
        "hrtimer_cancel",
        1,
        {
            {},
            {"hrtimer", ProtoSchemaType::kUint64},
        },
    },
    {
        "hrtimer_expire_entry",
        3,
        {
            {},
            {"hrtimer", ProtoSchemaType::kUint64},
            {"now", ProtoSchemaType::kInt64},
            {"function", ProtoSchemaType::kUint64},
        },
    },
    {
        "hrtimer_expire_exit",
        1,
        {
            {},
            {"hrtimer", ProtoSchemaType::kUint64},
        },
    },
    {
        "timer_start",
        7,
        {
            {},
            {"timer", ProtoSchemaType::kUint64},
            {"function", ProtoSchemaType::kUint64},
            {"expires", ProtoSchemaType::kUint64},
            {"now", ProtoSchemaType::kUint64},
            {"deferrable", ProtoSchemaType::kUint32},
            {"flags", ProtoSchemaType::kUint32},
            {"bucket_expiry", ProtoSchemaType::kUint64},
        },
    },
    {
        "timer_cancel",
        1,
        {
            {},
            {"timer", ProtoSchemaType::kUint64},
        },
    },
    {
        "timer_expire_entry",
        4,
        {
            {},
            {"timer", ProtoSchemaType::kUint64},
            {"now", ProtoSchemaType::kUint64},
            {"function", ProtoSchemaType::kUint64},
            {"baseclk", ProtoSchemaType::kUint64},
        },
    },
    {
        "timer_expire_exit",
        1,
        {
            {},
            {"timer", ProtoSchemaType::kUint64},
        },
    },
    {
        "local_timer_entry",
        1,
        {
            {},
            {"vector", ProtoSchemaType::kInt32},
        },
    },
    {
        "local_timer_exit",
        1,
        {
            {},
            {"vector", ProtoSchemaType::kInt32},
        },
    },
    {
        "dwc3_alloc_request",
        8,
        {
            {},
            {"name", ProtoSchemaType::kString},
            {"req", ProtoSchemaType::kUint64},
            {"actual", ProtoSchemaType::kUint32},
            {"length", ProtoSchemaType::kUint32},
            {"status", ProtoSchemaType::kInt32},
            {"zero", ProtoSchemaType::kInt32},
            {"short_not_ok", ProtoSchemaType::kInt32},
            {"no_interrupt", ProtoSchemaType::kInt32},
        },
    },
    {
        "dwc3_complete_trb",
        11,
        {
            {},
            {"name", ProtoSchemaType::kString},
            {"trb", ProtoSchemaType::kUint64},
            {"allocated", ProtoSchemaType::kUint32},
            {"queued", ProtoSchemaType::kUint32},
            {"bpl", ProtoSchemaType::kUint32},
            {"bph", ProtoSchemaType::kUint32},
            {"size", ProtoSchemaType::kUint32},
            {"ctrl", ProtoSchemaType::kUint32},
            {"type", ProtoSchemaType::kUint32},
            {"enqueue", ProtoSchemaType::kUint32},
            {"dequeue", ProtoSchemaType::kUint32},
        },
    },
    {
        "dwc3_ctrl_req",
        6,
        {
            {},
            {"bRequestType", ProtoSchemaType::kUint32},
            {"bRequest", ProtoSchemaType::kUint32},
            {"wValue", ProtoSchemaType::kUint32},
            {"wIndex", ProtoSchemaType::kUint32},
            {"wLength", ProtoSchemaType::kUint32},
            {"str", ProtoSchemaType::kString},
        },
    },
    {
        "dwc3_ep_dequeue",
        8,
        {
            {},
            {"name", ProtoSchemaType::kString},
            {"req", ProtoSchemaType::kUint64},
            {"actual", ProtoSchemaType::kUint32},
            {"length", ProtoSchemaType::kUint32},
            {"status", ProtoSchemaType::kInt32},
            {"zero", ProtoSchemaType::kInt32},
            {"short_not_ok", ProtoSchemaType::kInt32},
            {"no_interrupt", ProtoSchemaType::kInt32},
        },
    },
    {
        "dwc3_ep_queue",
        8,
        {
            {},
            {"name", ProtoSchemaType::kString},
            {"req", ProtoSchemaType::kUint64},
            {"actual", ProtoSchemaType::kUint32},
            {"length", ProtoSchemaType::kUint32},
            {"status", ProtoSchemaType::kInt32},
            {"zero", ProtoSchemaType::kInt32},
            {"short_not_ok", ProtoSchemaType::kInt32},
            {"no_interrupt", ProtoSchemaType::kInt32},
        },
    },
    {
        "dwc3_event",
        3,
        {
            {},
            {"event", ProtoSchemaType::kUint32},
            {"ep0state", ProtoSchemaType::kUint32},
            {"str", ProtoSchemaType::kString},
        },
    },
    {
        "dwc3_free_request",
        8,
        {
            {},
            {"name", ProtoSchemaType::kString},
            {"req", ProtoSchemaType::kUint64},
            {"actual", ProtoSchemaType::kUint32},
            {"length", ProtoSchemaType::kUint32},
            {"status", ProtoSchemaType::kInt32},
            {"zero", ProtoSchemaType::kInt32},
            {"short_not_ok", ProtoSchemaType::kInt32},
            {"no_interrupt", ProtoSchemaType::kInt32},
        },
    },
    {
        "dwc3_gadget_ep_cmd",
        6,
        {
            {},
            {"name", ProtoSchemaType::kString},
            {"cmd", ProtoSchemaType::kUint32},
            {"param0", ProtoSchemaType::kUint32},
            {"param1", ProtoSchemaType::kUint32},
            {"param2", ProtoSchemaType::kUint32},
            {"cmd_status", ProtoSchemaType::kInt32},
        },
    },
    {
        "dwc3_gadget_ep_disable",
        9,
        {
            {},
            {"name", ProtoSchemaType::kString},
            {"maxpacket", ProtoSchemaType::kUint32},
            {"maxpacket_limit", ProtoSchemaType::kUint32},
            {"max_streams", ProtoSchemaType::kUint32},
            {"maxburst", ProtoSchemaType::kUint32},
            {"flags", ProtoSchemaType::kUint32},
            {"direction", ProtoSchemaType::kUint32},
            {"trb_enqueue", ProtoSchemaType::kUint32},
            {"trb_dequeue", ProtoSchemaType::kUint32},
        },
    },
    {
        "dwc3_gadget_ep_enable",
        9,
        {
            {},
            {"name", ProtoSchemaType::kString},
            {"maxpacket", ProtoSchemaType::kUint32},
            {"maxpacket_limit", ProtoSchemaType::kUint32},
            {"max_streams", ProtoSchemaType::kUint32},
            {"maxburst", ProtoSchemaType::kUint32},
            {"flags", ProtoSchemaType::kUint32},
            {"direction", ProtoSchemaType::kUint32},
            {"trb_enqueue", ProtoSchemaType::kUint32},
            {"trb_dequeue", ProtoSchemaType::kUint32},
        },
    },
    {
        "dwc3_gadget_generic_cmd",
        3,
        {
            {},
            {"cmd", ProtoSchemaType::kUint32},
            {"param", ProtoSchemaType::kUint32},
            {"status", ProtoSchemaType::kInt32},
        },
    },
    {
        "dwc3_gadget_giveback",
        8,
        {
            {},
            {"name", ProtoSchemaType::kString},
            {"req", ProtoSchemaType::kUint64},
            {"actual", ProtoSchemaType::kUint32},
            {"length", ProtoSchemaType::kUint32},
            {"status", ProtoSchemaType::kInt32},
            {"zero", ProtoSchemaType::kInt32},
            {"short_not_ok", ProtoSchemaType::kInt32},
            {"no_interrupt", ProtoSchemaType::kInt32},
        },
    },
    {
        "dwc3_prepare_trb",
        11,
        {
            {},
            {"name", ProtoSchemaType::kString},
            {"trb", ProtoSchemaType::kUint64},
            {"allocated", ProtoSchemaType::kUint32},
            {"queued", ProtoSchemaType::kUint32},
            {"bpl", ProtoSchemaType::kUint32},
            {"bph", ProtoSchemaType::kUint32},
            {"size", ProtoSchemaType::kUint32},
            {"ctrl", ProtoSchemaType::kUint32},
            {"type", ProtoSchemaType::kUint32},
            {"enqueue", ProtoSchemaType::kUint32},
            {"dequeue", ProtoSchemaType::kUint32},
        },
    },
    {
        "dwc3_readl",
        4,
        {
            {},
            {"base", ProtoSchemaType::kUint64},
            {"offset", ProtoSchemaType::kUint32},
            {"value", ProtoSchemaType::kUint32},
            {"msg", ProtoSchemaType::kString},
        },
    },
    {
        "dwc3_writel",
        4,
        {
            {},
            {"base", ProtoSchemaType::kUint64},
            {"offset", ProtoSchemaType::kUint32},
            {"value", ProtoSchemaType::kUint32},
            {"msg", ProtoSchemaType::kString},
        },
    },
    {
        "cma_alloc_finish",
        6,
        {
            {},
            {"name", ProtoSchemaType::kString},
            {"pfn", ProtoSchemaType::kUint64},
            {"page", ProtoSchemaType::kUint64},
            {"count", ProtoSchemaType::kUint64},
            {"align", ProtoSchemaType::kUint32},
            {"errorno", ProtoSchemaType::kInt32},
        },
    },
    {
        "mm_alloc_contig_migrate_range_info",
        6,
        {
            {},
            {"start", ProtoSchemaType::kUint64},
            {"end", ProtoSchemaType::kUint64},
            {"nr_migrated", ProtoSchemaType::kUint64},
            {"nr_reclaimed", ProtoSchemaType::kUint64},
            {"nr_mapped", ProtoSchemaType::kUint64},
            {"migratetype", ProtoSchemaType::kInt32},
        },
    },
    {
        "host_ffa_call",
        7,
        {
            {},
            {"func_id", ProtoSchemaType::kUint64},
            {"res_a1", ProtoSchemaType::kUint64},
            {"res_a2", ProtoSchemaType::kUint64},
            {"res_a3", ProtoSchemaType::kUint64},
            {"res_a4", ProtoSchemaType::kUint64},
            {"handled", ProtoSchemaType::kInt32},
            {"err", ProtoSchemaType::kInt32},
        },
    },
    {
        "dmabuf_rss_stat",
        3,
        {
            {},
            {"rss", ProtoSchemaType::kUint64},
            {"rss_delta", ProtoSchemaType::kInt64},
            {"i_ino", ProtoSchemaType::kUint64},
        },
    },
    {
        "iommu_idmap",
        3,
        {
            {},
            {"from", ProtoSchemaType::kUint64},
            {"to", ProtoSchemaType::kUint64},
            {"prot", ProtoSchemaType::kInt32},
        },
    },
    {
        "psci_mem_protect",
        2,
        {
            {},
            {"count", ProtoSchemaType::kUint64},
            {"was", ProtoSchemaType::kUint64},
        },
    },
    {
        "hypervisor_host_hcall",
        2,
        {
            {},
            {"id", ProtoSchemaType::kUint32},
            {"invalid", ProtoSchemaType::kUint32},
        },
    },
    {
        "hypervisor_host_smc",
        2,
        {
            {},
            {"id", ProtoSchemaType::kUint64},
            {"forwarded", ProtoSchemaType::kUint32},
        },
    },
    {
        "hypervisor_hyp_exit",
        0,
        {
            {},
        },
    },
    {
        "hypervisor_iommu_idmap",
        3,
        {
            {},
            {"from", ProtoSchemaType::kUint64},
            {"to", ProtoSchemaType::kUint64},
            {"prot", ProtoSchemaType::kInt32},
        },
    },
    {
        "hypervisor_psci_mem_protect",
        2,
        {
            {},
            {"count", ProtoSchemaType::kUint64},
            {"was", ProtoSchemaType::kUint64},
        },
    },
    {
        "hypervisor_host_mem_abort",
        2,
        {
            {},
            {"esr", ProtoSchemaType::kUint64},
            {"addr", ProtoSchemaType::kUint64},
        },
    },
    {
        "hypervisor_hyp_enter",
        0,
        {
            {},
        },
    },
    {
        "hypervisor_iommu_idmap_complete",
        1,
        {
            {},
            {"map", ProtoSchemaType::kUint32},
        },
    },
    {
        "hypervisor_vcpu_illegal_trap",
        1,
        {
            {},
            {"esr", ProtoSchemaType::kUint64},
        },
    },
    {
        "drm_sched_job_add_dep",
        4,
        {
            {},
            {"fence_context", ProtoSchemaType::kUint64},
            {"fence_seqno", ProtoSchemaType::kUint64},
            {"ctx", ProtoSchemaType::kUint64},
            {"seqno", ProtoSchemaType::kUint64},
        },
    },
    {
        "drm_sched_job_done",
        2,
        {
            {},
            {"fence_context", ProtoSchemaType::kUint64},
            {"fence_seqno", ProtoSchemaType::kUint64},
        },
    },
    {
        "drm_sched_job_queue",
        7,
        {
            {},
            {"name", ProtoSchemaType::kString},
            {"job_count", ProtoSchemaType::kUint32},
            {"hw_job_count", ProtoSchemaType::kInt32},
            {"dev", ProtoSchemaType::kString},
            {"fence_context", ProtoSchemaType::kUint64},
            {"fence_seqno", ProtoSchemaType::kUint64},
            {"client_id", ProtoSchemaType::kUint64},
        },
    },
    {
        "drm_sched_job_run",
        7,
        {
            {},
            {"name", ProtoSchemaType::kString},
            {"job_count", ProtoSchemaType::kUint32},
            {"hw_job_count", ProtoSchemaType::kInt32},
            {"dev", ProtoSchemaType::kString},
            {"fence_context", ProtoSchemaType::kUint64},
            {"fence_seqno", ProtoSchemaType::kUint64},
            {"client_id", ProtoSchemaType::kUint64},
        },
    },
    {
        "drm_sched_job_unschedulable",
        4,
        {
            {},
            {"fence_context", ProtoSchemaType::kUint64},
            {"fence_seqno", ProtoSchemaType::kUint64},
            {"ctx", ProtoSchemaType::kUint64},
            {"seqno", ProtoSchemaType::kUint64},
        },
    },
}};

}  // namespace

FtraceMessageDescriptor* GetMessageDescriptorForId(size_t id) {
  PERFETTO_CHECK(id < descriptors.size());
  return &descriptors[id];
}

FtraceMessageDescriptor* GetMessageDescriptorForName(base::StringView name) {
  for (FtraceMessageDescriptor& descriptor : descriptors) {
    if (descriptor.name != nullptr && descriptor.name == name)
      return &descriptor;
  }
  return nullptr;
}

size_t GetDescriptorsSize() {
  return descriptors.size();
}
}  // namespace trace_processor
}  // namespace perfetto
