% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_geometric.R
\name{dist_geometric}
\alias{dist_geometric}
\title{The Geometric Distribution}
\usage{
dist_geometric(prob)
}
\arguments{
\item{prob}{probability of success in each trial. \code{0 < prob <= 1}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The Geometric distribution can be thought of as a generalization
of the \code{\link[=dist_bernoulli]{dist_bernoulli()}} distribution where we ask: "if I keep flipping a
coin with probability \code{p} of heads, what is the probability I need
\eqn{k} flips before I get my first heads?" The Geometric
distribution is a special case of Negative Binomial distribution.
}
\details{
We recommend reading this documentation on \href{https://pkg.mitchelloharawild.com/distributional/reference/dist_geometric.html}{pkgdown} which renders math nicely.
\url{https://pkg.mitchelloharawild.com/distributional/reference/dist_geometric.html}

In the following, let \eqn{X} be a Geometric random variable with
success probability \code{prob} = \eqn{p}. Note that there are multiple
parameterizations of the Geometric distribution.

\strong{Support}: \eqn{\{0, 1, 2, 3, ...\}}{{0, 1, 2, 3, ...}}

\strong{Mean}: \eqn{\frac{1-p}{p}}

\strong{Variance}: \eqn{\frac{1-p}{p^2}}

\strong{Probability mass function (p.m.f)}:

\deqn{
    P(X = k) = p(1-p)^k
  }{
    P(X = k) = p(1-p)^k
  }

\strong{Cumulative distribution function (c.d.f)}:

\deqn{
    P(X \le k) = 1 - (1-p)^{k+1}
  }{
    P(X \le k) = 1 - (1-p)^(k+1)
  }

\strong{Moment generating function (m.g.f)}:

\deqn{
    E(e^{tX}) = \frac{pe^t}{1 - (1-p)e^t}
  }{
    E(e^(tX)) = pe^t / (1 - (1-p)e^t)
  }

\strong{Skewness}:

\deqn{
    \frac{2 - p}{\sqrt{1 - p}}
  }{
    (2 - p) / sqrt(1 - p)
  }

\strong{Excess Kurtosis}:

\deqn{
    6 + \frac{p^2}{1 - p}
  }{
    6 + p^2 / (1 - p)
  }
}
\examples{
dist <- dist_geometric(prob = c(0.2, 0.5, 0.8))

dist
mean(dist)
variance(dist)
skewness(dist)
kurtosis(dist)

generate(dist, 10)

density(dist, 2)
density(dist, 2, log = TRUE)

cdf(dist, 4)

quantile(dist, 0.7)
}
\seealso{
\link[stats:Geometric]{stats::Geometric}
}
