(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require Import R_sqrt.
Require BuiltIn.
Require real.Real.
Require real.Square.

(* Why3 assumption *)
Definition dot (x1:R) (x2:R) (y1:R) (y2:R): R :=
  ((x1 * y1)%R + (x2 * y2)%R)%R.

(* Why3 assumption *)
Definition norm2 (x1:R) (x2:R): R := ((Rsqr x1) + (Rsqr x2))%R.

Axiom norm2_pos : forall (x1:R) (x2:R), (0%R <= (norm2 x1 x2))%R.

Axiom Lagrange : forall (a1:R) (a2:R) (b1:R) (b2:R), (((norm2 a1
  a2) * (norm2 b1 b2))%R = ((Rsqr (dot a1 a2 b1
  b2)) + (Rsqr ((a1 * b2)%R - (a2 * b1)%R)%R))%R).

Axiom CauchySchwarz_aux : forall (x1:R) (x2:R) (y1:R) (y2:R), ((Rsqr (dot x1
  x2 y1 y2)) <= ((norm2 x1 x2) * (norm2 y1 y2))%R)%R.

(* Why3 assumption *)
Definition norm (x1:R) (x2:R): R := (sqrt (norm2 x1 x2)).

Axiom norm_pos : forall (x1:R) (x2:R), (0%R <= (norm x1 x2))%R.

Axiom sqr_le_sqrt : forall (x:R) (y:R), ((Rsqr x) <= y)%R ->
  (x <= (sqrt y))%R.

Axiom CauchySchwarz : forall (x1:R) (x2:R) (y1:R) (y2:R), ((dot x1 x2 y1
  y2) <= ((norm x1 x2) * (norm y1 y2))%R)%R.

Axiom triangle_aux : forall (x1:R) (x2:R) (y1:R) (y2:R), ((norm2 (x1 + y1)%R
  (x2 + y2)%R) <= (Rsqr ((norm x1 x2) + (norm y1 y2))%R))%R.

Axiom sqr_sqrt_le : forall (x:R) (y:R), ((0%R <= y)%R /\ ((0%R <= x)%R /\
  (x <= (Rsqr y))%R)) -> ((sqrt x) <= y)%R.

(* Why3 goal *)
Theorem triangle : forall (x1:R) (x2:R) (y1:R) (y2:R), ((norm (x1 + y1)%R
  (x2 + y2)%R) <= ((norm x1 x2) + (norm y1 y2))%R)%R.
intros x1 x2 y1 y2.
apply sqr_sqrt_le.
split.
apply Rplus_le_le_0_compat; apply norm_pos.
split.
apply Rplus_le_le_0_compat; apply Rle_0_sqr.
apply triangle_aux.
Qed.


